/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer.providers.bvalue;

import java.util.HashSet;
import org.ballerinalang.core.model.types.BArrayType;
import org.ballerinalang.core.model.types.BTypes;
import org.ballerinalang.core.model.util.serializer.BPacket;
import org.ballerinalang.core.model.util.serializer.BValueDeserializer;
import org.ballerinalang.core.model.util.serializer.BValueSerializer;
import org.ballerinalang.core.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.core.model.values.BInteger;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BValueArray;

public class HashSetBValueProvider
implements SerializationBValueProvider<HashSet> {
    @Override
    public String typeName() {
        return this.getType().getName();
    }

    @Override
    public Class<?> getType() {
        return HashSet.class;
    }

    @Override
    public BPacket toBValue(HashSet set, BValueSerializer serializer) {
        BValueArray array = new BValueArray(new BArrayType(BTypes.typeAny));
        for (Object item : set) {
            array.append((BRefType)serializer.toBValue(item, null));
        }
        return BPacket.from(this.typeName(), array).put("len#", new BInteger(set.size()));
    }

    @Override
    public HashSet toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
        BInteger length = (BInteger)packet.get("len#");
        BValueArray array = (BValueArray)packet.getValue();
        HashSet<Object> set = new HashSet<Object>((int)length.intValue());
        int i = 0;
        while ((long)i < array.size()) {
            set.add(bValueDeserializer.deserialize(array.getRefValue(i), null));
            ++i;
        }
        return set;
    }
}

