/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.values;

import java.util.Map;
import org.ballerinalang.core.model.types.BArrayType;
import org.ballerinalang.core.model.types.BType;
import org.ballerinalang.core.model.types.BTypes;
import org.ballerinalang.core.model.values.BCollection;
import org.ballerinalang.core.model.values.BInteger;
import org.ballerinalang.core.model.values.BIterator;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BValue;

public class BIntRange
implements BRefType,
BCollection {
    private long startValue;
    private long endValue;

    public BIntRange(long startValue, long endValue) {
        this.startValue = startValue;
        this.endValue = endValue;
    }

    @Override
    public String stringValue() {
        return null;
    }

    @Override
    public BIterator newIterator() {
        return new BIntRangeIterator(this);
    }

    @Override
    public BType getType() {
        return new BArrayType(BTypes.typeInt);
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return null;
    }

    public Object value() {
        return null;
    }

    static class BIntRangeIterator
    implements BIterator {
        private BIntRange collection;
        long currentValue;

        BIntRangeIterator(BIntRange collection) {
            this.collection = collection;
            this.currentValue = collection.startValue;
        }

        @Override
        public BValue getNext() {
            long currentValue = this.currentValue++;
            if (this.hasNext()) {
                return new BInteger(currentValue);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.collection.startValue <= this.currentValue && this.currentValue <= this.collection.endValue;
        }
    }
}

