/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.values;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import org.ballerinalang.core.model.types.BType;
import org.ballerinalang.core.model.types.BTypes;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BValue;
import org.ballerinalang.core.model.values.BValueType;
import org.ballerinalang.core.util.exceptions.BallerinaException;

public final class BString
extends BValueType
implements BRefType<String> {
    private String value;
    private BType type = BTypes.typeString;

    public BString(String value) {
        this.value = value;
    }

    @Override
    public long intValue() {
        long result;
        try {
            result = Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            throw new BallerinaException("input value " + this.value + " cannot be cast to integer");
        }
        return result;
    }

    @Override
    public long byteValue() {
        long result;
        try {
            result = Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            throw new BallerinaException("input value " + this.value + " cannot be cast to byte");
        }
        return result;
    }

    @Override
    public double floatValue() {
        double result;
        try {
            result = Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            throw new BallerinaException("input value " + this.value + " cannot be cast to float");
        }
        return result;
    }

    @Override
    public BigDecimal decimalValue() {
        BigDecimal result;
        try {
            result = new BigDecimal(this.value, MathContext.DECIMAL128);
        }
        catch (NumberFormatException e) {
            throw new BallerinaException("input value " + this.value + " cannot be cast to decimal");
        }
        return result;
    }

    @Override
    public boolean booleanValue() {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void setType(BType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BString bString = (BString)o;
        return this.value != null ? this.value.equals(bString.value) : bString.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return this;
    }
}

