/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.utils;

import io.ballerina.projects.CompilationCache;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.repos.FileSystemCache;
import io.ballerina.projects.util.ProjectUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;

public class BuildLangLib {
    static Path projectDir;
    static Path distCache;
    static boolean skipBootstrap;

    public static void main(String[] args) throws IOException {
        PrintStream out = System.out;
        try {
            projectDir = Paths.get(args[0], new String[0]);
            distCache = Paths.get(args[1], new String[0]);
            String pkgName = args[2];
            if (args.length >= 4 && args[3].equals("true")) {
                skipBootstrap = true;
            }
            System.setProperty("ballerina.home", distCache.toString());
            out.println("Building langlib ...");
            out.println("Project Dir: " + projectDir);
            if (!skipBootstrap) {
                System.setProperty("BOOTSTRAP_LANG_LIB", pkgName);
            }
            Path targetPath = projectDir.resolve("target");
            BuildLangLib.clearTarget(targetPath);
            Path pkgTargetPath = targetPath.resolve(pkgName);
            ProjectEnvironmentBuilder environmentBuilder = BuildLangLib.createProjectEnvBuilder(pkgTargetPath);
            BuildProject project = BuildProject.load(environmentBuilder, projectDir);
            Package pkg = project.currentPackage();
            PackageCompilation packageCompilation = pkg.getCompilation();
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from(packageCompilation, JdkVersion.JAVA_11);
            if (jBallerinaBackend.diagnosticResult().hasErrors()) {
                out.println("Error building Ballerina package: " + pkg.packageName());
                jBallerinaBackend.diagnosticResult().diagnostics().forEach(d -> out.println(d.toString()));
                System.exit(1);
            }
            PackageManifest pkgDesc = pkg.manifest();
            String baloName = ProjectUtils.getBaloName(pkgDesc);
            Path baloDirPath = pkgTargetPath.resolve("balo");
            Path balrPath = baloDirPath.resolve(pkgDesc.org().toString()).resolve(pkgDesc.name().value()).resolve(pkgDesc.version().toString());
            Files.createDirectories(balrPath, new FileAttribute[0]);
            jBallerinaBackend.emit(JBallerinaBackend.OutputType.BALO, balrPath.resolve(baloName));
            Path zipFilePath = targetPath.resolve(pkgDesc.name().value() + ".zip");
            try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(zipFilePath, new OpenOption[0]));){
                Files.walk(pkgTargetPath, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ZipEntry zipEntry = new ZipEntry(pkgTargetPath.relativize((Path)path).toString());
                    try {
                        zs.putNextEntry(zipEntry);
                        Files.copy(path, zs);
                        zs.closeEntry();
                    }
                    catch (IOException e) {
                        PrintStream err = System.err;
                        err.println(e.getMessage());
                    }
                });
            }
            Path cacheDirPath = pkgTargetPath.resolve("cache");
            String jarFileName = pkgDesc.name().value() + ".jar";
            Path generatedJarFilePath = cacheDirPath.resolve(pkgDesc.org().toString()).resolve(pkgDesc.name().value()).resolve(pkgDesc.version().toString()).resolve(jBallerinaBackend.targetPlatform().code()).resolve(jarFileName);
            Path targetJarFilePath = targetPath.resolve(jarFileName);
            Files.copy(generatedJarFilePath, targetJarFilePath, new CopyOption[0]);
            out.println("Generating docs...");
            BallerinaDocGenerator.generateAPIDocs(project, targetPath.resolve("apidocs").toString());
        }
        catch (Exception e) {
            out.println("Unknown error building : " + projectDir.toString());
            e.printStackTrace();
            throw e;
        }
    }

    private static void clearTarget(Path targetPath) throws IOException {
        if (Files.exists(targetPath, new LinkOption[0])) {
            BuildLangLib.deleteDirectory(targetPath);
        }
    }

    private static ProjectEnvironmentBuilder createProjectEnvBuilder(final Path targetPath) {
        ProjectEnvironmentBuilder environmentBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        environmentBuilder.addCompilationCacheFactory(project -> new CompilationCache(project){
            private final FileSystemCache fsCache;
            {
                super(arg0);
                this.fsCache = new FileSystemCache(this.project, targetPath);
            }

            @Override
            public byte[] getBir(ModuleName moduleName) {
                return new byte[0];
            }

            @Override
            public void cacheBir(ModuleName moduleName, ByteArrayOutputStream birContent) {
                this.fsCache.cacheBir(moduleName, birContent);
            }

            @Override
            public Optional<Path> getPlatformSpecificLibrary(CompilerBackend compilerBackend, String libraryName) {
                return Optional.empty();
            }

            @Override
            public void cachePlatformSpecificLibrary(CompilerBackend compilerBackend, String libraryName, ByteArrayOutputStream libraryContent) {
                this.fsCache.cachePlatformSpecificLibrary(compilerBackend, libraryName, libraryContent);
            }
        });
        return environmentBuilder;
    }

    public static void deleteDirectory(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir2, IOException exc) throws IOException {
                Files.delete(dir2);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static {
        skipBootstrap = false;
    }
}

