/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.utils;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import org.ballerinalang.packerina.utils.EmptyPrintStream;
import org.ballerinalang.packerina.writer.JarFileWriter;
import org.ballerinalang.repository.CompiledPackage;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnostic;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class GenerateBalo {
    private static final String LOG_ISOLATION_WARNINGS_PROP = "BALLERINA_DEV_LOG_ISOLATION_WARNINGS";
    private static int errorCount = 0;
    private static int warnCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String isBuiltinFlag = args[0];
        String sourceDir = args[1];
        String targetDir = args[2];
        String libDir = args[3];
        boolean skipReportingWarnings = args.length > 4 && Boolean.parseBoolean(args[4]);
        String jvmTarget = args[5];
        String moduleFilter = args[6];
        String originalShouldCompileBalOrg = System.getProperty("BALLERINA_DEV_COMPILE_BALLERINA_ORG");
        String originalIsBuiltin = System.getProperty("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE");
        String originalHome = System.getProperty("ballerina.home");
        try {
            System.setProperty("BALLERINA_DEV_COMPILE_BALLERINA_ORG", "true");
            boolean isBuiltin = Boolean.parseBoolean(isBuiltinFlag);
            System.setProperty("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE", Boolean.toString(isBuiltin));
            System.setProperty("ballerina.home", libDir);
            boolean reportWarnings = !skipReportingWarnings;
            GenerateBalo.genBalo(targetDir, sourceDir, reportWarnings, Boolean.parseBoolean(jvmTarget), new HashSet<String>(Arrays.asList(moduleFilter.split(","))), Boolean.parseBoolean(System.getenv(LOG_ISOLATION_WARNINGS_PROP)));
        }
        finally {
            GenerateBalo.unsetProperty("BALLERINA_DEV_COMPILE_BALLERINA_ORG", originalShouldCompileBalOrg);
            GenerateBalo.unsetProperty("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE", originalIsBuiltin);
            GenerateBalo.unsetProperty("ballerina.home", originalHome);
        }
    }

    private static void unsetProperty(String key, String val) {
        if (val == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, val);
        }
    }

    private static void genBalo(String targetDir, String sourceRootDir, boolean reportWarnings, boolean jvmTarget, Set<String> docModuleFilter, boolean logIsolationWarnings) throws IOException {
        Files.createDirectories(Paths.get(targetDir, new String[0]), new FileAttribute[0]);
        CompilerContext context = new CompilerContext();
        context.put(SourceDirectory.class, new MvnSourceDirectory(sourceRootDir, targetDir));
        CompilerOptions options = CompilerOptions.getInstance(context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootDir);
        options.put(CompilerOptionName.OFFLINE, Boolean.TRUE.toString());
        options.put(CompilerOptionName.BALO_GENERATION, Boolean.TRUE.toString());
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.TRUE.toString());
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.TRUE.toString());
        Compiler compiler = Compiler.getInstance(context);
        List<BLangPackage> buildPackages = compiler.compilePackages(false);
        BallerinaDocGenerator.setPrintStream((PrintStream)new EmptyPrintStream());
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (BLangPackage buildPackage : buildPackages) {
            diagnostics.addAll(buildPackage.getDiagnostics());
            errorCount += buildPackage.getErrorCount();
            warnCount += buildPackage.getWarnCount();
        }
        GenerateBalo.printErrors(reportWarnings, diagnostics, logIsolationWarnings);
        compiler.write(buildPackages);
        JarFileWriter jarFileWriter = JarFileWriter.getInstance((CompilerContext)context);
        for (BLangPackage pkg : buildPackages) {
            Path jarOutput = Paths.get("./build/generated-bir-jar/" + pkg.packageID.orgName + "-" + pkg.packageID.name + "-" + pkg.packageID.version + ".jar", new String[0]);
            Path parent = jarOutput.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            jarFileWriter.write(pkg, jarOutput);
        }
    }

    private static void printErrors(boolean reportWarnings, List<Diagnostic> diagnostics, boolean logIsolationWarnings) {
        int deprecatedWarnCount = 0;
        if (reportWarnings && warnCount > 0) {
            for (Diagnostic diagnostic : diagnostics) {
                DiagnosticCode code;
                if (!(diagnostic instanceof BLangDiagnostic) || (code = ((BLangDiagnostic)diagnostic).getCode()) == null || code != DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT && (logIsolationWarnings || !GenerateBalo.isIsolatedWarningLog(code))) continue;
                ++deprecatedWarnCount;
            }
        }
        if (errorCount > 0 || reportWarnings && warnCount - deprecatedWarnCount > 0) {
            Object warnMsg = reportWarnings ? " and " + warnCount + " warning(s)" : "";
            throw new BLangCompilerException("Compilation failed with " + errorCount + " error(s)" + (String)warnMsg + " \n  ");
        }
    }

    private static boolean isIsolatedWarningLog(DiagnosticCode code) {
        if (code instanceof DiagnosticWarningCode) {
            DiagnosticWarningCode diagCode = (DiagnosticWarningCode)code;
            switch (diagCode) {
                case FUNCTION_CAN_BE_MARKED_ISOLATED: 
                case WARNING_INVALID_MUTABLE_ACCESS_AS_RECORD_DEFAULT: 
                case WARNING_INVALID_NON_ISOLATED_INVOCATION_AS_RECORD_DEFAULT: 
                case WARNING_INVALID_NON_ISOLATED_INIT_EXPRESSION_AS_RECORD_DEFAULT: {
                    return true;
                }
            }
        }
        return false;
    }

    private static class MvnSourceDirectory
    extends FileSystemProjectDirectory {
        private final String targetDir;

        MvnSourceDirectory(String sourceRoot, String targetDir) {
            super(Paths.get(sourceRoot, new String[0]));
            this.targetDir = targetDir;
        }

        @Override
        public void saveCompiledPackage(CompiledPackage compiledPackage, Path dirPath, String fileName) throws IOException {
            String dirName = fileName.endsWith(".zip") ? fileName.substring(0, fileName.length() - ".zip".length()) : fileName;
            Path path = Paths.get(this.targetDir, dirName, compiledPackage.getPackageID().version.value);
            super.saveCompiledPackage(compiledPackage, path, fileName);
        }
    }
}

