/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.utils;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModuleToPackage {
    static final String BALLERINA_TOML = "Ballerina.toml";
    static final String SOURCE_DIR = "src";
    private static boolean replaceInline = true;
    static Path projectDir;
    static Path oldProjectPath;

    public static void main(String[] args) throws IOException {
        List modules;
        oldProjectPath = Paths.get(args[0], new String[0]);
        Path outputPath = Paths.get(args[1], new String[0]);
        if (replaceInline) {
            outputPath = oldProjectPath;
            oldProjectPath = outputPath.getParent().resolve(oldProjectPath.getFileName().toString() + "_old");
            Files.move(outputPath, oldProjectPath, new CopyOption[0]);
        }
        projectDir = outputPath;
        String defaultModule = null;
        if (args.length > 2) {
            defaultModule = args[2];
        }
        if (!Files.exists(oldProjectPath, new LinkOption[0])) {
            throw new RuntimeException("Invalid project path");
        }
        if (!Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        if ((modules = Files.walk(oldProjectPath.resolve(SOURCE_DIR), 1, new FileVisitOption[0]).filter(file -> !SOURCE_DIR.equals(String.valueOf(file.getFileName()))).filter(file -> Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).collect(Collectors.toList())).size() > 1) {
            if (defaultModule == null) {
                throw new RuntimeException("More than one module in the project. Please provide a default module.");
            }
        } else {
            defaultModule = ((Path)modules.get(0)).toString();
        }
        if (!replaceInline) {
            projectDir = projectDir.resolve(defaultModule);
        }
        if (Files.exists(projectDir, new LinkOption[0])) {
            Files.walk(projectDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        Files.createDirectories(projectDir, new FileAttribute[0]);
        ModuleToPackage.createNewToml(defaultModule);
        ModuleToPackage.copyFilesInProjectRoot(oldProjectPath, projectDir);
        ModuleToPackage.copyModule(oldProjectPath.resolve(SOURCE_DIR).resolve(defaultModule), projectDir);
        if (replaceInline) {
            try (Stream<Path> walk = Files.walk(oldProjectPath, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).peek(System.out::println).forEach(File::delete);
            }
        }
    }

    private static void createNewToml(String moduleName) throws IOException {
        Toml oldPlatform;
        String oldToml = Files.readString(oldProjectPath.resolve(BALLERINA_TOML));
        Toml toml = new Toml().read(oldToml);
        Path newToml = projectDir.resolve(BALLERINA_TOML);
        Files.createFile(newToml, new FileAttribute[0]);
        TomlWriter tomlWriter = new TomlWriter();
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        HashMap<String, String> pkg = new HashMap<String, String>();
        pkg.put("name", moduleName);
        pkg.put("org", toml.getTable("project").getString("org-name"));
        pkg.put("version", toml.getTable("project").getString("version"));
        map.put("package", pkg);
        Toml oldDependencies = toml.getTable("dependencies");
        if (oldDependencies != null) {
            ArrayList dependencies = new ArrayList();
            for (Map.Entry<String, Object> entry : oldDependencies.entrySet()) {
                HashMap<String, Object> dependency = new HashMap<String, Object>();
                String[] strings = entry.getKey().split("/");
                dependency.put("org", strings[0].replace("\"", ""));
                dependency.put("name", strings[1].replace("\"", ""));
                dependency.put("version", entry.getValue());
                dependencies.add(dependency);
            }
            map.put("dependency", dependencies);
        }
        if ((oldPlatform = toml.getTable("platform")) != null) {
            HashMap platform = new HashMap();
            HashMap java11 = new HashMap();
            ArrayList<HashMap> dependencies = new ArrayList<HashMap>();
            java11.put("dependency", dependencies);
            platform.put("java11", java11);
            map.put("platform", platform);
            List libs = oldPlatform.getList("libraries");
            if (libs != null && !libs.isEmpty()) {
                for (HashMap lib : libs) {
                    lib.remove("modules");
                    String newPath = ((String)lib.get("path")).replace("<PATH>", "../libs").replace("<VERSION>", "2.0.0-Preview6-SNAPSHOT");
                    lib.put("path", newPath);
                    dependencies.add(lib);
                }
            }
        }
        String tomlString = tomlWriter.write(map);
        tomlString = tomlString.replace("[[platform", "\n[[platform");
        Files.writeString(newToml, (CharSequence)tomlString, new OpenOption[0]);
    }

    private static void copyFilesInProjectRoot(Path source, Path target) throws IOException {
        try (Stream<Path> walk = Files.walk(source, 1, new FileVisitOption[0]);){
            walk.filter(f -> !f.getFileName().toString().equals(BALLERINA_TOML) && !Files.isDirectory(f, new LinkOption[0])).forEach(f -> {
                try {
                    Files.copy(f, target.resolve(f.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static void copyModule(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
                if (dir2.getFileName().toString().equals("tests") || dir2.getFileName().toString().equals("resources")) {
                    Files.createDirectories(target.resolve(source.relativize(dir2)), new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile;
                if ("Module.md".equals(file.getFileName().toString())) {
                    targetFile = target.resolve("Package.md");
                } else if (source.relativize(file).startsWith("resources") || source.relativize(file).startsWith("tests" + File.separator + "resources") || !file.getFileName().toString().endsWith(".bal")) {
                    targetFile = target.resolve(source.relativize(file));
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                } else {
                    targetFile = source.relativize(file).startsWith("tests") ? target.resolve("tests").resolve(file.getFileName()) : target.resolve(file.getFileName());
                }
                Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

