/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.TestNGException;
import org.testng.collections.Sets;
import org.testng.internal.Yaml;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;

public class Converter {
    @Parameter(description="file1 [file2 file3...]", required=true)
    private List<String> m_files;
    @Parameter(names={"-d"}, description="The directory where the file(s) will be created")
    private String m_outputDirectory = ".";

    public static void main(String[] stringArray) throws ParserConfigurationException, SAXException, IOException {
        Converter converter = new Converter();
        converter.run(stringArray);
    }

    private void findAllSuites(Collection<XmlSuite> collection, Set<XmlSuite> set) {
        for (XmlSuite xmlSuite : collection) {
            set.add(xmlSuite);
            for (XmlSuite xmlSuite2 : xmlSuite.getChildSuites()) {
                this.findAllSuites(Arrays.asList(xmlSuite2), set);
            }
        }
    }

    private void run(String[] stringArray) throws ParserConfigurationException, SAXException, IOException {
        JCommander jCommander = new JCommander(this);
        try {
            jCommander.parse(stringArray);
            File file = new File(this.m_outputDirectory);
            if (!file.exists()) {
                file.mkdir();
            }
            for (String string : this.m_files) {
                Set<XmlSuite> set = Sets.newHashSet();
                Parser parser = new Parser(string);
                parser.setLoadClasses(false);
                this.findAllSuites(parser.parse(), set);
                for (XmlSuite xmlSuite : set) {
                    File file2;
                    String string2 = xmlSuite.getFileName();
                    int n = string2.lastIndexOf(".");
                    String string3 = string2.substring(0, n);
                    int n2 = string3.lastIndexOf(File.separatorChar);
                    String string4 = string3.substring(n2 + 1);
                    if (string.endsWith(".xml")) {
                        file2 = new File(this.m_outputDirectory, string4 + ".yaml");
                        this.writeFile(file2, Yaml.toYaml(xmlSuite).toString());
                        continue;
                    }
                    if (string.endsWith(".yaml")) {
                        file2 = new File(this.m_outputDirectory, string4 + ".xml");
                        this.writeFile(file2, xmlSuite.toXml());
                        continue;
                    }
                    throw new TestNGException("Unknown file type:" + string);
                }
            }
        }
        catch (ParameterException parameterException) {
            System.out.println("Error: " + parameterException.getMessage());
            jCommander.usage();
        }
    }

    private void writeFile(File file, String string) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(string);
        }
        System.out.println("Wrote " + file);
    }
}

