/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import io.ballerina.tools.diagnostics.Location;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.types.ConstrainedType;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.packaging.RepoHierarchy;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstructorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.TaintRecord;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.LambdaExceptionUtils;

public class BIRPackageSymbolEnter {
    private final PackageCache packageCache;
    private final SymbolResolver symbolResolver;
    private final SymbolTable symTable;
    private final Names names;
    private final TypeParamAnalyzer typeParamAnalyzer;
    private final Types types;
    private BIRTypeReader typeReader;
    private BIRPackageSymbolEnv env;
    private List<BStructureTypeSymbol> structureTypes;
    private BStructureTypeSymbol currentStructure = null;
    private LinkedList<Object> compositeStack = new LinkedList();
    private static final int SERVICE_TYPE_TAG = 52;
    private static final CompilerContext.Key<BIRPackageSymbolEnter> COMPILED_PACKAGE_SYMBOL_ENTER_KEY = new CompilerContext.Key();
    private Map<String, BVarSymbol> globalVarMap = new HashMap<String, BVarSymbol>();

    public static BIRPackageSymbolEnter getInstance(CompilerContext context) {
        BIRPackageSymbolEnter packageReader = context.get(COMPILED_PACKAGE_SYMBOL_ENTER_KEY);
        if (packageReader == null) {
            packageReader = new BIRPackageSymbolEnter(context);
        }
        return packageReader;
    }

    private BIRPackageSymbolEnter(CompilerContext context) {
        context.put(COMPILED_PACKAGE_SYMBOL_ENTER_KEY, this);
        this.packageCache = PackageCache.getInstance(context);
        this.symbolResolver = SymbolResolver.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.types = Types.getInstance(context);
    }

    public BPackageSymbol definePackage(PackageID packageId, RepoHierarchy packageRepositoryHierarchy, byte[] packageBinaryContent) {
        BPackageSymbol pkgSymbol = this.definePackage(packageId, packageRepositoryHierarchy, new ByteArrayInputStream(packageBinaryContent));
        byte[] modifiedPkgBinaryContent = Arrays.copyOfRange(packageBinaryContent, 8, packageBinaryContent.length);
        pkgSymbol.birPackageFile = new CompiledBinaryFile.BIRPackageFile(modifiedPkgBinaryContent);
        SymbolEnv builtinEnv = this.symTable.pkgEnvMap.get(this.symTable.langAnnotationModuleSymbol);
        SymbolEnv pkgEnv = SymbolEnv.createPkgEnv(null, pkgSymbol.scope, builtinEnv);
        this.symTable.pkgEnvMap.put(pkgSymbol, pkgEnv);
        return pkgSymbol;
    }

    private BPackageSymbol definePackage(PackageID packageId, RepoHierarchy packageRepositoryHierarchy, InputStream programFileInStream) {
        BPackageSymbol bPackageSymbol;
        DataInputStream dataInStream = new DataInputStream(programFileInStream);
        try {
            BIRPackageSymbolEnv prevEnv = this.env;
            this.env = new BIRPackageSymbolEnv();
            this.env.requestedPackageId = packageId;
            this.env.repoHierarchy = packageRepositoryHierarchy;
            BPackageSymbol pkgSymbol = this.definePackage(dataInStream);
            this.env = prevEnv;
            bPackageSymbol = pkgSymbol;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new BLangCompilerException(e.getMessage(), e);
            }
        }
        dataInStream.close();
        return bPackageSymbol;
    }

    private BPackageSymbol definePackage(DataInputStream dataInStream) throws IOException {
        byte[] magic = new byte[4];
        dataInStream.read(magic, 0, 4);
        if (!Arrays.equals(magic, CompiledBinaryFile.BIRPackageFile.BIR_MAGIC)) {
            throw new BLangCompilerException("invalid magic number " + Arrays.toString(magic));
        }
        int version = dataInStream.readInt();
        if (version != 53) {
            throw new BLangCompilerException("unsupported program file version " + version);
        }
        this.env.constantPool = this.readConstantPool(dataInStream);
        int pkgCPIndex = dataInStream.readInt();
        return this.definePackage(dataInStream, pkgCPIndex);
    }

    private BPackageSymbol definePackage(DataInputStream dataInStream, int pkgCpIndex) throws IOException {
        CPEntry.PackageCPEntry pkgCpEntry = (CPEntry.PackageCPEntry)this.env.constantPool[pkgCpIndex];
        String orgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.orgNameCPIndex]).value;
        String pkgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.pkgNameCPIndex]).value;
        String pkgVersion = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.versionCPIndex]).value;
        PackageID pkgId = this.createPackageID(orgName, pkgName, pkgVersion);
        this.env.pkgSymbol = Symbols.createPackageSymbol(pkgId, this.symTable, SymbolOrigin.COMPILED_SOURCE);
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineImportPackage));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineConstant));
        this.structureTypes = new ArrayList<BStructureTypeSymbol>();
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineTypeDef));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::definePackageLevelVariables));
        this.readTypeDefBodies(dataInStream);
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineFunction));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineAnnotations));
        this.typeReader = null;
        return this.env.pkgSymbol;
    }

    private void readTypeDefBodies(DataInputStream dataInStream) throws IOException {
        dataInStream.readInt();
        Iterator<BStructureTypeSymbol> iterator = this.structureTypes.iterator();
        while (iterator.hasNext()) {
            BStructureTypeSymbol structureTypeSymbol;
            this.currentStructure = structureTypeSymbol = iterator.next();
            this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineFunction));
            this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::readBType));
        }
        this.currentStructure = null;
    }

    private CPEntry[] readConstantPool(DataInputStream dataInStream) throws IOException {
        int constantPoolSize = dataInStream.readInt();
        CPEntry[] constantPool = new CPEntry[constantPoolSize];
        this.env.constantPool = constantPool;
        for (int i = 0; i < constantPoolSize; ++i) {
            byte cpTag = dataInStream.readByte();
            CPEntry.Type cpEntryType = CPEntry.Type.values()[cpTag - 1];
            constantPool[i] = this.readCPEntry(dataInStream, constantPool, cpEntryType, i);
        }
        return constantPool;
    }

    private CPEntry readCPEntry(DataInputStream dataInStream, CPEntry[] constantPool, CPEntry.Type cpEntryType, int i) throws IOException {
        switch (cpEntryType) {
            case CP_ENTRY_INTEGER: {
                return new CPEntry.IntegerCPEntry(dataInStream.readLong());
            }
            case CP_ENTRY_FLOAT: {
                return new CPEntry.FloatCPEntry(dataInStream.readDouble());
            }
            case CP_ENTRY_BOOLEAN: {
                return new CPEntry.BooleanCPEntry(dataInStream.readBoolean());
            }
            case CP_ENTRY_STRING: {
                int length = dataInStream.readInt();
                String strValue = null;
                if (length >= 0) {
                    byte[] bytes = new byte[length];
                    dataInStream.read(bytes, 0, length);
                    strValue = new String(bytes);
                }
                return new CPEntry.StringCPEntry(strValue);
            }
            case CP_ENTRY_PACKAGE: {
                return new CPEntry.PackageCPEntry(dataInStream.readInt(), dataInStream.readInt(), dataInStream.readInt());
            }
            case CP_ENTRY_SHAPE: {
                this.env.unparsedBTypeCPs.put(i, this.readByteArray(dataInStream));
                return null;
            }
            case CP_ENTRY_BYTE: {
                return new CPEntry.ByteCPEntry(dataInStream.readInt());
            }
        }
        throw new IllegalStateException("unsupported constant pool entry type: " + cpEntryType.name());
    }

    private byte[] readByteArray(DataInputStream dataInStream) throws IOException {
        int length = dataInStream.readInt();
        byte[] bytes = new byte[length];
        dataInStream.readFully(bytes);
        return bytes;
    }

    private void defineSymbols(DataInputStream dataInStream, Consumer<DataInputStream> symbolDefineFunc) throws IOException {
        int symbolCount = dataInStream.readInt();
        for (int i = 0; i < symbolCount; ++i) {
            symbolDefineFunc.accept(dataInStream);
        }
    }

    private void defineImportPackage(DataInputStream dataInStream) throws IOException {
        String orgName = this.getStringCPEntryValue(dataInStream);
        String pkgName = this.getStringCPEntryValue(dataInStream);
        String pkgVersion = this.getStringCPEntryValue(dataInStream);
        PackageID importPkgID = this.createPackageID(orgName, pkgName, pkgVersion);
        BPackageSymbol importPackageSymbol = this.packageCache.getSymbol(importPkgID);
        this.env.pkgSymbol.scope.define(importPkgID.name, importPackageSymbol);
        this.env.pkgSymbol.imports.add(importPackageSymbol);
    }

    private void defineFunction(DataInputStream dataInStream) throws IOException {
        Location pos = this.readPosition(dataInStream);
        String funcName = this.getStringCPEntryValue(dataInStream);
        String workerName = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        byte origin = dataInStream.readByte();
        BInvokableType funcType = (BInvokableType)this.readBType(dataInStream);
        BInvokableSymbol invokableSymbol = Symbols.createFunctionSymbol(flags, this.names.fromString(funcName), this.env.pkgSymbol.pkgID, funcType, this.env.pkgSymbol, Symbols.isFlagOn(flags, 2L), pos, SymbolOrigin.toOrigin(origin));
        invokableSymbol.source = pos.lineRange().filePath();
        invokableSymbol.retType = funcType.retType;
        Scope scopeToDefine = this.env.pkgSymbol.scope;
        if (this.currentStructure != null) {
            BType attachedType = this.currentStructure.type;
            invokableSymbol.owner = attachedType.tsymbol;
            invokableSymbol.name = this.names.fromString(Symbols.getAttachedFuncSymbolName(attachedType.tsymbol.name.value, funcName));
            if (attachedType.tag == 33 || attachedType.tag == 12) {
                scopeToDefine = attachedType.tsymbol.scope;
                BAttachedFunction attachedFunc = new BAttachedFunction(this.names.fromString(funcName), invokableSymbol, funcType, this.symTable.builtinPos);
                BStructureTypeSymbol structureTypeSymbol = (BStructureTypeSymbol)attachedType.tsymbol;
                if (Names.USER_DEFINED_INIT_SUFFIX.value.equals(funcName) || funcName.equals(Names.INIT_FUNCTION_SUFFIX.value)) {
                    structureTypeSymbol.initializerFunc = attachedFunc;
                } else if (funcName.equals(Names.GENERATED_INIT_SUFFIX.value)) {
                    ((BObjectTypeSymbol)structureTypeSymbol).generatedInitializerFunc = attachedFunc;
                } else {
                    structureTypeSymbol.attachedFuncs.add(attachedFunc);
                }
            }
        }
        dataInStream.skip(dataInStream.readLong());
        this.setParamSymbols(invokableSymbol, dataInStream);
        this.readTaintTable(invokableSymbol, dataInStream);
        this.defineMarkDownDocAttachment(invokableSymbol, this.readDocBytes(dataInStream));
        this.defineGlobalVarDependencies(invokableSymbol, dataInStream);
        dataInStream.skip(dataInStream.readLong());
        dataInStream.skip(dataInStream.readLong());
        scopeToDefine.define(invokableSymbol.name, invokableSymbol);
    }

    private void defineGlobalVarDependencies(BInvokableSymbol invokableSymbol, DataInputStream dataInStream) throws IOException {
        long length = dataInStream.readInt();
        int i = 0;
        while ((long)i < length) {
            String globalVarName = this.getStringCPEntryValue(dataInStream.readInt());
            invokableSymbol.dependentGlobalVars.add(this.globalVarMap.get(globalVarName));
            ++i;
        }
    }

    private void defineTypeDef(DataInputStream dataInStream) throws IOException {
        Location pos = this.readPosition(dataInStream);
        String typeDefName = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        boolean isLabel = dataInStream.readByte() == 1;
        byte origin = dataInStream.readByte();
        byte[] docBytes = this.readDocBytes(dataInStream);
        BType type = this.readBType(dataInStream);
        if (type.tag == 16) {
            this.setInvokableTypeSymbol((BInvokableType)type);
        }
        flags = Symbols.isFlagOn(type.tsymbol.flags, 0x10000000L) ? flags | 0x10000000L : flags;
        flags = Symbols.isFlagOn(type.tsymbol.flags, 65536L) ? flags | 0x10000L : flags;
        BTypeSymbol symbol = isLabel ? type.tsymbol.createLabelSymbol() : type.tsymbol;
        this.defineMarkDownDocAttachment(symbol, docBytes);
        symbol.name = this.names.fromString(typeDefName);
        symbol.type = type;
        symbol.pkgID = this.env.pkgSymbol.pkgID;
        symbol.flags = flags;
        symbol.origin = SymbolOrigin.toOrigin(origin);
        symbol.pos = pos;
        if (type.tag == 12 || type.tag == 33) {
            this.structureTypes.add((BStructureTypeSymbol)symbol);
        }
        this.env.pkgSymbol.scope.define(symbol.name, symbol);
        if (type.tag == 28) {
            this.defineErrorConstructor(this.env.pkgSymbol.scope, symbol);
        }
    }

    private void skipPosition(DataInputStream dataInStream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            dataInStream.readInt();
        }
    }

    private void setInvokableTypeSymbol(BInvokableType invokableType) {
        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)invokableType.tsymbol;
        ArrayList<BVarSymbol> params = new ArrayList<BVarSymbol>();
        for (BType paramType : invokableType.paramTypes) {
            BVarSymbol varSymbol = new BVarSymbol(paramType.flags, Names.EMPTY, this.env.pkgSymbol.pkgID, paramType, null, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
            params.add(varSymbol);
        }
        tsymbol.params = params;
        if (invokableType.restType != null) {
            tsymbol.restParam = new BVarSymbol(0L, Names.EMPTY, this.env.pkgSymbol.pkgID, invokableType.restType, null, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        }
        tsymbol.returnType = invokableType.retType;
    }

    private void defineMarkDownDocAttachment(BSymbol symbol, byte[] docBytes) throws IOException {
        DataInputStream dataInStream = new DataInputStream(new ByteArrayInputStream(docBytes));
        boolean docPresent = dataInStream.readBoolean();
        if (!docPresent) {
            return;
        }
        MarkdownDocAttachment markdownDocAttachment = new MarkdownDocAttachment();
        int descCPIndex = dataInStream.readInt();
        int retDescCPIndex = dataInStream.readInt();
        markdownDocAttachment.description = descCPIndex >= 0 ? this.getStringCPEntryValue(descCPIndex) : null;
        markdownDocAttachment.returnValueDescription = retDescCPIndex >= 0 ? this.getStringCPEntryValue(retDescCPIndex) : null;
        int paramLength = dataInStream.readInt();
        for (int i = 0; i < paramLength; ++i) {
            int nameCPIndex = dataInStream.readInt();
            int paramDescCPIndex = dataInStream.readInt();
            String name = nameCPIndex >= 0 ? this.getStringCPEntryValue(nameCPIndex) : null;
            String description = paramDescCPIndex >= 0 ? this.getStringCPEntryValue(paramDescCPIndex) : null;
            MarkdownDocAttachment.Parameter parameter = new MarkdownDocAttachment.Parameter(name, description);
            markdownDocAttachment.parameters.add(parameter);
        }
        symbol.markdownDocumentation = markdownDocAttachment;
    }

    private void defineErrorConstructor(Scope scope, BTypeSymbol typeDefSymbol) {
        BConstructorSymbol symbol = new BConstructorSymbol(typeDefSymbol.flags, typeDefSymbol.name, typeDefSymbol.pkgID, typeDefSymbol.type, typeDefSymbol.owner, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        symbol.kind = SymbolKind.ERROR_CONSTRUCTOR;
        symbol.scope = new Scope(symbol);
        symbol.retType = typeDefSymbol.type;
        scope.define(symbol.name, symbol);
        ((BErrorTypeSymbol)typeDefSymbol).ctorSymbol = symbol;
    }

    private BType readBType(DataInputStream dataInStream) throws IOException {
        int typeCpIndex = dataInStream.readInt();
        CPEntry cpEntry = this.env.constantPool[typeCpIndex];
        BType type = null;
        if (cpEntry != null) {
            type = ((CPEntry.ShapeCPEntry)cpEntry).shape;
            if (type.tag != 16) {
                return type;
            }
        }
        if (type == null) {
            byte[] e = this.env.unparsedBTypeCPs.get(typeCpIndex);
            type = new BIRTypeReader(new DataInputStream(new ByteArrayInputStream(e))).readType(typeCpIndex);
            this.addShapeCP(type, typeCpIndex);
        }
        if (type.tag == 16) {
            return this.createClonedInvokableTypeWithTsymbol((BInvokableType)type);
        }
        return type;
    }

    private BInvokableType createClonedInvokableTypeWithTsymbol(BInvokableType bInvokableType) {
        BInvokableType clonedType = new BInvokableType(bInvokableType.paramTypes, bInvokableType.restType, bInvokableType.retType, null);
        clonedType.tsymbol = Symbols.createInvokableTypeSymbol(67108892, bInvokableType.flags, this.env.pkgSymbol.pkgID, null, this.env.pkgSymbol.owner, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        clonedType.flags = bInvokableType.flags;
        return clonedType;
    }

    private void addShapeCP(BType bType, int typeCpIndex) {
        this.env.constantPool[typeCpIndex] = new CPEntry.ShapeCPEntry(bType);
    }

    private void defineAnnotations(DataInputStream dataInStream) throws IOException {
        String name = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        byte origin = dataInStream.readByte();
        Location pos = this.readPosition(dataInStream);
        int attachPointCount = dataInStream.readInt();
        HashSet<AttachPoint> attachPoints = new HashSet<AttachPoint>(attachPointCount);
        for (int i = 0; i < attachPointCount; ++i) {
            attachPoints.add(AttachPoint.getAttachmentPoint(this.getStringCPEntryValue(dataInStream), dataInStream.readBoolean()));
        }
        BType annotationType = this.readBType(dataInStream);
        BAnnotationSymbol annotationSymbol = Symbols.createAnnotationSymbol(flags, attachPoints, this.names.fromString(name), this.env.pkgSymbol.pkgID, null, this.env.pkgSymbol, pos, SymbolOrigin.toOrigin(origin));
        annotationSymbol.type = new BAnnotationType(annotationSymbol);
        this.defineMarkDownDocAttachment(annotationSymbol, this.readDocBytes(dataInStream));
        this.env.pkgSymbol.scope.define(annotationSymbol.name, annotationSymbol);
        if (annotationType != this.symTable.noType) {
            annotationSymbol.attachedType = annotationType.tsymbol;
        }
    }

    private void defineConstant(DataInputStream dataInStream) throws IOException {
        String constantName = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        byte origin = dataInStream.readByte();
        Location pos = this.readPosition(dataInStream);
        byte[] docBytes = this.readDocBytes(dataInStream);
        BType type = this.readBType(dataInStream);
        Scope enclScope = this.env.pkgSymbol.scope;
        BConstantSymbol constantSymbol = new BConstantSymbol(flags, this.names.fromString(constantName), this.env.pkgSymbol.pkgID, null, type, enclScope.owner, pos, SymbolOrigin.toOrigin(origin));
        this.defineMarkDownDocAttachment(constantSymbol, docBytes);
        dataInStream.readLong();
        constantSymbol.value = this.readConstLiteralValue(dataInStream);
        constantSymbol.literalType = constantSymbol.value.type;
        enclScope.define(constantSymbol.name, constantSymbol);
    }

    private BLangConstantValue readConstLiteralValue(DataInputStream dataInStream) throws IOException {
        BType valueType = this.readBType(dataInStream);
        switch (valueType.tag) {
            case 1: {
                return new BLangConstantValue(this.getIntCPEntryValue(dataInStream), this.symTable.intType);
            }
            case 2: {
                return new BLangConstantValue(this.getByteCPEntryValue(dataInStream), this.symTable.byteType);
            }
            case 3: {
                return new BLangConstantValue(this.getFloatCPEntryValue(dataInStream), this.symTable.floatType);
            }
            case 5: {
                return new BLangConstantValue(this.getStringCPEntryValue(dataInStream), this.symTable.stringType);
            }
            case 4: {
                return new BLangConstantValue(this.getStringCPEntryValue(dataInStream), this.symTable.decimalType);
            }
            case 6: {
                return new BLangConstantValue(dataInStream.readBoolean(), this.symTable.booleanType);
            }
            case 10: {
                return new BLangConstantValue(null, this.symTable.nilType);
            }
            case 15: {
                int size = dataInStream.readInt();
                LinkedHashMap<String, BLangConstantValue> keyValuePairs = new LinkedHashMap<String, BLangConstantValue>();
                for (int i = 0; i < size; ++i) {
                    String key = this.getStringCPEntryValue(dataInStream);
                    BLangConstantValue value = this.readConstLiteralValue(dataInStream);
                    keyValuePairs.put(key, value);
                }
                return new BLangConstantValue(keyValuePairs, valueType);
            }
        }
        throw new RuntimeException("unexpected type: " + valueType);
    }

    private void definePackageLevelVariables(DataInputStream dataInStream) throws IOException {
        BVarSymbol varSymbol;
        dataInStream.readByte();
        String varName = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        byte origin = dataInStream.readByte();
        byte[] docBytes = this.readDocBytes(dataInStream);
        BType varType = this.readBType(dataInStream);
        Scope enclScope = this.env.pkgSymbol.scope;
        if (varType.tag == 16) {
            varSymbol = new BInvokableSymbol(52, flags, this.names.fromString(varName), this.env.pkgSymbol.pkgID, varType, enclScope.owner, this.symTable.builtinPos, SymbolOrigin.toOrigin(origin));
        } else {
            varSymbol = new BVarSymbol(flags, this.names.fromString(varName), this.env.pkgSymbol.pkgID, varType, enclScope.owner, this.symTable.builtinPos, SymbolOrigin.toOrigin(origin));
            if (varType.tsymbol != null && Symbols.isFlagOn(varType.tsymbol.flags, 65536L)) {
                varSymbol.tag = 32820;
            }
        }
        this.globalVarMap.put(varName, varSymbol);
        this.defineMarkDownDocAttachment(varSymbol, docBytes);
        enclScope.define(varSymbol.name, varSymbol);
    }

    private void setParamSymbols(BInvokableSymbol invokableSymbol, DataInputStream dataInStream) throws IOException {
        int requiredParamCount = dataInStream.readInt();
        BInvokableType invokableType = (BInvokableType)invokableSymbol.type;
        for (int i = 0; i < requiredParamCount; ++i) {
            String paramName = this.getStringCPEntryValue(dataInStream);
            long flags = dataInStream.readLong();
            BVarSymbol varSymbol = new BVarSymbol(flags, this.names.fromString(paramName), this.env.pkgSymbol.pkgID, invokableType.paramTypes.get(i), invokableSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
            varSymbol.defaultableParam = (flags & 0x1000L) == 4096L;
            invokableSymbol.params.add(varSymbol);
        }
        if (dataInStream.readBoolean()) {
            String paramName = this.getStringCPEntryValue(dataInStream);
            invokableSymbol.restParam = new BVarSymbol(0L, this.names.fromString(paramName), this.env.pkgSymbol.pkgID, invokableType.restType, invokableSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        }
        if (Symbols.isFlagOn(invokableSymbol.retType.flags, 0x4000000L)) {
            HashMap<Name, BVarSymbol> paramsMap = new HashMap<Name, BVarSymbol>();
            for (BVarSymbol param : invokableSymbol.params) {
                if (paramsMap.put(param.getName(), param) == null) continue;
                throw new IllegalStateException("Duplicate key: " + param.getName());
            }
            this.populateParameterizedType(invokableSymbol.retType, paramsMap, invokableSymbol);
        }
        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)invokableType.tsymbol;
        tsymbol.flags = invokableSymbol.flags;
        tsymbol.params = invokableSymbol.params;
        tsymbol.restParam = invokableSymbol.restParam;
        tsymbol.returnType = invokableSymbol.retType;
        boolean hasReceiver = dataInStream.readBoolean();
        if (hasReceiver) {
            dataInStream.readByte();
            this.readBType(dataInStream);
            this.getStringCPEntryValue(dataInStream);
        }
    }

    private void populateParameterizedType(BType type, Map<Name, BVarSymbol> paramsMap, BInvokableSymbol invSymbol) {
        if (type == null) {
            return;
        }
        switch (type.tag) {
            case 51: {
                BParameterizedType varType = (BParameterizedType)type;
                varType.paramSymbol = paramsMap.get(varType.name);
                varType.tsymbol = new BTypeSymbol(12, 0x4000000L | varType.paramSymbol.flags, varType.paramSymbol.name, varType.paramSymbol.pkgID, varType, invSymbol, varType.paramSymbol.pos, SymbolOrigin.VIRTUAL);
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 31: {
                ConstrainedType constrainedType = (ConstrainedType)((Object)type);
                this.populateParameterizedType((BType)constrainedType.getConstraint(), paramsMap, invSymbol);
                break;
            }
            case 19: {
                this.populateParameterizedType(((BArrayType)type).eType, paramsMap, invSymbol);
                break;
            }
            case 30: {
                BTupleType tupleType = (BTupleType)type;
                for (BType t : tupleType.tupleTypes) {
                    this.populateParameterizedType(t, paramsMap, invSymbol);
                }
                this.populateParameterizedType(tupleType.restType, paramsMap, invSymbol);
                break;
            }
            case 14: {
                BStreamType streamType = (BStreamType)type;
                this.populateParameterizedType(streamType.constraint, paramsMap, invSymbol);
                this.populateParameterizedType(streamType.error, paramsMap, invSymbol);
                break;
            }
            case 9: {
                BTableType tableType = (BTableType)type;
                this.populateParameterizedType(tableType.constraint, paramsMap, invSymbol);
                this.populateParameterizedType(tableType.keyTypeConstraint, paramsMap, invSymbol);
                break;
            }
            case 16: {
                BInvokableType invokableType = (BInvokableType)type;
                for (BType t : invokableType.paramTypes) {
                    this.populateParameterizedType(t, paramsMap, invSymbol);
                }
                this.populateParameterizedType(invokableType.restType, paramsMap, invSymbol);
                this.populateParameterizedType(invokableType.retType, paramsMap, invSymbol);
                break;
            }
            case 20: {
                BUnionType unionType = (BUnionType)type;
                for (BType t : unionType.getMemberTypes()) {
                    this.populateParameterizedType(t, paramsMap, invSymbol);
                }
                break;
            }
        }
    }

    private void readTaintTable(BInvokableSymbol invokableSymbol, DataInputStream dataInStream) throws IOException {
        long length = dataInStream.readLong();
        if (length <= 0L) {
            return;
        }
        int rowCount = dataInStream.readShort();
        int columnCount = dataInStream.readShort();
        invokableSymbol.taintTable = new HashMap<Integer, TaintRecord>();
        dataInStream.readInt();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            short paramIndex = dataInStream.readShort();
            dataInStream.readInt();
            TaintRecord.TaintedStatus returnTaintedStatus = this.convertByteToTaintedStatus(dataInStream.readByte());
            ArrayList<TaintRecord.TaintedStatus> parameterTaintedStatusList = new ArrayList<TaintRecord.TaintedStatus>();
            for (int columnIndex = 1; columnIndex < columnCount; ++columnIndex) {
                parameterTaintedStatusList.add(this.convertByteToTaintedStatus(dataInStream.readByte()));
            }
            TaintRecord taintRecord = new TaintRecord(returnTaintedStatus, parameterTaintedStatusList);
            invokableSymbol.taintTable.put(Integer.valueOf(paramIndex), taintRecord);
        }
    }

    private TaintRecord.TaintedStatus convertByteToTaintedStatus(byte readByte) {
        return EnumSet.allOf(TaintRecord.TaintedStatus.class).stream().filter(taintedStatus -> readByte == taintedStatus.getByteValue()).findFirst().get();
    }

    private Location readPosition(DataInputStream dataInStream) throws IOException {
        String cUnitName = this.getStringCPEntryValue(dataInStream);
        int sLine = dataInStream.readInt();
        int sCol = dataInStream.readInt();
        int eLine = dataInStream.readInt();
        int eCol = dataInStream.readInt();
        return new BLangDiagnosticLocation(cUnitName, sLine, eLine, sCol, eCol);
    }

    private String getStringCPEntryValue(DataInputStream dataInStream) throws IOException {
        int pkgNameCPIndex = dataInStream.readInt();
        CPEntry.StringCPEntry stringCPEntry = (CPEntry.StringCPEntry)this.env.constantPool[pkgNameCPIndex];
        return stringCPEntry.value;
    }

    private String getStringCPEntryValue(int cpIndex) throws IOException {
        CPEntry.StringCPEntry stringCPEntry = (CPEntry.StringCPEntry)this.env.constantPool[cpIndex];
        return stringCPEntry.value;
    }

    private long getIntCPEntryValue(DataInputStream dataInStream) throws IOException {
        int pkgNameCPIndex = dataInStream.readInt();
        CPEntry.IntegerCPEntry intCPEntry = (CPEntry.IntegerCPEntry)this.env.constantPool[pkgNameCPIndex];
        return intCPEntry.value;
    }

    private int getByteCPEntryValue(DataInputStream dataInStream) throws IOException {
        int byteCpIndex = dataInStream.readInt();
        CPEntry.ByteCPEntry byteCPEntry = (CPEntry.ByteCPEntry)this.env.constantPool[byteCpIndex];
        return byteCPEntry.value;
    }

    private String getFloatCPEntryValue(DataInputStream dataInStream) throws IOException {
        int floatCpIndex = dataInStream.readInt();
        CPEntry.FloatCPEntry floatCPEntry = (CPEntry.FloatCPEntry)this.env.constantPool[floatCpIndex];
        return Double.toString(floatCPEntry.value);
    }

    private PackageID createPackageID(String orgName, String pkgName, String pkgVersion) {
        if (orgName == null || orgName.isEmpty()) {
            throw new BLangCompilerException("invalid module name '" + pkgName + "' in compiled package file");
        }
        return new PackageID(this.names.fromString(orgName), this.names.fromString(pkgName), this.names.fromString(pkgVersion));
    }

    private byte[] readDocBytes(DataInputStream inputStream) throws IOException {
        byte[] docBytes;
        int noOfBytesRead;
        int docLength = inputStream.readInt();
        if (docLength != (noOfBytesRead = inputStream.read(docBytes = new byte[docLength]))) {
            throw new RuntimeException("Failed to read Markdown Documenation");
        }
        return docBytes;
    }

    private PackageID getPackageId(int pkgCPIndex) {
        CPEntry.PackageCPEntry pkgCpEntry = (CPEntry.PackageCPEntry)this.env.constantPool[pkgCPIndex];
        String orgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.orgNameCPIndex]).value;
        String pkgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.pkgNameCPIndex]).value;
        String version = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.versionCPIndex]).value;
        return new PackageID(this.names.fromString(orgName), this.names.fromString(pkgName), this.names.fromString(version));
    }

    private void defineValueSpace(DataInputStream dataInStream, BFiniteType finiteType, BIRTypeReader typeReader) throws IOException {
        BType valueType = typeReader.readTypeFromCp();
        dataInStream.readInt();
        BLangLiteral litExpr = this.createLiteralBasedOnType(valueType);
        switch (valueType.tag) {
            case 1: {
                int integerCpIndex = dataInStream.readInt();
                CPEntry.IntegerCPEntry integerCPEntry = (CPEntry.IntegerCPEntry)this.env.constantPool[integerCpIndex];
                litExpr.value = integerCPEntry.value;
                break;
            }
            case 2: {
                int byteCpIndex = dataInStream.readInt();
                CPEntry.ByteCPEntry byteCPEntry = (CPEntry.ByteCPEntry)this.env.constantPool[byteCpIndex];
                litExpr.value = byteCPEntry.value;
                break;
            }
            case 3: {
                int floatCpIndex = dataInStream.readInt();
                CPEntry.FloatCPEntry floatCPEntry = (CPEntry.FloatCPEntry)this.env.constantPool[floatCpIndex];
                litExpr.value = Double.toString(floatCPEntry.value);
                break;
            }
            case 4: 
            case 5: {
                litExpr.value = this.getStringCPEntryValue(dataInStream);
                break;
            }
            case 6: {
                litExpr.value = dataInStream.readBoolean();
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("finite type value is not supported for type: " + valueType);
            }
        }
        litExpr.type = valueType;
        finiteType.addValue(litExpr);
    }

    private BLangLiteral createLiteralBasedOnType(BType valueType) {
        NodeKind nodeKind = valueType.tag <= 4 ? NodeKind.NUMERIC_LITERAL : NodeKind.LITERAL;
        return nodeKind == NodeKind.LITERAL ? (BLangLiteral)TreeBuilder.createLiteralExpression() : (BLangLiteral)TreeBuilder.createNumericLiteralExpression();
    }

    private boolean isImmutable(long flags) {
        return Symbols.isFlagOn(flags, 32L);
    }

    private BType getEffectiveImmutableType(BType type) {
        return ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, (SelectivelyImmutableReferenceType)((Object)type), type.tsymbol.pkgID, type.tsymbol.owner, this.symTable, null, this.names);
    }

    private BType getEffectiveImmutableType(BType type, PackageID pkgID, BSymbol owner) {
        return ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, (SelectivelyImmutableReferenceType)((Object)type), pkgID, owner, this.symTable, null, this.names);
    }

    private class BIRTypeReader {
        private DataInputStream inputStream;

        public BIRTypeReader(DataInputStream inputStream) {
            this.inputStream = inputStream;
        }

        private BType readTypeFromCp() throws IOException {
            return BIRPackageSymbolEnter.this.readBType(this.inputStream);
        }

        public BType readType(int cpI) throws IOException {
            byte tag = this.inputStream.readByte();
            Name name = BIRPackageSymbolEnter.this.names.fromString(BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream));
            long flags = this.inputStream.readLong();
            this.inputStream.readInt();
            switch (tag) {
                case 1: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.intType, name, flags);
                }
                case 2: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.byteType, name, flags);
                }
                case 3: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.floatType, name, flags);
                }
                case 4: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.decimalType, name, flags);
                }
                case 5: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.stringType, name, flags);
                }
                case 6: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.booleanType, name, flags);
                }
                case 7: {
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(BIRPackageSymbolEnter.this.symTable.jsonType) : BIRPackageSymbolEnter.this.symTable.jsonType;
                }
                case 8: {
                    BType constraintType = this.readTypeFromCp();
                    BXMLType mutableXmlType = new BXMLType(constraintType, BIRPackageSymbolEnter.this.symTable.xmlType.tsymbol);
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(mutableXmlType) : mutableXmlType;
                }
                case 10: {
                    return BIRPackageSymbolEnter.this.symTable.nilType;
                }
                case 49: {
                    return BIRPackageSymbolEnter.this.symTable.neverType;
                }
                case 11: {
                    BType anydataNominalType = BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.anydataType, name, flags);
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(anydataNominalType, BIRPackageSymbolEnter.this.symTable.anydataType.tsymbol.pkgID, BIRPackageSymbolEnter.this.symTable.anydataType.tsymbol.owner) : anydataNominalType;
                }
                case 12: {
                    boolean isInitAvailable;
                    int pkgCpIndex = this.inputStream.readInt();
                    PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                    String recordName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(Flags.asMask(EnumSet.of(Flag.PUBLIC)), BIRPackageSymbolEnter.this.names.fromString(recordName), BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    recordSymbol.flags |= flags;
                    recordSymbol.scope = new Scope(recordSymbol);
                    BRecordType recordType = new BRecordType(recordSymbol, recordSymbol.flags);
                    recordType.flags |= flags;
                    if (BIRPackageSymbolEnter.this.isImmutable(flags)) {
                        recordSymbol.flags |= 0x20L;
                    }
                    recordSymbol.type = recordType;
                    BIRPackageSymbolEnter.this.compositeStack.push(recordType);
                    BIRPackageSymbolEnter.this.addShapeCP(recordType, cpI);
                    recordType.sealed = this.inputStream.readBoolean();
                    recordType.restFieldType = this.readTypeFromCp();
                    int recordFields = this.inputStream.readInt();
                    for (int i = 0; i < recordFields; ++i) {
                        String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        long fieldFlags = this.inputStream.readLong();
                        byte[] docBytes = BIRPackageSymbolEnter.this.readDocBytes(this.inputStream);
                        BType fieldType = this.readTypeFromCp();
                        BVarSymbol varSymbol = new BVarSymbol(fieldFlags, BIRPackageSymbolEnter.this.names.fromString(fieldName), recordSymbol.pkgID, fieldType, recordSymbol.scope.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                        BIRPackageSymbolEnter.this.defineMarkDownDocAttachment(varSymbol, docBytes);
                        BField structField = new BField(varSymbol.name, null, varSymbol);
                        recordType.fields.put(structField.name.value, structField);
                        recordSymbol.scope.define(varSymbol.name, varSymbol);
                    }
                    boolean bl = isInitAvailable = this.inputStream.readByte() == 1;
                    if (isInitAvailable) {
                        String recordInitFuncName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        long recordInitFuncFlags = this.inputStream.readLong();
                        BInvokableType recordInitFuncType = (BInvokableType)this.readTypeFromCp();
                        Name initFuncName = BIRPackageSymbolEnter.this.names.fromString(recordInitFuncName);
                        boolean isNative = Symbols.isFlagOn(recordInitFuncFlags, 2L);
                        BInvokableSymbol recordInitFuncSymbol = Symbols.createFunctionSymbol(recordInitFuncFlags, initFuncName, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, recordInitFuncType, BIRPackageSymbolEnter.this.env.pkgSymbol, isNative, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                        recordInitFuncSymbol.retType = recordInitFuncType.retType;
                        recordSymbol.initializerFunc = new BAttachedFunction(initFuncName, recordInitFuncSymbol, recordInitFuncType, BIRPackageSymbolEnter.this.symTable.builtinPos);
                        recordSymbol.scope.define(initFuncName, recordInitFuncSymbol);
                    }
                    recordType.typeInclusions = this.readTypeInclusions();
                    Object poppedRecordType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedRecordType == recordType);
                    if (pkgId.equals(BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID)) {
                        return recordType;
                    }
                    SymbolEnv pkgEnv = BIRPackageSymbolEnter.this.symTable.pkgEnvMap.get(BIRPackageSymbolEnter.this.packageCache.getSymbol(pkgId));
                    return BIRPackageSymbolEnter.this.symbolResolver.lookupSymbolInMainSpace((SymbolEnv)pkgEnv, (Name)BIRPackageSymbolEnter.this.names.fromString((String)recordName)).type;
                }
                case 13: {
                    BTypedescType typedescType = new BTypedescType(null, BIRPackageSymbolEnter.this.symTable.typeDesc.tsymbol);
                    typedescType.constraint = this.readTypeFromCp();
                    typedescType.flags = flags;
                    return typedescType;
                }
                case 51: {
                    BParameterizedType type = new BParameterizedType(null, null, null, name, -1);
                    type.paramValueType = this.readTypeFromCp();
                    type.flags = flags;
                    type.paramIndex = this.inputStream.readInt();
                    return type;
                }
                case 14: {
                    boolean hasError;
                    BStreamType bStreamType = new BStreamType(14, null, null, BIRPackageSymbolEnter.this.symTable.streamType.tsymbol);
                    bStreamType.constraint = this.readTypeFromCp();
                    bStreamType.flags = flags;
                    boolean bl = hasError = this.inputStream.readByte() == 1;
                    if (hasError) {
                        bStreamType.error = this.readTypeFromCp();
                    }
                    return bStreamType;
                }
                case 9: {
                    boolean hasKeyConstraint;
                    boolean hasFieldNameList;
                    BTableType bTableType = new BTableType(9, null, BIRPackageSymbolEnter.this.symTable.tableType.tsymbol, flags);
                    bTableType.constraint = this.readTypeFromCp();
                    boolean bl = hasFieldNameList = this.inputStream.readByte() == 1;
                    if (hasFieldNameList) {
                        bTableType.fieldNameList = new ArrayList<String>();
                        int fieldNameListSize = this.inputStream.readInt();
                        for (int i = 0; i < fieldNameListSize; ++i) {
                            String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                            bTableType.fieldNameList.add(fieldName);
                        }
                    }
                    boolean bl2 = hasKeyConstraint = this.inputStream.readByte() == 1;
                    if (hasKeyConstraint) {
                        bTableType.keyTypeConstraint = this.readTypeFromCp();
                        if (bTableType.keyTypeConstraint.tsymbol == null) {
                            bTableType.keyTypeConstraint.tsymbol = Symbols.createTypeSymbol(12, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, bTableType.keyTypeConstraint, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                        }
                    }
                    return bTableType;
                }
                case 15: {
                    BMapType bMapType = new BMapType(15, null, BIRPackageSymbolEnter.this.symTable.mapType.tsymbol, flags);
                    bMapType.constraint = this.readTypeFromCp();
                    return bMapType;
                }
                case 16: {
                    BInvokableType bInvokableType = new BInvokableType(null, null, null, null);
                    bInvokableType.flags = flags;
                    int paramCount = this.inputStream.readInt();
                    ArrayList<BType> paramTypes = new ArrayList<BType>();
                    for (int i = 0; i < paramCount; ++i) {
                        paramTypes.add(this.readTypeFromCp());
                    }
                    bInvokableType.paramTypes = paramTypes;
                    if (this.inputStream.readBoolean()) {
                        bInvokableType.restType = this.readTypeFromCp();
                    }
                    bInvokableType.retType = this.readTypeFromCp();
                    return bInvokableType;
                }
                case 17: {
                    BType anyNominalType = BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.anyType, name, flags);
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(anyNominalType, BIRPackageSymbolEnter.this.symTable.anyType.tsymbol.pkgID, BIRPackageSymbolEnter.this.symTable.anyType.tsymbol.owner) : anyNominalType;
                }
                case 36: {
                    return BIRPackageSymbolEnter.this.symTable.handleType;
                }
                case 37: {
                    return BIRPackageSymbolEnter.this.symTable.readonlyType;
                }
                case 18: {
                    break;
                }
                case 19: {
                    byte state = this.inputStream.readByte();
                    int size = this.inputStream.readInt();
                    BTypeSymbol arrayTypeSymbol = Symbols.createTypeSymbol(0x101001C, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    BArrayType bArrayType = new BArrayType(null, arrayTypeSymbol, size, BArrayState.valueOf(state), flags);
                    bArrayType.eType = this.readTypeFromCp();
                    return bArrayType;
                }
                case 20: {
                    BTypeSymbol unionTypeSymbol = Symbols.createTypeSymbol(2162716, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    BUnionType unionType = BUnionType.create(unionTypeSymbol, new LinkedHashSet<BType>());
                    int unionMemberCount = this.inputStream.readInt();
                    for (int i = 0; i < unionMemberCount; ++i) {
                        unionType.add(this.readTypeFromCp());
                    }
                    unionType.flags = flags;
                    return unionType;
                }
                case 21: {
                    BTypeSymbol intersectionTypeSymbol = Symbols.createTypeSymbol(4194332, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    int intersectionMemberCount = this.inputStream.readInt();
                    LinkedHashSet<BType> constituentTypes = new LinkedHashSet<BType>(intersectionMemberCount);
                    for (int i = 0; i < intersectionMemberCount; ++i) {
                        constituentTypes.add(this.readTypeFromCp());
                    }
                    BType effectiveType = this.readTypeFromCp();
                    return new BIntersectionType(intersectionTypeSymbol, constituentTypes, effectiveType, flags);
                }
                case 22: {
                    break;
                }
                case 23: {
                    return BIRPackageSymbolEnter.this.symTable.noType;
                }
                case 24: {
                    break;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    break;
                }
                case 28: {
                    BType detailsType;
                    BErrorTypeSymbol errorSymbol = new BErrorTypeSymbol(589852, 1L, Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    BErrorType errorType = new BErrorType(errorSymbol);
                    BIRPackageSymbolEnter.this.addShapeCP(errorType, cpI);
                    BIRPackageSymbolEnter.this.compositeStack.push(errorType);
                    int pkgCpIndex = this.inputStream.readInt();
                    PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                    String errorName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    errorType.detailType = detailsType = this.readTypeFromCp();
                    errorType.flags = flags;
                    errorSymbol.type = errorType;
                    errorSymbol.pkgID = pkgId;
                    errorSymbol.name = BIRPackageSymbolEnter.this.names.fromString(errorName);
                    Object poppedErrorType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedErrorType == errorType);
                    if (!BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID.equals(PackageID.ANNOTATIONS) && Symbols.isFlagOn(flags, 2L)) {
                        return BIRPackageSymbolEnter.this.symTable.errorType;
                    }
                    errorType.typeIdSet = this.readTypeIdSet(this.inputStream);
                    return errorType;
                }
                case 29: {
                    break;
                }
                case 30: {
                    BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(8454172, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    BTupleType bTupleType = new BTupleType(tupleTypeSymbol, null);
                    bTupleType.flags = flags;
                    int tupleMemberCount = this.inputStream.readInt();
                    ArrayList<BType> tupleMemberTypes = new ArrayList<BType>();
                    for (int i = 0; i < tupleMemberCount; ++i) {
                        tupleMemberTypes.add(this.readTypeFromCp());
                    }
                    bTupleType.tupleTypes = tupleMemberTypes;
                    return bTupleType;
                }
                case 31: {
                    BFutureType bFutureType = new BFutureType(31, null, BIRPackageSymbolEnter.this.symTable.futureType.tsymbol);
                    bFutureType.constraint = this.readTypeFromCp();
                    bFutureType.flags = flags;
                    return bFutureType;
                }
                case 32: {
                    String finiteTypeName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    long finiteTypeFlags = this.inputStream.readLong();
                    BTypeSymbol symbol = Symbols.createTypeSymbol(0x10001C, finiteTypeFlags, BIRPackageSymbolEnter.this.names.fromString(finiteTypeName), BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    symbol.scope = new Scope(symbol);
                    BFiniteType finiteType = new BFiniteType(symbol);
                    finiteType.flags = flags;
                    symbol.type = finiteType;
                    int valueSpaceSize = this.inputStream.readInt();
                    for (int i = 0; i < valueSpaceSize; ++i) {
                        BIRPackageSymbolEnter.this.defineValueSpace(this.inputStream, finiteType, this);
                    }
                    return finiteType;
                }
                case 33: {
                    boolean constructorPresent;
                    BObjectType objectType;
                    boolean service = this.inputStream.readByte() == 1;
                    int pkgCpIndex = this.inputStream.readInt();
                    PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                    String objName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    long objFlags = (this.inputStream.readBoolean() ? 0x10000000L : 0L) | 1L;
                    objFlags = this.inputStream.readBoolean() ? objFlags | 0x10000L : objFlags;
                    BObjectTypeSymbol objectSymbol = Symbols.isFlagOn(objFlags, 0x10000000L) ? Symbols.createClassSymbol(objFlags, BIRPackageSymbolEnter.this.names.fromString(objName), BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE) : Symbols.createObjectSymbol(objFlags, BIRPackageSymbolEnter.this.names.fromString(objName), BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    objectSymbol.scope = new Scope(objectSymbol);
                    if (service) {
                        objectType = new BServiceType(objectSymbol);
                    } else {
                        objectType = new BObjectType(objectSymbol);
                        if (BIRPackageSymbolEnter.this.isImmutable(flags)) {
                            objectSymbol.flags |= 0x20L;
                        }
                    }
                    objectType.flags = flags;
                    objectSymbol.type = objectType;
                    BIRPackageSymbolEnter.this.addShapeCP(objectType, cpI);
                    BIRPackageSymbolEnter.this.compositeStack.push(objectType);
                    int fieldCount = this.inputStream.readInt();
                    for (int i = 0; i < fieldCount; ++i) {
                        String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        long fieldFlags = this.inputStream.readLong();
                        byte[] docBytes = BIRPackageSymbolEnter.this.readDocBytes(this.inputStream);
                        BType fieldType = this.readTypeFromCp();
                        BVarSymbol objectVarSymbol = new BVarSymbol(fieldFlags, BIRPackageSymbolEnter.this.names.fromString(fieldName), objectSymbol.pkgID, fieldType, objectSymbol.scope.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                        BIRPackageSymbolEnter.this.defineMarkDownDocAttachment(objectVarSymbol, docBytes);
                        BField structField = new BField(objectVarSymbol.name, null, objectVarSymbol);
                        objectType.fields.put(structField.name.value, structField);
                        objectSymbol.scope.define(objectVarSymbol.name, objectVarSymbol);
                    }
                    boolean generatedConstructorPresent = this.inputStream.readBoolean();
                    if (generatedConstructorPresent) {
                        this.ignoreAttachedFunc();
                    }
                    if (constructorPresent = this.inputStream.readBoolean()) {
                        this.ignoreAttachedFunc();
                    }
                    int funcCount = this.inputStream.readInt();
                    for (int i = 0; i < funcCount; ++i) {
                        this.ignoreAttachedFunc();
                    }
                    objectType.typeInclusions = this.readTypeInclusions();
                    objectType.typeIdSet = this.readTypeIdSet(this.inputStream);
                    Object poppedObjType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedObjType == objectType);
                    if (pkgId.equals(BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID)) {
                        return objectType;
                    }
                    SymbolEnv pkgEnv = BIRPackageSymbolEnter.this.symTable.pkgEnvMap.get(BIRPackageSymbolEnter.this.packageCache.getSymbol(pkgId));
                    return BIRPackageSymbolEnter.this.symbolResolver.lookupSymbolInMainSpace((SymbolEnv)pkgEnv, (Name)BIRPackageSymbolEnter.this.names.fromString((String)objName)).type;
                }
                case 34: {
                    break;
                }
                case 35: {
                    break;
                }
                case 52: {
                    return BIRPackageSymbolEnter.this.symTable.anyServiceType;
                }
                case 38: {
                    return BIRPackageSymbolEnter.this.symTable.signed32IntType;
                }
                case 39: {
                    return BIRPackageSymbolEnter.this.symTable.signed16IntType;
                }
                case 40: {
                    return BIRPackageSymbolEnter.this.symTable.signed8IntType;
                }
                case 41: {
                    return BIRPackageSymbolEnter.this.symTable.unsigned32IntType;
                }
                case 42: {
                    return BIRPackageSymbolEnter.this.symTable.unsigned16IntType;
                }
                case 43: {
                    return BIRPackageSymbolEnter.this.symTable.unsigned8IntType;
                }
                case 44: {
                    return BIRPackageSymbolEnter.this.symTable.charStringType;
                }
                case 45: {
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(BIRPackageSymbolEnter.this.symTable.xmlElementType) : BIRPackageSymbolEnter.this.symTable.xmlElementType;
                }
                case 46: {
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(BIRPackageSymbolEnter.this.symTable.xmlPIType) : BIRPackageSymbolEnter.this.symTable.xmlPIType;
                }
                case 47: {
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(BIRPackageSymbolEnter.this.symTable.xmlCommentType) : BIRPackageSymbolEnter.this.symTable.xmlCommentType;
                }
                case 48: {
                    return BIRPackageSymbolEnter.this.symTable.xmlTextType;
                }
            }
            return null;
        }

        private BTypeIdSet readTypeIdSet(DataInputStream inputStream) throws IOException {
            HashSet<BTypeIdSet.BTypeId> primary = new HashSet<BTypeIdSet.BTypeId>();
            int primaryTypeIdCount = inputStream.readInt();
            for (int i = 0; i < primaryTypeIdCount; ++i) {
                primary.add(this.readTypeId(inputStream));
            }
            HashSet<BTypeIdSet.BTypeId> secondary = new HashSet<BTypeIdSet.BTypeId>();
            int secondaryTypeIdCount = inputStream.readInt();
            for (int i = 0; i < secondaryTypeIdCount; ++i) {
                secondary.add(this.readTypeId(inputStream));
            }
            return new BTypeIdSet(primary, secondary);
        }

        private BTypeIdSet.BTypeId readTypeId(DataInputStream inputStream) throws IOException {
            int pkgCPIndex = inputStream.readInt();
            PackageID packageId = BIRPackageSymbolEnter.this.getPackageId(pkgCPIndex);
            String name = BIRPackageSymbolEnter.this.getStringCPEntryValue(inputStream);
            boolean isPublicTypeId = inputStream.readBoolean();
            return new BTypeIdSet.BTypeId(packageId, name, isPublicTypeId);
        }

        private void ignoreAttachedFunc() throws IOException {
            BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
            this.inputStream.readLong();
            this.readTypeFromCp();
        }

        private List<BType> readTypeInclusions() throws IOException {
            int nTypeInclusions = this.inputStream.readInt();
            ArrayList<BType> typeInclusions = new ArrayList<BType>();
            for (int i = 0; i < nTypeInclusions; ++i) {
                BType inclusion = this.readTypeFromCp();
                typeInclusions.add(inclusion);
            }
            return typeInclusions;
        }
    }

    private static class UnresolvedType {
        String typeSig;
        Consumer<BType> completer;

        UnresolvedType(String typeSig, Consumer<BType> completer) {
            this.typeSig = typeSig;
            this.completer = completer;
        }
    }

    private static class BIRPackageSymbolEnv {
        PackageID requestedPackageId;
        RepoHierarchy repoHierarchy;
        Map<Integer, byte[]> unparsedBTypeCPs = new HashMap<Integer, byte[]>();
        BPackageSymbol pkgSymbol;
        CPEntry[] constantPool;
        List<UnresolvedType> unresolvedTypes = new ArrayList<UnresolvedType>();

        BIRPackageSymbolEnv() {
        }
    }
}

