/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompiledPackage;
import org.ballerinalang.repository.CompilerOutputEntry;

public class InMemoryCompiledPackage
implements CompiledPackage {
    public PackageID pkgID;
    public List<CompilerOutputEntry> srcEntries;
    public CompilerOutputEntry pkgMDEntry;
    public CompilerOutputEntry pkgBinaryEntry;
    public CompilerOutputEntry pkgBirEntry;

    public InMemoryCompiledPackage(PackageID pkgID) {
        this.pkgID = pkgID;
        this.srcEntries = new ArrayList<CompilerOutputEntry>();
    }

    @Override
    public PackageID getPackageID() {
        return this.pkgID;
    }

    @Override
    public List<CompilerOutputEntry> getSourceEntries() {
        return this.srcEntries;
    }

    @Override
    public void addSourceEntry(CompilerOutputEntry compiledPackageEntry) {
        this.srcEntries.add(compiledPackageEntry);
    }

    @Override
    public CompilerOutputEntry getPackageMDEntry() {
        return this.pkgMDEntry;
    }

    @Override
    public CompilerOutputEntry getPackageBirEntry() {
        return this.pkgBirEntry;
    }

    @Override
    public void setPackageBirEntry(CompilerOutputEntry entry) {
        this.pkgBirEntry = entry;
    }

    @Override
    public CompilerOutputEntry getPackageBinaryEntry() {
        return this.pkgBinaryEntry;
    }

    @Override
    public void setPackageBinaryEntry(CompilerOutputEntry entry) {
        this.pkgBinaryEntry = entry;
    }

    @Override
    public List<CompilerOutputEntry> getAllEntries() {
        ArrayList<CompilerOutputEntry> allEntries = new ArrayList<CompilerOutputEntry>(this.srcEntries);
        if (this.pkgBinaryEntry != null) {
            allEntries.add(this.pkgBinaryEntry);
        }
        if (this.pkgBirEntry != null) {
            allEntries.add(this.pkgBirEntry);
        }
        if (this.pkgMDEntry != null) {
            allEntries.add(this.pkgMDEntry);
        }
        return allEntries;
    }

    @Override
    public CompiledPackage.Kind getKind() {
        return CompiledPackage.Kind.FROM_SOURCE;
    }
}

