/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class PackageCache {
    private static final CompilerContext.Key<PackageCache> PACKAGE_CACHE_KEY = new CompilerContext.Key();
    protected Map<String, BLangPackage> packageMap;
    protected Map<String, Map<String, BPackageSymbol>> packageSymbolMap;

    public static PackageCache getInstance(CompilerContext context) {
        PackageCache packageCache = context.get(PACKAGE_CACHE_KEY);
        if (packageCache == null) {
            packageCache = new PackageCache(context);
        }
        return packageCache;
    }

    public static void setInstance(PackageCache packageCache, CompilerContext context) {
        context.put(PACKAGE_CACHE_KEY, packageCache);
    }

    protected PackageCache(CompilerContext context) {
        context.put(PACKAGE_CACHE_KEY, this);
        this.packageMap = new HashMap<String, BLangPackage>();
        this.packageSymbolMap = new HashMap<String, Map<String, BPackageSymbol>>();
    }

    public BLangPackage get(PackageID packageID) {
        return this.packageMap.get(PackageCache.getCacheID(packageID));
    }

    public BLangPackage get(String pkgPath) {
        return this.packageMap.get(pkgPath);
    }

    public void put(PackageID packageID, BLangPackage bLangPackage) {
        if (bLangPackage != null) {
            bLangPackage.packageID = packageID;
        }
        this.packageMap.put(PackageCache.getCacheID(packageID), bLangPackage);
    }

    public static String getCacheID(PackageID packageID) {
        Object bvmAlias = packageID.toString();
        if (packageID.sourceFileName != null) {
            bvmAlias = (String)bvmAlias + "-" + packageID.sourceFileName.getValue();
        }
        return bvmAlias;
    }

    public BPackageSymbol getSymbol(PackageID packageID) {
        return this.getSymbol(packageID.toString());
    }

    public BPackageSymbol getSymbol(String bvmAlias) {
        String[] packageElements = bvmAlias.split(Names.VERSION_SEPARATOR.value);
        Map<String, BPackageSymbol> versionMap = this.packageSymbolMap.get(packageElements[0]);
        if (versionMap != null) {
            if (packageElements.length > 1) {
                return versionMap.get(packageElements[1]);
            }
            Iterator<BPackageSymbol> itr = versionMap.values().iterator();
            if (itr.hasNext()) {
                return itr.next();
            }
        }
        return null;
    }

    public void putSymbol(PackageID packageID, BPackageSymbol packageSymbol) {
        String[] packageElements = packageID.toString().split(Names.VERSION_SEPARATOR.value);
        Map versionMap = this.packageSymbolMap.computeIfAbsent(packageElements[0], k -> new LinkedHashMap());
        if (packageElements.length > 1) {
            versionMap.put(packageElements[1], packageSymbol);
        } else {
            versionMap.put(Names.DEFAULT_VERSION.value, packageSymbol);
        }
    }
}

