/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompiledPackage;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.repository.CompilerOutputEntry;
import org.ballerinalang.repository.PackageBinary;
import org.ballerinalang.repository.PackageEntity;
import org.ballerinalang.repository.PackageSource;
import org.ballerinalang.spi.SystemPackageRepositoryProvider;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.LockFile;
import org.ballerinalang.toml.model.LockFileImport;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.LockFileProcessor;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.wso2.ballerinalang.compiler.BIRPackageSymbolEnter;
import org.wso2.ballerinalang.compiler.GenericPackageBinary;
import org.wso2.ballerinalang.compiler.InMemoryCompiledPackage;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.PathBasedCompiledPackageEntry;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.packaging.GenericPackageSource;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.RepoHierarchy;
import org.wso2.ballerinalang.compiler.packaging.RepoHierarchyBuilder;
import org.wso2.ballerinalang.compiler.packaging.Resolution;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.URIDryConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.BinaryRepo;
import org.wso2.ballerinalang.compiler.packaging.repo.BirRepo;
import org.wso2.ballerinalang.compiler.packaging.repo.HomeBaloRepo;
import org.wso2.ballerinalang.compiler.packaging.repo.HomeBirRepo;
import org.wso2.ballerinalang.compiler.packaging.repo.PathBaloRepo;
import org.wso2.ballerinalang.compiler.packaging.repo.ProgramingSourceRepo;
import org.wso2.ballerinalang.compiler.packaging.repo.ProjectSourceRepo;
import org.wso2.ballerinalang.compiler.packaging.repo.RemoteRepo;
import org.wso2.ballerinalang.compiler.parser.Parser;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;

public class PackageLoader {
    private static final CompilerContext.Key<PackageLoader> PACKAGE_LOADER_KEY = new CompilerContext.Key();
    private final RepoHierarchy repos;
    private final boolean offline;
    private final boolean testEnabled;
    private final boolean lockEnabled;
    private final Manifest manifest;
    private final LockFile lockFile;
    private final CompilerOptions options;
    private final Parser parser;
    private final SourceDirectory sourceDirectory;
    private final PackageCache packageCache;
    private final SymbolEnter symbolEnter;
    private final BIRPackageSymbolEnter birPackageSymbolEnter;
    private final Names names;
    private static final boolean shouldReadBalo = true;
    private final CompilerPhase compilerPhase;
    private Map<PackageID, Manifest> dependencyManifests = new HashMap<PackageID, Manifest>();

    public static PackageLoader getInstance(CompilerContext context) {
        PackageLoader loader = context.get(PACKAGE_LOADER_KEY);
        if (loader == null) {
            loader = new PackageLoader(context);
        }
        return loader;
    }

    private PackageLoader(CompilerContext context) {
        context.put(PACKAGE_LOADER_KEY, this);
        this.options = CompilerOptions.getInstance(context);
        this.compilerPhase = this.options.getCompilerPhase();
        this.parser = Parser.getInstance(context);
        this.packageCache = PackageCache.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.birPackageSymbolEnter = BIRPackageSymbolEnter.getInstance(context);
        this.names = Names.getInstance(context);
        this.offline = Boolean.parseBoolean(this.options.get(CompilerOptionName.OFFLINE));
        this.testEnabled = Boolean.parseBoolean(this.options.get(CompilerOptionName.TEST_ENABLED));
        this.lockEnabled = Boolean.parseBoolean(this.options.get(CompilerOptionName.LOCK_ENABLED));
        this.manifest = ManifestProcessor.getInstance(context).getManifest();
        boolean projectAPIInitiatedCompilation = Boolean.parseBoolean(this.options.get(CompilerOptionName.PROJECT_API_INITIATED_COMPILATION));
        if (projectAPIInitiatedCompilation) {
            this.sourceDirectory = null;
            this.repos = null;
            this.lockFile = null;
            return;
        }
        this.sourceDirectory = context.get(SourceDirectory.class);
        if (this.sourceDirectory == null) {
            throw new IllegalArgumentException("source directory has not been initialized");
        }
        this.repos = this.genRepoHierarchy(Paths.get(this.options.get(CompilerOptionName.PROJECT_DIR), new String[0]));
        this.lockFile = LockFileProcessor.getInstance(context, this.lockEnabled).getLockFile();
    }

    private RepoHierarchy genRepoHierarchy(Path sourceRoot) {
        RepoHierarchyBuilder.RepoNode fullRepoGraph;
        Optional<Dependency> pathDependency;
        Converter<Path> converter = this.sourceDirectory.getConverter();
        Path ballerinaHome = Paths.get(System.getProperty("ballerina.home"), new String[0]);
        BirRepo systemBirRepo = new BirRepo(ballerinaHome);
        BinaryRepo systemZipRepo = new BinaryRepo(RepoUtils.getLibDir(), this.compilerPhase);
        RemoteRepo remoteRepo = new RemoteRepo(URI.create(RepoUtils.getRemoteRepoURL()), this.dependencyManifests, ballerinaHome);
        RemoteRepo remoteDryRepo = new RemoteRepo(new URIDryConverter(URI.create(RepoUtils.getRemoteRepoURL()), this.dependencyManifests), ballerinaHome);
        HomeBaloRepo homeBaloCache = new HomeBaloRepo(this.dependencyManifests);
        HomeBirRepo homeBirRepo = new HomeBirRepo();
        BinaryRepo secondarySystemRepo = new BinaryRepo(RepoUtils.getLibDir(), this.compilerPhase);
        RepoHierarchyBuilder.RepoNode homeCacheNode = this.offline ? RepoHierarchyBuilder.node(homeBaloCache, RepoHierarchyBuilder.node(systemBirRepo, RepoHierarchyBuilder.node(systemZipRepo, new RepoHierarchyBuilder.RepoNode[0]))) : RepoHierarchyBuilder.node(homeBaloCache, RepoHierarchyBuilder.node(systemBirRepo, RepoHierarchyBuilder.node(systemZipRepo, RepoHierarchyBuilder.node(remoteRepo, RepoHierarchyBuilder.node(homeBaloCache, RepoHierarchyBuilder.node(systemBirRepo, RepoHierarchyBuilder.node(secondarySystemRepo, new RepoHierarchyBuilder.RepoNode[0])))))));
        if (null != this.manifest && !(pathDependency = this.manifest.getDependencies().stream().filter(dep -> null != dep.getMetadata()).filter(dep -> null != dep.getMetadata().getPath()).findAny()).isPresent()) {
            homeCacheNode = RepoHierarchyBuilder.node(homeBirRepo, homeCacheNode);
        }
        if (!this.offline) {
            homeCacheNode = RepoHierarchyBuilder.node(remoteDryRepo, homeCacheNode);
        }
        if (converter != null) {
            ProgramingSourceRepo programingSource = new ProgramingSourceRepo(converter);
            ProjectSourceRepo projectSource = new ProjectSourceRepo(converter, this.manifest, this.testEnabled);
            fullRepoGraph = RepoHierarchyBuilder.node(programingSource, RepoHierarchyBuilder.node(projectSource, homeCacheNode));
        } else {
            fullRepoGraph = homeCacheNode;
        }
        return RepoHierarchyBuilder.build(fullRepoGraph);
    }

    private RepoHierarchyBuilder.RepoNode[] loadSystemRepos() {
        ServiceLoader<SystemPackageRepositoryProvider> loader = ServiceLoader.load(SystemPackageRepositoryProvider.class);
        List<RepoHierarchyBuilder.RepoNode> systemList = StreamSupport.stream(loader.spliterator(), false).map(SystemPackageRepositoryProvider::loadRepository).filter(Objects::nonNull).map(r -> RepoHierarchyBuilder.node(r, new RepoHierarchyBuilder.RepoNode[0])).collect(Collectors.toList());
        return systemList.toArray(new RepoHierarchyBuilder.RepoNode[systemList.size()]);
    }

    private PackageEntity loadPackageEntity(PackageID pkgId) {
        return this.loadPackageEntity(pkgId, null, null);
    }

    private PackageEntity loadPackageEntity(PackageID pkgId, PackageID enclPackageId, RepoHierarchy encPkgRepoHierarchy) {
        this.updateModuleIDVersion(pkgId, enclPackageId);
        Resolution resolution = this.resolveModuleByPath(pkgId);
        if (resolution != Resolution.NOT_FOUND) {
            resolution.resolvedBy = null != encPkgRepoHierarchy ? encPkgRepoHierarchy : this.repos;
        } else {
            resolution = null != encPkgRepoHierarchy ? encPkgRepoHierarchy.resolve(pkgId) : this.repos.resolve(pkgId);
        }
        if (resolution == Resolution.NOT_FOUND) {
            return null;
        }
        CompilerInput firstEntry = resolution.inputs.get(0);
        if (firstEntry.getEntryName().endsWith(PackageEntity.Kind.COMPILED.getExtension())) {
            return new GenericPackageBinary(pkgId, firstEntry, resolution.resolvedBy, PackageEntity.Kind.COMPILED);
        }
        if (firstEntry.getEntryName().endsWith(PackageEntity.Kind.COMPILED_BIR.getExtension())) {
            return new GenericPackageBinary(pkgId, firstEntry, resolution.resolvedBy, PackageEntity.Kind.COMPILED_BIR);
        }
        return new GenericPackageSource(pkgId, resolution.inputs, resolution.resolvedBy);
    }

    private Resolution resolveModuleByPath(PackageID moduleID) {
        PathBaloRepo pathBaloRepo = new PathBaloRepo(this.manifest, this.dependencyManifests);
        RepoHierarchy pathRepoHierarchy = RepoHierarchyBuilder.build(RepoHierarchyBuilder.node(pathBaloRepo, new RepoHierarchyBuilder.RepoNode[0]));
        return pathRepoHierarchy.resolve(moduleID);
    }

    private void updateModuleIDVersion(PackageID moduleID, PackageID enclPackageId) {
        String orgName = moduleID.orgName.value;
        String moduleName = moduleID.name.value;
        if (enclPackageId != null && this.hasLockFile(Paths.get(this.options.get(CompilerOptionName.PROJECT_DIR), new String[0])) && this.lockFile.getImports().containsKey(enclPackageId.toString())) {
            List<LockFileImport> foundBaseImport = this.lockFile.getImports().get(enclPackageId.toString());
            for (LockFileImport nestedImport : foundBaseImport) {
                if (!moduleID.orgName.value.equals(nestedImport.getOrgName()) || !moduleID.name.value.equals(nestedImport.getName())) continue;
                moduleID.version = new Name(nestedImport.getVersion());
                return;
            }
        }
        if (enclPackageId != null && this.manifest != null) {
            for (Dependency dependency : this.manifest.getDependencies()) {
                if (!dependency.getModuleName().equals(moduleName) || !dependency.getOrgName().equals(orgName) || dependency.getMetadata().getVersion() == null || "*".equals(dependency.getMetadata().getVersion())) continue;
                moduleID.version = new Name(dependency.getMetadata().getVersion());
                return;
            }
        }
        if (enclPackageId != null && this.dependencyManifests.size() > 0 && this.dependencyManifests.containsKey(enclPackageId)) {
            for (Dependency manifestDependency : this.dependencyManifests.get(enclPackageId).getDependencies()) {
                if (!manifestDependency.getOrgName().equals(moduleID.orgName.value) || !manifestDependency.getModuleName().equals(moduleID.name.value) || manifestDependency.getMetadata().getVersion() == null || "*".equals(manifestDependency.getMetadata().getVersion())) continue;
                moduleID.version = new Name(manifestDependency.getMetadata().getVersion());
                return;
            }
        }
    }

    public BLangPackage loadEntryPackage(PackageID pkgId, PackageID enclPackageId, PrintStream outStream) {
        if (null == outStream) {
            outStream = System.out;
        }
        outStream.println("\t" + (pkgId.isUnnamed ? pkgId.sourceFileName.value : pkgId.toString()));
        BLangPackage bLangPackage = this.packageCache.get(pkgId);
        if (bLangPackage != null) {
            return bLangPackage;
        }
        PackageEntity pkgEntity = this.loadPackageEntity(pkgId, enclPackageId, null);
        if (pkgEntity == null) {
            return null;
        }
        BLangPackage packageNode = this.parse(pkgId, (PackageSource)pkgEntity);
        this.define(packageNode);
        return packageNode;
    }

    public BLangPackage loadPackage(PackageID pkgId) {
        BLangPackage bLangPackage = this.packageCache.get(pkgId);
        if (bLangPackage != null) {
            return bLangPackage;
        }
        BLangPackage packageNode = this.loadPackageFromEntity(pkgId, this.loadPackageEntity(pkgId));
        if (packageNode == null) {
            throw ProjectDirs.getPackageNotFoundError(pkgId);
        }
        return packageNode;
    }

    public BLangPackage loadAndDefinePackage(String orgName, String pkgName, String version) {
        PackageID pkgId = this.getPackageID(orgName, pkgName, version);
        return this.loadAndDefinePackage(pkgId);
    }

    public BLangPackage loadAndDefinePackage(PackageID pkgId) {
        BLangPackage bLangPackage = this.loadPackage(pkgId);
        if (bLangPackage == null) {
            return null;
        }
        this.symbolEnter.definePackage(bLangPackage);
        bLangPackage.symbol.compiledPackage = this.createInMemoryCompiledPackage(bLangPackage);
        return bLangPackage;
    }

    public BPackageSymbol loadPackageSymbol(PackageID packageId, PackageID enclPackageId, RepoHierarchy encPkgRepoHierarchy) {
        BPackageSymbol packageSymbol = this.packageCache.getSymbol(packageId);
        if (packageSymbol != null) {
            return packageSymbol;
        }
        PackageEntity pkgEntity = this.loadPackageEntity(packageId, enclPackageId, encPkgRepoHierarchy);
        if (pkgEntity == null) {
            return null;
        }
        packageSymbol = this.packageCache.getSymbol(pkgEntity.getPackageId());
        if (packageSymbol != null) {
            return packageSymbol;
        }
        if (pkgEntity.getKind() == PackageEntity.Kind.SOURCE) {
            return this.parseAndDefine(packageId, (PackageSource)pkgEntity);
        }
        if (pkgEntity.getKind() == PackageEntity.Kind.COMPILED || pkgEntity.getKind() == PackageEntity.Kind.COMPILED_BIR) {
            return this.loadCompiledPackageAndDefine(packageId, (PackageBinary)pkgEntity);
        }
        return null;
    }

    private PackageID getPackageID(String org, String sourcePkg, String version) {
        List<Name> pkgNameComps = this.getPackageNameComps(sourcePkg);
        Name orgName = new Name(org);
        return new PackageID(orgName, pkgNameComps, new Name(version));
    }

    private List<Name> getPackageNameComps(String sourcePkg) {
        String[] pkgParts = sourcePkg.split("\\.|\\\\|\\/");
        return Arrays.stream(pkgParts).map(this.names::fromString).collect(Collectors.toList());
    }

    private BPackageSymbol parseAndDefine(PackageID pkgId, PackageSource pkgSource) {
        BLangPackage pkgNode = this.parse(pkgId, pkgSource);
        return this.define(pkgNode);
    }

    private BPackageSymbol define(BLangPackage pkgNode) {
        this.symbolEnter.definePackage(pkgNode);
        this.packageCache.putSymbol(pkgNode.packageID, pkgNode.symbol);
        pkgNode.symbol.compiledPackage = this.createInMemoryCompiledPackage(pkgNode);
        if (pkgNode.hasTestablePackage()) {
            BLangTestablePackage testablePackage = pkgNode.getTestablePkg();
            testablePackage.symbol.compiledPackage = this.createInMemoryCompiledPackage(testablePackage);
        }
        return pkgNode.symbol;
    }

    private BLangPackage loadPackageFromEntity(PackageID pkgId, PackageEntity pkgEntity) {
        if (pkgEntity == null) {
            return null;
        }
        BLangPackage bLangPackage = this.parse(pkgId, (PackageSource)pkgEntity);
        this.packageCache.put(pkgId, bLangPackage);
        return bLangPackage;
    }

    private BLangPackage parse(PackageID pkgId, PackageSource pkgSource) {
        BLangPackage packageNode = this.parser.parse(pkgSource, this.sourceDirectory.getPath());
        packageNode.packageID = pkgId;
        packageNode.getTestablePkgs().forEach(testablePkg -> {
            testablePkg.packageID = pkgId;
        });
        this.packageCache.put(pkgId, packageNode);
        return packageNode;
    }

    private BPackageSymbol loadCompiledPackageAndDefine(PackageID pkgId, PackageBinary pkgBinary) {
        byte[] pkgBinaryContent = pkgBinary.getCompilerInput().getCode();
        BPackageSymbol pkgSymbol = this.birPackageSymbolEnter.definePackage(pkgId, pkgBinary.getRepoHierarchy(), pkgBinaryContent);
        this.packageCache.putSymbol(pkgSymbol.pkgID, pkgSymbol);
        return pkgSymbol;
    }

    private CompiledPackage createInMemoryCompiledPackage(BLangPackage pkgNode) {
        PackageID packageID = pkgNode.packageID;
        InMemoryCompiledPackage compiledPackage = new InMemoryCompiledPackage(packageID);
        Path projectPath = this.sourceDirectory.getPath();
        ProjectSourceRepo projectSourceRepo = new ProjectSourceRepo(projectPath, this.manifest, this.testEnabled);
        Patten packageIDPattern = projectSourceRepo.calculate(packageID);
        if (packageIDPattern != Patten.NULL) {
            Stream srcPathStream = packageIDPattern.convert(projectSourceRepo.getConverterInstance(), packageID);
            compiledPackage.srcEntries = srcPathStream.filter(path -> Files.exists(path, LinkOption.NOFOLLOW_LINKS)).filter(path -> !ProjectDirs.isTestSource(path, projectPath, packageID.getName().getValue())).map(projectPath::relativize).map(path -> new PathBasedCompiledPackageEntry(projectPath, (Path)path, CompilerOutputEntry.Kind.SRC)).collect(Collectors.toList());
            Patten pkgMDPattern = packageIDPattern.sibling(Patten.path("Module.md"));
            pkgMDPattern.convert(projectSourceRepo.getConverterInstance(), packageID).filter(pkgMDPath -> Files.exists(pkgMDPath, LinkOption.NOFOLLOW_LINKS)).map(projectPath::relativize).map(pkgMDPath -> new PathBasedCompiledPackageEntry(projectPath, (Path)pkgMDPath, CompilerOutputEntry.Kind.ROOT)).findAny().ifPresent(pkgEntry -> {
                compiledPackage.pkgMDEntry = pkgEntry;
            });
        }
        return compiledPackage;
    }

    public boolean hasLockFile(Path sourceRoot) {
        return RepoUtils.isBallerinaProject(sourceRoot) && null != this.lockFile && null != this.lockFile.getImports() && this.lockFile.getImports().size() > 0;
    }
}

