/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import org.ballerinalang.compiler.BLangCompilerException;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmCastGen {
    static SymbolTable symbolTable;

    static void generatePlatformCheckCast(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, BType sourceType, BType targetType) {
        if (sourceType.tag == Integer.MAX_VALUE) {
            JvmCastGen.generateJToBCheckCast(mv, indexMap, (JType)sourceType, targetType);
        } else {
            JvmCastGen.generateBToJCheckCast(mv, sourceType, (JType)targetType);
        }
    }

    public static void generateBToJCheckCast(MethodVisitor mv, BType sourceType, JType targetType) {
        switch (targetType.jTag) {
            case 1: {
                JvmCastGen.generateCheckCastBToJByte(mv, sourceType);
                break;
            }
            case 2: {
                JvmCastGen.generateCheckCastBToJChar(mv, sourceType);
                break;
            }
            case 3: {
                JvmCastGen.generateCheckCastBToJShort(mv, sourceType);
                break;
            }
            case 4: {
                JvmCastGen.generateCheckCastBToJInt(mv, sourceType);
                break;
            }
            case 5: {
                JvmCastGen.generateCheckCastBToJLong(mv, sourceType);
                break;
            }
            case 6: {
                JvmCastGen.generateCheckCastBToJFloat(mv, sourceType);
                break;
            }
            case 7: {
                JvmCastGen.generateCheckCastBToJDouble(mv, sourceType);
                break;
            }
            case 10: {
                JvmCastGen.generateCheckCastBToJRef(mv, sourceType, targetType);
                break;
            }
            case 9: {
                JvmCastGen.generateCheckCastBToJRef(mv, sourceType, targetType);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java %s'", sourceType, targetType));
            }
        }
    }

    private static void generateCheckCastBToJByte(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            mv.visitInsn(145);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                break;
            }
            case 3: {
                mv.visitInsn(142);
                mv.visitInsn(145);
                break;
            }
            case 36: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
                break;
            }
            case 32: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToByte", String.format("(L%s;)I", "java/lang/Object"), false);
                mv.visitInsn(145);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java byte'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJChar(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            mv.visitInsn(146);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(146);
                break;
            }
            case 3: {
                mv.visitInsn(142);
                mv.visitInsn(146);
                break;
            }
            case 36: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", String.format("()L%s;", "java/lang/Object"), false);
                break;
            }
            case 32: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
                mv.visitInsn(136);
                mv.visitInsn(146);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java char'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJShort(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            mv.visitInsn(147);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(147);
                break;
            }
            case 3: {
                mv.visitInsn(142);
                mv.visitInsn(147);
                break;
            }
            case 36: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", String.format("()L%s;", "java/lang/Object"), false);
                break;
            }
            case 32: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
                mv.visitInsn(136);
                mv.visitInsn(147);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java short'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJInt(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                break;
            }
            case 3: {
                mv.visitInsn(142);
                break;
            }
            case 36: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", String.format("()L%s;", "java/lang/Object"), false);
                break;
            }
            case 32: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
                mv.visitInsn(136);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java int'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJLong(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitInsn(143);
                break;
            }
            case 36: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", String.format("()L%s;", "java/lang/Object"), false);
                mv.visitTypeInsn(192, "java/lang/Long");
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            case 32: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java long'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJFloat(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(137);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(134);
                break;
            }
            case 3: {
                mv.visitInsn(144);
                break;
            }
            case 36: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", String.format("()L%s;", "java/lang/Object"), false);
                break;
            }
            case 32: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToFloat", String.format("(L%s;)D", "java/lang/Object"), false);
                mv.visitInsn(144);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java float'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJDouble(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(138);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(135);
                break;
            }
            case 3: {
                break;
            }
            case 36: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", String.format("()L%s;", "java/lang/Object"), false);
                break;
            }
            case 32: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToFloat", String.format("(L%s;)D", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java double'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJRef(MethodVisitor mv, BType sourceType, JType targetType) {
        if (sourceType.tag == 4) {
            return;
        }
        if (sourceType.tag == 36) {
            if (targetType.jTag == 10) {
                JType.JRefType jRefType = (JType.JRefType)targetType;
                if (jRefType.typeValue.equals("io/ballerina/runtime/internal/values/HandleValue") || jRefType.typeValue.equals("io/ballerina/runtime/api/values/BHandle")) {
                    return;
                }
            }
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", String.format("()L%s;", "java/lang/Object"), false);
            String sig = InteropMethodGen.getSignatureForJType(targetType);
            mv.visitTypeInsn(192, sig);
        } else if (targetType.jTag == 10) {
            JvmCastGen.addBoxInsn(mv, sourceType);
            mv.visitTypeInsn(192, ((JType.JRefType)targetType).typeValue);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to '%s'", sourceType, targetType));
        }
    }

    private static void generateJToBCheckCast(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType, BType targetType) {
        if (TypeTags.isIntegerTypeTag(targetType.tag)) {
            JvmCastGen.generateCheckCastJToBInt(mv, sourceType);
            return;
        }
        switch (targetType.tag) {
            case 3: {
                JvmCastGen.generateCheckCastJToBFloat(mv, sourceType);
                break;
            }
            case 4: {
                JvmCastGen.generateCheckCastJToBDecimal(mv, sourceType);
                break;
            }
            case 6: {
                JvmCastGen.generateCheckCastJToBBoolean(mv, sourceType);
                break;
            }
            case 2: {
                JvmCastGen.generateCheckCastJToBByte(mv, sourceType);
                break;
            }
            case 10: 
            case 49: {
                break;
            }
            default: {
                switch (targetType.tag) {
                    case 20: {
                        JvmCastGen.generateCheckCastJToBUnionType(mv, indexMap, sourceType, (BUnionType)targetType);
                        break;
                    }
                    case 11: {
                        JvmCastGen.generateCheckCastJToBAnyData(mv, indexMap, sourceType);
                        break;
                    }
                    case 36: {
                        JvmCastGen.generateJCastToBHandle(mv);
                        break;
                    }
                    case 17: {
                        JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, targetType);
                        break;
                    }
                    case 7: {
                        JvmCastGen.generateCheckCastJToBJSON(mv, indexMap, sourceType);
                        break;
                    }
                    case 37: {
                        JvmCastGen.generateCheckCastJToBReadOnly(mv, indexMap, sourceType);
                        break;
                    }
                    case 32: {
                        JvmCastGen.generateCheckCastJToBFiniteType(mv, indexMap, sourceType, targetType);
                    }
                }
                JvmCastGen.checkCast(mv, targetType);
                String targetTypeClass = JvmCastGen.getTargetClass(targetType);
                if (targetTypeClass == null) break;
                mv.visitTypeInsn(192, targetTypeClass);
            }
        }
    }

    private static void generateCheckCastJToBInt(MethodVisitor mv, JType sourceType) {
        switch (sourceType.jTag) {
            case 1: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 2: {
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitInsn(133);
                break;
            }
            case 4: {
                mv.visitInsn(133);
                break;
            }
            case 5: {
                break;
            }
            case 10: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJLong", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int'", sourceType));
            }
        }
    }

    private static void generateCheckCastJToBFloat(MethodVisitor mv, JType sourceType) {
        switch (sourceType.jTag) {
            case 1: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(135);
                break;
            }
            case 2: {
                mv.visitInsn(135);
                break;
            }
            case 3: {
                mv.visitInsn(135);
                break;
            }
            case 4: {
                mv.visitInsn(135);
                break;
            }
            case 5: {
                mv.visitInsn(138);
                break;
            }
            case 6: {
                mv.visitInsn(141);
                break;
            }
            case 7: {
                break;
            }
            case 10: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJDouble", String.format("(L%s;)D", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'float'", sourceType));
            }
        }
    }

    private static void generateCheckCastJToBDecimal(MethodVisitor mv, JType sourceType) {
        switch (sourceType.jTag) {
            case 1: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", String.format("(B)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", String.format("(C)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", String.format("(S)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", String.format("(I)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", String.format("(J)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", String.format("(F)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", String.format("(D)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 10: {
                mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/DecimalValue");
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'decimal'", sourceType));
            }
        }
    }

    private static void generateCheckCastJToBBoolean(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag == 8) {
            return;
        }
        if (sourceType.jTag != 10) {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'boolean'", sourceType));
        }
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToBoolean", String.format("(L%s;)Z", "java/lang/Object"), false);
    }

    private static void generateCheckCastJToBByte(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag == 1) {
            return;
        }
        if (sourceType.jTag != 10) {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'byte'", sourceType));
        }
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToByte", String.format("(L%s;)I", "java/lang/Object"), false);
    }

    private static void generateCheckCastJToBUnionType(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType, BUnionType targetType) {
        JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, targetType);
    }

    private static void generateCheckCastJToBAnyData(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType) {
        if (sourceType.jTag != 10 && sourceType.jTag != 9) {
            JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, JvmCastGen.symbolTable.anydataType);
        }
    }

    private static void generateJCastToBHandle(MethodVisitor mv) {
        LabelGenerator labelGen = new LabelGenerator();
        Label afterHandle = labelGen.getLabel("after_handle");
        mv.visitInsn(89);
        mv.visitTypeInsn(193, "io/ballerina/runtime/api/values/BHandle");
        mv.visitJumpInsn(154, afterHandle);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/HandleValue", "valueOfJ", String.format("(L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/internal/values/HandleValue"), false);
        mv.visitLabel(afterHandle);
    }

    private static void generateJCastToBAny(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType, BType targetType) {
        switch (sourceType.jTag) {
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", String.format("(Z)L%s;", "java/lang/Boolean"), false);
                break;
            }
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", String.format("(I)L%s;", "java/lang/Integer"), false);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                mv.visitInsn(133);
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
                break;
            }
            case 6: {
                mv.visitInsn(141);
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", String.format("(D)L%s;", "java/lang/Double"), false);
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", String.format("(D)L%s;", "java/lang/Double"), false);
                break;
            }
            case 10: {
                Label afterHandle = new Label();
                if (((JType.JRefType)sourceType).typeValue.equals("java/lang/Object")) {
                    mv.visitInsn(89);
                    mv.visitTypeInsn(193, "io/ballerina/runtime/api/values/BError");
                    mv.visitJumpInsn(154, afterHandle);
                    mv.visitInsn(89);
                    mv.visitTypeInsn(193, "java/lang/Number");
                    mv.visitJumpInsn(154, afterHandle);
                    mv.visitInsn(89);
                    mv.visitTypeInsn(193, "java/lang/Boolean");
                    mv.visitJumpInsn(154, afterHandle);
                    mv.visitInsn(89);
                    mv.visitTypeInsn(193, "io/ballerina/runtime/internal/values/SimpleValue");
                    mv.visitJumpInsn(154, afterHandle);
                }
                if (JvmCastGen.isNillable(targetType)) {
                    mv.visitInsn(89);
                    mv.visitJumpInsn(198, afterHandle);
                }
                mv.visitInsn(89);
                mv.visitTypeInsn(193, "io/ballerina/runtime/internal/values/RefValue");
                mv.visitJumpInsn(154, afterHandle);
                int returnJObjectVarRefIndex = indexMap.addIfNotExists("$_ret_jobject_val_$", JvmCastGen.symbolTable.anyType);
                mv.visitVarInsn(58, returnJObjectVarRefIndex);
                mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/HandleValue");
                mv.visitInsn(89);
                mv.visitVarInsn(25, returnJObjectVarRefIndex);
                mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/HandleValue", "<init>", "(Ljava/lang/Object;)V", false);
                mv.visitLabel(afterHandle);
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'any'", sourceType));
            }
        }
    }

    private static boolean isNillable(BType targetType) {
        switch (targetType.tag) {
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 37: 
            case 49: {
                return true;
            }
            case 20: 
            case 21: {
                return targetType.isNullable();
            }
            case 32: {
                return targetType.isNullable();
            }
        }
        return false;
    }

    private static void generateCheckCastJToBJSON(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType) {
        if (sourceType.jTag == 10 || sourceType.jTag == 9) {
            return;
        }
        JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, JvmCastGen.symbolTable.jsonType);
    }

    private static void generateCheckCastJToBReadOnly(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType) {
        if (sourceType.jTag == 10 || sourceType.jTag == 9) {
            return;
        }
        JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, JvmCastGen.symbolTable.readonlyType);
    }

    private static void generateCheckCastJToBFiniteType(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType, BType targetType) {
        if (sourceType.jTag != 10 && sourceType.jTag != 9) {
            JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, targetType);
        }
    }

    static void generateCheckCast(MethodVisitor mv, BType sourceType, BType targetType, BIRVarToJVMIndexMap indexMap) {
        if (TypeTags.isXMLTypeTag(sourceType.tag) && targetType.tag == 15) {
            JvmCastGen.generateXMLToAttributesMap(mv);
            return;
        }
        if (sourceType.tag != 12 || targetType.tag != 15 || ((BMapType)targetType).constraint.tag != 17) {
            switch (targetType.tag) {
                case 1: {
                    JvmCastGen.generateCheckCastToInt(mv, sourceType);
                    return;
                }
                case 38: {
                    JvmCastGen.generateCheckCastToSigned32(mv, sourceType);
                    return;
                }
                case 39: {
                    JvmCastGen.generateCheckCastToSigned16(mv, sourceType);
                    return;
                }
                case 40: {
                    JvmCastGen.generateCheckCastToSigned8(mv, sourceType);
                    return;
                }
                case 41: {
                    JvmCastGen.generateCheckCastToUnsigned32(mv, sourceType);
                    return;
                }
                case 42: {
                    JvmCastGen.generateCheckCastToUnsigned16(mv, sourceType);
                    return;
                }
                case 43: {
                    JvmCastGen.generateCheckCastToUnsigned8(mv, sourceType);
                    return;
                }
                case 3: {
                    JvmCastGen.generateCheckCastToFloat(mv, sourceType);
                    return;
                }
                case 5: {
                    JvmCastGen.generateCheckCastToString(mv, sourceType, indexMap);
                    return;
                }
                case 44: {
                    JvmCastGen.generateCheckCastToChar(mv, sourceType);
                    return;
                }
                case 4: {
                    JvmCastGen.generateCheckCastToDecimal(mv, sourceType);
                    return;
                }
                case 6: {
                    JvmCastGen.generateCheckCastToBoolean(mv, sourceType);
                    return;
                }
                case 2: {
                    JvmCastGen.generateCheckCastToByte(mv, sourceType);
                    return;
                }
                case 10: 
                case 49: {
                    JvmCastGen.checkCast(mv, targetType);
                    return;
                }
                case 20: {
                    JvmCastGen.generateCheckCastToUnionType(mv, sourceType, (BUnionType)targetType);
                    return;
                }
                case 21: {
                    JvmCastGen.generateCheckCast(mv, sourceType, ((BIntersectionType)targetType).effectiveType, indexMap);
                    return;
                }
                case 11: {
                    JvmCastGen.generateCheckCastToAnyData(mv, sourceType);
                    return;
                }
                case 17: {
                    JvmCastGen.generateCastToAny(mv, sourceType);
                    return;
                }
                case 7: {
                    JvmCastGen.generateCheckCastToJSON(mv, sourceType);
                    return;
                }
                case 37: {
                    JvmCastGen.generateCheckCastToReadonlyType(mv, sourceType, targetType);
                    return;
                }
                case 32: {
                    JvmCastGen.generateCheckCastToFiniteType(mv, sourceType, (BFiniteType)targetType);
                    return;
                }
            }
            JvmCastGen.checkCast(mv, targetType);
        }
        String targetTypeClass = JvmCastGen.getTargetClass(targetType);
        if (targetTypeClass != null) {
            mv.visitTypeInsn(192, targetTypeClass);
        }
    }

    private static void generateCheckCastToInt(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToInt", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int'", sourceType));
            }
        }
    }

    private static void generateCheckCastToSigned32(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToSigned32", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToSigned32", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToSigned32", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Signed32'", sourceType));
            }
        }
    }

    private static void generateCheckCastToSigned16(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToSigned16", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToSigned16", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToSigned16", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Signed16'", sourceType));
            }
        }
    }

    private static void generateCheckCastToSigned8(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToSigned8", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToSigned8", "(J)J", false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToSigned8", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToSigned8", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Signed8'", sourceType));
            }
        }
    }

    private static void generateCheckCastToUnsigned32(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToUnsigned32", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToUnsigned32", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToUnsigned32", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Unsigned32'", sourceType));
            }
        }
    }

    private static void generateCheckCastToUnsigned16(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToUnsigned16", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToUnsigned16", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToUnsigned16", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Unsigned16'", sourceType));
            }
        }
    }

    private static void generateCheckCastToUnsigned8(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToUnsigned8", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToUnsigned8", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToUnsigned8", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Unsigned8'", sourceType));
            }
        }
    }

    private static void generateCheckCastToFloat(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(138);
            return;
        }
        switch (sourceType.tag) {
            case 3: {
                break;
            }
            case 2: {
                mv.visitInsn(135);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToFloat", String.format("(L%s;)D", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'float'", sourceType));
            }
        }
    }

    private static void generateCheckCastToDecimal(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", String.format("(J)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
            return;
        }
        switch (sourceType.tag) {
            case 4: {
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToDecimal", String.format("(L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", String.format("(D)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", String.format("(I)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'decimal'", sourceType));
            }
        }
    }

    private static void generateCheckCastToString(MethodVisitor mv, BType sourceType, BIRVarToJVMIndexMap indexMap) {
        if (TypeTags.isStringTypeTag(sourceType.tag)) {
            return;
        }
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "java/lang/Long", "toString", String.format("(J)L%s;", "java/lang/String"), false);
        } else {
            switch (sourceType.tag) {
                case 7: 
                case 11: 
                case 17: 
                case 20: 
                case 32: 
                case 37: {
                    JvmCastGen.checkCast(mv, JvmCastGen.symbolTable.stringType);
                    mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
                    return;
                }
                case 3: {
                    mv.visitMethodInsn(184, "java/lang/Double", "toString", String.format("(D)L%s;", "java/lang/String"), false);
                    break;
                }
                case 6: {
                    mv.visitMethodInsn(184, "java/lang/Boolean", "toString", String.format("(Z)L%s;", "java/lang/String"), false);
                    break;
                }
                case 4: {
                    mv.visitMethodInsn(184, "java/lang/String", "valueOf", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/String"), false);
                    break;
                }
                default: {
                    throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'string'", sourceType));
                }
            }
        }
        JvmCastGen.generateNonBMPStringValue(mv, indexMap);
    }

    private static void generateNonBMPStringValue(MethodVisitor mv, BIRVarToJVMIndexMap indexMap) {
        int tmpVarIndex = indexMap.addIfNotExists("str", JvmCastGen.symbolTable.anyType);
        mv.visitVarInsn(58, tmpVarIndex);
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/BmpStringValue");
        mv.visitInsn(89);
        mv.visitVarInsn(25, tmpVarIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/BmpStringValue", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
    }

    private static void generateCheckCastToChar(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isStringTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "stringToChar", String.format("(L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/api/values/BString"), false);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7 || sourceType.tag == 37 || sourceType.tag == 32 || TypeTags.isIntegerTypeTag(sourceType.tag) || sourceType.tag == 3 || sourceType.tag == 6 || sourceType.tag == 4) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "anyToChar", String.format("(L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/api/values/BString"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'char'", sourceType));
        }
    }

    private static void generateCheckCastToBoolean(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 6) {
            return;
        }
        if (sourceType.tag != 17 && sourceType.tag != 11 && sourceType.tag != 20 && sourceType.tag != 7 && sourceType.tag != 37 && sourceType.tag != 32) {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'boolean'", sourceType));
        }
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToBoolean", String.format("(L%s;)Z", "java/lang/Object"), false);
    }

    static void generateCheckCastToByte(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToByte", "(J)I", false);
            return;
        }
        switch (sourceType.tag) {
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToByte", "(D)I", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToByte", String.format("(L%s;)I", "java/lang/Object"), false);
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'byte'", sourceType));
            }
        }
    }

    private static void generateCheckCastToAnyData(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 17 || sourceType.tag == 20 || sourceType.tag == 21) {
            JvmCastGen.checkCast(mv, JvmCastGen.symbolTable.anydataType);
        } else {
            JvmCastGen.generateCastToAny(mv, sourceType);
        }
    }

    private static void generateCheckCastToJSON(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 17 || sourceType.tag == 20 || sourceType.tag == 21 || sourceType.tag == 37 || sourceType.tag == 15) {
            JvmCastGen.checkCast(mv, JvmCastGen.symbolTable.jsonType);
        } else {
            JvmCastGen.generateCastToAny(mv, sourceType);
        }
    }

    private static void generateCheckCastToUnionType(MethodVisitor mv, BType sourceType, BUnionType targetType) {
        JvmCastGen.generateCastToAny(mv, sourceType);
        JvmCastGen.checkCast(mv, targetType);
    }

    private static void checkCast(MethodVisitor mv, BType targetType) {
        JvmTypeGen.loadType(mv, targetType);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkCast", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/api/types/Type", "java/lang/Object"), false);
    }

    static String getTargetClass(BType targetType) {
        String targetTypeClass;
        if (TypeTags.isXMLTypeTag(targetType.tag)) {
            return "io/ballerina/runtime/internal/values/XmlValue";
        }
        switch (targetType.tag) {
            case 19: 
            case 30: {
                targetTypeClass = "io/ballerina/runtime/internal/values/ArrayValue";
                break;
            }
            case 12: 
            case 15: {
                targetTypeClass = "io/ballerina/runtime/internal/values/MapValue";
                break;
            }
            case 9: {
                targetTypeClass = "io/ballerina/runtime/internal/values/TableValueImpl";
                break;
            }
            case 14: {
                targetTypeClass = "io/ballerina/runtime/internal/values/StreamValue";
                break;
            }
            case 33: {
                targetTypeClass = "io/ballerina/runtime/api/values/BObject";
                break;
            }
            case 28: {
                targetTypeClass = "io/ballerina/runtime/internal/values/ErrorValue";
                break;
            }
            case 13: {
                targetTypeClass = "io/ballerina/runtime/internal/values/TypedescValue";
                break;
            }
            case 16: {
                targetTypeClass = "io/ballerina/runtime/internal/values/FPValue";
                break;
            }
            case 31: {
                targetTypeClass = "io/ballerina/runtime/internal/values/FutureValue";
                break;
            }
            case 36: {
                targetTypeClass = "io/ballerina/runtime/internal/values/HandleValue";
                break;
            }
            default: {
                return null;
            }
        }
        return targetTypeClass;
    }

    private static void generateCheckCastToFiniteType(MethodVisitor mv, BType sourceType, BFiniteType targetType) {
        JvmCastGen.generateCastToAny(mv, sourceType);
        JvmCastGen.checkCast(mv, targetType);
    }

    private static void generateCheckCastToReadonlyType(MethodVisitor mv, BType sourceType, BType targetType) {
        JvmCastGen.generateCastToAny(mv, sourceType);
        JvmCastGen.checkCast(mv, targetType);
    }

    public static void addBoxInsn(MethodVisitor mv, BType bType) {
        if (bType != null) {
            JvmCastGen.generateCast(mv, bType, JvmInstructionGen.anyType);
        }
    }

    public static void addUnboxInsn(MethodVisitor mv, BType bType) {
        if (bType != null) {
            JvmCastGen.generateCast(mv, JvmInstructionGen.anyType, bType);
        }
    }

    static void generateCast(MethodVisitor mv, BType sourceType, BType targetType) {
        if (TypeTags.isIntegerTypeTag(targetType.tag)) {
            JvmCastGen.generateCastToInt(mv, sourceType);
            return;
        }
        if (TypeTags.isStringTypeTag(targetType.tag)) {
            JvmCastGen.generateCastToString(mv, sourceType);
            return;
        }
        switch (targetType.tag) {
            case 3: {
                JvmCastGen.generateCastToFloat(mv, sourceType);
                return;
            }
            case 6: {
                JvmCastGen.generateCastToBoolean(mv, sourceType);
                return;
            }
            case 2: {
                JvmCastGen.generateCastToByte(mv, sourceType);
                return;
            }
            case 4: {
                JvmCastGen.generateCastToDecimal(mv, sourceType);
                return;
            }
            case 10: 
            case 49: {
                return;
            }
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 32: 
            case 37: {
                JvmCastGen.generateCastToAny(mv, sourceType);
                return;
            }
            case 21: {
                JvmCastGen.generateCast(mv, sourceType, ((BIntersectionType)targetType).effectiveType);
                return;
            }
        }
        String targetTypeClass = JvmCastGen.getTargetClass(targetType);
        if (targetTypeClass != null) {
            mv.visitTypeInsn(192, targetTypeClass);
        }
    }

    private static void generateCastToInt(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitInsn(143);
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int'", sourceType));
            }
        }
    }

    private static void generateCastToFloat(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 3) {
            return;
        }
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(138);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7 || sourceType.tag == 37) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToFloat", String.format("(L%s;)D", "java/lang/Object"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'float'", sourceType));
        }
    }

    private static void generateCastToString(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isStringTypeTag(sourceType.tag)) {
            return;
        }
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "java/lang/Long", "toString", String.format("(J)L%s;", "java/lang/String"), false);
            return;
        }
        switch (sourceType.tag) {
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Double", "toString", String.format("(D)L%s;", "java/lang/String"), false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "toString", String.format("(Z)L%s;", "java/lang/String"), false);
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 37: {
                mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'string'", sourceType));
            }
        }
    }

    private static void generateCastToDecimal(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", String.format("(J)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
            return;
        }
        switch (sourceType.tag) {
            case 4: {
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", String.format("(D)L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 37: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToDecimal", String.format("(L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'decimal'", sourceType));
            }
        }
    }

    private static void generateCastToBoolean(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 6) {
            return;
        }
        if (sourceType.tag != 17 && sourceType.tag != 11 && sourceType.tag != 20 && sourceType.tag != 7 && sourceType.tag != 37) {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'boolean'", sourceType));
        }
        mv.visitTypeInsn(192, "java/lang/Boolean");
        mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
    }

    private static void generateCastToByte(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 2) {
            return;
        }
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7 || sourceType.tag == 37) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToByte", String.format("(L%s;)I", "java/lang/Object"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'byte'", sourceType));
        }
    }

    private static void generateCastToAny(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", String.format("(I)L%s;", "java/lang/Integer"), false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", String.format("(D)L%s;", "java/lang/Double"), false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", String.format("(Z)L%s;", "java/lang/Boolean"), false);
            }
        }
    }

    private static void generateXMLToAttributesMap(MethodVisitor mv) {
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "getAttributesMap", String.format("()L%s;", "io/ballerina/runtime/internal/values/MapValue"), false);
    }

    private JvmCastGen() {
    }
}

