/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.runtime.internal.IdentifierUtils;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JIMethodCall;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

class JvmObservabilityGen {
    private static final String ENTRY_POINT_MAIN_METHOD_NAME = "main";
    private static final String NEW_BB_PREFIX = "observabilityDesugaredBB";
    private static final String SERVICE_IDENTIFIER = "$$service$";
    private static final String ANONYMOUS_SERVICE_IDENTIFIER = "$anonService$";
    private static final String INVOCATION_INSTRUMENTATION_TYPE = "invocation";
    private static final String FUNC_BODY_INSTRUMENTATION_TYPE = "funcBody";
    private static final Location COMPILE_TIME_CONST_POS = new BLangDiagnosticLocation(null, -1, -1, -1, -1);
    private final PackageCache packageCache;
    private final SymbolTable symbolTable;
    private int lambdaIndex;
    private int desugaredBBIndex;
    private int constantIndex;
    private final Map<Object, BIROperand> compileTimeConstants = new HashMap<Object, BIROperand>();

    JvmObservabilityGen(PackageCache packageCache, SymbolTable symbolTable) {
        this.packageCache = packageCache;
        this.symbolTable = symbolTable;
        this.lambdaIndex = 0;
        this.desugaredBBIndex = 0;
        this.constantIndex = 0;
    }

    void instrumentPackage(BIRNode.BIRPackage pkg) {
        for (int i = 0; i < pkg.functions.size(); ++i) {
            BIRNode.BIRFunction func = pkg.functions.get(i);
            this.rewriteAsyncInvocations(func, null, pkg);
            this.rewriteObservableFunctionInvocations(func, pkg);
            if (ENTRY_POINT_MAIN_METHOD_NAME.equals(func.name.value)) {
                this.rewriteObservableFunctionBody(func, pkg, false, true, false, "", func.name.value);
                continue;
            }
            if ((func.flags & 0x800000L) != 0x800000L) continue;
            this.rewriteObservableFunctionBody(func, pkg, false, false, true, "", func.workerName.value);
        }
        for (BIRNode.BIRTypeDefinition typeDef : pkg.typeDefs) {
            if ((typeDef.flags & 0x10000000L) != 0x10000000L && typeDef.type.tag == 33) continue;
            boolean isService = typeDef.type instanceof BServiceType;
            for (int i = 0; i < typeDef.attachedFuncs.size(); ++i) {
                BIRNode.BIRFunction func = typeDef.attachedFuncs.get(i);
                this.rewriteAsyncInvocations(func, typeDef, pkg);
                this.rewriteObservableFunctionInvocations(func, pkg);
                if (!isService || (func.flags & 0x20000L) != 131072L) continue;
                this.rewriteObservableFunctionBody(func, pkg, true, false, false, this.cleanUpServiceName(typeDef.name.value), func.name.value);
            }
        }
        BIRNode.BIRFunction initFunc = pkg.functions.get(0);
        BIRNode.BIRBasicBlock constInitBB = initFunc.basicBlocks.get(0);
        for (Map.Entry<Object, BIROperand> entry : this.compileTimeConstants.entrySet()) {
            BIROperand operand = entry.getValue();
            BIRNonTerminator.ConstantLoad constLoadIns = new BIRNonTerminator.ConstantLoad(COMPILE_TIME_CONST_POS, entry.getKey(), operand.variableDcl.type, operand);
            constInitBB.instructions.add(constLoadIns);
        }
    }

    private void rewriteAsyncInvocations(BIRNode.BIRFunction func, BIRNode.BIRTypeDefinition attachedTypeDef, BIRNode.BIRPackage pkg) {
        List<BIRNode.BIRFunction> scopeFunctionsList;
        BTypeSymbol functionOwner;
        Name org = new Name(IdentifierUtils.decodeIdentifier(pkg.org.value));
        Name module = new Name(IdentifierUtils.decodeIdentifier(pkg.name.value));
        PackageID currentPkgId = new PackageID(org, module, pkg.version);
        if (attachedTypeDef == null) {
            functionOwner = this.packageCache.getSymbol(currentPkgId);
            scopeFunctionsList = pkg.functions;
        } else {
            functionOwner = attachedTypeDef.type.tsymbol;
            scopeFunctionsList = attachedTypeDef.attachedFuncs;
        }
        for (BIRNode.BIRBasicBlock currentBB : func.basicBlocks) {
            if (currentBB.terminator.kind != InstructionKind.ASYNC_CALL || !this.isObservable((BIRTerminator.AsyncCall)currentBB.terminator)) continue;
            BIRTerminator.AsyncCall asyncCallIns = (BIRTerminator.AsyncCall)currentBB.terminator;
            BType returnType = ((BFutureType)asyncCallIns.lhsOp.variableDcl.type).constraint;
            List<BType> argTypes = asyncCallIns.args.stream().map(arg -> arg.variableDcl.type).collect(Collectors.toList());
            Name lambdaName = new Name(String.format("$lambda$observability%d$%s", this.lambdaIndex++, asyncCallIns.name.value.replace(".", "_")));
            BInvokableType bInvokableType = new BInvokableType(argTypes, null, returnType, null);
            BIRNode.BIRFunction desugaredFunc = new BIRNode.BIRFunction(asyncCallIns.pos, lambdaName, 0L, bInvokableType, func.workerName, 0, null, SymbolOrigin.VIRTUAL);
            desugaredFunc.receiver = func.receiver;
            scopeFunctionsList.add(desugaredFunc);
            BIRNode.BIRVariableDcl funcReturnVariableDcl = new BIRNode.BIRVariableDcl(returnType, new Name(String.format("$%s$retVal", lambdaName.value)), VarScope.FUNCTION, VarKind.RETURN);
            BIROperand funcReturnOperand = new BIROperand(funcReturnVariableDcl);
            desugaredFunc.localVars.add(funcReturnVariableDcl);
            desugaredFunc.returnVariable = funcReturnVariableDcl;
            BInvokableSymbol invokableSymbol = new BInvokableSymbol(820, 0L, lambdaName, currentPkgId, bInvokableType, functionOwner, desugaredFunc.pos, SymbolOrigin.VIRTUAL);
            invokableSymbol.retType = funcReturnVariableDcl.type;
            invokableSymbol.kind = SymbolKind.FUNCTION;
            invokableSymbol.params = asyncCallIns.args.stream().map(arg -> new BVarSymbol(0L, arg.variableDcl.name, currentPkgId, arg.variableDcl.type, invokableSymbol, arg.pos, SymbolOrigin.VIRTUAL)).collect(Collectors.toList());
            invokableSymbol.scope = new Scope(invokableSymbol);
            invokableSymbol.params.forEach(param -> invokableSymbol.scope.define(param.name, (BSymbol)param));
            if (attachedTypeDef == null) {
                functionOwner.scope.define(lambdaName, invokableSymbol);
            }
            ArrayList<BIROperand> funcParamOperands = new ArrayList<BIROperand>();
            Name selfArgName = new Name("%self");
            for (int i = 0; i < asyncCallIns.args.size(); ++i) {
                BIRNode.BIRFunctionParameter funcParam;
                BIROperand arg2 = (BIROperand)asyncCallIns.args.get(i);
                if (arg2.variableDcl.kind == VarKind.SELF) {
                    funcParam = new BIRNode.BIRFunctionParameter(asyncCallIns.pos, arg2.variableDcl.type, selfArgName, VarScope.FUNCTION, VarKind.SELF, selfArgName.value, false);
                } else {
                    Name argName = new Name(String.format("$funcParam%d", i));
                    funcParam = new BIRNode.BIRFunctionParameter(asyncCallIns.pos, arg2.variableDcl.type, argName, VarScope.FUNCTION, VarKind.ARG, argName.value, false);
                    desugaredFunc.localVars.add(funcParam);
                    desugaredFunc.parameters.put(funcParam, Collections.emptyList());
                    desugaredFunc.requiredParams.add(new BIRNode.BIRParameter(asyncCallIns.pos, argName, 0L));
                    ++desugaredFunc.argsCount;
                }
                funcParamOperands.add(new BIROperand(funcParam));
            }
            BIRNode.BIRBasicBlock callInsBB = this.insertBasicBlock(desugaredFunc, 0);
            BIRNode.BIRBasicBlock returnInsBB = this.insertBasicBlock(desugaredFunc, 1);
            callInsBB.terminator = new BIRTerminator.Call(asyncCallIns.pos, InstructionKind.CALL, asyncCallIns.isVirtual, asyncCallIns.calleePkg, asyncCallIns.name, funcParamOperands, funcReturnOperand, returnInsBB, asyncCallIns.calleeAnnotAttachments, asyncCallIns.calleeFlags);
            returnInsBB.terminator = new BIRTerminator.Return(asyncCallIns.pos);
            asyncCallIns.name = lambdaName;
            asyncCallIns.calleePkg = currentPkgId;
            boolean bl = asyncCallIns.isVirtual = attachedTypeDef != null;
            if (attachedTypeDef == null) continue;
            asyncCallIns.args.add(0, new BIROperand(new BIRNode.BIRVariableDcl(attachedTypeDef.type, selfArgName, VarScope.FUNCTION, VarKind.SELF)));
        }
    }

    private void rewriteObservableFunctionBody(BIRNode.BIRFunction func, BIRNode.BIRPackage pkg, boolean isResource, boolean isMainEntryPoint, boolean isWorker, String serviceName, String resourceOrAction) {
        BIRNode.BIRBasicBlock startBB = func.basicBlocks.get(0);
        BIRNode.BIRBasicBlock newStartBB = this.insertBasicBlock(func, 1);
        this.swapBasicBlockContent(startBB, newStartBB);
        if (isResource) {
            this.injectStartResourceObservationCall(startBB, serviceName, resourceOrAction, pkg, func.pos);
        } else {
            BIROperand objectTypeOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.nilType, null);
            this.injectStartCallableObservationCall(startBB, null, false, isMainEntryPoint, isWorker, objectTypeOperand, resourceOrAction, pkg, func.pos);
        }
        startBB.terminator.thenBB = newStartBB;
        boolean isErrorCheckRequired = this.isErrorAssignable(func.returnVariable);
        BIROperand returnValOperand = new BIROperand(func.returnVariable);
        for (int i = 1; i < func.basicBlocks.size(); ++i) {
            Optional<BIRNode.BIRErrorEntry> existingEE;
            BIRNode.BIRBasicBlock newCurrentBB;
            BIRNode.BIRBasicBlock observeEndBB;
            BIRNode.BIRBasicBlock currentBB = func.basicBlocks.get(i);
            if (currentBB.terminator.kind == InstructionKind.RETURN) {
                if (isErrorCheckRequired) {
                    BIRNode.BIRBasicBlock errorReportBB = this.insertBasicBlock(func, i + 1);
                    observeEndBB = this.insertBasicBlock(func, i + 2);
                    newCurrentBB = this.insertBasicBlock(func, i + 3);
                    this.swapBasicBlockTerminator(currentBB, newCurrentBB);
                    this.injectCheckErrorCalls(currentBB, errorReportBB, observeEndBB, func.localVars, null, returnValOperand, FUNC_BODY_INSTRUMENTATION_TYPE);
                    this.injectReportErrorCall(errorReportBB, func.localVars, null, returnValOperand, FUNC_BODY_INSTRUMENTATION_TYPE);
                    this.injectStopObservationCall(observeEndBB, null);
                    observeEndBB.terminator.thenBB = newCurrentBB;
                    errorReportBB.terminator.thenBB = observeEndBB;
                    i += 3;
                    continue;
                }
                BIRNode.BIRBasicBlock newCurrentBB2 = this.insertBasicBlock(func, i + 1);
                this.swapBasicBlockTerminator(currentBB, newCurrentBB2);
                this.injectStopObservationCall(currentBB, null);
                currentBB.terminator.thenBB = newCurrentBB2;
                ++i;
                continue;
            }
            if (currentBB.terminator.kind == InstructionKind.PANIC) {
                BIRTerminator.Panic panicCall = (BIRTerminator.Panic)currentBB.terminator;
                observeEndBB = this.insertBasicBlock(func, i + 1);
                newCurrentBB = this.insertBasicBlock(func, i + 2);
                this.swapBasicBlockTerminator(currentBB, newCurrentBB);
                this.injectReportErrorCall(currentBB, func.localVars, newCurrentBB.terminator.pos, panicCall.errorOp, FUNC_BODY_INSTRUMENTATION_TYPE);
                this.injectStopObservationCall(observeEndBB, newCurrentBB.terminator.pos);
                currentBB.terminator.thenBB = observeEndBB;
                observeEndBB.terminator.thenBB = newCurrentBB;
                i += 2;
                continue;
            }
            if (currentBB.terminator.kind != InstructionKind.CALL && (currentBB.terminator.kind != InstructionKind.FP_CALL || ((BIRTerminator.FPCall)currentBB.terminator).isAsync) || !(existingEE = func.errorTable.stream().filter(errorEntry -> this.isBBCoveredInErrorEntry((BIRNode.BIRErrorEntry)errorEntry, func.basicBlocks, currentBB)).findAny()).isEmpty()) continue;
            BIRNode.BIRBasicBlock errorCheckBB = this.insertBasicBlock(func, i + 1);
            BIRNode.BIRBasicBlock errorReportBB = this.insertBasicBlock(func, i + 2);
            BIRNode.BIRBasicBlock observeEndBB2 = this.insertBasicBlock(func, i + 3);
            BIRNode.BIRBasicBlock rePanicBB = this.insertBasicBlock(func, i + 4);
            BIRNode.BIRVariableDcl trappedErrorVariableDcl = new BIRNode.BIRVariableDcl(this.symbolTable.errorType, new Name(String.format("$%s$trappedError", currentBB.id.value)), VarScope.FUNCTION, VarKind.TEMP);
            func.localVars.add(trappedErrorVariableDcl);
            BIROperand trappedErrorOperand = new BIROperand(trappedErrorVariableDcl);
            this.injectCheckErrorCalls(errorCheckBB, errorReportBB, currentBB.terminator.thenBB, func.localVars, currentBB.terminator.pos, trappedErrorOperand, FUNC_BODY_INSTRUMENTATION_TYPE);
            this.injectReportErrorCall(errorReportBB, func.localVars, currentBB.terminator.pos, trappedErrorOperand, FUNC_BODY_INSTRUMENTATION_TYPE);
            this.injectStopObservationCall(observeEndBB2, currentBB.terminator.pos);
            rePanicBB.terminator = new BIRTerminator.Panic(currentBB.terminator.pos, trappedErrorOperand);
            BIRNode.BIRErrorEntry errorEntry2 = new BIRNode.BIRErrorEntry(currentBB, currentBB, trappedErrorOperand, errorCheckBB);
            func.errorTable.add(errorEntry2);
            currentBB.terminator.thenBB = errorCheckBB;
            errorReportBB.terminator.thenBB = observeEndBB2;
            observeEndBB2.terminator.thenBB = rePanicBB;
            i += 4;
        }
    }

    private void rewriteObservableFunctionInvocations(BIRNode.BIRFunction func, BIRNode.BIRPackage pkg) {
        for (int i = 0; i < func.basicBlocks.size(); ++i) {
            BIRNode.BIRBasicBlock observeEndBB;
            String action;
            BIROperand objectTypeOperand;
            BIRNode.BIRBasicBlock currentBB = func.basicBlocks.get(i);
            if (currentBB.terminator.kind != InstructionKind.CALL || !this.isObservable((BIRTerminator.Call)currentBB.terminator)) continue;
            BIRTerminator.Call callIns = (BIRTerminator.Call)currentBB.terminator;
            Location desugaredInsPosition = callIns.pos;
            BIRNode.BIRBasicBlock observeStartBB = this.insertBasicBlock(func, i + 1);
            int newCurrentIndex = i + 2;
            BIRNode.BIRBasicBlock newCurrentBB = this.insertBasicBlock(func, newCurrentIndex);
            this.swapBasicBlockTerminator(currentBB, newCurrentBB);
            if (callIns.isVirtual) {
                objectTypeOperand = callIns.args.get(0);
                if (callIns.name.value.contains(".")) {
                    String[] split = callIns.name.value.split("\\.");
                    action = split[1];
                } else {
                    action = callIns.name.value;
                }
            } else {
                objectTypeOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.nilType, null);
                action = callIns.name.value;
            }
            currentBB.terminator = new BIRTerminator.GOTO(desugaredInsPosition, observeStartBB);
            boolean isRemote = callIns.calleeFlags.contains((Object)Flag.REMOTE);
            Location originalInsPos = callIns.pos;
            if (this.isErrorAssignable(callIns.lhsOp.variableDcl)) {
                BIRNode.BIRBasicBlock errorCheckBB = this.insertBasicBlock(func, i + 3);
                BIRNode.BIRBasicBlock errorReportBB = this.insertBasicBlock(func, i + 4);
                observeEndBB = this.insertBasicBlock(func, i + 5);
                this.injectStartCallableObservationCall(observeStartBB, desugaredInsPosition, isRemote, false, false, objectTypeOperand, action, pkg, originalInsPos);
                this.injectCheckErrorCalls(errorCheckBB, errorReportBB, observeEndBB, func.localVars, desugaredInsPosition, callIns.lhsOp, INVOCATION_INSTRUMENTATION_TYPE);
                this.injectReportErrorCall(errorReportBB, func.localVars, desugaredInsPosition, callIns.lhsOp, INVOCATION_INSTRUMENTATION_TYPE);
                this.injectStopObservationCall(observeEndBB, desugaredInsPosition);
                observeEndBB.terminator.thenBB = newCurrentBB.terminator.thenBB;
                errorReportBB.terminator.thenBB = observeEndBB;
                newCurrentBB.terminator.thenBB = errorCheckBB;
                observeStartBB.terminator.thenBB = newCurrentBB;
                i += 5;
            } else {
                observeEndBB = this.insertBasicBlock(func, i + 3);
                this.injectStartCallableObservationCall(observeStartBB, desugaredInsPosition, isRemote, false, false, objectTypeOperand, action, pkg, originalInsPos);
                this.injectStopObservationCall(observeEndBB, desugaredInsPosition);
                observeEndBB.terminator.thenBB = newCurrentBB.terminator.thenBB;
                newCurrentBB.terminator.thenBB = observeEndBB;
                observeStartBB.terminator.thenBB = newCurrentBB;
                i += 3;
            }
            this.fixErrorTable(func, currentBB, observeEndBB);
            Optional<BIRNode.BIRErrorEntry> existingEE = func.errorTable.stream().filter(errorEntry -> this.isBBCoveredInErrorEntry((BIRNode.BIRErrorEntry)errorEntry, func.basicBlocks, newCurrentBB)).findAny();
            Location desugaredInsPos = callIns.pos;
            if (existingEE.isPresent()) {
                BIRNode.BIRErrorEntry errorEntry2 = existingEE.get();
                int eeTargetIndex = func.basicBlocks.indexOf(errorEntry2.targetBB);
                if (eeTargetIndex == -1) {
                    throw new BLangCompilerException("Invalid Error Entry pointing to non-existent target Basic Block " + errorEntry2.targetBB.id);
                }
                BIRNode.BIRBasicBlock errorReportBB = this.insertBasicBlock(func, eeTargetIndex + 1);
                BIRNode.BIRBasicBlock observeEndBB2 = this.insertBasicBlock(func, eeTargetIndex + 2);
                BIRNode.BIRBasicBlock newTargetBB = this.insertBasicBlock(func, eeTargetIndex + 3);
                this.swapBasicBlockContent(errorEntry2.targetBB, newTargetBB);
                this.injectCheckErrorCalls(errorEntry2.targetBB, errorReportBB, newTargetBB, func.localVars, desugaredInsPos, errorEntry2.errorOp, INVOCATION_INSTRUMENTATION_TYPE);
                this.injectReportErrorCall(errorReportBB, func.localVars, desugaredInsPos, errorEntry2.errorOp, INVOCATION_INSTRUMENTATION_TYPE);
                this.injectStopObservationCall(observeEndBB2, desugaredInsPos);
                errorReportBB.terminator.thenBB = observeEndBB2;
                observeEndBB2.terminator.thenBB = newTargetBB;
                this.fixErrorTable(func, errorEntry2.targetBB, newTargetBB);
                continue;
            }
            BIRNode.BIRBasicBlock errorCheckBB = this.insertBasicBlock(func, newCurrentIndex + 1);
            BIRNode.BIRBasicBlock errorReportBB = this.insertBasicBlock(func, newCurrentIndex + 2);
            BIRNode.BIRBasicBlock observeEndBB3 = this.insertBasicBlock(func, newCurrentIndex + 3);
            BIRNode.BIRBasicBlock rePanicBB = this.insertBasicBlock(func, newCurrentIndex + 4);
            BIRNode.BIRVariableDcl trappedErrorVariableDcl = new BIRNode.BIRVariableDcl(this.symbolTable.errorType, new Name(String.format("$%s$trappedError", newCurrentBB.id.value)), VarScope.FUNCTION, VarKind.TEMP);
            func.localVars.add(trappedErrorVariableDcl);
            BIROperand trappedErrorOperand = new BIROperand(trappedErrorVariableDcl);
            this.injectCheckErrorCalls(errorCheckBB, errorReportBB, newCurrentBB.terminator.thenBB, func.localVars, newCurrentBB.terminator.pos, trappedErrorOperand, INVOCATION_INSTRUMENTATION_TYPE);
            this.injectReportErrorCall(errorReportBB, func.localVars, newCurrentBB.terminator.pos, trappedErrorOperand, INVOCATION_INSTRUMENTATION_TYPE);
            this.injectStopObservationCall(observeEndBB3, newCurrentBB.terminator.pos);
            rePanicBB.terminator = new BIRTerminator.Panic(newCurrentBB.terminator.pos, trappedErrorOperand);
            BIRNode.BIRErrorEntry errorEntry3 = new BIRNode.BIRErrorEntry(newCurrentBB, newCurrentBB, trappedErrorOperand, errorCheckBB);
            func.errorTable.add(errorEntry3);
            newCurrentBB.terminator.thenBB = errorCheckBB;
            errorReportBB.terminator.thenBB = observeEndBB3;
            observeEndBB3.terminator.thenBB = rePanicBB;
            i += 4;
        }
    }

    private void injectStartResourceObservationCall(BIRNode.BIRBasicBlock observeStartBB, String serviceName, String resource, BIRNode.BIRPackage pkg, Location originalInsPosition) {
        String pkgId = this.generatePackageId(pkg);
        String position = this.generatePositionId(originalInsPosition);
        BIROperand serviceNameOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, serviceName);
        BIROperand resourceOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, resource);
        BIROperand pkgOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, pkgId);
        BIROperand originalInsPosOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, position);
        JIMethodCall observeStartCallTerminator = new JIMethodCall(null);
        observeStartCallTerminator.invocationType = 184;
        observeStartCallTerminator.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        observeStartCallTerminator.jMethodVMSig = String.format("(L%s;L%s;L%s;L%s;L%s;)V", "io/ballerina/runtime/api/Environment", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString");
        observeStartCallTerminator.name = "startResourceObservation";
        observeStartCallTerminator.args = Arrays.asList(serviceNameOperand, resourceOperand, pkgOperand, originalInsPosOperand);
        observeStartBB.terminator = observeStartCallTerminator;
    }

    private void injectStartCallableObservationCall(BIRNode.BIRBasicBlock observeStartBB, Location desugaredInsLocation, boolean isRemote, boolean isMainEntryPoint, boolean isWorker, BIROperand objectOperand, String action, BIRNode.BIRPackage pkg, Location originalInsPosition) {
        String pkgId = this.generatePackageId(pkg);
        String position = this.generatePositionId(originalInsPosition);
        BIROperand isRemoteOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.booleanType, isRemote);
        BIROperand isMainEntryPointOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.booleanType, isMainEntryPoint);
        BIROperand isWorkerOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.booleanType, isWorker);
        BIROperand pkgOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, pkgId);
        BIROperand originalInsPosOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, position);
        BIROperand actionOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, action);
        JIMethodCall observeStartCallTerminator = new JIMethodCall(desugaredInsLocation);
        observeStartCallTerminator.invocationType = 184;
        observeStartCallTerminator.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        observeStartCallTerminator.jMethodVMSig = String.format("(L%s;ZZZL%s;L%s;L%s;L%s;)V", "io/ballerina/runtime/api/Environment", "io/ballerina/runtime/api/values/BObject", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString");
        observeStartCallTerminator.name = "startCallableObservation";
        observeStartCallTerminator.args = Arrays.asList(isRemoteOperand, isMainEntryPointOperand, isWorkerOperand, objectOperand, actionOperand, pkgOperand, originalInsPosOperand);
        observeStartBB.terminator = observeStartCallTerminator;
    }

    private void injectCheckErrorCalls(BIRNode.BIRBasicBlock errorCheckBB, BIRNode.BIRBasicBlock isErrorBB, BIRNode.BIRBasicBlock noErrorBB, Collection<BIRNode.BIRVariableDcl> scopeVarList, Location pos, BIROperand valueOperand, String uniqueId) {
        BIRNode.BIRVariableDcl isErrorVariableDcl = new BIRNode.BIRVariableDcl(this.symbolTable.booleanType, new Name(String.format("$%s$%s$isError", uniqueId, errorCheckBB.id.value)), VarScope.FUNCTION, VarKind.TEMP);
        scopeVarList.add(isErrorVariableDcl);
        BIROperand isErrorOperand = new BIROperand(isErrorVariableDcl);
        BIRNonTerminator.TypeTest errorTypeTestInstruction = new BIRNonTerminator.TypeTest(pos, this.symbolTable.errorType, isErrorOperand, valueOperand);
        errorCheckBB.instructions.add(errorTypeTestInstruction);
        errorCheckBB.terminator = new BIRTerminator.Branch(pos, isErrorOperand, isErrorBB, noErrorBB);
    }

    private void injectReportErrorCall(BIRNode.BIRBasicBlock errorReportBB, Collection<BIRNode.BIRVariableDcl> scopeVarList, Location pos, BIROperand errorOperand, String uniqueId) {
        BIRNode.BIRVariableDcl castedErrorVariableDcl = new BIRNode.BIRVariableDcl(this.symbolTable.errorType, new Name(String.format("$%s$%s$castedError", uniqueId, errorReportBB.id.value)), VarScope.FUNCTION, VarKind.TEMP);
        scopeVarList.add(castedErrorVariableDcl);
        BIROperand castedErrorOperand = new BIROperand(castedErrorVariableDcl);
        BIRNonTerminator.TypeCast errorCastInstruction = new BIRNonTerminator.TypeCast(pos, castedErrorOperand, errorOperand, this.symbolTable.errorType, false);
        errorReportBB.instructions.add(errorCastInstruction);
        JIMethodCall reportErrorCallTerminator = new JIMethodCall(pos);
        reportErrorCallTerminator.invocationType = 184;
        reportErrorCallTerminator.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        reportErrorCallTerminator.jMethodVMSig = String.format("(L%s;L%s;)V", "io/ballerina/runtime/api/Environment", "io/ballerina/runtime/internal/values/ErrorValue");
        reportErrorCallTerminator.name = "reportError";
        reportErrorCallTerminator.args = Collections.singletonList(castedErrorOperand);
        errorReportBB.terminator = reportErrorCallTerminator;
    }

    private void injectStopObservationCall(BIRNode.BIRBasicBlock observeEndBB, Location pos) {
        JIMethodCall observeEndCallTerminator = new JIMethodCall(pos);
        observeEndCallTerminator.invocationType = 184;
        observeEndCallTerminator.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        observeEndCallTerminator.jMethodVMSig = String.format("(L%s;)V", "io/ballerina/runtime/api/Environment");
        observeEndCallTerminator.name = "stopObservation";
        observeEndCallTerminator.args = Collections.emptyList();
        observeEndBB.terminator = observeEndCallTerminator;
    }

    private BIROperand generateGlobalConstantOperand(BIRNode.BIRPackage pkg, BType constantType, Object constantValue) {
        return this.compileTimeConstants.computeIfAbsent(constantValue, k -> {
            PackageID pkgId = new PackageID(pkg.org, pkg.name, pkg.version);
            BIRNode.BIRGlobalVariableDcl constLoadVariableDcl = new BIRNode.BIRGlobalVariableDcl(COMPILE_TIME_CONST_POS, 0L, constantType, pkgId, new Name("$observabilityConst" + this.constantIndex++), VarScope.GLOBAL, VarKind.CONSTANT, "", SymbolOrigin.VIRTUAL);
            pkg.globalVars.add(constLoadVariableDcl);
            return new BIROperand(constLoadVariableDcl);
        });
    }

    private BIRNode.BIRBasicBlock insertBasicBlock(BIRNode.BIRFunction func, int insertIndex) {
        BIRNode.BIRBasicBlock newBB = new BIRNode.BIRBasicBlock(new Name(NEW_BB_PREFIX + this.desugaredBBIndex++));
        func.basicBlocks.add(insertIndex, newBB);
        return newBB;
    }

    private void swapBasicBlockContent(BIRNode.BIRBasicBlock firstBB, BIRNode.BIRBasicBlock secondBB) {
        List<BIRNonTerminator> firstBBInstructions = firstBB.instructions;
        firstBB.instructions = secondBB.instructions;
        secondBB.instructions = firstBBInstructions;
        this.swapBasicBlockTerminator(firstBB, secondBB);
    }

    private void swapBasicBlockTerminator(BIRNode.BIRBasicBlock firstBB, BIRNode.BIRBasicBlock secondBB) {
        BIRTerminator firstBBTerminator = firstBB.terminator;
        firstBB.terminator = secondBB.terminator;
        secondBB.terminator = firstBBTerminator;
    }

    private void fixErrorTable(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock oldBB, BIRNode.BIRBasicBlock newBB) {
        for (BIRNode.BIRErrorEntry errorEntry : func.errorTable) {
            if (errorEntry.endBB != oldBB) continue;
            errorEntry.endBB = newBB;
        }
    }

    private boolean isObservable(BIRTerminator.Call callIns) {
        boolean isRemote = callIns.calleeFlags.contains((Object)Flag.REMOTE);
        boolean isObservableAnnotationPresent = false;
        for (BIRNode.BIRAnnotationAttachment annot : callIns.calleeAnnotAttachments) {
            if (!"ballerina/observe/Observable".equals(JvmCodeGenUtil.getPackageName(annot.packageID.orgName, annot.packageID.name, Names.EMPTY) + annot.annotTagRef.value)) continue;
            isObservableAnnotationPresent = true;
            break;
        }
        return isRemote || isObservableAnnotationPresent;
    }

    private boolean isErrorAssignable(BIRNode.BIRVariableDcl variableDcl) {
        boolean isErrorAssignable = false;
        if (variableDcl.type instanceof BUnionType) {
            BUnionType returnUnionType = (BUnionType)variableDcl.type;
            isErrorAssignable = returnUnionType.getMemberTypes().stream().anyMatch(type -> type instanceof BErrorType);
        } else if (variableDcl.type instanceof BErrorType) {
            isErrorAssignable = true;
        }
        return isErrorAssignable;
    }

    private boolean isBBCoveredInErrorEntry(BIRNode.BIRErrorEntry errorEntry, List<BIRNode.BIRBasicBlock> basicBlocksList, BIRNode.BIRBasicBlock basicBlock) {
        boolean isCovered;
        boolean bl = isCovered = Objects.equals(basicBlock, errorEntry.trapBB) || Objects.equals(basicBlock, errorEntry.endBB);
        if (!isCovered) {
            BIRNode.BIRBasicBlock currentBB;
            int i;
            for (i = 0; i < basicBlocksList.size() && (currentBB = basicBlocksList.get(i)) != errorEntry.trapBB; ++i) {
            }
            while (i < basicBlocksList.size()) {
                currentBB = basicBlocksList.get(i);
                if (currentBB == basicBlock) {
                    isCovered = true;
                    break;
                }
                if (currentBB == errorEntry.endBB) break;
                ++i;
            }
        }
        return isCovered;
    }

    private String cleanUpServiceName(String serviceName) {
        if (serviceName.contains(SERVICE_IDENTIFIER)) {
            return serviceName.substring(0, serviceName.indexOf(SERVICE_IDENTIFIER));
        }
        return serviceName;
    }

    private String generatePositionId(Location pos) {
        return String.format("%s:%d:%d", pos.lineRange().filePath(), pos.lineRange().startLine().line() + 1, pos.lineRange().startLine().offset() + 1);
    }

    private String generatePackageId(BIRNode.BIRPackage pkg) {
        return String.format("%s/%s:%s", pkg.org.value, pkg.name.value, pkg.version.value);
    }
}

