/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.runtime.internal.IdentifierUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.objectweb.asm.ClassTooLargeException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodTooLargeException;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.CompiledJarFile;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.ShutDownListenerGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JavaClass;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.ConfigMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.FrameClassGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.LambdaGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MainMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.ModuleStopMethodGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.ResolvedTypeBuilder;

public class JvmPackageGen {
    private static ResolvedTypeBuilder typeBuilder;
    public final SymbolTable symbolTable;
    public final PackageCache packageCache;
    private final MethodGen methodGen;
    private final FrameClassGen frameClassGen;
    private final InitMethodGen initMethodGen;
    private final ConfigMethodGen configMethodGen;
    private final LambdaGen lambdaGen;
    private final Map<String, BIRFunctionWrapper> birFunctionMap = new HashMap<String, BIRFunctionWrapper>();
    private final Map<String, String> externClassMap;
    private final Map<String, String> globalVarClassMap = new HashMap<String, String>();
    private final Map<String, PackageID> dependentModules;
    private final BLangDiagnosticLog dlog;

    JvmPackageGen(SymbolTable symbolTable, PackageCache packageCache, BLangDiagnosticLog dlog) {
        this.externClassMap = new HashMap<String, String>();
        this.dependentModules = new LinkedHashMap<String, PackageID>();
        this.symbolTable = symbolTable;
        this.packageCache = packageCache;
        this.dlog = dlog;
        this.methodGen = new MethodGen(this);
        this.initMethodGen = new InitMethodGen(symbolTable);
        this.configMethodGen = new ConfigMethodGen();
        this.lambdaGen = new LambdaGen(this);
        this.frameClassGen = new FrameClassGen();
        typeBuilder = new ResolvedTypeBuilder();
        JvmCastGen.symbolTable = symbolTable;
        JvmInstructionGen.anyType = symbolTable.anyType;
    }

    private static String getBvmAlias(String orgName, String moduleName) {
        if (Names.ANON_ORG.value.equals(orgName)) {
            return moduleName;
        }
        return orgName + "/" + moduleName;
    }

    private static void addBuiltinImports(BIRNode.BIRPackage currentModule, Set<PackageID> dependentModuleArray) {
        if (JvmPackageGen.isSameModule(currentModule, PackageID.ANNOTATIONS)) {
            return;
        }
        dependentModuleArray.add(PackageID.ANNOTATIONS);
        if (JvmPackageGen.isSameModule(currentModule, PackageID.JAVA)) {
            return;
        }
        dependentModuleArray.add(PackageID.JAVA);
        if (JvmPackageGen.isLangModule(currentModule)) {
            return;
        }
        if (JvmPackageGen.isSameModule(currentModule, PackageID.INTERNAL)) {
            return;
        }
        dependentModuleArray.add(PackageID.INTERNAL);
        dependentModuleArray.add(PackageID.ARRAY);
        dependentModuleArray.add(PackageID.DECIMAL);
        dependentModuleArray.add(PackageID.ERROR);
        dependentModuleArray.add(PackageID.FLOAT);
        dependentModuleArray.add(PackageID.FUTURE);
        dependentModuleArray.add(PackageID.INT);
        dependentModuleArray.add(PackageID.MAP);
        dependentModuleArray.add(PackageID.OBJECT);
        dependentModuleArray.add(PackageID.STREAM);
        dependentModuleArray.add(PackageID.STRING);
        dependentModuleArray.add(PackageID.TABLE);
        dependentModuleArray.add(PackageID.VALUE);
        dependentModuleArray.add(PackageID.XML);
        dependentModuleArray.add(PackageID.TYPEDESC);
        dependentModuleArray.add(PackageID.BOOLEAN);
        dependentModuleArray.add(PackageID.QUERY);
        dependentModuleArray.add(PackageID.TRANSACTION);
    }

    private static boolean isSameModule(BIRNode.BIRPackage moduleId, PackageID importModule) {
        PackageID cleanedPkg = JvmCodeGenUtil.cleanupPackageID(importModule);
        if (!moduleId.org.value.equals(cleanedPkg.orgName.value)) {
            return false;
        }
        if (!moduleId.name.value.equals(cleanedPkg.name.value)) {
            return false;
        }
        return moduleId.version.value.equals(cleanedPkg.version.value);
    }

    private static boolean isLangModule(BIRNode.BIRPackage moduleId) {
        if (!"ballerina".equals(moduleId.org.value)) {
            return false;
        }
        return moduleId.name.value.indexOf("lang$0046") == 0 || moduleId.name.equals(Names.JAVA);
    }

    private static void generatePackageVariable(BIRNode.BIRGlobalVariableDcl globalVar, ClassWriter cw) {
        String varName = globalVar.name.value;
        BType bType = globalVar.type;
        String typeSig = JvmCodeGenUtil.getFieldTypeSignature(bType);
        cw.visitField(9, varName, typeSig, null, null).visitEnd();
    }

    private static void generateLockForVariable(ClassWriter cw) {
        String lockStoreClass = "Lio/ballerina/runtime/internal/BLockStore;";
        FieldVisitor fv = cw.visitField(25, "$LOCK_STORE", lockStoreClass, null, null);
        fv.visitEnd();
    }

    private static void generateStaticInitializer(ClassWriter cw, String className, BIRNode.BIRPackage module, boolean isInitClass, boolean serviceEPAvailable, AsyncDataCollector asyncDataCollector) {
        if (!isInitClass && asyncDataCollector.getStrandMetadata().isEmpty()) {
            return;
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        if (isInitClass) {
            JvmPackageGen.setLockStoreField(mv, className);
            JvmPackageGen.setServiceEPAvailableField(cw, mv, serviceEPAvailable, className);
            JvmPackageGen.setModuleStatusField(cw, mv, className);
            JvmPackageGen.setCurrentModuleField(cw, mv, module, className);
        }
        JvmCodeGenUtil.generateStrandMetadata(mv, className, module, asyncDataCollector);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void setLockStoreField(MethodVisitor mv, String className) {
        String lockStoreClass = "Lio/ballerina/runtime/internal/BLockStore;";
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/BLockStore");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/BLockStore", "<init>", "()V", false);
        mv.visitFieldInsn(179, className, "$LOCK_STORE", lockStoreClass);
    }

    private static void setServiceEPAvailableField(ClassWriter cw, MethodVisitor mv, boolean serviceEPAvailable, String initClass) {
        FieldVisitor fv = cw.visitField(9, "$serviceEPAvailable", "Z", null, null);
        fv.visitEnd();
        if (serviceEPAvailable) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitFieldInsn(179, initClass, "$serviceEPAvailable", "Z");
    }

    private static void setModuleStatusField(ClassWriter cw, MethodVisitor mv, String initClass) {
        FieldVisitor fv = cw.visitField(9, "$moduleStartAttempted", "Z", null, null);
        fv.visitEnd();
        mv.visitInsn(3);
        mv.visitFieldInsn(179, initClass, "$moduleStartAttempted", "Z");
        fv = cw.visitField(9, "$moduleStarted", "Z", null, null);
        fv.visitEnd();
        mv.visitInsn(3);
        mv.visitFieldInsn(179, initClass, "$moduleStarted", "Z");
    }

    private static void setCurrentModuleField(ClassWriter cw, MethodVisitor mv, BIRNode.BIRPackage module, String moduleInitClass) {
        FieldVisitor fv = cw.visitField(9, "$moduleName", String.format("L%s;", "io/ballerina/runtime/api/Module"), null, null);
        fv.visitEnd();
        mv.visitTypeInsn(187, "io/ballerina/runtime/api/Module");
        mv.visitInsn(89);
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(module.org.value));
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(module.name.value));
        mv.visitLdcInsn(module.version.value);
        mv.visitMethodInsn(183, "io/ballerina/runtime/api/Module", "<init>", String.format("(L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String"), false);
        mv.visitFieldInsn(179, moduleInitClass, "$moduleName", String.format("L%s;", "io/ballerina/runtime/api/Module"));
    }

    static String computeLockNameFromString(String varName) {
        return "$lock" + varName;
    }

    public static String cleanupPackageName(String pkgName) {
        int index = pkgName.lastIndexOf("/");
        if (index > 0) {
            return pkgName.substring(0, index);
        }
        return pkgName;
    }

    public static BIRFunctionWrapper getFunctionWrapper(BIRNode.BIRFunction currentFunc, String orgName, String moduleName, String version, String moduleClass) {
        BInvokableType functionTypeDesc = currentFunc.type;
        BIRNode.BIRVariableDcl receiver = currentFunc.receiver;
        BType retType = functionTypeDesc.retType;
        if (JvmCodeGenUtil.isExternFunc(currentFunc) && Symbols.isFlagOn(retType.flags, 0x4000000L)) {
            retType = typeBuilder.build(retType);
        }
        String jvmMethodDescription = receiver == null ? JvmCodeGenUtil.getMethodDesc(functionTypeDesc.paramTypes, retType) : JvmCodeGenUtil.getMethodDesc(functionTypeDesc.paramTypes, retType, receiver.type);
        return new BIRFunctionWrapper(orgName, moduleName, version, currentFunc, moduleClass, jvmMethodDescription);
    }

    private static BIRNode.BIRFunction findFunction(BIRNode parentNode, String funcName) {
        BIRNode.BIRFunction func;
        if (parentNode instanceof BIRNode.BIRTypeDefinition) {
            BIRNode.BIRTypeDefinition typeDef = (BIRNode.BIRTypeDefinition)parentNode;
            func = JvmPackageGen.findFunction(typeDef.attachedFuncs, funcName);
        } else if (parentNode instanceof BIRNode.BIRPackage) {
            BIRNode.BIRPackage pkg = (BIRNode.BIRPackage)parentNode;
            func = JvmPackageGen.findFunction(pkg.functions, funcName);
        } else {
            throw new IllegalStateException();
        }
        return func;
    }

    private static BIRNode.BIRFunction findFunction(List<BIRNode.BIRFunction> functions, String funcName) {
        for (BIRNode.BIRFunction func : functions) {
            if (!func.name.value.equals(funcName)) continue;
            return func;
        }
        throw new IllegalStateException("cannot find function: '" + funcName + "'");
    }

    private BIRNode.BIRFunction getMainFunc(List<BIRNode.BIRFunction> funcs) {
        BIRNode.BIRFunction userMainFunc = null;
        for (BIRNode.BIRFunction func : funcs) {
            if (func == null || !func.name.value.equals("main")) continue;
            userMainFunc = func;
            break;
        }
        return userMainFunc;
    }

    CompiledJarFile generate(BIRNode.BIRPackage module, InteropValidator interopValidator, boolean isEntry) {
        LinkedHashSet<PackageID> moduleImports = new LinkedHashSet<PackageID>();
        JvmPackageGen.addBuiltinImports(module, moduleImports);
        for (BIRNode.BIRImportModule importModule : module.importModules) {
            BPackageSymbol pkgSymbol = this.packageCache.getSymbol(JvmPackageGen.getBvmAlias(importModule.org.value, importModule.name.value));
            this.generateDependencyList(pkgSymbol, interopValidator);
            if (this.dlog.errorCount() <= 0) continue;
            return new CompiledJarFile(Collections.emptyMap());
        }
        String moduleInitClass = JvmCodeGenUtil.getModuleLevelClassName(module.org.value, module.name.value, module.version.value, "$_init");
        Map<String, JavaClass> jvmClassMapping = this.generateClassNameLinking(module, moduleInitClass, interopValidator, isEntry);
        if (!isEntry || this.dlog.errorCount() > 0) {
            return new CompiledJarFile(Collections.emptyMap());
        }
        ConcurrentHashMap<String, byte[]> jarEntries = new ConcurrentHashMap<String, byte[]>();
        ExternalMethodGen.injectDefaultParamInits(module, this.initMethodGen, this);
        JvmValueGen.injectDefaultParamInitsToAttachedFuncs(module, this.initMethodGen, this);
        List<PackageID> flattenedModuleImports = this.flattenModuleImports(moduleImports);
        this.initMethodGen.enrichPkgWithInitializers(jvmClassMapping, moduleInitClass, module, flattenedModuleImports);
        this.configMethodGen.generateConfigInit(flattenedModuleImports, module, moduleInitClass, jarEntries);
        new ShutDownListenerGen().generateShutdownSignalListener(moduleInitClass, jarEntries);
        JvmDesugarPhase.rewriteRecordInits(module.typeDefs);
        JvmValueGen valueGen = new JvmValueGen(module, this, this.methodGen, this.lambdaGen);
        valueGen.generateValueClasses(jarEntries);
        this.frameClassGen.generateFrameClasses(module, jarEntries);
        this.generateModuleClasses(module, jarEntries, moduleInitClass, jvmClassMapping, flattenedModuleImports);
        this.clearPackageGenInfo();
        return new CompiledJarFile(JvmCodeGenUtil.getModuleLevelClassName(module.org.value, module.name.value, module.version.value, "$_init", "."), jarEntries);
    }

    private void generateModuleClasses(BIRNode.BIRPackage module, Map<String, byte[]> jarEntries, String moduleInitClass, Map<String, JavaClass> jvmClassMapping, List<PackageID> moduleImports) {
        jvmClassMapping.entrySet().parallelStream().forEach(entry -> {
            String moduleClass = (String)entry.getKey();
            JavaClass javaClass = (JavaClass)entry.getValue();
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            AsyncDataCollector asyncDataCollector = new AsyncDataCollector(moduleClass);
            boolean serviceEPAvailable = false;
            boolean isInitClass = Objects.equals(moduleClass, moduleInitClass);
            if (isInitClass) {
                cw.visit(52, 33, moduleClass, null, "io/ballerina/runtime/internal/values/ValueCreator", null);
                JvmCodeGenUtil.generateDefaultConstructor(cw, "io/ballerina/runtime/internal/values/ValueCreator");
                JvmTypeGen.generateUserDefinedTypeFields(cw, module.typeDefs);
                JvmTypeGen.generateValueCreatorMethods(cw, module.typeDefs, module, moduleInitClass, this.symbolTable, asyncDataCollector);
                for (BIRNode.BIRGlobalVariableDcl bIRGlobalVariableDcl : module.globalVars) {
                    if (bIRGlobalVariableDcl == null) continue;
                    JvmPackageGen.generatePackageVariable(bIRGlobalVariableDcl, cw);
                }
                BIRNode.BIRFunction mainFunc = this.getMainFunc(module.functions);
                String string = "";
                if (mainFunc != null) {
                    String string2 = JvmCodeGenUtil.getModuleLevelClassName(module, JvmCodeGenUtil.cleanupPathSeparators(mainFunc.pos.lineRange().filePath()));
                }
                serviceEPAvailable = this.listenerDeclarationFound(module.globalVars) || this.isServiceDefAvailable(module.typeDefs);
                MainMethodGen mainMethodGen = new MainMethodGen(this.symbolTable);
                mainMethodGen.generateMainMethod(mainFunc, cw, module, moduleClass, serviceEPAvailable, asyncDataCollector);
                if (mainFunc != null) {
                    void var13_16;
                    mainMethodGen.generateLambdaForMain(mainFunc, cw, (String)var13_16);
                }
                this.initMethodGen.generateLambdaForPackageInits(cw, module, moduleClass, moduleImports);
                JvmPackageGen.generateLockForVariable(cw);
                JvmTypeGen.generateCreateTypesMethod(cw, module.typeDefs, moduleInitClass, this.symbolTable);
                this.initMethodGen.generateModuleInitializer(cw, module, moduleInitClass);
                new ModuleStopMethodGen(this.symbolTable).generateExecutionStopMethod(cw, moduleInitClass, module, moduleImports, asyncDataCollector);
            } else {
                cw.visit(52, 33, moduleClass, null, "java/lang/Object", null);
                JvmCodeGenUtil.generateDefaultConstructor(cw, "java/lang/Object");
            }
            cw.visitSource(javaClass.sourceFileName, null);
            for (BIRNode.BIRFunction bIRFunction : javaClass.functions) {
                this.methodGen.generateMethod(bIRFunction, cw, module, null, moduleClass, asyncDataCollector);
            }
            for (Map.Entry entry2 : asyncDataCollector.getLambdas().entrySet()) {
                String name = (String)entry2.getKey();
                BIRInstruction call = (BIRInstruction)entry2.getValue();
                this.lambdaGen.generateLambdaMethod(call, cw, name);
            }
            JvmCodeGenUtil.visitStrandMetadataField((ClassWriter)cw, asyncDataCollector);
            JvmPackageGen.generateStaticInitializer(cw, moduleClass, module, isInitClass, serviceEPAvailable, asyncDataCollector);
            cw.visitEnd();
            byte[] bytes = this.getBytes(cw, module);
            jarEntries.put(moduleClass + ".class", bytes);
        });
    }

    private boolean listenerDeclarationFound(List<BIRNode.BIRGlobalVariableDcl> variableDcls) {
        for (BIRNode.BIRGlobalVariableDcl globalVariableDcl : variableDcls) {
            if (!Symbols.isFlagOn(globalVariableDcl.flags, 524288L)) continue;
            return true;
        }
        return false;
    }

    private boolean isServiceDefAvailable(List<BIRNode.BIRTypeDefinition> typeDefs) {
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BType bType = optionalTypeDef.type;
            if (!(bType instanceof BServiceType)) continue;
            return true;
        }
        return false;
    }

    private List<PackageID> flattenModuleImports(Set<PackageID> dependentModuleArray) {
        for (Map.Entry<String, PackageID> entry : this.dependentModules.entrySet()) {
            PackageID id = entry.getValue();
            dependentModuleArray.add(id);
        }
        return new ArrayList<PackageID>(dependentModuleArray);
    }

    private Map<String, JavaClass> generateClassNameLinking(BIRNode.BIRPackage module, String initClass, InteropValidator interopValidator, boolean isEntry) {
        String orgName = module.org.value;
        String moduleName = module.name.value;
        String version = module.version.value;
        HashMap<String, JavaClass> jvmClassMap = new HashMap<String, JavaClass>();
        String pkgName = JvmCodeGenUtil.getPackageName(module);
        this.linkGlobalVars(module, pkgName, initClass, isEntry);
        this.linkModuleFunctions(module, pkgName, initClass, interopValidator, isEntry, orgName, moduleName, version, jvmClassMap);
        this.linkModuleInitFunction(pkgName, initClass, orgName, moduleName, version);
        this.linkModuleStopFunction(pkgName, initClass, orgName, moduleName, version);
        this.linkTypeDefinitions(module, pkgName, interopValidator, isEntry, orgName, moduleName, version);
        return jvmClassMap;
    }

    private void linkGlobalVars(BIRNode.BIRPackage module, String pkgName, String initClass, boolean isEntry) {
        if (isEntry) {
            for (BIRNode.BIRConstant constant : module.constants) {
                module.globalVars.add(new BIRNode.BIRGlobalVariableDcl(constant.pos, constant.flags, constant.type, null, constant.name, VarScope.GLOBAL, VarKind.CONSTANT, "", constant.origin));
            }
        }
        for (BIRNode.BIRGlobalVariableDcl globalVar : module.globalVars) {
            if (globalVar == null) continue;
            this.globalVarClassMap.put(pkgName + globalVar.name.value, initClass);
        }
        this.globalVarClassMap.put(pkgName + "$LOCK_STORE", initClass);
    }

    private void linkTypeDefinitions(BIRNode.BIRPackage module, String pkgName, InteropValidator interopValidator, boolean isEntry, String orgName, String moduleName, String version) {
        List<BIRNode.BIRTypeDefinition> typeDefs = module.typeDefs;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BType bType = optionalTypeDef.type;
            if ((bType.tag != 33 || !Symbols.isFlagOn(bType.tsymbol.flags, 0x10000000L)) && !(bType instanceof BServiceType)) continue;
            List<BIRNode.BIRFunction> attachedFuncs = optionalTypeDef.attachedFuncs;
            String typeName = JvmCodeGenUtil.toNameString(bType);
            for (BIRNode.BIRFunction func : attachedFuncs) {
                String functionName = func.name.value;
                String lookupKey = typeName + "." + functionName;
                String className = JvmValueGen.getTypeValueClassName(module, typeName);
                try {
                    BIRFunctionWrapper birFuncWrapperOrError = this.getBirFunctionWrapper(interopValidator, isEntry, orgName, moduleName, version, func, className, lookupKey);
                    this.birFunctionMap.put(pkgName + lookupKey, birFuncWrapperOrError);
                }
                catch (JInteropException e) {
                    this.dlog.error(func.pos, e.getCode(), e.getMessage());
                }
            }
        }
    }

    private void linkModuleStopFunction(String pkgName, String initClass, String orgName, String moduleName, String version) {
        BInvokableType funcType = new BInvokableType(Collections.emptyList(), null, new BNilType(), null);
        BIRNode.BIRFunction moduleStopFunction = new BIRNode.BIRFunction(null, new Name("$moduleStop"), 0L, funcType, new Name(""), 0, null, SymbolOrigin.VIRTUAL);
        this.birFunctionMap.put(pkgName + "$moduleStop", JvmPackageGen.getFunctionWrapper(moduleStopFunction, orgName, moduleName, version, initClass));
    }

    private void linkModuleInitFunction(String pkgName, String initClass, String orgName, String moduleName, String version) {
        BInvokableType funcType = new BInvokableType(Collections.emptyList(), null, new BNilType(), null);
        BIRNode.BIRFunction moduleInitFunction = new BIRNode.BIRFunction(null, new Name("$currentModuleInit"), 0L, funcType, new Name(""), 0, null, SymbolOrigin.VIRTUAL);
        this.birFunctionMap.put(pkgName + "$currentModuleInit", JvmPackageGen.getFunctionWrapper(moduleInitFunction, orgName, moduleName, version, initClass));
    }

    private void linkModuleFunctions(BIRNode.BIRPackage module, String pkgName, String initClass, InteropValidator interopValidator, boolean isEntry, String orgName, String moduleName, String version, Map<String, JavaClass> jvmClassMap) {
        List<BIRNode.BIRFunction> functions = module.functions;
        if (functions.size() <= 0) {
            return;
        }
        int funcSize = functions.size();
        int count = 0;
        BIRNode.BIRFunction initFunc = functions.get(0);
        String functionName = initFunc.name.value;
        JavaClass klass = new JavaClass(initFunc.pos.lineRange().filePath());
        klass.functions.add(0, initFunc);
        this.initMethodGen.addInitAndTypeInitInstructions(module, initFunc);
        jvmClassMap.put(initClass, klass);
        this.birFunctionMap.put(pkgName + functionName, JvmPackageGen.getFunctionWrapper(initFunc, orgName, moduleName, version, initClass));
        ++count;
        BIRNode.BIRFunction startFunc = functions.get(1);
        functionName = startFunc.name.value;
        this.birFunctionMap.put(pkgName + functionName, JvmPackageGen.getFunctionWrapper(startFunc, orgName, moduleName, version, initClass));
        klass.functions.add(1, startFunc);
        ++count;
        BIRNode.BIRFunction stopFunc = functions.get(2);
        functionName = stopFunc.name.value;
        this.birFunctionMap.put(pkgName + functionName, JvmPackageGen.getFunctionWrapper(stopFunc, orgName, moduleName, version, initClass));
        klass.functions.add(2, stopFunc);
        ++count;
        while (count < funcSize) {
            BIRNode.BIRFunction birFunc = functions.get(count);
            ++count;
            String birFuncName = birFunc.name.value;
            String balFileName = birFunc.pos == null ? "$_init" : birFunc.pos.lineRange().filePath();
            String birModuleClassName = JvmCodeGenUtil.getModuleLevelClassName(orgName, moduleName, version, JvmCodeGenUtil.cleanupPathSeparators(balFileName));
            if (!JvmCodeGenUtil.isBallerinaBuiltinModule(orgName, moduleName)) {
                JavaClass javaClass = jvmClassMap.get(birModuleClassName);
                if (javaClass != null) {
                    javaClass.functions.add(birFunc);
                } else {
                    klass = new JavaClass(balFileName);
                    klass.functions.add(0, birFunc);
                    jvmClassMap.put(birModuleClassName, klass);
                }
            }
            interopValidator.setEntryModuleValidation(isEntry);
            try {
                BIRFunctionWrapper birFuncWrapperOrError = this.getBirFunctionWrapper(interopValidator, isEntry, orgName, moduleName, version, birFunc, birModuleClassName, birFuncName);
                this.birFunctionMap.put(pkgName + birFuncName, birFuncWrapperOrError);
            }
            catch (JInteropException e) {
                this.dlog.error(birFunc.pos, e.getCode(), e.getMessage());
            }
        }
    }

    private BIRFunctionWrapper getBirFunctionWrapper(InteropValidator interopValidator, boolean isEntry, String orgName, String moduleName, String version, BIRNode.BIRFunction birFunc, String birModuleClassName, String lookupKey) {
        BIRFunctionWrapper birFuncWrapperOrError;
        if (JvmCodeGenUtil.isExternFunc(birFunc) && isEntry) {
            birFuncWrapperOrError = ExternalMethodGen.createExternalFunctionWrapper(interopValidator, birFunc, orgName, moduleName, version, birModuleClassName, lookupKey, this);
        } else {
            if (isEntry && birFunc.receiver == null) {
                JvmDesugarPhase.addDefaultableBooleanVarsToSignature(birFunc, this.symbolTable.booleanType);
            }
            birFuncWrapperOrError = JvmPackageGen.getFunctionWrapper(birFunc, orgName, moduleName, version, birModuleClassName);
        }
        return birFuncWrapperOrError;
    }

    public String lookupExternClassName(String pkgName, String functionName) {
        return this.externClassMap.get(pkgName + "/" + functionName);
    }

    public byte[] getBytes(ClassWriter cw, BIRNode node) {
        byte[] result;
        try {
            return cw.toByteArray();
        }
        catch (MethodTooLargeException e) {
            String funcName = e.getMethodName();
            BIRNode.BIRFunction func = JvmPackageGen.findFunction(node, funcName);
            this.dlog.error(func.pos, DiagnosticErrorCode.METHOD_TOO_LARGE, IdentifierUtils.decodeIdentifier(func.name.value));
            result = new byte[]{};
        }
        catch (ClassTooLargeException e) {
            this.dlog.error(node.pos, DiagnosticErrorCode.FILE_TOO_LARGE, IdentifierUtils.decodeIdentifier(e.getClassName()));
            result = new byte[]{};
        }
        catch (Exception e) {
            throw new BLangCompilerException(e.getMessage(), e);
        }
        return result;
    }

    private void clearPackageGenInfo() {
        this.birFunctionMap.clear();
        this.globalVarClassMap.clear();
        this.externClassMap.clear();
        this.dependentModules.clear();
    }

    public BIRFunctionWrapper lookupBIRFunctionWrapper(String lookupKey) {
        return this.birFunctionMap.get(lookupKey);
    }

    void addExternClassMapping(String key, String value) {
        this.externClassMap.put(key, value);
    }

    BType lookupTypeDef(BIRNonTerminator.NewInstance objectNewIns) {
        if (!objectNewIns.isExternalDef) {
            return objectNewIns.def.type;
        }
        PackageID id = objectNewIns.externalPackageId;
        assert (id != null);
        BPackageSymbol symbol = this.packageCache.getSymbol(id.orgName + "/" + id.name);
        if (symbol != null) {
            Name lookupKey = new Name(IdentifierUtils.decodeIdentifier(objectNewIns.objectName));
            BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)symbol.scope.lookup((Name)lookupKey).symbol;
            if (objectTypeSymbol != null) {
                return objectTypeSymbol.type;
            }
        }
        throw new BLangCompilerException("Reference to unknown type " + objectNewIns.externalPackageId + "/" + objectNewIns.objectName);
    }

    public String lookupGlobalVarClassName(String pkgName, String varName) {
        String key = pkgName + varName;
        if (!this.globalVarClassMap.containsKey(key)) {
            return pkgName + "$_init";
        }
        return this.globalVarClassMap.get(key);
    }

    private void generateDependencyList(BPackageSymbol packageSymbol, InteropValidator interopValidator) {
        if (packageSymbol.bir != null) {
            this.generate(packageSymbol.bir, interopValidator, false);
        } else {
            for (BPackageSymbol importPkgSymbol : packageSymbol.imports) {
                if (importPkgSymbol == null) continue;
                this.generateDependencyList(importPkgSymbol, interopValidator);
            }
        }
        PackageID moduleId = packageSymbol.pkgID;
        String pkgName = JvmCodeGenUtil.getPackageName(moduleId.orgName, moduleId.name, moduleId.version);
        if (!this.dependentModules.containsKey(pkgName)) {
            this.dependentModules.put(pkgName, moduleId);
        }
    }
}

