/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.runtime.internal.IdentifierUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.ScheduleFunctionInfo;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.semantics.model.types.NamedNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.TypeFlags;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.util.ResolvedTypeBuilder;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmTypeGen {
    private static ResolvedTypeBuilder typeBuilder = new ResolvedTypeBuilder();

    static void generateUserDefinedTypeFields(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs) {
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            String fieldName = JvmTypeGen.getTypeFieldName(optionalTypeDef.name.value);
            BType bType = optionalTypeDef.type;
            if (bType.tag != 12 && bType.tag != 28 && bType.tag != 33) continue;
            FieldVisitor fv = cw.visitField(9, fieldName, String.format("L%s;", "io/ballerina/runtime/api/types/Type"), null, null);
            fv.visitEnd();
        }
    }

    static void generateCreateTypesMethod(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, String typeOwnerClass, SymbolTable symbolTable) {
        JvmTypeGen.createTypesInstance(cw, typeDefs, typeOwnerClass);
        List<String> populateTypeFuncNames = JvmTypeGen.populateTypes(cw, typeDefs, typeOwnerClass, symbolTable);
        MethodVisitor mv = cw.visitMethod(9, "$createTypes", "()V", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, typeOwnerClass, "$createTypeInstances", "()V", false);
        for (String funcName : populateTypeFuncNames) {
            mv.visitMethodInsn(184, typeOwnerClass, funcName, "()V", false);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createTypesInstance(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, String typeOwnerClass) {
        MethodVisitor mv = cw.visitMethod(9, "$createTypeInstances", "()V", null, null);
        mv.visitCode();
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            String fieldName = JvmTypeGen.getTypeFieldName(optionalTypeDef.name.value);
            BType bType = optionalTypeDef.type;
            if (bType.tag == 12) {
                JvmTypeGen.createRecordType(mv, (BRecordType)bType);
            } else if (bType.tag == 33) {
                if (bType instanceof BServiceType) {
                    JvmTypeGen.createServiceType(mv, (BServiceType)bType);
                } else {
                    JvmTypeGen.createObjectType(mv, (BObjectType)bType);
                }
            } else {
                if (bType.tag != 28) continue;
                JvmTypeGen.createErrorType(mv, (BErrorType)bType, bType.tsymbol.name.value);
            }
            mv.visitFieldInsn(179, typeOwnerClass, fieldName, String.format("L%s;", "io/ballerina/runtime/api/types/Type"));
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static List<String> populateTypes(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, String typeOwnerClass, SymbolTable symbolTable) {
        ArrayList<String> funcNames = new ArrayList<String>();
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BType bType = optionalTypeDef.type;
            if (bType.tag != 12 && bType.tag != 33 && bType.tag != 28) continue;
            String fieldName = JvmTypeGen.getTypeFieldName(optionalTypeDef.name.value);
            String methodName = String.format("$populate%s", fieldName);
            funcNames.add(methodName);
            MethodVisitor mv = cw.visitMethod(9, methodName, "()V", null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, typeOwnerClass, fieldName, String.format("L%s;", "io/ballerina/runtime/api/types/Type"));
            BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
            switch (bType.tag) {
                case 12: {
                    BRecordType recordType = (BRecordType)bType;
                    mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BRecordType");
                    mv.visitInsn(89);
                    mv.visitInsn(89);
                    JvmTypeGen.addRecordFields(mv, recordType.fields);
                    JvmTypeGen.addRecordRestField(mv, recordType.restFieldType);
                    JvmTypeGen.addImmutableType(mv, recordType);
                    break;
                }
                case 33: {
                    if (bType instanceof BServiceType) {
                        BServiceType serviceType = (BServiceType)bType;
                        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
                        mv.visitInsn(89);
                        JvmTypeGen.addObjectFields(mv, serviceType.fields);
                        JvmTypeGen.addObjectAttachedFunctions(mv, ((BObjectTypeSymbol)serviceType.tsymbol).attachedFuncs, serviceType, indexMap, symbolTable);
                    } else {
                        BObjectType objectType = (BObjectType)bType;
                        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
                        mv.visitInsn(89);
                        mv.visitInsn(89);
                        JvmTypeGen.addObjectFields(mv, objectType.fields);
                        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)objectType.tsymbol;
                        JvmTypeGen.addObjectInitFunction(mv, objectTypeSymbol.generatedInitializerFunc, objectType, indexMap, "$init$", "setGeneratedInitializer", symbolTable);
                        JvmTypeGen.addObjectInitFunction(mv, objectTypeSymbol.initializerFunc, objectType, indexMap, "init", "setInitializer", symbolTable);
                        JvmTypeGen.addObjectAttachedFunctions(mv, objectTypeSymbol.attachedFuncs, objectType, indexMap, symbolTable);
                        JvmTypeGen.addImmutableType(mv, objectType);
                    }
                    BTypeIdSet objTypeIdSet = ((BObjectType)bType).typeIdSet;
                    if (objTypeIdSet.isEmpty()) break;
                    mv.visitInsn(89);
                    JvmTypeGen.loadTypeIdSet(mv, objTypeIdSet);
                    mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setTypeIdSet", String.format("(L%s;)V", "io/ballerina/runtime/internal/types/BTypeIdSet"), false);
                    break;
                }
                case 28: {
                    mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BErrorType");
                    mv.visitInsn(89);
                    mv.visitInsn(89);
                    JvmTypeGen.loadType(mv, ((BErrorType)bType).detailType);
                    mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BErrorType", "setDetailType", String.format("(L%s;)V", "io/ballerina/runtime/api/types/Type"), false);
                    BTypeIdSet typeIdSet = ((BErrorType)bType).typeIdSet;
                    if (typeIdSet.isEmpty()) break;
                    mv.visitInsn(89);
                    JvmTypeGen.loadTypeIdSet(mv, typeIdSet);
                    mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BErrorType", "setTypeIdSet", String.format("(L%s;)V", "io/ballerina/runtime/internal/types/BTypeIdSet"), false);
                }
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        return funcNames;
    }

    private static void addImmutableType(MethodVisitor mv, BStructureType structureType) {
        BIntersectionType immutableType = ((SelectivelyImmutableReferenceType)((Object)structureType)).getImmutableType();
        if (immutableType == null) {
            return;
        }
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, immutableType);
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/types/Type", "setImmutableType", String.format("(L%s;)V", "io/ballerina/runtime/api/types/IntersectionType"), true);
    }

    private static void loadTypeIdSet(MethodVisitor mv, BTypeIdSet typeIdSet) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTypeIdSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTypeIdSet", "<init>", "()V", false);
        for (BTypeIdSet.BTypeId typeId : typeIdSet.primary) {
            JvmTypeGen.addTypeId(mv, typeId, true);
        }
        for (BTypeIdSet.BTypeId typeId : typeIdSet.secondary) {
            JvmTypeGen.addTypeId(mv, typeId, false);
        }
    }

    private static void addTypeId(MethodVisitor mv, BTypeIdSet.BTypeId typeId, boolean isPrimaryTypeId) {
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "io/ballerina/runtime/api/Module");
        mv.visitInsn(89);
        mv.visitLdcInsn(typeId.packageID.orgName.value);
        mv.visitLdcInsn(typeId.packageID.name.value);
        mv.visitLdcInsn(typeId.packageID.version.value);
        mv.visitMethodInsn(183, "io/ballerina/runtime/api/Module", "<init>", String.format("(L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String"), false);
        mv.visitLdcInsn(typeId.name);
        mv.visitInsn(isPrimaryTypeId ? 4 : 3);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BTypeIdSet", "add", String.format("(L%s;L%s;Z)V", "io/ballerina/runtime/api/Module", "java/lang/String"), false);
    }

    static List<Label> createLabelsForSwitch(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, Label defaultCaseLabel) {
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(182, "java/lang/String", "hashCode", "()I", false);
        int i = 0;
        ArrayList<Label> labels = new ArrayList<Label>();
        int[] hashCodes = new int[nodes.size()];
        for (NamedNode namedNode : nodes) {
            if (namedNode == null) continue;
            labels.add(i, new Label());
            String name = namedNode.getName().value;
            hashCodes[i] = name.hashCode();
            ++i;
        }
        mv.visitLookupSwitchInsn(defaultCaseLabel, hashCodes, labels.toArray(new Label[0]));
        return labels;
    }

    static List<Label> createLabelsForEqualCheck(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, List<Label> labels, Label defaultCaseLabel) {
        ArrayList<Label> targetLabels = new ArrayList<Label>();
        int i = 0;
        for (NamedNode namedNode : nodes) {
            if (namedNode == null) continue;
            mv.visitLabel(labels.get(i));
            mv.visitVarInsn(25, nameRegIndex);
            mv.visitLdcInsn(namedNode.getName().value);
            mv.visitMethodInsn(182, "java/lang/String", "equals", String.format("(L%s;)Z", "java/lang/Object"), false);
            Label targetLabel = new Label();
            mv.visitJumpInsn(154, targetLabel);
            mv.visitJumpInsn(167, defaultCaseLabel);
            targetLabels.add(i, targetLabel);
            ++i;
        }
        return targetLabels;
    }

    static void generateValueCreatorMethods(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, BIRNode.BIRPackage moduleId, String typeOwnerClass, SymbolTable symbolTable, AsyncDataCollector asyncDataCollector) {
        BType bType;
        ArrayList<BIRNode.BIRTypeDefinition> recordTypeDefs = new ArrayList<BIRNode.BIRTypeDefinition>();
        ArrayList<BIRNode.BIRTypeDefinition> objectTypeDefs = new ArrayList<BIRNode.BIRTypeDefinition>();
        int i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            bType = optionalTypeDef.type;
            if (bType.tag != 12) continue;
            recordTypeDefs.add(i, optionalTypeDef);
            ++i;
        }
        i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            bType = optionalTypeDef.type;
            if (bType.tag != 33 || !Symbols.isFlagOn(bType.tsymbol.flags, 0x10000000L)) continue;
            objectTypeDefs.add(i, optionalTypeDef);
            ++i;
        }
        JvmTypeGen.generateRecordValueCreateMethod(cw, recordTypeDefs, moduleId, typeOwnerClass, asyncDataCollector);
        JvmTypeGen.generateObjectValueCreateMethod(cw, objectTypeDefs, moduleId, typeOwnerClass, symbolTable, asyncDataCollector);
    }

    private static void generateRecordValueCreateMethod(ClassWriter cw, List<BIRNode.BIRTypeDefinition> recordTypeDefs, BIRNode.BIRPackage moduleId, String typeOwnerClass, AsyncDataCollector asyncDataCollector) {
        MethodVisitor mv = cw.visitMethod(1, "createRecordValue", String.format("(L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/internal/values/MapValue"), String.format("(L%s;)L%s<L%s;L%s;>;", "java/lang/String", "io/ballerina/runtime/internal/values/MapValue", "java/lang/String", "java/lang/Object"), null);
        mv.visitCode();
        int fieldNameRegIndex = 1;
        Label defaultCaseLabel = new Label();
        recordTypeDefs.sort(JvmValueGen.NAME_HASH_COMPARATOR);
        List<Label> labels = JvmTypeGen.createLabelsForSwitch(mv, fieldNameRegIndex, recordTypeDefs, defaultCaseLabel);
        List<Label> targetLabels = JvmTypeGen.createLabelsForEqualCheck(mv, fieldNameRegIndex, recordTypeDefs, labels, defaultCaseLabel);
        int i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : recordTypeDefs) {
            String fieldName = JvmTypeGen.getTypeFieldName(optionalTypeDef.name.value);
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitVarInsn(25, 0);
            String className = JvmValueGen.getTypeValueClassName(moduleId, optionalTypeDef.name.value);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitFieldInsn(178, typeOwnerClass, fieldName, String.format("L%s;", "io/ballerina/runtime/api/types/Type"));
            mv.visitMethodInsn(183, className, "<init>", String.format("(L%s;)V", "io/ballerina/runtime/api/types/Type"), false);
            mv.visitInsn(89);
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/scheduling/Strand");
            mv.visitInsn(89);
            mv.visitInsn(1);
            String metaDataVarName = JvmCodeGenUtil.getStrandMetadataVarName("createRecordValue");
            asyncDataCollector.getStrandMetadata().putIfAbsent(metaDataVarName, new ScheduleFunctionInfo("createRecordValue"));
            mv.visitFieldInsn(178, typeOwnerClass, metaDataVarName, String.format("L%s;", "io/ballerina/runtime/api/async/StrandMetadata"));
            mv.visitInsn(1);
            mv.visitInsn(1);
            mv.visitInsn(1);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/scheduling/Strand", "<init>", String.format("(L%s;L%s;L%s;L%s;L%s;)V", "java/lang/String", "io/ballerina/runtime/api/async/StrandMetadata", "io/ballerina/runtime/internal/scheduling/Scheduler", "io/ballerina/runtime/internal/scheduling/Strand", "java/util/Map"), false);
            mv.visitInsn(95);
            mv.visitMethodInsn(184, className, "$init", String.format("(L%s;L%s;)V", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/internal/values/MapValue"), false);
            mv.visitInsn(176);
            ++i;
        }
        JvmValueGen.createDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
        mv.visitMaxs(recordTypeDefs.size() + 10, recordTypeDefs.size() + 10);
        mv.visitEnd();
    }

    private static void generateObjectValueCreateMethod(ClassWriter cw, List<BIRNode.BIRTypeDefinition> objectTypeDefs, BIRNode.BIRPackage moduleId, String typeOwnerClass, SymbolTable symbolTable, AsyncDataCollector asyncDataCollector) {
        MethodVisitor mv = cw.visitMethod(1, "createObjectValue", String.format("(L%s;L%s;L%s;L%s;[L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/internal/scheduling/Scheduler", "io/ballerina/runtime/internal/scheduling/Strand", "java/util/Map", "java/lang/Object", "io/ballerina/runtime/api/values/BObject"), null, null);
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        indexMap.addIfNotExists("self", symbolTable.anyType);
        int var1Index = indexMap.addIfNotExists("var1", symbolTable.stringType);
        int schedulerIndex = indexMap.addIfNotExists("scheduler", symbolTable.anyType);
        int parentIndex = indexMap.addIfNotExists("parent", symbolTable.anyType);
        int propertiesIndex = indexMap.addIfNotExists("properties", symbolTable.anyType);
        int argsIndex = indexMap.addIfNotExists("args", symbolTable.anyType);
        mv.visitCode();
        Label defaultCaseLabel = new Label();
        objectTypeDefs.sort(JvmValueGen.NAME_HASH_COMPARATOR);
        List<Label> labels = JvmTypeGen.createLabelsForSwitch(mv, var1Index, objectTypeDefs, defaultCaseLabel);
        List<Label> targetLabels = JvmTypeGen.createLabelsForEqualCheck(mv, var1Index, objectTypeDefs, labels, defaultCaseLabel);
        int i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : objectTypeDefs) {
            String fieldName = JvmTypeGen.getTypeFieldName(optionalTypeDef.name.value);
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitVarInsn(25, 0);
            String className = JvmValueGen.getTypeValueClassName(moduleId, optionalTypeDef.name.value);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitFieldInsn(178, typeOwnerClass, fieldName, String.format("L%s;", "io/ballerina/runtime/api/types/Type"));
            mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
            mv.visitMethodInsn(183, className, "<init>", String.format("(L%s;)V", "io/ballerina/runtime/internal/types/BObjectType"), false);
            int tempVarIndex = indexMap.addIfNotExists("tempVar", optionalTypeDef.type);
            mv.visitVarInsn(58, tempVarIndex);
            int strandVarIndex = indexMap.addIfNotExists("strandVar", symbolTable.anyType);
            mv.visitVarInsn(25, parentIndex);
            Label parentNonNullLabel = new Label();
            mv.visitJumpInsn(199, parentNonNullLabel);
            Label parentNullLabel = new Label();
            mv.visitLabel(parentNullLabel);
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/scheduling/Strand");
            mv.visitInsn(89);
            mv.visitInsn(1);
            String metaDataVarName = JvmCodeGenUtil.getStrandMetadataVarName("createObjectValue");
            asyncDataCollector.getStrandMetadata().putIfAbsent(metaDataVarName, new ScheduleFunctionInfo("createObjectValue"));
            mv.visitFieldInsn(178, typeOwnerClass, metaDataVarName, String.format("L%s;", "io/ballerina/runtime/api/async/StrandMetadata"));
            mv.visitVarInsn(25, schedulerIndex);
            mv.visitVarInsn(25, parentIndex);
            mv.visitVarInsn(25, propertiesIndex);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/scheduling/Strand", "<init>", String.format("(L%s;L%s;L%s;L%s;L%s;)V", "java/lang/String", "io/ballerina/runtime/api/async/StrandMetadata", "io/ballerina/runtime/internal/scheduling/Scheduler", "io/ballerina/runtime/internal/scheduling/Strand", "java/util/Map"), false);
            mv.visitVarInsn(58, strandVarIndex);
            Label endConditionLabel = new Label();
            mv.visitJumpInsn(167, endConditionLabel);
            mv.visitLabel(parentNonNullLabel);
            mv.visitVarInsn(25, parentIndex);
            mv.visitVarInsn(58, strandVarIndex);
            mv.visitLabel(endConditionLabel);
            mv.visitVarInsn(25, tempVarIndex);
            mv.visitVarInsn(25, strandVarIndex);
            mv.visitLdcInsn("$init$");
            mv.visitVarInsn(25, argsIndex);
            String methodDesc = String.format("(L%s;L%s;[L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "java/lang/String", "java/lang/Object", "java/lang/Object");
            mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BObject", "call", methodDesc, true);
            int tempResultIndex = indexMap.addIfNotExists("tempResult", symbolTable.anyType);
            mv.visitVarInsn(58, tempResultIndex);
            mv.visitVarInsn(25, tempResultIndex);
            mv.visitTypeInsn(193, "io/ballerina/runtime/api/values/BError");
            Label noErrorLabel = new Label();
            mv.visitJumpInsn(153, noErrorLabel);
            mv.visitVarInsn(25, tempResultIndex);
            mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BError");
            mv.visitInsn(191);
            mv.visitLabel(noErrorLabel);
            mv.visitVarInsn(25, tempVarIndex);
            mv.visitInsn(176);
            ++i;
        }
        JvmValueGen.createDefaultCase(mv, defaultCaseLabel, var1Index);
        mv.visitMaxs(objectTypeDefs.size() + 100, objectTypeDefs.size() + 100);
        mv.visitEnd();
    }

    private static void createRecordType(MethodVisitor mv, BRecordType recordType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BRecordType");
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = recordType.tsymbol;
        String name = typeSymbol.name.getValue();
        mv.visitLdcInsn(name);
        mv.visitTypeInsn(187, "io/ballerina/runtime/api/Module");
        mv.visitInsn(89);
        PackageID packageID = recordType.tsymbol.pkgID;
        mv.visitLdcInsn(packageID.orgName.value);
        mv.visitLdcInsn(packageID.name.value);
        mv.visitLdcInsn(packageID.version.value);
        mv.visitMethodInsn(183, "io/ballerina/runtime/api/Module", "<init>", String.format("(L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String"), false);
        mv.visitLdcInsn(recordType.tsymbol.flags);
        mv.visitLdcInsn(recordType.sealed);
        mv.visitLdcInsn(JvmTypeGen.typeFlag(recordType));
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BRecordType", "<init>", String.format("(L%s;L%s;JZI)V", "java/lang/String", "io/ballerina/runtime/api/Module"), false);
    }

    private static void addRecordFields(MethodVisitor mv, Map<String, BField> fields) {
        mv.visitTypeInsn(187, "java/util/LinkedHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        for (BField optionalField : fields.values()) {
            mv.visitInsn(89);
            mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(optionalField.name.value));
            JvmTypeGen.createRecordField(mv, optionalField);
            mv.visitMethodInsn(185, "java/util/Map", "put", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), true);
            mv.visitInsn(87);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BRecordType", "setFields", String.format("(L%s;)V", "java/util/Map"), false);
    }

    private static void createRecordField(MethodVisitor mv, BField field) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BField");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, field.type);
        mv.visitLdcInsn(field.name.value);
        mv.visitLdcInsn(field.symbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BField", "<init>", String.format("(L%s;L%s;J)V", "io/ballerina/runtime/api/types/Type", "java/lang/String"), false);
    }

    private static int typeFlag(BType type) {
        return TypeFlags.asMask(type.isNullable(), type.isAnydata(), type.isPureType());
    }

    private static void addRecordRestField(MethodVisitor mv, BType restFieldType) {
        JvmTypeGen.loadType(mv, restFieldType);
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/types/BRecordType", "restFieldType", String.format("L%s;", "io/ballerina/runtime/api/types/Type"));
    }

    private static void createObjectType(MethodVisitor mv, BObjectType objectType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BObjectType");
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = objectType.tsymbol;
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(typeSymbol.name.getValue()));
        mv.visitTypeInsn(187, "io/ballerina/runtime/api/Module");
        mv.visitInsn(89);
        PackageID packageID = objectType.tsymbol.pkgID;
        mv.visitLdcInsn(packageID.orgName.value);
        mv.visitLdcInsn(packageID.name.value);
        mv.visitLdcInsn(packageID.version.value);
        mv.visitMethodInsn(183, "io/ballerina/runtime/api/Module", "<init>", String.format("(L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String"), false);
        mv.visitLdcInsn(typeSymbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BObjectType", "<init>", String.format("(L%s;L%s;J)V", "java/lang/String", "io/ballerina/runtime/api/Module"), false);
    }

    private static void createServiceType(MethodVisitor mv, BObjectType objectType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BServiceType");
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = objectType.tsymbol;
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(typeSymbol.name.getValue()));
        mv.visitTypeInsn(187, "io/ballerina/runtime/api/Module");
        mv.visitInsn(89);
        PackageID packageID = objectType.tsymbol.pkgID;
        mv.visitLdcInsn(packageID.orgName.value);
        mv.visitLdcInsn(packageID.name.value);
        mv.visitLdcInsn(packageID.version.value);
        mv.visitMethodInsn(183, "io/ballerina/runtime/api/Module", "<init>", String.format("(L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String"), false);
        mv.visitLdcInsn(typeSymbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BServiceType", "<init>", String.format("(L%s;L%s;J)V", "java/lang/String", "io/ballerina/runtime/api/Module"), false);
    }

    static void duplicateServiceTypeWithAnnots(MethodVisitor mv, BObjectType objectType, String pkgClassName, int strandIndex) {
        JvmTypeGen.createServiceType(mv, objectType);
        mv.visitInsn(89);
        mv.visitFieldInsn(178, pkgClassName, "$annotation_data", String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue"));
        mv.visitVarInsn(25, strandIndex);
        JvmTypeGen.loadType(mv, objectType);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BServiceType");
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)objectType.tsymbol;
        List attachedFunctions = objectTypeSymbol.attachedFuncs;
        mv.visitLdcInsn(attachedFunctions.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/internal/types/AttachedFunction");
        int i = 0;
        for (BAttachedFunction attachedFunc : attachedFunctions) {
            if (attachedFunc == null) continue;
            mv.visitInsn(89);
            mv.visitLdcInsn(i);
            mv.visitInsn(136);
            JvmTypeGen.createObjectAttachedFunction(mv, attachedFunc, objectType);
            mv.visitInsn(83);
            ++i;
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BServiceType", "setAttachedFuncsAndProcessAnnots", String.format("(L%s;L%s;L%s;[L%s;)V", "io/ballerina/runtime/internal/values/MapValue", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/internal/types/BServiceType", "io/ballerina/runtime/internal/types/AttachedFunction"), false);
    }

    private static void addObjectFields(MethodVisitor mv, Map<String, BField> fields) {
        mv.visitTypeInsn(187, "java/util/LinkedHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        for (BField optionalField : fields.values()) {
            mv.visitInsn(89);
            mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(optionalField.name.value));
            JvmTypeGen.createObjectField(mv, optionalField);
            mv.visitMethodInsn(185, "java/util/Map", "put", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), true);
            mv.visitInsn(87);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setFields", String.format("(L%s;)V", "java/util/Map"), false);
    }

    private static void createObjectField(MethodVisitor mv, BField field) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BField");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, field.type);
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(field.name.value));
        mv.visitLdcInsn(field.symbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BField", "<init>", String.format("(L%s;L%s;J)V", "io/ballerina/runtime/api/types/Type", "java/lang/String"), false);
    }

    private static void addObjectAttachedFunctions(MethodVisitor mv, List<BAttachedFunction> attachedFunctions, BObjectType objType, BIRVarToJVMIndexMap indexMap, SymbolTable symbolTable) {
        mv.visitLdcInsn(attachedFunctions.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/internal/types/AttachedFunction");
        int i = 0;
        for (BAttachedFunction attachedFunc : attachedFunctions) {
            if (attachedFunc == null) continue;
            JvmTypeGen.createObjectAttachedFunction(mv, attachedFunc, objType);
            int attachedFunctionVarIndex = indexMap.addIfNotExists(JvmCodeGenUtil.toNameString(objType) + attachedFunc.funcName.value, symbolTable.anyType);
            mv.visitVarInsn(58, attachedFunctionVarIndex);
            mv.visitInsn(89);
            mv.visitLdcInsn(i);
            mv.visitInsn(136);
            mv.visitVarInsn(25, attachedFunctionVarIndex);
            mv.visitInsn(83);
            ++i;
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setAttachedFunctions", String.format("([L%s;)V", "io/ballerina/runtime/api/types/AttachedFunctionType"), false);
    }

    private static void addObjectInitFunction(MethodVisitor mv, BAttachedFunction initFunction, BObjectType objType, BIRVarToJVMIndexMap indexMap, String funcName, String initializerFuncName, SymbolTable symbolTable) {
        if (initFunction == null || !initFunction.funcName.value.contains(funcName)) {
            return;
        }
        mv.visitInsn(89);
        JvmTypeGen.createObjectAttachedFunction(mv, initFunction, objType);
        int attachedFunctionVarIndex = indexMap.addIfNotExists(objType.name + initFunction.funcName.value, symbolTable.anyType);
        mv.visitVarInsn(58, attachedFunctionVarIndex);
        mv.visitVarInsn(25, attachedFunctionVarIndex);
        mv.visitInsn(89);
        mv.visitInsn(87);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", initializerFuncName, String.format("(L%s;)V", "io/ballerina/runtime/internal/types/AttachedFunction"), false);
    }

    private static void createObjectAttachedFunction(MethodVisitor mv, BAttachedFunction attachedFunc, BObjectType objType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/AttachedFunction");
        mv.visitInsn(89);
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(attachedFunc.funcName.value));
        JvmTypeGen.loadType(mv, objType);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
        JvmTypeGen.loadType(mv, attachedFunc.type);
        mv.visitLdcInsn(attachedFunc.symbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/AttachedFunction", "<init>", String.format("(L%s;L%s;L%s;J)V", "java/lang/String", "io/ballerina/runtime/internal/types/BObjectType", "io/ballerina/runtime/internal/types/BFunctionType"), false);
    }

    private static void createErrorType(MethodVisitor mv, BErrorType errorType, String name) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BErrorType");
        mv.visitInsn(89);
        mv.visitLdcInsn(name);
        mv.visitTypeInsn(187, "io/ballerina/runtime/api/Module");
        mv.visitInsn(89);
        PackageID packageID = errorType.tsymbol.pkgID;
        mv.visitLdcInsn(packageID.orgName.value);
        mv.visitLdcInsn(packageID.name.value);
        mv.visitLdcInsn(packageID.version.value);
        mv.visitMethodInsn(183, "io/ballerina/runtime/api/Module", "<init>", String.format("(L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String"), false);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BErrorType", "<init>", String.format("(L%s;L%s;)V", "java/lang/String", "io/ballerina/runtime/api/Module"), false);
    }

    public static void loadType(MethodVisitor mv, BType bType) {
        String typeFieldName = "";
        if (bType == null || bType.tag == 10) {
            typeFieldName = "TYPE_NULL";
        } else {
            switch (bType.tag) {
                case 49: {
                    typeFieldName = "TYPE_NEVER";
                    break;
                }
                case 1: {
                    typeFieldName = "TYPE_INT";
                    break;
                }
                case 38: {
                    typeFieldName = "TYPE_INT_SIGNED_32";
                    break;
                }
                case 39: {
                    typeFieldName = "TYPE_INT_SIGNED_16";
                    break;
                }
                case 40: {
                    typeFieldName = "TYPE_INT_SIGNED_8";
                    break;
                }
                case 41: {
                    typeFieldName = "TYPE_INT_UNSIGNED_32";
                    break;
                }
                case 42: {
                    typeFieldName = "TYPE_INT_UNSIGNED_16";
                    break;
                }
                case 43: {
                    typeFieldName = "TYPE_INT_UNSIGNED_8";
                    break;
                }
                case 3: {
                    typeFieldName = "TYPE_FLOAT";
                    break;
                }
                case 5: {
                    typeFieldName = "TYPE_STRING";
                    break;
                }
                case 44: {
                    typeFieldName = "TYPE_STRING_CHAR";
                    break;
                }
                case 4: {
                    typeFieldName = "TYPE_DECIMAL";
                    break;
                }
                case 6: {
                    typeFieldName = "TYPE_BOOLEAN";
                    break;
                }
                case 2: {
                    typeFieldName = "TYPE_BYTE";
                    break;
                }
                case 17: {
                    typeFieldName = Symbols.isFlagOn(bType.flags, 32L) ? "TYPE_READONLY_ANY" : "TYPE_ANY";
                    break;
                }
                case 11: {
                    typeFieldName = Symbols.isFlagOn(bType.flags, 32L) ? "TYPE_READONLY_ANYDATA" : "TYPE_ANYDATA";
                    break;
                }
                case 7: {
                    typeFieldName = Symbols.isFlagOn(bType.flags, 32L) ? "TYPE_READONLY_JSON" : "TYPE_JSON";
                    break;
                }
                case 8: {
                    JvmTypeGen.loadXmlType(mv, (BXMLType)bType);
                    return;
                }
                case 45: {
                    typeFieldName = Symbols.isFlagOn(bType.flags, 32L) ? "TYPE_READONLY_ELEMENT" : "TYPE_ELEMENT";
                    break;
                }
                case 46: {
                    typeFieldName = Symbols.isFlagOn(bType.flags, 32L) ? "TYPE_READONLY_PROCESSING_INSTRUCTION" : "TYPE_PROCESSING_INSTRUCTION";
                    break;
                }
                case 47: {
                    typeFieldName = Symbols.isFlagOn(bType.flags, 32L) ? "TYPE_READONLY_COMMENT" : "TYPE_COMMENT";
                    break;
                }
                case 48: {
                    typeFieldName = "TYPE_TEXT";
                    break;
                }
                case 13: {
                    JvmTypeGen.loadTypedescType(mv, (BTypedescType)bType);
                    return;
                }
                case 33: {
                    if (bType instanceof BServiceType) {
                        if (!Objects.equals(JvmTypeGen.getTypeFieldName(JvmCodeGenUtil.toNameString(bType)), "$type$service")) {
                            JvmTypeGen.loadUserDefinedType(mv, bType);
                            return;
                        }
                        typeFieldName = "TYPE_ANY_SERVICE";
                        break;
                    }
                    if (!(bType instanceof BObjectType)) break;
                    JvmTypeGen.loadUserDefinedType(mv, bType);
                    return;
                }
                case 36: {
                    typeFieldName = "TYPE_HANDLE";
                    break;
                }
                case 19: {
                    JvmTypeGen.loadArrayType(mv, (BArrayType)bType);
                    return;
                }
                case 15: {
                    JvmTypeGen.loadMapType(mv, (BMapType)bType);
                    return;
                }
                case 14: {
                    JvmTypeGen.loadStreamType(mv, (BStreamType)bType);
                    return;
                }
                case 9: {
                    JvmTypeGen.loadTableType(mv, (BTableType)bType);
                    return;
                }
                case 28: {
                    JvmTypeGen.loadErrorType(mv, (BErrorType)bType);
                    return;
                }
                case 20: {
                    JvmTypeGen.loadUnionType(mv, (BUnionType)bType);
                    return;
                }
                case 21: {
                    JvmTypeGen.loadIntersectionType(mv, (BIntersectionType)bType);
                    return;
                }
                case 12: {
                    JvmTypeGen.loadUserDefinedType(mv, bType);
                    return;
                }
                case 16: {
                    JvmTypeGen.loadInvokableType(mv, (BInvokableType)bType);
                    return;
                }
                case 23: {
                    mv.visitInsn(1);
                    return;
                }
                case 30: {
                    JvmTypeGen.loadTupleType(mv, (BTupleType)bType);
                    return;
                }
                case 32: {
                    JvmTypeGen.loadFiniteType(mv, (BFiniteType)bType);
                    return;
                }
                case 31: {
                    JvmTypeGen.loadFutureType(mv, (BFutureType)bType);
                    return;
                }
                case 37: {
                    typeFieldName = "TYPE_READONLY";
                    break;
                }
                case 51: {
                    JvmTypeGen.loadParameterizedType(mv, (BParameterizedType)bType);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        mv.visitFieldInsn(178, "io/ballerina/runtime/api/PredefinedTypes", typeFieldName, String.format("L%s;", JvmTypeGen.loadTypeClass(bType)));
    }

    private static String loadTypeClass(BType bType) {
        if (bType == null || bType.tag == 10) {
            return "io/ballerina/runtime/api/types/NullType";
        }
        switch (bType.tag) {
            case 49: {
                return "io/ballerina/runtime/api/types/NeverType";
            }
            case 1: {
                return "io/ballerina/runtime/api/types/IntegerType";
            }
            case 38: {
                return "io/ballerina/runtime/api/types/IntegerType";
            }
            case 39: {
                return "io/ballerina/runtime/api/types/IntegerType";
            }
            case 40: {
                return "io/ballerina/runtime/api/types/IntegerType";
            }
            case 41: {
                return "io/ballerina/runtime/api/types/IntegerType";
            }
            case 42: {
                return "io/ballerina/runtime/api/types/IntegerType";
            }
            case 43: {
                return "io/ballerina/runtime/api/types/IntegerType";
            }
            case 3: {
                return "io/ballerina/runtime/api/types/FloatType";
            }
            case 5: {
                return "io/ballerina/runtime/api/types/StringType";
            }
            case 44: {
                return "io/ballerina/runtime/api/types/StringType";
            }
            case 4: {
                return "io/ballerina/runtime/api/types/DecimalType";
            }
            case 6: {
                return "io/ballerina/runtime/api/types/BooleanType";
            }
            case 2: {
                return "io/ballerina/runtime/api/types/ByteType";
            }
            case 17: {
                return "io/ballerina/runtime/api/types/AnyType";
            }
            case 11: {
                return "io/ballerina/runtime/api/types/AnydataType";
            }
            case 7: {
                return "io/ballerina/runtime/api/types/JsonType";
            }
            case 8: {
                return "io/ballerina/runtime/api/types/XmlType";
            }
            case 45: {
                return Symbols.isFlagOn(bType.flags, 32L) ? "io/ballerina/runtime/api/types/Type" : "io/ballerina/runtime/api/types/XmlType";
            }
            case 46: {
                return Symbols.isFlagOn(bType.flags, 32L) ? "io/ballerina/runtime/api/types/Type" : "io/ballerina/runtime/api/types/XmlType";
            }
            case 47: {
                return Symbols.isFlagOn(bType.flags, 32L) ? "io/ballerina/runtime/api/types/Type" : "io/ballerina/runtime/api/types/XmlType";
            }
            case 48: {
                return "io/ballerina/runtime/api/types/XmlType";
            }
            case 33: {
                return bType instanceof BServiceType ? "io/ballerina/runtime/api/types/ServiceType" : "io/ballerina/runtime/api/types/ObjectType";
            }
            case 36: {
                return "io/ballerina/runtime/api/types/HandleType";
            }
            case 37: {
                return "io/ballerina/runtime/api/types/ReadonlyType";
            }
        }
        return "io/ballerina/runtime/api/types/Type";
    }

    private static void loadArrayType(MethodVisitor mv, BArrayType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BArrayType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.eType);
        int arraySize = bType.size;
        mv.visitLdcInsn(arraySize);
        mv.visitInsn(136);
        JvmTypeGen.loadReadonlyFlag(mv, bType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BArrayType", "<init>", String.format("(L%s;IZ)V", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadTypedescType(MethodVisitor mv, BTypedescType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTypedescType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTypedescType", "<init>", String.format("(L%s;)V", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadMapType(MethodVisitor mv, BMapType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BMapType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        JvmTypeGen.loadReadonlyFlag(mv, bType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BMapType", "<init>", String.format("(L%s;Z)V", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadReadonlyFlag(MethodVisitor mv, BType bType) {
        if (Symbols.isFlagOn(bType.flags, 32L)) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
    }

    private static void loadXmlType(MethodVisitor mv, BXMLType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BXmlType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        JvmTypeGen.loadReadonlyFlag(mv, bType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BXmlType", "<init>", String.format("(L%s;Z)V", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadTableType(MethodVisitor mv, BTableType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTableType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        if (bType.fieldNameList != null) {
            List<String> fieldNames = bType.fieldNameList;
            mv.visitLdcInsn(fieldNames.size());
            mv.visitInsn(136);
            mv.visitTypeInsn(189, "java/lang/String");
            int i = 0;
            for (String fieldName : fieldNames) {
                mv.visitInsn(89);
                mv.visitLdcInsn(i);
                mv.visitInsn(136);
                mv.visitLdcInsn(fieldName);
                mv.visitInsn(83);
                ++i;
            }
            JvmTypeGen.loadReadonlyFlag(mv, bType);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTableType", "<init>", String.format("(L%s;[L%s;Z)V", "io/ballerina/runtime/api/types/Type", "java/lang/String"), false);
        } else if (bType.keyTypeConstraint != null) {
            JvmTypeGen.loadType(mv, bType.keyTypeConstraint);
            JvmTypeGen.loadReadonlyFlag(mv, bType);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTableType", "<init>", String.format("(L%s;L%s;Z)V", "io/ballerina/runtime/api/types/Type", "io/ballerina/runtime/api/types/Type"), false);
        } else {
            JvmTypeGen.loadReadonlyFlag(mv, bType);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTableType", "<init>", String.format("(L%s;Z)V", "io/ballerina/runtime/api/types/Type"), false);
        }
    }

    private static void loadStreamType(MethodVisitor mv, BStreamType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BStreamType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BStreamType", "<init>", String.format("(L%s;)V", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadErrorType(MethodVisitor mv, BErrorType errorType) {
        PackageID packageID = errorType.tsymbol.pkgID;
        if (JvmCodeGenUtil.isBuiltInPackage(packageID)) {
            mv.visitFieldInsn(178, "io/ballerina/runtime/api/PredefinedTypes", "TYPE_ERROR", String.format("L%s;", "io/ballerina/runtime/api/types/ErrorType"));
            return;
        }
        String typeOwner = JvmCodeGenUtil.getPackageName(packageID) + "$_init";
        String fieldName = JvmTypeGen.getTypeFieldName(JvmCodeGenUtil.toNameString(errorType));
        mv.visitFieldInsn(178, typeOwner, fieldName, String.format("L%s;", "io/ballerina/runtime/api/types/Type"));
    }

    private static void loadUnionType(MethodVisitor mv, BUnionType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BUnionType");
        mv.visitInsn(89);
        Set<BType> memberTypes = bType.getMemberTypes();
        mv.visitLdcInsn(memberTypes.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/types/Type");
        int i = 0;
        for (BType memberType : memberTypes) {
            mv.visitInsn(89);
            mv.visitLdcInsn(i);
            mv.visitInsn(136);
            JvmTypeGen.loadType(mv, memberType);
            mv.visitInsn(83);
            ++i;
        }
        mv.visitLdcInsn(JvmTypeGen.typeFlag(bType));
        JvmTypeGen.loadReadonlyFlag(mv, bType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BUnionType", "<init>", String.format("([L%s;IZ)V", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadIntersectionType(MethodVisitor mv, BIntersectionType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BIntersectionType");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "io/ballerina/runtime/api/Module");
        mv.visitInsn(89);
        PackageID packageID = bType.tsymbol.pkgID;
        mv.visitLdcInsn(packageID.orgName.value);
        mv.visitLdcInsn(packageID.name.value);
        mv.visitLdcInsn(packageID.version.value);
        mv.visitMethodInsn(183, "io/ballerina/runtime/api/Module", "<init>", String.format("(L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String"), false);
        Set<BType> constituentTypes = bType.getConstituentTypes();
        mv.visitLdcInsn(constituentTypes.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/types/Type");
        int i = 0;
        for (BType memberType : constituentTypes) {
            mv.visitInsn(89);
            mv.visitLdcInsn(i);
            mv.visitInsn(136);
            JvmTypeGen.loadType(mv, memberType);
            mv.visitInsn(83);
            ++i;
        }
        JvmTypeGen.loadType(mv, bType.effectiveType);
        mv.visitLdcInsn(JvmTypeGen.typeFlag(bType));
        JvmTypeGen.loadReadonlyFlag(mv, bType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BIntersectionType", "<init>", String.format("(L%s;[L%s;L%s;IZ)V", "io/ballerina/runtime/api/Module", "io/ballerina/runtime/api/types/Type", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadTupleType(MethodVisitor mv, BTupleType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTupleType");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        List<BType> tupleTypes = bType.tupleTypes;
        for (BType tupleType : tupleTypes) {
            mv.visitInsn(89);
            JvmTypeGen.loadType(mv, tupleType);
            mv.visitMethodInsn(185, "java/util/List", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
            mv.visitInsn(87);
        }
        BType restType = bType.restType;
        if (restType == null) {
            mv.visitInsn(1);
        } else {
            JvmTypeGen.loadType(mv, restType);
        }
        mv.visitLdcInsn(JvmTypeGen.typeFlag(bType));
        JvmTypeGen.loadReadonlyFlag(mv, bType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTupleType", "<init>", String.format("(L%s;L%s;IZ)V", "java/util/List", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadUserDefinedType(MethodVisitor mv, BType bType) {
        PackageID packageID = bType.tsymbol.pkgID;
        String typeOwner = JvmCodeGenUtil.getPackageName(packageID) + "$_init";
        String fieldName = JvmTypeGen.getTypeFieldName(JvmCodeGenUtil.toNameString(bType));
        mv.visitFieldInsn(178, typeOwner, fieldName, String.format("L%s;", "io/ballerina/runtime/api/types/Type"));
    }

    private static String getTypeFieldName(String typeName) {
        return String.format("$type$%s", typeName);
    }

    private static void loadFutureType(MethodVisitor mv, BFutureType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BFutureType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BFutureType", "<init>", String.format("(L%s;)V", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadInvokableType(MethodVisitor mv, BInvokableType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BFunctionType");
        mv.visitInsn(89);
        mv.visitLdcInsn(bType.paramTypes.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/types/Type");
        int i = 0;
        for (BType paramType : bType.paramTypes) {
            mv.visitInsn(89);
            mv.visitLdcInsn(i);
            mv.visitInsn(136);
            JvmTypeGen.loadType(mv, paramType);
            mv.visitInsn(83);
            ++i;
        }
        BType restType = bType.restType;
        if (restType == null) {
            mv.visitInsn(1);
        } else {
            JvmTypeGen.loadType(mv, restType);
        }
        JvmTypeGen.loadType(mv, bType.retType);
        mv.visitLdcInsn(bType.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BFunctionType", "<init>", String.format("([L%s;L%s;L%s;J)V", "io/ballerina/runtime/api/types/Type", "io/ballerina/runtime/api/types/Type", "io/ballerina/runtime/api/types/Type"), false);
    }

    private static void loadParameterizedType(MethodVisitor mv, BParameterizedType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BParameterizedType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.paramValueType);
        mv.visitLdcInsn(bType.paramIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BParameterizedType", "<init>", String.format("(L%s;I)V", "io/ballerina/runtime/api/types/Type"), false);
    }

    static String getTypeDesc(BType bType) {
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return String.format("L%s;", "io/ballerina/runtime/api/values/BString");
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return String.format("L%s;", "io/ballerina/runtime/internal/values/XmlValue");
        }
        switch (bType.tag) {
            case 2: {
                return "I";
            }
            case 3: {
                return "D";
            }
            case 6: {
                return "Z";
            }
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 32: 
            case 37: 
            case 49: {
                return String.format("L%s;", "java/lang/Object");
            }
            case 19: 
            case 30: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/ArrayValue");
            }
            case 28: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/ErrorValue");
            }
            case 31: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/FutureValue");
            }
            case 12: 
            case 15: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue");
            }
            case 13: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/TypedescValue");
            }
            case 14: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/StreamValue");
            }
            case 9: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/TableValueImpl");
            }
            case 4: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/DecimalValue");
            }
            case 33: {
                return String.format("L%s;", "io/ballerina/runtime/api/values/BObject");
            }
            case 36: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/HandleValue");
            }
            case 16: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/FPValue");
            }
        }
        throw new BLangCompilerException("JVM generation is not supported for type " + bType);
    }

    private static void loadFiniteType(MethodVisitor mv, BFiniteType finiteType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BFiniteType");
        mv.visitInsn(89);
        String name = JvmCodeGenUtil.toNameString(finiteType);
        mv.visitLdcInsn(name);
        mv.visitTypeInsn(187, "java/util/LinkedHashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
        for (BLangExpression valueTypePair : finiteType.getValueSpace()) {
            Object value = ((BLangLiteral)valueTypePair).value;
            BType valueType = valueTypePair.type;
            mv.visitInsn(89);
            JvmInstructionGen.loadConstantValue(valueType, value, mv);
            if (TypeTags.isIntegerTypeTag(valueType.tag)) {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
            } else {
                switch (valueType.tag) {
                    case 6: {
                        mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", String.format("(Z)L%s;", "java/lang/Boolean"), false);
                        break;
                    }
                    case 3: {
                        mv.visitMethodInsn(184, "java/lang/Double", "valueOf", String.format("(D)L%s;", "java/lang/Double"), false);
                        break;
                    }
                    case 2: {
                        mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", String.format("(I)L%s;", "java/lang/Integer"), false);
                    }
                }
            }
            mv.visitMethodInsn(185, "java/util/Set", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
            mv.visitInsn(87);
        }
        mv.visitLdcInsn(JvmTypeGen.typeFlag(finiteType));
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BFiniteType", "<init>", String.format("(L%s;L%s;I)V", "java/lang/String", "java/util/Set"), false);
    }

    private JvmTypeGen() {
    }
}

