/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.emit;

import io.ballerina.runtime.api.flags.SymbolFlags;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.emit.TypeEmitter;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;

class EmitterUtils {
    EmitterUtils() {
    }

    static String emitName(Name name) {
        return name.value;
    }

    static String emitVarRef(BIROperand ref) {
        return EmitterUtils.emitName(ref.variableDcl.name);
    }

    static String emitBasicBlockRef(BIRNode.BIRBasicBlock basicBlock) {
        return EmitterUtils.emitName(basicBlock.id);
    }

    static String emitModuleID(PackageID modId) {
        Object str = "";
        str = (String)str + modId.orgName + "/";
        str = (String)str + modId.name;
        if (!modId.version.value.equals("")) {
            str = (String)str + ":";
            str = (String)str + modId.version.value;
        }
        return str;
    }

    static String emitBinaryOpInstructionKind(InstructionKind kind) {
        switch (kind) {
            case ADD: {
                return "+";
            }
            case SUB: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
            case EQUAL: {
                return "==";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_EQUAL: {
                return ">=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_EQUAL: {
                return "<=";
            }
            case REF_EQUAL: {
                return "===";
            }
            case REF_NOT_EQUAL: {
                return "!==";
            }
            case CLOSED_RANGE: {
                return "...";
            }
            case HALF_OPEN_RANGE: {
                return "..<";
            }
            case ANNOT_ACCESS: {
                return ".@";
            }
            case BITWISE_AND: {
                return "&";
            }
            case BITWISE_OR: {
                return "|";
            }
            case BITWISE_XOR: {
                return "^";
            }
            case BITWISE_LEFT_SHIFT: {
                return "<<";
            }
            case BITWISE_RIGHT_SHIFT: {
                return ">>";
            }
            case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                return ">>>";
            }
        }
        throw new IllegalStateException("Not a binary opkind");
    }

    static String emitFlags(long flag) {
        if (SymbolFlags.isFlagOn(1024L, flag)) {
            return "private";
        }
        if (SymbolFlags.isFlagOn(1L, flag)) {
            return "public";
        }
        return "";
    }

    static String emitTabs(int tabs) {
        StringBuilder tab = new StringBuilder();
        for (int i = 0; i < tabs; ++i) {
            tab.append(EmitterUtils.emitSpaces(4));
        }
        return tab.toString();
    }

    static String emitSpaces(int spaces) {
        StringBuilder spacesString = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            spacesString.append(" ");
        }
        return spacesString.toString();
    }

    static String emitLBreaks(int breaks) {
        StringBuilder lineBreaks = new StringBuilder();
        for (int i = 0; i < breaks; ++i) {
            lineBreaks.append("\n");
        }
        return lineBreaks.toString();
    }

    static String getTypeName(BType bType) {
        for (Map.Entry<String, BType> entry : TypeEmitter.B_TYPES.entrySet()) {
            if (!entry.getValue().equals(bType)) continue;
            return entry.getKey();
        }
        return "";
    }

    static boolean isEmpty(Name nameVal) {
        return nameVal.value.equals("");
    }

    static String emitValue(Object value, BType type) {
        if (value == null || 10 == type.tag) {
            return "0";
        }
        return value.toString();
    }

    static boolean isBinaryInstructionKind(InstructionKind insKind) {
        switch (insKind) {
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case EQUAL: 
            case NOT_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case REF_EQUAL: 
            case REF_NOT_EQUAL: 
            case CLOSED_RANGE: 
            case HALF_OPEN_RANGE: 
            case ANNOT_ACCESS: 
            case BITWISE_AND: 
            case BITWISE_OR: 
            case BITWISE_XOR: 
            case BITWISE_LEFT_SHIFT: 
            case BITWISE_RIGHT_SHIFT: 
            case BITWISE_UNSIGNED_RIGHT_SHIFT: 
            case AND: 
            case OR: {
                return true;
            }
        }
        return false;
    }

    static boolean isUnaryInstructionKind(InstructionKind insKind) {
        switch (insKind) {
            case ADD: 
            case SUB: 
            case TYPEOF: 
            case NOT: 
            case NEGATE: {
                return true;
            }
        }
        return false;
    }
}

