/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.optimizer.BIRLockOptimizer;
import org.wso2.ballerinalang.compiler.bir.optimizer.BirVariableOptimizer;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.util.Lists;

public class BIROptimizer {
    private static final CompilerContext.Key<BIROptimizer> BIR_OPTIMIZER = new CompilerContext.Key();
    private final RHSTempVarOptimizer rhsTempVarOptimizer;
    private final LHSTempVarOptimizer lhsTempVarOptimizer;
    private final BIRLockOptimizer lockOptimizer;
    private final BirVariableOptimizer variableOptimizer;

    public static BIROptimizer getInstance(CompilerContext context) {
        BIROptimizer birGen = context.get(BIR_OPTIMIZER);
        if (birGen == null) {
            birGen = new BIROptimizer(context);
        }
        return birGen;
    }

    private BIROptimizer(CompilerContext context) {
        context.put(BIR_OPTIMIZER, this);
        this.rhsTempVarOptimizer = new RHSTempVarOptimizer();
        this.lhsTempVarOptimizer = new LHSTempVarOptimizer();
        this.lockOptimizer = new BIRLockOptimizer();
        this.variableOptimizer = new BirVariableOptimizer();
    }

    public void optimizePackage(BIRNode.BIRPackage pkg) {
        pkg.accept(this.rhsTempVarOptimizer);
        this.lhsTempVarOptimizer.optimizeNode(pkg, null);
        this.lockOptimizer.optimizeNode(pkg);
        this.variableOptimizer.optimizeNode(pkg);
    }

    public static class OptimizerEnv {
        private final Map<BIRNode.BIRVariableDcl, BIRNode.BIRVariableDcl> tempVars = new HashMap<BIRNode.BIRVariableDcl, BIRNode.BIRVariableDcl>();
        private List<BIRNonTerminator> newInstructions;
    }

    public static class LHSTempVarOptimizer
    extends BIRVisitor {
        private OptimizerEnv env;

        @Override
        public void visit(BIRNode.BIRPackage birPackage) {
            birPackage.typeDefs.forEach(tDef -> this.optimizeNode((BIRNode)tDef, this.env));
            birPackage.functions.forEach(func -> this.optimizeNode((BIRNode)func, this.env));
        }

        public void optimizeNode(BIRNode node, OptimizerEnv env) {
            if (node == null) {
                return;
            }
            OptimizerEnv oldEnv = this.env;
            this.env = env;
            node.accept(this);
            this.env = oldEnv;
        }

        public void optimizeTerm(BIRTerminator term, OptimizerEnv env) {
            this.optimizeNode(term, env);
        }

        public void optimizeNonTerm(BIRNonTerminator nonTerm, OptimizerEnv env) {
            if (nonTerm.kind != InstructionKind.MOVE) {
                this.env.newInstructions.add(nonTerm);
            }
            this.optimizeNode(nonTerm, env);
        }

        @Override
        public void visit(BIRNode.BIRTypeDefinition birTypeDefinition) {
            birTypeDefinition.attachedFuncs.forEach(func -> this.optimizeNode((BIRNode)func, this.env));
        }

        @Override
        public void visit(BIRNode.BIRFunction birFunction) {
            OptimizerEnv funcOpEnv = new OptimizerEnv();
            birFunction.basicBlocks.forEach(bb -> this.optimizeNode((BIRNode)bb, funcOpEnv));
            birFunction.errorTable.forEach(ee -> this.optimizeNode((BIRNode)ee, funcOpEnv));
            birFunction.localVars = birFunction.localVars.stream().filter(l -> l.kind != VarKind.TEMP || !funcOpEnv.tempVars.containsKey(l)).collect(Collectors.toList());
        }

        @Override
        public void visit(BIRNode.BIRBasicBlock birBasicBlock) {
            this.env.newInstructions = new ArrayList<BIRNonTerminator>();
            birBasicBlock.instructions.forEach(i -> this.optimizeNonTerm((BIRNonTerminator)i, this.env));
            birBasicBlock.instructions = this.env.newInstructions;
            this.optimizeTerm(birBasicBlock.terminator, this.env);
        }

        @Override
        public void visit(BIRNode.BIRErrorEntry birErrorEntry) {
            this.optimizeNode(birErrorEntry.errorOp, this.env);
        }

        @Override
        public void visit(BIRTerminator.GOTO birGoto) {
        }

        @Override
        public void visit(BIRTerminator.Call birCall) {
            this.optimizeNode(birCall.lhsOp, this.env);
            birCall.args.forEach(a -> this.optimizeNode((BIRNode)a, this.env));
        }

        @Override
        public void visit(BIRTerminator.AsyncCall birCall) {
            this.optimizeNode(birCall.lhsOp, this.env);
            birCall.args.forEach(a -> this.optimizeNode((BIRNode)a, this.env));
        }

        @Override
        public void visit(BIRTerminator.Return birReturn) {
        }

        @Override
        public void visit(BIRTerminator.Branch birBranch) {
            this.optimizeNode(birBranch.op, this.env);
        }

        @Override
        public void visit(BIRTerminator.FPCall fpCall) {
            this.optimizeNode(fpCall.lhsOp, this.env);
            this.optimizeNode(fpCall.fp, this.env);
            fpCall.args.forEach(a -> this.optimizeNode((BIRNode)a, this.env));
        }

        @Override
        public void visit(BIRTerminator.Lock lock) {
        }

        @Override
        public void visit(BIRTerminator.FieldLock lock) {
            this.optimizeNode(lock.localVar, this.env);
        }

        @Override
        public void visit(BIRTerminator.Unlock unlock) {
        }

        @Override
        public void visit(BIRTerminator.Panic birPanic) {
            this.optimizeNode(birPanic.errorOp, this.env);
        }

        @Override
        public void visit(BIRTerminator.Wait birWait) {
            this.optimizeNode(birWait.lhsOp, this.env);
            birWait.exprList.forEach(e -> this.optimizeNode((BIRNode)e, this.env));
        }

        @Override
        public void visit(BIRTerminator.WaitAll waitAll) {
            this.optimizeNode(waitAll.lhsOp, this.env);
            waitAll.valueExprs.forEach(v -> this.optimizeNode((BIRNode)v, this.env));
        }

        @Override
        public void visit(BIRTerminator.Flush birFlush) {
            this.optimizeNode(birFlush.lhsOp, this.env);
        }

        @Override
        public void visit(BIRTerminator.WorkerReceive workerReceive) {
            this.optimizeNode(workerReceive.lhsOp, this.env);
        }

        @Override
        public void visit(BIRTerminator.WorkerSend workerSend) {
            this.optimizeNode(workerSend.lhsOp, this.env);
            this.optimizeNode(workerSend.data, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.Move birMove) {
            if (birMove.lhsOp.variableDcl.kind != VarKind.TEMP) {
                this.env.newInstructions.add(birMove);
                return;
            }
            if (birMove.rhsOp.variableDcl.kind != VarKind.TEMP) {
                this.env.tempVars.put(birMove.lhsOp.variableDcl, birMove.rhsOp.variableDcl);
            }
        }

        @Override
        public void visit(BIRNonTerminator.BinaryOp birBinaryOp) {
            this.optimizeNode(birBinaryOp.lhsOp, this.env);
            birBinaryOp.rhsOp1.accept(this);
            birBinaryOp.rhsOp2.accept(this);
        }

        @Override
        public void visit(BIRNonTerminator.UnaryOP birUnaryOp) {
            this.optimizeNode(birUnaryOp.lhsOp, this.env);
            this.optimizeNode(birUnaryOp.rhsOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.ConstantLoad birConstantLoad) {
            this.optimizeNode(birConstantLoad.lhsOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewStructure birNewStructure) {
            this.optimizeNode(birNewStructure.lhsOp, this.env);
            for (BIRNode.BIRMappingConstructorEntry initialValue : birNewStructure.initialValues) {
                if (initialValue.isKeyValuePair()) {
                    BIRNode.BIRMappingConstructorKeyValueEntry keyValueEntry = (BIRNode.BIRMappingConstructorKeyValueEntry)initialValue;
                    this.optimizeNode(keyValueEntry.keyOp, this.env);
                    this.optimizeNode(keyValueEntry.valueOp, this.env);
                    continue;
                }
                this.optimizeNode(((BIRNode.BIRMappingConstructorSpreadFieldEntry)initialValue).exprOp, this.env);
            }
        }

        @Override
        public void visit(BIRNonTerminator.NewArray birNewArray) {
            this.optimizeNode(birNewArray.lhsOp, this.env);
            this.optimizeNode(birNewArray.sizeOp, this.env);
            for (BIROperand value : birNewArray.values) {
                this.optimizeNode(value, this.env);
            }
        }

        @Override
        public void visit(BIRNonTerminator.FieldAccess birFieldAccess) {
            this.optimizeNode(birFieldAccess.lhsOp, this.env);
            this.optimizeNode(birFieldAccess.rhsOp, this.env);
            this.optimizeNode(birFieldAccess.keyOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewError birNewError) {
            this.optimizeNode(birNewError.lhsOp, this.env);
            this.optimizeNode(birNewError.messageOp, this.env);
            this.optimizeNode(birNewError.causeOp, this.env);
            this.optimizeNode(birNewError.detailOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.FPLoad fpLoad) {
            this.optimizeNode(fpLoad.lhsOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.TypeCast birTypeCast) {
            this.optimizeNode(birTypeCast.lhsOp, this.env);
            this.optimizeNode(birTypeCast.rhsOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewInstance newInstance) {
            this.optimizeNode(newInstance.lhsOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.IsLike birIsLike) {
            this.optimizeNode(birIsLike.lhsOp, this.env);
            this.optimizeNode(birIsLike.rhsOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.TypeTest birTypeTest) {
            this.optimizeNode(birTypeTest.lhsOp, this.env);
            this.optimizeNode(birTypeTest.rhsOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewTable newTable) {
            this.optimizeNode(newTable.lhsOp, this.env);
            this.optimizeNode(newTable.keyColOp, this.env);
            this.optimizeNode(newTable.dataOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewTypeDesc newTypeDesc) {
            this.optimizeNode(newTypeDesc.lhsOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewStringXMLQName newStringXMLQName) {
            this.optimizeNode(newStringXMLQName.lhsOp, this.env);
            this.optimizeNode(newStringXMLQName.stringQNameOP, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewXMLProcIns newXMLProcIns) {
            this.optimizeNode(newXMLProcIns.lhsOp, this.env);
            this.optimizeNode(newXMLProcIns.dataOp, this.env);
            this.optimizeNode(newXMLProcIns.targetOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewXMLComment newXMLComment) {
            this.optimizeNode(newXMLComment.lhsOp, this.env);
            this.optimizeNode(newXMLComment.textOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.XMLAccess xmlAccess) {
            this.optimizeNode(xmlAccess.lhsOp, this.env);
            this.optimizeNode(xmlAccess.rhsOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewXMLText newXMLText) {
            this.optimizeNode(newXMLText.lhsOp, this.env);
            this.optimizeNode(newXMLText.textOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewXMLQName newXMLQName) {
            this.optimizeNode(newXMLQName.lhsOp, this.env);
            this.optimizeNode(newXMLQName.localnameOp, this.env);
            this.optimizeNode(newXMLQName.nsURIOp, this.env);
            this.optimizeNode(newXMLQName.prefixOp, this.env);
        }

        @Override
        public void visit(BIRNonTerminator.NewXMLElement newXMLElement) {
            this.optimizeNode(newXMLElement.lhsOp, this.env);
            this.optimizeNode(newXMLElement.startTagOp, this.env);
            this.optimizeNode(newXMLElement.defaultNsURIOp, this.env);
        }

        @Override
        public void visit(BIROperand birVarRef) {
            BIRNode.BIRVariableDcl realVar = this.env.tempVars.get(birVarRef.variableDcl);
            if (realVar != null) {
                birVarRef.variableDcl = realVar;
            }
        }
    }

    public static class RHSTempVarOptimizer
    extends BIRVisitor {
        private final Map<BIROperand, List<BIRAbstractInstruction>> tempVarUpdateInstructions = new HashMap<BIROperand, List<BIRAbstractInstruction>>();
        private final Map<BIROperand, List<BIRNode.BIRErrorEntry>> errorEntries = new HashMap<BIROperand, List<BIRNode.BIRErrorEntry>>();
        private final List<BIRNode.BIRVariableDcl> removedTempVars = new ArrayList<BIRNode.BIRVariableDcl>();

        @Override
        public void visit(BIRNode.BIRPackage birPackage) {
            birPackage.typeDefs.forEach(tDef -> tDef.accept(this));
            birPackage.functions.forEach(func -> func.accept(this));
        }

        @Override
        public void visit(BIRNode.BIRTypeDefinition birTypeDefinition) {
            birTypeDefinition.attachedFuncs.forEach(func -> func.accept(this));
        }

        @Override
        public void visit(BIRNode.BIRFunction birFunction) {
            for (BIRNode.BIRErrorEntry bIRErrorEntry : birFunction.errorTable) {
                this.addErrorTableDependency(bIRErrorEntry);
            }
            birFunction.parameters.values().forEach(this::addDependency);
            this.addDependency(birFunction.basicBlocks);
            for (List list : birFunction.parameters.values()) {
                list.forEach(bb -> bb.accept(this));
            }
            birFunction.basicBlocks.forEach(bb -> bb.accept(this));
            ArrayList<BIRNode.BIRVariableDcl> newLocalVars = new ArrayList<BIRNode.BIRVariableDcl>();
            for (BIRNode.BIRVariableDcl var : birFunction.localVars) {
                if (var.kind != VarKind.TEMP) {
                    newLocalVars.add(var);
                    continue;
                }
                if (this.removedTempVars.contains(var)) continue;
                newLocalVars.add(var);
            }
            this.removedTempVars.clear();
            this.tempVarUpdateInstructions.clear();
            this.errorEntries.clear();
            birFunction.localVars = newLocalVars;
        }

        @Override
        public void visit(BIRNode.BIRBasicBlock birBasicBlock) {
            List<BIRNonTerminator> instructions = birBasicBlock.instructions;
            ArrayList<BIRNonTerminator> newInstructions = new ArrayList<BIRNonTerminator>();
            for (BIRNonTerminator ins : instructions) {
                if (ins.getKind() != InstructionKind.MOVE) {
                    newInstructions.add(ins);
                    continue;
                }
                BIRNonTerminator.Move moveIns = (BIRNonTerminator.Move)ins;
                if (moveIns.rhsOp.variableDcl.kind != VarKind.TEMP) {
                    newInstructions.add(ins);
                    continue;
                }
                this.replaceTempVar(moveIns);
            }
            birBasicBlock.instructions = newInstructions;
        }

        private void replaceTempVar(BIRNonTerminator.Move moveIns) {
            List<BIRNode.BIRErrorEntry> errorEntriesWithTemp;
            List<BIRAbstractInstruction> tempUpdateInsList = this.tempVarUpdateInstructions.get(moveIns.rhsOp);
            if (tempUpdateInsList != null) {
                this.removedTempVars.add(moveIns.rhsOp.variableDcl);
                for (BIRAbstractInstruction tempUpdateIns : tempUpdateInsList) {
                    tempUpdateIns.lhsOp = moveIns.lhsOp;
                    this.addDependency(tempUpdateIns);
                }
            }
            if ((errorEntriesWithTemp = this.errorEntries.get(moveIns.rhsOp)) != null) {
                for (BIRNode.BIRErrorEntry errorEntryWithTemp : errorEntriesWithTemp) {
                    errorEntryWithTemp.errorOp = moveIns.lhsOp;
                    this.addErrorTableDependency(errorEntryWithTemp);
                }
            }
        }

        private void addErrorTableDependency(BIRNode.BIRErrorEntry errorEntryWithTemp) {
            List<BIRNode.BIRErrorEntry> errorTableEntries = this.errorEntries.get(errorEntryWithTemp.errorOp);
            if (errorTableEntries != null) {
                errorTableEntries.add(errorEntryWithTemp);
            } else {
                this.errorEntries.put(errorEntryWithTemp.errorOp, Lists.of(errorEntryWithTemp));
            }
        }

        private void addDependency(List<BIRNode.BIRBasicBlock> basicBlocks) {
            for (BIRNode.BIRBasicBlock bb : basicBlocks) {
                for (BIRNonTerminator ins : bb.instructions) {
                    this.addDependency(ins);
                }
                this.addDependency(bb.terminator);
            }
        }

        private void addDependency(BIRAbstractInstruction ins) {
            if (ins.lhsOp == null || ins.lhsOp.variableDcl.kind != VarKind.TEMP) {
                return;
            }
            List<BIRAbstractInstruction> tempVarUpdates = this.tempVarUpdateInstructions.get(ins.lhsOp);
            if (tempVarUpdates != null) {
                tempVarUpdates.add(ins);
            } else {
                this.tempVarUpdateInstructions.put(ins.lhsOp, Lists.of(ins));
            }
        }
    }
}

