/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.optimizer.ControlFlowGraph;
import org.wso2.ballerinalang.compiler.bir.optimizer.LivenessAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class BirVariableOptimizer
extends BIRVisitor {
    public void optimizeNode(BIRNode node) {
        node.accept(this);
    }

    @Override
    public void visit(BIRNode.BIRPackage birPackage) {
        birPackage.typeDefs.forEach(tDef -> tDef.accept(this));
        birPackage.functions.forEach(func -> func.accept(this));
    }

    @Override
    public void visit(BIRNode.BIRTypeDefinition birTypeDefinition) {
        birTypeDefinition.attachedFuncs.forEach(func -> func.accept(this));
    }

    @Override
    public void visit(BIRNode.BIRFunction birFunction) {
        ControlFlowGraph graph = new ControlFlowGraph(birFunction);
        LivenessAnalyzer analyzer = new LivenessAnalyzer(graph.getNodes());
        Map<BIRAbstractInstruction, Set<BIRNode.BIRVariableDcl>> liveOuts = analyzer.getInstructionLiveOuts();
        ArrayList<BIRNode.BIRVariableDcl> unusedVars = new ArrayList<BIRNode.BIRVariableDcl>();
        this.reuseVars(liveOuts, unusedVars, birFunction);
        unusedVars.forEach(var -> birFunction.localVars.remove(var));
    }

    private void reuseVars(Map<BIRAbstractInstruction, Set<BIRNode.BIRVariableDcl>> liveOuts, List<BIRNode.BIRVariableDcl> unusedVars, BIRNode.BIRFunction birFunction) {
        List<BIRAbstractInstruction> instructionList = this.getInstructionList(birFunction);
        HashMap<BType, LinkedList<BIRNode.BIRVariableDcl>> freeVars = new HashMap<BType, LinkedList<BIRNode.BIRVariableDcl>>();
        for (int i = 0; i < instructionList.size(); ++i) {
            if (instructionList.get(i).getKind() == InstructionKind.XML_SEQ_STORE) continue;
            this.tryToReuseFromFreeVars(liveOuts, freeVars, instructionList, i, unusedVars);
            this.checkForFreeVars(freeVars, liveOuts, instructionList.get(i));
        }
    }

    private void checkForFreeVars(Map<BType, LinkedList<BIRNode.BIRVariableDcl>> freeVars, Map<BIRAbstractInstruction, Set<BIRNode.BIRVariableDcl>> liveOuts, BIRAbstractInstruction instruction) {
        for (BIROperand operand : instruction.getRhsOperands()) {
            BType type = operand.variableDcl.type;
            if (!this.isReusableVarKind(operand.variableDcl) || liveOuts.get(instruction).contains(operand.variableDcl)) continue;
            if (!freeVars.containsKey(type)) {
                freeVars.put(type, new LinkedList());
            }
            LinkedList<BIRNode.BIRVariableDcl> ls = freeVars.get(type);
            ls.add(operand.variableDcl);
        }
    }

    private void tryToReuseFromFreeVars(Map<BIRAbstractInstruction, Set<BIRNode.BIRVariableDcl>> liveOuts, Map<BType, LinkedList<BIRNode.BIRVariableDcl>> freeVars, List<BIRAbstractInstruction> instructionList, int index, List<BIRNode.BIRVariableDcl> unusedVars) {
        BIRAbstractInstruction instruction = instructionList.get(index);
        if (instruction.lhsOp == null) {
            return;
        }
        BType type = instruction.lhsOp.variableDcl.type;
        LinkedList<BIRNode.BIRVariableDcl> defLs = freeVars.get(type);
        if (defLs == null || defLs.isEmpty()) {
            return;
        }
        BIRNode.BIRVariableDcl newLhsOp = defLs.peek();
        BIRNode.BIRVariableDcl oldLhsOp = instruction.lhsOp.variableDcl;
        if (this.isReusableVarKind(oldLhsOp) && !this.checkVarUse(instruction, oldLhsOp)) {
            defLs.remove();
            unusedVars.add(oldLhsOp);
            this.replaceOldOp(instructionList, index, oldLhsOp, newLhsOp, liveOuts);
            instruction.lhsOp.variableDcl = newLhsOp;
        }
    }

    private boolean isReusableVarKind(BIRNode.BIRVariableDcl oldLhsOp) {
        return oldLhsOp.kind == VarKind.TEMP;
    }

    private void replaceOldOp(List<BIRAbstractInstruction> instructionList, int index, BIRNode.BIRVariableDcl oldLhsOp, BIRNode.BIRVariableDcl newLhsOp, Map<BIRAbstractInstruction, Set<BIRNode.BIRVariableDcl>> liveOuts) {
        for (int i = index + 1; i < instructionList.size(); ++i) {
            Set<BIRNode.BIRVariableDcl> insLiveOuts;
            BIROperand[] operands;
            BIRAbstractInstruction instruction = instructionList.get(i);
            boolean changed = false;
            for (BIROperand operand : operands = instruction.getRhsOperands()) {
                if (operand.variableDcl != oldLhsOp) continue;
                operand.variableDcl = newLhsOp;
                changed = true;
            }
            if (!changed || !(insLiveOuts = liveOuts.get(instruction)).remove(oldLhsOp)) continue;
            insLiveOuts.add(newLhsOp);
        }
    }

    private boolean checkVarUse(BIRAbstractInstruction instruction, BIRNode.BIRVariableDcl oldLhsOp) {
        for (BIROperand operand : instruction.getRhsOperands()) {
            if (operand.variableDcl != oldLhsOp) continue;
            return true;
        }
        return false;
    }

    private List<BIRAbstractInstruction> getInstructionList(BIRNode.BIRFunction birFunction) {
        ArrayList<BIRAbstractInstruction> ls = new ArrayList<BIRAbstractInstruction>();
        birFunction.basicBlocks.forEach(basicBlock -> {
            ls.addAll(basicBlock.instructions);
            ls.add(basicBlock.terminator);
        });
        return ls;
    }

    @Override
    public void visit(BIRNode.BIRBasicBlock basicBlock) {
    }

    @Override
    public void visit(BIRTerminator.GOTO birGoto) {
    }

    @Override
    public void visit(BIRTerminator.Call birCall) {
    }

    @Override
    public void visit(BIRTerminator.AsyncCall birCall) {
    }

    @Override
    public void visit(BIRTerminator.Return birReturn) {
    }

    @Override
    public void visit(BIRTerminator.Branch birBranch) {
    }

    @Override
    public void visit(BIRTerminator.FPCall fpCall) {
    }

    @Override
    public void visit(BIRTerminator.Lock lock) {
    }

    @Override
    public void visit(BIRTerminator.FieldLock lock) {
    }

    @Override
    public void visit(BIRTerminator.Unlock unlock) {
    }

    @Override
    public void visit(BIRTerminator.Panic birPanic) {
    }

    @Override
    public void visit(BIRTerminator.Wait birWait) {
    }

    @Override
    public void visit(BIRTerminator.WaitAll waitAll) {
    }

    @Override
    public void visit(BIRTerminator.Flush birFlush) {
    }

    @Override
    public void visit(BIRTerminator.WorkerReceive workerReceive) {
    }

    @Override
    public void visit(BIRTerminator.WorkerSend workerSend) {
    }
}

