/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;

public class ControlFlowGraph {
    private final BIRNode.BIRFunction function;
    private final Map<BIRNode.BIRBasicBlock, Node> funcBasicBlockFirstNodeMap;
    private final Map<BIRNode.BIRBasicBlock, Node> funcBasicBlockLastNodeMap;
    private final List<Node> nodes;

    public ControlFlowGraph(BIRNode.BIRFunction function) {
        this.function = function;
        this.funcBasicBlockFirstNodeMap = new HashMap<BIRNode.BIRBasicBlock, Node>();
        this.funcBasicBlockLastNodeMap = new HashMap<BIRNode.BIRBasicBlock, Node>();
        this.nodes = new ArrayList<Node>();
        this.generate();
    }

    public void generate() {
        for (BIRNode.BIRBasicBlock basicBlock : this.function.basicBlocks) {
            Node prev = null;
            for (int i = 0; i < basicBlock.instructions.size(); ++i) {
                Node node = new Node(basicBlock.instructions.get(i));
                this.nodes.add(node);
                if (i == 0) {
                    this.funcBasicBlockFirstNodeMap.put(basicBlock, node);
                }
                if (prev != null) {
                    this.addEdge(prev, node);
                }
                prev = node;
            }
            Node terminatorNode = new Node(basicBlock.terminator);
            this.nodes.add(terminatorNode);
            if (prev != null) {
                this.addEdge(prev, terminatorNode);
            } else {
                this.funcBasicBlockFirstNodeMap.put(basicBlock, terminatorNode);
            }
            this.funcBasicBlockLastNodeMap.put(basicBlock, terminatorNode);
        }
        this.connectNodesAcrossBasicBlocks();
    }

    private void connectNodesAcrossBasicBlocks() {
        this.funcBasicBlockLastNodeMap.forEach((birBasicBlock, node) -> {
            BIRTerminator terminator = birBasicBlock.terminator;
            for (BIRNode.BIRBasicBlock basicBlock : terminator.getNextBasicBlocks()) {
                Node target = this.funcBasicBlockFirstNodeMap.get(basicBlock);
                if (target == null) continue;
                this.addEdge((Node)node, target);
            }
        });
    }

    private void addEdge(Node first, Node second) {
        first.successors.add(second);
        second.predecessors.add(first);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    static class Node {
        List<Node> successors;
        List<Node> predecessors;
        BIRAbstractInstruction instruction;

        public Node(BIRAbstractInstruction instruction) {
            this.instruction = instruction;
            this.predecessors = new ArrayList<Node>();
            this.successors = new ArrayList<Node>();
        }
    }
}

