/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.clauses.OrderKeyNode;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownReferenceDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangInputClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangThrow;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTryCatchFinally;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.util.Lists;

public class QueryDesugar
extends BLangNodeVisitor {
    private static final Name QUERY_CREATE_PIPELINE_FUNCTION = new Name("createPipeline");
    private static final Name QUERY_CREATE_INPUT_FUNCTION = new Name("createInputFunction");
    private static final Name QUERY_CREATE_NESTED_FROM_FUNCTION = new Name("createNestedFromFunction");
    private static final Name QUERY_CREATE_LET_FUNCTION = new Name("createLetFunction");
    private static final Name QUERY_CREATE_INNER_JOIN_FUNCTION = new Name("createInnerJoinFunction");
    private static final Name QUERY_CREATE_OUTER_JOIN_FUNCTION = new Name("createOuterJoinFunction");
    private static final Name QUERY_CREATE_FILTER_FUNCTION = new Name("createFilterFunction");
    private static final Name QUERY_CREATE_ORDER_BY_FUNCTION = new Name("createOrderByFunction");
    private static final Name QUERY_CREATE_SELECT_FUNCTION = new Name("createSelectFunction");
    private static final Name QUERY_CREATE_DO_FUNCTION = new Name("createDoFunction");
    private static final Name QUERY_CREATE_LIMIT_FUNCTION = new Name("createLimitFunction");
    private static final Name QUERY_ADD_STREAM_FUNCTION = new Name("addStreamFunction");
    private static final Name QUERY_CONSUME_STREAM_FUNCTION = new Name("consumeStream");
    private static final Name QUERY_TO_ARRAY_FUNCTION = new Name("toArray");
    private static final Name QUERY_TO_STRING_FUNCTION = new Name("toString");
    private static final Name QUERY_TO_XML_FUNCTION = new Name("toXML");
    private static final Name QUERY_ADD_TO_TABLE_FUNCTION = new Name("addToTable");
    private static final Name QUERY_GET_STREAM_FROM_PIPELINE_FUNCTION = new Name("getStreamFromPipeline");
    private static final String FRAME_PARAMETER_NAME = "$frame$";
    private static final CompilerContext.Key<QueryDesugar> QUERY_DESUGAR_KEY = new CompilerContext.Key();
    private BLangExpression onConflictExpr;
    private BVarSymbol currentFrameSymbol;
    private BLangBlockFunctionBody currentLambdaBody;
    private Map<String, BSymbol> identifiers;
    private int streamElementCount = 0;
    private final Desugar desugar;
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final Names names;
    private final Types types;
    private SymbolEnv env;

    private QueryDesugar(CompilerContext context) {
        context.put(QUERY_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.types = Types.getInstance(context);
        this.desugar = Desugar.getInstance(context);
    }

    public static QueryDesugar getInstance(CompilerContext context) {
        QueryDesugar desugar = context.get(QUERY_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new QueryDesugar(context);
        }
        return desugar;
    }

    BLangStatementExpression desugar(BLangQueryExpr queryExpr, SymbolEnv env) {
        BLangStatementExpression streamStmtExpr;
        List<BLangNode> clauses = queryExpr.getQueryClauses();
        Location pos = clauses.get((int)0).pos;
        BLangBlockStmt queryBlock = ASTBuilderUtil.createBlockStmt(pos);
        BLangVariableReference streamRef = this.buildStream(clauses, queryExpr.type, env, queryBlock);
        if (queryExpr.isStream) {
            streamStmtExpr = ASTBuilderUtil.createStatementExpression(queryBlock, streamRef);
            streamStmtExpr.type = streamRef.type;
        } else if (queryExpr.isTable) {
            this.onConflictExpr = this.onConflictExpr == null ? ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE) : this.onConflictExpr;
            BLangVariableReference tableRef = this.addTableConstructor(queryExpr, queryBlock);
            BLangVariableReference result = this.getStreamFunctionVariableRef(queryBlock, QUERY_ADD_TO_TABLE_FUNCTION, Lists.of(streamRef, tableRef, this.onConflictExpr), pos);
            streamStmtExpr = ASTBuilderUtil.createStatementExpression(queryBlock, result);
            streamStmtExpr.type = tableRef.type;
            this.onConflictExpr = null;
        } else {
            BLangVariableReference result;
            if (TypeTags.isXMLTypeTag(queryExpr.type.tag)) {
                result = this.getStreamFunctionVariableRef(queryBlock, QUERY_TO_XML_FUNCTION, Lists.of(streamRef), pos);
            } else if (TypeTags.isStringTypeTag(queryExpr.type.tag)) {
                result = this.getStreamFunctionVariableRef(queryBlock, QUERY_TO_STRING_FUNCTION, Lists.of(streamRef), pos);
            } else {
                BType arrayType = queryExpr.type;
                if (arrayType.tag == 20) {
                    arrayType = ((BUnionType)arrayType).getMemberTypes().stream().filter(m -> m.tag == 19).findFirst().orElse(this.symTable.arrayType);
                }
                BLangListConstructorExpr.BLangArrayLiteral arr = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
                arr.exprs = new ArrayList();
                arr.type = arrayType;
                result = this.getStreamFunctionVariableRef(queryBlock, QUERY_TO_ARRAY_FUNCTION, Lists.of(streamRef, arr), pos);
            }
            streamStmtExpr = ASTBuilderUtil.createStatementExpression(queryBlock, result);
            streamStmtExpr.type = result.type;
        }
        return streamStmtExpr;
    }

    BLangStatementExpression desugar(BLangQueryAction queryAction, SymbolEnv env) {
        List<BLangNode> clauses = queryAction.getQueryClauses();
        Location pos = clauses.get((int)0).pos;
        BLangBlockStmt queryBlock = ASTBuilderUtil.createBlockStmt(pos);
        BLangVariableReference streamRef = this.buildStream(clauses, queryAction.type, env, queryBlock);
        BLangVariableReference result = this.getStreamFunctionVariableRef(queryBlock, QUERY_CONSUME_STREAM_FUNCTION, this.symTable.errorOrNilType, Lists.of(streamRef), pos);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(queryBlock, result);
        stmtExpr.type = this.symTable.errorOrNilType;
        return stmtExpr;
    }

    BLangVariableReference buildStream(List<BLangNode> clauses, BType resultType, SymbolEnv env, BLangBlockStmt block) {
        this.env = env;
        BLangFromClause initFromClause = (BLangFromClause)clauses.get(0);
        BLangVariableReference initPipeline = this.addPipeline(block, initFromClause.pos, initFromClause.collection, resultType);
        BLangVariableReference initFrom = this.addInputFunction(block, initFromClause);
        this.addStreamFunction(block, initPipeline, initFrom);
        for (BLangNode clause : clauses.subList(1, clauses.size())) {
            switch (clause.getKind()) {
                case FROM: {
                    BLangFromClause fromClause = (BLangFromClause)clause;
                    BLangVariableReference nestedFromFunc = this.addNestedFromFunction(block, fromClause);
                    this.addStreamFunction(block, initPipeline, nestedFromFunc);
                    BLangVariableReference fromInputFunc = this.addInputFunction(block, fromClause);
                    this.addStreamFunction(block, initPipeline, fromInputFunc);
                    break;
                }
                case JOIN: {
                    BLangJoinClause joinClause = (BLangJoinClause)clause;
                    BLangVariableReference joinPipeline = this.addPipeline(block, joinClause.pos, joinClause.collection, resultType);
                    BLangVariableReference joinInputFunc = this.addInputFunction(block, joinClause);
                    this.addStreamFunction(block, joinPipeline, joinInputFunc);
                    BLangVariableReference joinFunc = this.addJoinFunction(block, joinClause, joinPipeline);
                    this.addStreamFunction(block, initPipeline, joinFunc);
                    break;
                }
                case LET_CLAUSE: {
                    BLangVariableReference letFunc = this.addLetFunction(block, (BLangLetClause)clause);
                    this.addStreamFunction(block, initPipeline, letFunc);
                    break;
                }
                case WHERE: {
                    BLangVariableReference whereFunc = this.addWhereFunction(block, (BLangWhereClause)clause);
                    this.addStreamFunction(block, initPipeline, whereFunc);
                    break;
                }
                case ORDER_BY: {
                    BLangVariableReference orderFunc = this.addOrderByFunction(block, (BLangOrderByClause)clause);
                    this.addStreamFunction(block, initPipeline, orderFunc);
                    break;
                }
                case SELECT: {
                    BLangVariableReference selectFunc = this.addSelectFunction(block, (BLangSelectClause)clause);
                    this.addStreamFunction(block, initPipeline, selectFunc);
                    break;
                }
                case DO: {
                    BLangVariableReference doFunc = this.addDoFunction(block, (BLangDoClause)clause);
                    this.addStreamFunction(block, initPipeline, doFunc);
                    break;
                }
                case LIMIT: {
                    BLangVariableReference limitFunc = this.addLimitFunction(block, (BLangLimitClause)clause);
                    this.addStreamFunction(block, initPipeline, limitFunc);
                    break;
                }
                case ON_CONFLICT: {
                    BLangOnConflictClause onConflict = (BLangOnConflictClause)clause;
                    this.onConflictExpr = onConflict.expression;
                }
            }
        }
        return this.addGetStreamFromPipeline(block, initPipeline);
    }

    BLangVariableReference addPipeline(BLangBlockStmt blockStmt, Location pos, BLangExpression collection, BType resultType) {
        String name = this.getNewVarName();
        BVarSymbol dataSymbol = new BVarSymbol(0L, this.names.fromString(name), this.env.scope.owner.pkgID, collection.type, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable dataVariable = ASTBuilderUtil.createVariable(pos, name, collection.type, this.addTypeConversionExpr(collection, collection.type), dataSymbol);
        BLangSimpleVariableDef dataVarDef = ASTBuilderUtil.createVariableDef(pos, dataVariable);
        BLangSimpleVarRef valueVarRef = ASTBuilderUtil.createVariableRef(pos, dataSymbol);
        blockStmt.addStatement(dataVarDef);
        if (resultType.tag == 19) {
            resultType = ((BArrayType)resultType).eType;
        } else if (resultType.tag == 14) {
            resultType = ((BStreamType)resultType).constraint;
        }
        BTypedescType typedescType = new BTypedescType(resultType, this.symTable.typeDesc.tsymbol);
        BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
        typedescExpr.resolvedType = resultType;
        typedescExpr.type = typedescType;
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_PIPELINE_FUNCTION, Lists.of(valueVarRef, typedescExpr), pos);
    }

    BLangVariableReference addInputFunction(BLangBlockStmt blockStmt, BLangInputClause inputClause) {
        Location pos = inputClause.pos;
        BLangLambdaFunction lambda = this.createPassthroughLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        BVarSymbol frameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        List<BVarSymbol> symbols = this.getIntroducedSymbols((BLangVariable)inputClause.variableDefinitionNode.getVariable());
        this.shadowSymbolScope(pos, body, ASTBuilderUtil.createVariableRef(pos, frameSymbol), symbols);
        BLangFieldBasedAccess valueAccessExpr = this.desugar.getValueAccessExpression(inputClause.pos, this.symTable.anyOrErrorType, frameSymbol);
        valueAccessExpr.expr = this.desugar.addConversionExprIfRequired(valueAccessExpr.expr, this.types.getSafeType(valueAccessExpr.expr.type, true, false));
        VariableDefinitionNode variableDefinitionNode = inputClause.variableDefinitionNode;
        BLangVariable variable = (BLangVariable)variableDefinitionNode.getVariable();
        variable.setInitialExpression(this.desugar.addConversionExprIfRequired(valueAccessExpr, inputClause.varType));
        body.stmts.add(0, (BLangStatement)((Object)variableDefinitionNode));
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_INPUT_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addNestedFromFunction(BLangBlockStmt blockStmt, BLangFromClause fromClause) {
        Location pos = fromClause.pos;
        BLangUnionTypeNode returnType = this.getAnyErrorNilTypeNode();
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.expr = fromClause.collection;
        returnNode.pos = pos;
        BLangLambdaFunction lambda = this.createLambdaFunction(pos, returnType, returnNode, false);
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_NESTED_FROM_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addJoinFunction(BLangBlockStmt blockStmt, BLangJoinClause joinClause, BLangVariableReference joinPipeline) {
        BLangExpression lhsExpr = (BLangExpression)joinClause.onClause.getLeftExpression();
        BLangExpression rhsExpr = (BLangExpression)joinClause.onClause.getRightExpression();
        BLangLambdaFunction lhsKeyFunction = this.createKeyFunction(lhsExpr);
        BLangLambdaFunction rhsKeyFunction = this.createKeyFunction(rhsExpr);
        if (joinClause.isOuterJoin) {
            List<BVarSymbol> symbols = this.getIntroducedSymbols((BLangVariable)joinClause.variableDefinitionNode.getVariable());
            BLangSimpleVarRef nilFrame = this.defineNilFrameForType(symbols, blockStmt, rhsExpr.pos);
            return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_OUTER_JOIN_FUNCTION, Lists.of(joinPipeline, lhsKeyFunction, rhsKeyFunction, nilFrame), joinClause.pos);
        }
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_INNER_JOIN_FUNCTION, Lists.of(joinPipeline, lhsKeyFunction, rhsKeyFunction), joinClause.pos);
    }

    BLangVariableReference addLetFunction(BLangBlockStmt blockStmt, BLangLetClause letClause) {
        Location pos = letClause.pos;
        BLangLambdaFunction lambda = this.createPassthroughLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        BVarSymbol frameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        List<BVarSymbol> symbols = this.getIntroducedSymbols(letClause);
        this.shadowSymbolScope(pos, body, ASTBuilderUtil.createVariableRef(pos, frameSymbol), symbols);
        Collections.reverse(letClause.letVarDeclarations);
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            body.stmts.add(0, (BLangStatement)((Object)letVariable.definitionNode));
        }
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_LET_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addWhereFunction(BLangBlockStmt blockStmt, BLangWhereClause whereClause) {
        Location pos = whereClause.pos;
        BLangLambdaFunction lambda = this.createFilterLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.pos = pos;
        returnNode.setExpression(whereClause.expression);
        body.addStatement(returnNode);
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_FILTER_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addOrderByFunction(BLangBlockStmt blockStmt, BLangOrderByClause orderByClause) {
        Location pos = orderByClause.pos;
        BLangLambdaFunction lambda = this.createActionLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        BVarSymbol frameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        BLangSimpleVarRef frame = ASTBuilderUtil.createVariableRef(pos, frameSymbol);
        BLangListConstructorExpr.BLangArrayLiteral sortFieldsArrayExpr = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        sortFieldsArrayExpr.exprs = new ArrayList();
        sortFieldsArrayExpr.type = new BArrayType(this.symTable.anydataType);
        BLangListConstructorExpr.BLangArrayLiteral sortModesArrayExpr = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        sortModesArrayExpr.exprs = new ArrayList();
        sortModesArrayExpr.type = new BArrayType(this.symTable.booleanType);
        for (OrderKeyNode orderKeyNode : orderByClause.getOrderKeyList()) {
            BLangOrderKey orderKey = (BLangOrderKey)orderKeyNode;
            sortFieldsArrayExpr.exprs.add(orderKey.expression);
            sortModesArrayExpr.exprs.add(ASTBuilderUtil.createLiteral(orderKey.pos, this.symTable.booleanType, orderKey.getOrderDirection()));
        }
        BLangStatement orderKeyStmt = this.getAddToFrameStmt(pos, frame, "$orderKey$", sortFieldsArrayExpr);
        body.stmts.add(orderKeyStmt);
        BLangStatement orderDirectionStmt = this.getAddToFrameStmt(pos, frame, "$orderDirection$", sortModesArrayExpr);
        body.stmts.add(orderDirectionStmt);
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_ORDER_BY_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addSelectFunction(BLangBlockStmt blockStmt, BLangSelectClause selectClause) {
        Location pos = selectClause.pos;
        BLangLambdaFunction lambda = this.createPassthroughLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        BVarSymbol oldFrameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        BLangSimpleVarRef frame = ASTBuilderUtil.createVariableRef(pos, oldFrameSymbol);
        BLangStatement assignment = this.getAddToFrameStmt(pos, frame, "$value$", selectClause.expression);
        body.stmts.add(body.stmts.size() - 1, assignment);
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_SELECT_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addDoFunction(BLangBlockStmt blockStmt, BLangDoClause doClause) {
        Location pos = doClause.pos;
        BLangLambdaFunction lambda = this.createActionLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        for (BLangStatement stmt : doClause.body.stmts) {
            body.addStatement(stmt);
        }
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_DO_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addLimitFunction(BLangBlockStmt blockStmt, BLangLimitClause limitClause) {
        Location pos = limitClause.pos;
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.expr = this.desugar.addConversionExprIfRequired(limitClause.expression, this.symTable.intType);
        returnNode.pos = pos;
        BLangLambdaFunction limitFunction = this.createLambdaFunction(pos, this.getIntTypeNode(), returnNode, false);
        limitFunction.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_LIMIT_FUNCTION, Lists.of(limitFunction), pos);
    }

    void addStreamFunction(BLangBlockStmt blockStmt, BLangVariableReference pipelineRef, BLangVariableReference functionRef) {
        BLangInvocation addStreamFunctionInvocation = this.createQueryLibInvocation(QUERY_ADD_STREAM_FUNCTION, Lists.of(pipelineRef, functionRef), pipelineRef.pos);
        BLangExpressionStmt stmt = ASTBuilderUtil.createExpressionStmt(pipelineRef.pos, blockStmt);
        stmt.expr = addStreamFunctionInvocation;
    }

    BLangVariableReference addGetStreamFromPipeline(BLangBlockStmt blockStmt, BLangVariableReference pipelineRef) {
        Location pos = pipelineRef.pos;
        BLangVariableReference streamVarRef = this.getStreamFunctionVariableRef(blockStmt, QUERY_GET_STREAM_FROM_PIPELINE_FUNCTION, null, Lists.of(pipelineRef), pos);
        return streamVarRef;
    }

    BLangVariableReference addTableConstructor(BLangQueryExpr queryExpr, BLangBlockStmt queryBlock) {
        Location pos = queryExpr.pos;
        BType type = queryExpr.type;
        String name = this.getNewVarName();
        BType tableType = type;
        if (type.tag == 20) {
            tableType = ((BUnionType)type).getMemberTypes().stream().filter(m -> m.tag == 9).findFirst().orElse(this.symTable.tableType);
        }
        List<IdentifierNode> keyFieldIdentifiers = queryExpr.fieldNameIdentifierList;
        BLangTableConstructorExpr tableConstructorExpr = (BLangTableConstructorExpr)TreeBuilder.createTableConstructorExpressionNode();
        tableConstructorExpr.pos = pos;
        tableConstructorExpr.type = tableType;
        if (!keyFieldIdentifiers.isEmpty()) {
            BLangTableKeySpecifier keySpecifier = (BLangTableKeySpecifier)TreeBuilder.createTableKeySpecifierNode();
            keySpecifier.pos = pos;
            for (IdentifierNode identifier : keyFieldIdentifiers) {
                keySpecifier.addFieldNameIdentifier(identifier);
            }
            tableConstructorExpr.tableKeySpecifier = keySpecifier;
        }
        BVarSymbol tableSymbol = new BVarSymbol(0L, this.names.fromString(name), this.env.scope.owner.pkgID, tableType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable tableVariable = ASTBuilderUtil.createVariable(pos, name, tableType, tableConstructorExpr, tableSymbol);
        queryBlock.addStatement(ASTBuilderUtil.createVariableDef(pos, tableVariable));
        return ASTBuilderUtil.createVariableRef(pos, tableSymbol);
    }

    private BLangExpression addTypeConversionExpr(BLangExpression expr, BType type) {
        BLangTypeConversionExpr conversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        conversionExpr.expr = expr;
        conversionExpr.targetType = type;
        conversionExpr.type = type;
        conversionExpr.pos = expr.pos;
        conversionExpr.checkTypes = false;
        return conversionExpr;
    }

    private BLangLambdaFunction createPassthroughLambda(Location pos) {
        BLangUnionTypeNode returnType = this.getFrameErrorNilTypeNode();
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.pos = pos;
        return this.createLambdaFunction(pos, returnType, returnNode, true);
    }

    private BLangLambdaFunction createFilterLambda(Location pos) {
        BLangValueType returnType = this.getBooleanTypeNode();
        return this.createLambdaFunction(pos, returnType, null, false);
    }

    private BLangLambdaFunction createActionLambda(Location pos) {
        BLangValueType returnType = this.getNilTypeNode();
        return this.createLambdaFunction(pos, returnType, null, false);
    }

    private BLangLambdaFunction createLambdaFunction(Location pos, TypeNode returnType, BLangReturn returnNode, boolean isPassthrough) {
        BType frameType = this.getFrameTypeSymbol().type;
        BVarSymbol frameSymbol = new BVarSymbol(0L, this.names.fromString(FRAME_PARAMETER_NAME), this.env.scope.owner.pkgID, frameType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable frameVariable = ASTBuilderUtil.createVariable(pos, null, frameSymbol.type, null, frameSymbol);
        BLangSimpleVarRef frameVarRef = ASTBuilderUtil.createVariableRef(pos, frameSymbol);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)TreeBuilder.createBlockFunctionBodyNode();
        if (returnNode != null) {
            if (isPassthrough) {
                returnNode.setExpression(frameVarRef);
            }
            body.addStatement(returnNode);
        }
        return this.createLambdaFunction(pos, Lists.of(frameVariable), returnType, body);
    }

    private BLangLambdaFunction createLambdaFunction(Location pos, List<BLangSimpleVariable> requiredParams, TypeNode returnType, BLangFunctionBody lambdaBody) {
        return this.desugar.createLambdaFunction(pos, "$streamLambda$", requiredParams, returnType, lambdaBody);
    }

    private BLangVariableReference getStreamFunctionVariableRef(BLangBlockStmt blockStmt, Name functionName, List<BLangExpression> requiredArgs, Location pos) {
        return this.getStreamFunctionVariableRef(blockStmt, functionName, null, requiredArgs, pos);
    }

    private BLangVariableReference getStreamFunctionVariableRef(BLangBlockStmt blockStmt, Name functionName, BType type, List<BLangExpression> requiredArgs, Location pos) {
        String name = this.getNewVarName();
        BLangInvocation queryLibInvocation = this.createQueryLibInvocation(functionName, requiredArgs, pos);
        type = type == null ? queryLibInvocation.type : type;
        BVarSymbol varSymbol = new BVarSymbol(0L, new Name(name), this.env.scope.owner.pkgID, type, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable variable = ASTBuilderUtil.createVariable(pos, name, type, this.desugar.addConversionExprIfRequired(queryLibInvocation, type), varSymbol);
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDef(pos, variable);
        blockStmt.addStatement(variableDef);
        return ASTBuilderUtil.createVariableRef(pos, variable.symbol);
    }

    private String getNewVarName() {
        return "$streamElement$_" + this.streamElementCount++;
    }

    private BLangInvocation createQueryLibInvocation(Name functionName, List<BLangExpression> requiredArgs, Location pos) {
        BInvokableSymbol symbol = this.getQueryLibInvokableSymbol(functionName);
        BLangInvocation bLangInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, symbol, requiredArgs, this.symResolver);
        bLangInvocation.type = symbol.retType;
        return bLangInvocation;
    }

    private BInvokableSymbol getQueryLibInvokableSymbol(Name functionName) {
        return (BInvokableSymbol)this.symTable.langQueryModuleSymbol.scope.lookup((Name)functionName).symbol;
    }

    private BLangStatement getAddToFrameStmt(Location pos, BLangVariableReference frame, String key, BLangExpression value) {
        BLangIdentifier valueIdentifier = ASTBuilderUtil.createIdentifier(pos, key);
        BLangFieldBasedAccess valueAccess = ASTBuilderUtil.createFieldAccessExpr(frame, valueIdentifier);
        valueAccess.pos = pos;
        valueAccess.originalType = valueAccess.type = this.symTable.anyOrErrorType;
        return ASTBuilderUtil.createAssignmentStmt(pos, valueAccess, value);
    }

    private void shadowSymbolScope(Location pos, BLangBlockFunctionBody lambdaBody, BLangSimpleVarRef frameRef, List<BVarSymbol> symbols) {
        Collections.reverse(symbols);
        for (BVarSymbol symbol : symbols) {
            this.env.scope.entries.remove(symbol.name);
            BLangStatement addToFrameStmt = this.getAddToFrameStmt(pos, frameRef, symbol.name.value, ASTBuilderUtil.createVariableRef(pos, symbol));
            lambdaBody.stmts.add(0, addToFrameStmt);
        }
    }

    private List<BVarSymbol> getIntroducedSymbols(BLangLetClause letClause) {
        ArrayList<BVarSymbol> symbols = new ArrayList<BVarSymbol>();
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            symbols.addAll(this.getIntroducedSymbols(letVariable));
        }
        return symbols;
    }

    private List<BVarSymbol> getIntroducedSymbols(BLangLetVariable variable) {
        return this.getIntroducedSymbols((BLangVariable)variable.definitionNode.getVariable());
    }

    private List<BVarSymbol> getIntroducedSymbols(BLangVariable variable) {
        if (variable != null) {
            ArrayList<BVarSymbol> symbols = new ArrayList<BVarSymbol>();
            if (variable.getKind() == NodeKind.RECORD_VARIABLE) {
                BLangRecordVariable record = (BLangRecordVariable)variable;
                for (BLangRecordVariable.BLangRecordVariableKeyValue keyValue : record.variableList) {
                    symbols.addAll(this.getIntroducedSymbols(keyValue.valueBindingPattern));
                }
                if (record.hasRestParam()) {
                    symbols.addAll(this.getIntroducedSymbols((BLangVariable)record.restParam));
                }
            } else if (variable.getKind() == NodeKind.TUPLE_VARIABLE) {
                BLangTupleVariable tuple = (BLangTupleVariable)variable;
                for (BLangVariable memberVariable : tuple.memberVariables) {
                    symbols.addAll(this.getIntroducedSymbols(memberVariable));
                }
                if (tuple.restVariable != null) {
                    symbols.addAll(this.getIntroducedSymbols(tuple.restVariable));
                }
            } else if (variable.getKind() == NodeKind.ERROR_VARIABLE) {
                BLangErrorVariable error = (BLangErrorVariable)variable;
                if (error.message != null) {
                    symbols.addAll(this.getIntroducedSymbols(error.message));
                }
                if (error.restDetail != null) {
                    symbols.addAll(this.getIntroducedSymbols(error.restDetail));
                }
                for (BLangErrorVariable.BLangErrorDetailEntry entry : error.detail) {
                    symbols.addAll(this.getIntroducedSymbols(entry.valueBindingPattern));
                }
            } else {
                symbols.add(((BLangSimpleVariable)variable).symbol);
            }
            return symbols;
        }
        return Collections.emptyList();
    }

    private BLangLambdaFunction createKeyFunction(BLangExpression expr) {
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.expr = this.desugar.addConversionExprIfRequired(expr, this.symTable.anyType);
        returnNode.pos = expr.pos;
        BLangLambdaFunction keyFunction = this.createLambdaFunction(expr.pos, this.getAnyTypeNode(), returnNode, false);
        keyFunction.accept(this);
        return keyFunction;
    }

    private BLangSimpleVarRef defineNilFrameForType(List<BVarSymbol> symbols, BLangBlockStmt blockStmt, Location pos) {
        BLangSimpleVarRef frame = this.defineFrameVariable(blockStmt, pos);
        for (BVarSymbol symbol : symbols) {
            BType type = symbol.type;
            String key = symbol.name.value;
            if (type.tag == 12 || type.tag == 33) {
                ArrayList<BVarSymbol> nestedSymbols = new ArrayList<BVarSymbol>();
                for (BField field : ((BStructureType)type).fields.values()) {
                    nestedSymbols.add(field.symbol);
                }
                this.addFrameValueToFrame(frame, key, this.defineNilFrameForType(nestedSymbols, blockStmt, pos), blockStmt, pos);
                continue;
            }
            this.addNilValueToFrame(frame, key, blockStmt, pos);
        }
        return frame;
    }

    private void addNilValueToFrame(BLangSimpleVarRef frameToAddValueTo, String key, BLangBlockStmt blockStmt, Location pos) {
        BLangStatement addToFrameStmt = this.getAddToFrameStmt(pos, frameToAddValueTo, key, ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE));
        blockStmt.addStatement(addToFrameStmt);
    }

    private void addFrameValueToFrame(BLangSimpleVarRef frameToAddValueTo, String key, BLangSimpleVarRef frameValue, BLangBlockStmt blockStmt, Location pos) {
        BLangStatement addToFrameStmt = this.getAddToFrameStmt(pos, frameToAddValueTo, key, frameValue);
        blockStmt.addStatement(addToFrameStmt);
    }

    private BLangSimpleVarRef defineFrameVariable(BLangBlockStmt blockStmt, Location pos) {
        BRecordTypeSymbol frameTypeSymbol = this.getFrameTypeSymbol();
        BRecordType frameType = (BRecordType)frameTypeSymbol.type;
        String frameName = this.getNewVarName();
        BVarSymbol frameSymbol = new BVarSymbol(0L, this.names.fromString(frameName), this.env.scope.owner.pkgID, frameType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangRecordLiteral frameInit = ASTBuilderUtil.createEmptyRecordLiteral(pos, frameType);
        BLangSimpleVariable frameVariable = ASTBuilderUtil.createVariable(pos, frameName, frameType, frameInit, frameSymbol);
        blockStmt.addStatement(ASTBuilderUtil.createVariableDef(pos, frameVariable));
        return ASTBuilderUtil.createVariableRef(pos, frameSymbol);
    }

    BLangValueType getNilTypeNode() {
        BLangValueType nilTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        nilTypeNode.typeKind = TypeKind.NIL;
        nilTypeNode.type = this.symTable.nilType;
        return nilTypeNode;
    }

    BLangValueType getAnyTypeNode() {
        BLangValueType anyTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        anyTypeNode.typeKind = TypeKind.ANY;
        anyTypeNode.type = this.symTable.anyType;
        return anyTypeNode;
    }

    BLangValueType getIntTypeNode() {
        BLangValueType intTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        intTypeNode.typeKind = TypeKind.INT;
        intTypeNode.type = this.symTable.intType;
        return intTypeNode;
    }

    BLangErrorType getErrorTypeNode() {
        BLangErrorType errorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        errorTypeNode.type = this.symTable.errorType;
        return errorTypeNode;
    }

    private BLangValueType getBooleanTypeNode() {
        BLangValueType booleanTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        booleanTypeNode.typeKind = TypeKind.BOOLEAN;
        booleanTypeNode.type = this.symTable.booleanType;
        return booleanTypeNode;
    }

    private BLangUnionTypeNode getFrameErrorNilTypeNode() {
        BType frameType = this.getFrameTypeSymbol().type;
        BUnionType unionType = BUnionType.create(null, frameType, this.symTable.errorType, this.symTable.nilType);
        BLangUnionTypeNode unionTypeNode = (BLangUnionTypeNode)TreeBuilder.createUnionTypeNode();
        unionTypeNode.type = unionType;
        unionTypeNode.memberTypeNodes.add(this.getFrameTypeNode());
        unionTypeNode.memberTypeNodes.add(this.getErrorTypeNode());
        unionTypeNode.memberTypeNodes.add(this.getNilTypeNode());
        unionTypeNode.desugared = true;
        return unionTypeNode;
    }

    private BLangUnionTypeNode getAnyErrorNilTypeNode() {
        BUnionType unionType = BUnionType.create(null, this.symTable.anyType, this.symTable.errorType, this.symTable.nilType);
        BLangUnionTypeNode unionTypeNode = (BLangUnionTypeNode)TreeBuilder.createUnionTypeNode();
        unionTypeNode.memberTypeNodes.add(this.getAnyTypeNode());
        unionTypeNode.memberTypeNodes.add(this.getErrorTypeNode());
        unionTypeNode.memberTypeNodes.add(this.getNilTypeNode());
        unionTypeNode.type = unionType;
        unionTypeNode.desugared = true;
        return unionTypeNode;
    }

    private BLangRecordTypeNode getFrameTypeNode() {
        BRecordTypeSymbol frameTypeSymbol = this.getFrameTypeSymbol();
        BRecordType frameType = (BRecordType)frameTypeSymbol.type;
        BLangUnionTypeNode restFieldType = (BLangUnionTypeNode)TreeBuilder.createUnionTypeNode();
        restFieldType.type = frameType.restFieldType;
        restFieldType.memberTypeNodes.add(this.getErrorTypeNode());
        restFieldType.memberTypeNodes.add(this.getAnyTypeNode());
        BLangRecordTypeNode frameTypeNode = (BLangRecordTypeNode)TreeBuilder.createRecordTypeNode();
        frameTypeNode.type = frameType;
        frameTypeNode.restFieldType = restFieldType;
        frameTypeNode.symbol = frameType.tsymbol;
        frameTypeNode.desugared = true;
        return frameTypeNode;
    }

    private BRecordTypeSymbol getFrameTypeSymbol() {
        return (BRecordTypeSymbol)this.symTable.langQueryModuleSymbol.scope.lookup((Name)this.names.fromString((String)"_Frame")).symbol;
    }

    @Override
    public void visit(BLangLambdaFunction lambda) {
        BLangFunction function = lambda.function;
        this.currentFrameSymbol = ((BLangSimpleVariable)function.requiredParams.get((int)0)).symbol;
        this.identifiers = new HashMap<String, BSymbol>();
        this.currentLambdaBody = (BLangBlockFunctionBody)function.getBody();
        ArrayList<BLangStatement> stmts = new ArrayList<BLangStatement>(this.currentLambdaBody.getStatements());
        stmts.forEach(stmt -> stmt.accept(this));
        this.currentFrameSymbol = null;
        this.identifiers = null;
        this.currentLambdaBody = null;
    }

    @Override
    public void visit(BLangSimpleVariableDef bLangSimpleVariableDef) {
        bLangSimpleVariableDef.getVariable().accept(this);
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        bLangRecordVariableDef.var.accept(this);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        bLangRecordVariable.variableList.forEach(v -> v.getValue().accept(this));
        if (bLangRecordVariable.expr != null) {
            bLangRecordVariable.expr.accept(this);
        }
        if (bLangRecordVariable.hasRestParam()) {
            ((BLangNode)((Object)bLangRecordVariable.restParam)).accept(this);
        }
    }

    @Override
    public void visit(BLangSimpleVariable bLangSimpleVariable) {
        this.identifiers.putIfAbsent(bLangSimpleVariable.name.value, bLangSimpleVariable.symbol);
        if (bLangSimpleVariable.expr != null) {
            bLangSimpleVariable.expr.accept(this);
        }
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        conversionExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        fieldAccessExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        exprStmtNode.expr.accept(this);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        List<BLangExpression> requiredArgs = invocationExpr.requiredArgs;
        if (invocationExpr.langLibInvocation && !requiredArgs.isEmpty()) {
            requiredArgs = requiredArgs.subList(1, requiredArgs.size());
        }
        requiredArgs.forEach(arg -> arg.accept(this));
        invocationExpr.restArgs.forEach(arg -> arg.accept(this));
        if (invocationExpr.expr != null) {
            invocationExpr.expr.accept(this);
        }
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
    }

    @Override
    public void visit(BLangReturn bLangReturn) {
        bLangReturn.expr.accept(this);
    }

    @Override
    public void visit(BLangBinaryExpr bLangBinaryExpr) {
        bLangBinaryExpr.lhsExpr.accept(this);
        bLangBinaryExpr.rhsExpr.accept(this);
    }

    @Override
    public void visit(BLangAssignment bLangAssignment) {
        bLangAssignment.varRef.accept(this);
        bLangAssignment.expr.accept(this);
    }

    @Override
    public void visit(BLangRecordLiteral bLangRecordLiteral) {
        for (RecordLiteralNode.RecordField field : bLangRecordLiteral.fields) {
            ((BLangNode)((Object)field)).accept(this);
        }
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordKeyValueField recordKeyValue) {
        recordKeyValue.key.expr.accept(this);
        recordKeyValue.valueExpr.accept(this);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOperatorField) {
        spreadOperatorField.expr.accept(this);
    }

    @Override
    public void visit(BLangConstRef constRef) {
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        varRefExpr.expressions.forEach(expression -> expression.accept(this));
        if (varRefExpr.restParam != null) {
            BLangExpression restExpr = (BLangExpression)varRefExpr.restParam;
            restExpr.accept(this);
        }
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        varRefExpr.recordRefFields.forEach(recordVarRefKeyValue -> recordVarRefKeyValue.variableReference.accept(this));
        if (varRefExpr.restParam != null) {
            BLangExpression restExpr = (BLangExpression)varRefExpr.restParam;
            restExpr.accept(this);
        }
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        if (varRefExpr.message != null) {
            varRefExpr.message.accept(this);
        }
        if (varRefExpr.restVar != null) {
            varRefExpr.restVar.accept(this);
        }
        varRefExpr.detail.forEach(bLangNamedArgsExpression -> bLangNamedArgsExpression.accept(this));
    }

    @Override
    public void visit(BLangSimpleVarRef bLangSimpleVarRef) {
        BSymbol symbol = bLangSimpleVarRef.symbol;
        BSymbol resolvedSymbol = this.symResolver.lookupClosureVarSymbol(this.env, this.names.fromIdNode(bLangSimpleVarRef.variableName), 52);
        if (symbol != null && symbol != resolvedSymbol) {
            String identifier = bLangSimpleVarRef.variableName.getValue();
            if (!FRAME_PARAMETER_NAME.equals(identifier) && !this.identifiers.containsKey(identifier)) {
                Location pos = this.currentLambdaBody.pos;
                BLangFieldBasedAccess frameAccessExpr = this.desugar.getFieldAccessExpression(pos, identifier, this.symTable.anyOrErrorType, this.currentFrameSymbol);
                frameAccessExpr.expr = this.desugar.addConversionExprIfRequired(frameAccessExpr.expr, this.types.getSafeType(frameAccessExpr.expr.type, true, false));
                if (symbol instanceof BVarSymbol) {
                    ((BVarSymbol)symbol).originalSymbol = null;
                    BLangSimpleVariable variable = ASTBuilderUtil.createVariable(pos, identifier, symbol.type, this.desugar.addConversionExprIfRequired(frameAccessExpr, symbol.type), (BVarSymbol)symbol);
                    BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDef(pos, variable);
                    this.currentLambdaBody.stmts.add(0, variableDef);
                }
                this.identifiers.put(identifier, symbol);
            }
        } else if (resolvedSymbol != this.symTable.notFoundSymbol) {
            resolvedSymbol.closure = true;
        }
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        indexAccessExpr.indexExpr.accept(this);
        indexAccessExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangTypeInit connectorInitExpr) {
        connectorInitExpr.argsExpr.forEach(arg -> arg.accept(this));
        connectorInitExpr.initInvocation.accept(this);
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocationExpr) {
        actionInvocationExpr.argExprs.forEach(arg -> arg.accept(this));
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        ternaryExpr.expr.accept(this);
        ternaryExpr.elseExpr.accept(this);
        ternaryExpr.thenExpr.accept(this);
    }

    @Override
    public void visit(BLangWaitExpr awaitExpr) {
        awaitExpr.exprList.forEach(expression -> expression.accept(this));
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        elvisExpr.lhsExpr.accept(this);
        elvisExpr.rhsExpr.accept(this);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression.accept(this);
    }

    @Override
    public void visit(BLangLetExpression letExpr) {
        letExpr.expr.accept(this);
        letExpr.letVarDeclarations.forEach(var -> ((BLangNode)((Object)var.definitionNode)).accept(this));
    }

    @Override
    public void visit(BLangLetVariable letVariable) {
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        listConstructorExpr.exprs.forEach(expression -> expression.accept(this));
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        tupleLiteral.exprs.forEach(expression -> expression.accept(this));
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        arrayLiteral.exprs.forEach(expression -> expression.accept(this));
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        unaryExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.startTagName.accept(this);
        xmlElementLiteral.endTagName.accept(this);
        xmlElementLiteral.attributes.forEach(bLangXMLAttribute -> bLangXMLAttribute.accept(this));
        xmlElementLiteral.children.forEach(child -> child.accept(this));
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        xmlTextLiteral.textFragments.forEach(fragment -> fragment.accept(this));
        if (xmlTextLiteral.concatExpr != null) {
            xmlTextLiteral.concatExpr.accept(this);
        }
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        xmlCommentLiteral.textFragments.forEach(fragment -> fragment.accept(this));
        if (xmlCommentLiteral.concatExpr != null) {
            xmlCommentLiteral.concatExpr.accept(this);
        }
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.dataFragments.forEach(fragment -> fragment.accept(this));
        if (xmlProcInsLiteral.dataConcatExpr != null) {
            xmlProcInsLiteral.dataConcatExpr.accept(this);
        }
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.textFragments.forEach(fragment -> fragment.accept(this));
        if (xmlQuotedString.concatExpr != null) {
            xmlQuotedString.concatExpr.accept(this);
        }
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        stringTemplateLiteral.exprs.forEach(expression -> expression.accept(this));
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        for (BLangLiteral str : rawTemplateLiteral.strings) {
            str.accept(this);
        }
        for (BLangExpression expr : rawTemplateLiteral.insertions) {
            expr.accept(this);
        }
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        bLangArrowFunction.params.forEach(param -> param.accept(this));
        bLangArrowFunction.function.accept(this);
        bLangArrowFunction.body.accept(this);
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        intRangeExpression.startExpr.accept(this);
        intRangeExpression.endExpr.accept(this);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        bLangVarArgsExpression.expr.accept(this);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        bLangNamedArgsExpression.expr.accept(this);
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        assignableExpr.lhsExpr.accept(this);
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
        bLangMatchExpression.expr.accept(this);
        bLangMatchExpression.patternClauses.forEach(bLangMatchExprPatternClause -> bLangMatchExpression.patternClauses.forEach(pattern -> pattern.expr.accept(this)));
        bLangMatchExpression.patternClauses.forEach(bLangMatchExprPatternClause -> bLangMatchExpression.patternClauses.forEach(pattern -> pattern.variable.accept(this)));
        bLangMatchExpression.patternClauses.forEach(bLangMatchExprPatternClause -> bLangMatchExpression.expr.accept(this));
    }

    @Override
    public void visit(BLangMatchExpression.BLangMatchExprPatternClause bLangMatchExprPatternClause) {
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        checkedExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanickedExpr) {
        checkPanickedExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        serviceConstructorExpr.serviceNode.accept(this);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangIsLikeExpr typeTestExpr) {
        typeTestExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
        bLangXMLSequenceLiteral.xmlItems.forEach(item -> item.accept(this));
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        bLangStatementExpression.expr.accept(this);
        bLangStatementExpression.stmt.accept(this);
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        if (bLangTupleVariable.restVariable != null) {
            bLangTupleVariable.restVariable.accept(this);
        }
        bLangTupleVariable.memberVariables.forEach(var -> var.accept(this));
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        if (bLangTupleVariableDef.var.restVariable != null) {
            bLangTupleVariableDef.var.restVariable.accept(this);
        }
        if (bLangTupleVariableDef.var.expr != null) {
            bLangTupleVariableDef.var.expr.accept(this);
        }
        if (bLangTupleVariableDef.var.memberVariables != null) {
            bLangTupleVariableDef.var.memberVariables.forEach(var -> var.accept(this));
        }
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        if (bLangErrorVariable.message != null) {
            bLangErrorVariable.message.accept(this);
        }
        bLangErrorVariable.detail.forEach(var -> var.valueBindingPattern.accept(this));
        if (bLangErrorVariable.restDetail != null) {
            bLangErrorVariable.restDetail.accept(this);
        }
        if (bLangErrorVariable.detailExpr != null) {
            bLangErrorVariable.detailExpr.accept(this);
        }
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        bLangErrorVariableDef.errorVariable.accept(this);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause bLangMatchStmtStaticBindingPatternClause) {
        bLangMatchStmtStaticBindingPatternClause.literal.accept(this);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause bLangMatchStmtStructuredBindingPatternClause) {
        if (bLangMatchStmtStructuredBindingPatternClause.bindingPatternVariable != null) {
            bLangMatchStmtStructuredBindingPatternClause.bindingPatternVariable.accept(this);
        }
        if (bLangMatchStmtStructuredBindingPatternClause.typeGuardExpr != null) {
            bLangMatchStmtStructuredBindingPatternClause.typeGuardExpr.accept(this);
        }
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        waitForAllExpr.keyValuePairs.forEach(pair -> pair.accept(this));
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
    }

    @Override
    public void visit(BLangMarkdownReferenceDocumentation bLangMarkdownReferenceDocumentation) {
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitKeyValue waitKeyValue) {
        waitKeyValue.key.accept(this);
        waitKeyValue.valueExpr.accept(this);
    }

    @Override
    public void visit(BLangXMLElementFilter xmlElementFilter) {
        if (xmlElementFilter.impConversionExpr != null) {
            xmlElementFilter.impConversionExpr.expr.accept(this);
        }
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        xmlElementAccess.expr.accept(this);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        xmlNavigation.expr.accept(this);
        if (xmlNavigation.childIndex != null) {
            xmlNavigation.childIndex.accept(this);
        }
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        blockNode.stmts.forEach(statement -> statement.accept(this));
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmtNode) {
        lockStmtNode.body.accept(this);
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
        unLockNode.body.accept(this);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        if (compoundAssignNode.expr != null) {
            compoundAssignNode.expr.accept(this);
        }
        if (compoundAssignNode.modifiedExpr != null) {
            compoundAssignNode.modifiedExpr.accept(this);
        }
        if (compoundAssignNode.varRef != null) {
            compoundAssignNode.varRef.accept(this);
        }
    }

    @Override
    public void visit(BLangRetry retryNode) {
    }

    @Override
    public void visit(BLangContinue continueNode) {
    }

    @Override
    public void visit(BLangBreak breakNode) {
    }

    @Override
    public void visit(BLangThrow throwNode) {
        throwNode.expr.accept(this);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr.accept(this);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl.accept(this);
    }

    @Override
    public void visit(BLangIf ifNode) {
        ifNode.expr.accept(this);
        ifNode.body.accept(this);
        if (ifNode.elseStmt != null) {
            ifNode.elseStmt.accept(this);
        }
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
    }

    @Override
    public void visit(BLangMatch matchNode) {
        matchNode.expr.accept(this);
        matchNode.patternClauses.forEach(pattern -> pattern.accept(this));
    }

    @Override
    public void visit(BLangMatch.BLangMatchTypedBindingPatternClause patternClauseNode) {
        patternClauseNode.body.accept(this);
        patternClauseNode.matchExpr.accept(this);
        patternClauseNode.variable.accept(this);
    }

    @Override
    public void visit(BLangForeach foreach) {
        throw new AssertionError();
    }

    @Override
    public void visit(BLangFromClause fromClause) {
    }

    @Override
    public void visit(BLangLetClause letClause) {
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
    }

    @Override
    public void visit(BLangDoClause doClause) {
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
    }

    @Override
    public void visit(BLangWhile whileNode) {
        whileNode.expr.accept(this);
        whileNode.body.accept(this);
    }

    @Override
    public void visit(BLangLock lockNode) {
        lockNode.body.accept(this);
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        transactionNode.transactionBody.accept(this);
    }

    @Override
    public void visit(BLangTryCatchFinally tryNode) {
        tryNode.tryBody.accept(this);
        tryNode.catchBlocks.forEach(block -> block.accept(this));
        if (tryNode.finallyBody != null) {
            tryNode.finallyBody.accept(this);
        }
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        stmt.varRef.accept(this);
        stmt.expr.accept(this);
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        stmt.expr.accept(this);
        stmt.varRef.accept(this);
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        stmt.expr.accept(this);
        stmt.varRef.accept(this);
    }

    @Override
    public void visit(BLangCatch catchNode) {
        catchNode.param.accept(this);
        catchNode.body.accept(this);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        forkJoin.workers.forEach(worker -> worker.accept(this));
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        workerSendNode.expr.accept(this);
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        workerReceiveNode.sendExpression.accept(this);
    }
}

