/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstructorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Lists;

public class TransactionDesugar
extends BLangNodeVisitor {
    private static final CompilerContext.Key<TransactionDesugar> TRANSACTION_DESUGAR_KEY = new CompilerContext.Key();
    private static final String SHOULD_CLEANUP_SYMBOL = "$shouldCleanUp$";
    private final Desugar desugar;
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final Names names;
    private final PackageCache packageCache;
    private BSymbol transactionError;
    private BLangExpression retryStmt;
    private SymbolEnv env;
    private BLangExpression transactionBlockID;
    private BLangExpression transactionID;
    private BLangSimpleVarRef prevAttemptInfoRef;
    private BLangSimpleVarRef shouldCleanUpVariableRef;
    private String uniqueId;
    private int transactionBlockCount;
    private boolean transactionInternalModuleIncluded = false;
    private BLangStatementExpression result;
    private boolean onFailHandled;

    private TransactionDesugar(CompilerContext context) {
        context.put(TRANSACTION_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.desugar = Desugar.getInstance(context);
        this.packageCache = PackageCache.getInstance(context);
    }

    public static TransactionDesugar getInstance(CompilerContext context) {
        TransactionDesugar desugar = context.get(TRANSACTION_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new TransactionDesugar(context);
        }
        return desugar;
    }

    public BLangStatementExpression rewrite(BLangNode node, SymbolEnv env, boolean nestedTrxOnFailHandled) {
        this.onFailHandled = nestedTrxOnFailHandled;
        String id = this.uniqueId;
        BLangExpression trxId = this.transactionID;
        BLangExpression trxBlockId = this.transactionBlockID;
        BLangSimpleVarRef attemptVarRef = this.prevAttemptInfoRef;
        BLangSimpleVarRef prevShouldCleanUp = this.shouldCleanUpVariableRef;
        BLangExpression retryStmt = this.retryStmt;
        BSymbol errorSymbol = this.transactionError;
        SymbolEnv symbolEnv = this.env;
        this.env = env;
        node.accept(this);
        this.uniqueId = id;
        this.transactionID = trxId;
        this.transactionBlockID = trxBlockId;
        this.prevAttemptInfoRef = attemptVarRef;
        this.shouldCleanUpVariableRef = prevShouldCleanUp;
        this.retryStmt = retryStmt;
        this.transactionError = errorSymbol;
        this.env = symbolEnv;
        return this.result;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        Location pos = transactionNode.pos;
        BLangBlockStmt transactionBlockStmt = this.desugarTransactionBody(transactionNode, this.env, false, pos);
        BLangSimpleVarRef resultRef = ASTBuilderUtil.createVariableRef(transactionNode.pos, this.transactionError);
        if (transactionNode.statementBlockReturns) {
            BLangInvokableNode encInvokable = this.env.enclInvokable;
            this.result = ASTBuilderUtil.createStatementExpression(transactionBlockStmt, this.desugar.addConversionExprIfRequired(resultRef, encInvokable.returnTypeNode.type));
        } else {
            this.result = ASTBuilderUtil.createStatementExpression(transactionBlockStmt, ASTBuilderUtil.createLiteral(transactionNode.pos, this.symTable.nilType, Names.NIL_VALUE));
        }
    }

    private BLangBlockStmt desugarTransactionBody(BLangTransaction transactionNode, SymbolEnv env, boolean shouldRetry, Location pos) {
        BLangBlockStmt transactionBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        this.uniqueId = String.valueOf(++this.transactionBlockCount);
        BLangLiteral transactionBlockIDLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, this.uniqueId);
        BType transactionBlockIDType = this.symTable.stringType;
        BVarSymbol transactionBlockIDVarSymbol = new BVarSymbol(0L, new Name("transactionBlockId" + this.uniqueId), env.scope.owner.pkgID, transactionBlockIDType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable transactionBlockIDVariable = ASTBuilderUtil.createVariable(pos, "transactionBlockId" + this.uniqueId, transactionBlockIDType, transactionBlockIDLiteral, transactionBlockIDVarSymbol);
        transactionBlockIDVariable.symbol.closure = true;
        BLangSimpleVariableDef transactionBlockIDVariableDef = ASTBuilderUtil.createVariableDef(pos, transactionBlockIDVariable);
        transactionBlockStmt.stmts.add(transactionBlockIDVariableDef);
        BVarSymbol shouldCleanUpSymbol = new BVarSymbol(0L, new Name("$shouldCleanUp$_" + this.uniqueId), env.scope.owner.pkgID, this.symTable.booleanType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable shouldCleanUpVariable = ASTBuilderUtil.createVariable(pos, "$shouldCleanUp$_" + this.uniqueId, this.symTable.booleanType, ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, false), shouldCleanUpSymbol);
        shouldCleanUpVariable.symbol.closure = true;
        BLangSimpleVariableDef shouldCleanUpVariableDef = ASTBuilderUtil.createVariableDef(pos, shouldCleanUpVariable);
        transactionBlockStmt.stmts.add(shouldCleanUpVariableDef);
        this.shouldCleanUpVariableRef = ASTBuilderUtil.createVariableRef(pos, shouldCleanUpVariable.symbol);
        BLangSimpleVariableDef prevAttemptVarDef = this.createPrevAttemptInfoVarDef(env, pos);
        transactionBlockStmt.stmts.add(prevAttemptVarDef);
        this.prevAttemptInfoRef = ASTBuilderUtil.createVariableRef(pos, prevAttemptVarDef.var.symbol);
        this.transactionBlockID = ASTBuilderUtil.createVariableRef(pos, transactionBlockIDVariable.symbol);
        BType transactionIDType = this.symTable.stringType;
        BVarSymbol transactionIDVarSymbol = new BVarSymbol(0L, new Name("transactionId" + this.uniqueId), env.scope.owner.pkgID, transactionIDType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable transactionIDVariable = ASTBuilderUtil.createVariable(pos, "transactionId" + this.uniqueId, transactionIDType, ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, ""), transactionIDVarSymbol);
        BLangSimpleVariableDef transactionIDVariableDef = ASTBuilderUtil.createVariableDef(pos, transactionIDVariable);
        transactionBlockStmt.stmts.add(transactionIDVariableDef);
        this.transactionID = ASTBuilderUtil.createVariableRef(pos, transactionIDVariable.symbol);
        transactionIDVariable.symbol.closure = true;
        env.scope.define(transactionBlockIDVarSymbol.name, transactionBlockIDVarSymbol);
        env.scope.define(transactionIDVarSymbol.name, transactionIDVarSymbol);
        env.scope.define(prevAttemptVarDef.var.symbol.name, prevAttemptVarDef.var.symbol);
        env.scope.define(shouldCleanUpVariable.symbol.name, shouldCleanUpVariable.symbol);
        BLangType transactionReturnType = ASTBuilderUtil.createTypeNode(this.symTable.anyOrErrorType);
        BLangSimpleVariable trxMainFuncParamPrevAttempt = this.createPrevAttemptVariable(env, pos);
        BLangLambdaFunction trxMainFunc = this.desugar.createLambdaFunction(transactionNode.pos, "$trxFunc$", Lists.of(trxMainFuncParamPrevAttempt), transactionReturnType, transactionNode.transactionBody.stmts, env, transactionNode.transactionBody.scope);
        ((BLangBlockFunctionBody)trxMainFunc.function.body).isBreakable = this.onFailHandled;
        BLangInvocation startTransactionInvocation = this.createStartTransactionInvocation(pos, transactionBlockIDLiteral, ASTBuilderUtil.createVariableRef(pos, trxMainFuncParamPrevAttempt.symbol));
        BLangAssignment startTrxAssignment = ASTBuilderUtil.createAssignmentStmt(pos, ASTBuilderUtil.createVariableRef(pos, transactionIDVarSymbol), startTransactionInvocation);
        BLangAssignment infoAssignment = this.createPrevAttemptInfoInvocation(pos);
        ((BLangBlockFunctionBody)trxMainFunc.function.body).stmts.add(0, startTrxAssignment);
        ((BLangBlockFunctionBody)trxMainFunc.function.body).stmts.add(1, infoAssignment);
        BVarSymbol transactionVarSymbol = new BVarSymbol(0L, this.names.fromString("$trxFunc$"), env.scope.owner.pkgID, trxMainFunc.type, trxMainFunc.function.symbol, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable transactionLambdaVariable = ASTBuilderUtil.createVariable(pos, "trxFunc", trxMainFunc.type, trxMainFunc, transactionVarSymbol);
        BLangSimpleVariableDef transactionLambdaVariableDef = ASTBuilderUtil.createVariableDef(pos, transactionLambdaVariable);
        BLangSimpleVarRef.BLangLocalVarRef transactionLambdaVarRef = new BLangSimpleVarRef.BLangLocalVarRef(transactionLambdaVariable.symbol);
        transactionLambdaVarRef.type = transactionLambdaVariable.symbol.type;
        transactionBlockStmt.stmts.add(transactionLambdaVariableDef);
        BLangInvocation.BFunctionPointerInvocation transactionLambdaInvocation = new BLangInvocation.BFunctionPointerInvocation(pos, transactionLambdaVarRef, transactionLambdaVariable.symbol, this.symTable.anyOrErrorType);
        transactionLambdaInvocation.argExprs = Lists.of(this.desugar.rewrite(this.prevAttemptInfoRef, env));
        transactionLambdaInvocation.requiredArgs = transactionLambdaInvocation.argExprs;
        trxMainFunc.capturedClosureEnv = env;
        BVarSymbol resultSymbol = new BVarSymbol(0L, new Name("result" + this.uniqueId), env.scope.owner.pkgID, this.symTable.anyOrErrorType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable resultVariable = ASTBuilderUtil.createVariable(pos, "result" + this.uniqueId, this.symTable.anyOrErrorType, transactionLambdaInvocation, resultSymbol);
        BLangSimpleVariableDef trxFuncVarDef = ASTBuilderUtil.createVariableDef(pos, resultVariable);
        this.transactionError = resultSymbol;
        if (shouldRetry) {
            this.retryStmt = transactionLambdaInvocation;
        }
        transactionBlockStmt.stmts.add(trxFuncVarDef);
        BLangIf cleanValidationIf = ASTBuilderUtil.createIfStmt(pos, transactionBlockStmt);
        BLangGroupExpr cleanValidationGroupExpr = new BLangGroupExpr();
        cleanValidationGroupExpr.expression = ASTBuilderUtil.createVariableRef(pos, shouldCleanUpVariable.symbol);
        cleanValidationIf.expr = cleanValidationGroupExpr;
        cleanValidationIf.body = ASTBuilderUtil.createBlockStmt(pos);
        BLangExpressionStmt stmt = ASTBuilderUtil.createExpressionStmt(pos, cleanValidationIf.body);
        stmt.expr = this.createCleanupTrxStmt(pos);
        this.createRollbackIfFailed(transactionNode.pos, transactionBlockStmt, resultSymbol);
        return transactionBlockStmt;
    }

    private BLangAssignment createPrevAttemptInfoInvocation(Location pos) {
        BInvokableSymbol transactionInfoInvokableSymbol = (BInvokableSymbol)this.getTransactionLibInvokableSymbol(Names.CURRENT_TRANSACTION_INFO);
        BLangInvocation infoInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, transactionInfoInvokableSymbol, new ArrayList<BLangExpression>(), this.symResolver);
        infoInvocation.argExprs = infoInvocation.requiredArgs;
        return ASTBuilderUtil.createAssignmentStmt(pos, this.prevAttemptInfoRef, infoInvocation);
    }

    private BLangInvocation createStartTransactionInvocation(Location location, BLangLiteral transactionBlockIDLiteral, BLangSimpleVarRef prevAttempt) {
        BInvokableSymbol startTransactionInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.START_TRANSACTION);
        if (!this.transactionInternalModuleIncluded) {
            this.desugar.addTransactionInternalModuleImport();
            this.transactionInternalModuleIncluded = true;
        }
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(transactionBlockIDLiteral);
        args.add(prevAttempt);
        BLangInvocation startTransactionInvocation = ASTBuilderUtil.createInvocationExprForMethod(location, startTransactionInvokableSymbol, args, this.symResolver);
        startTransactionInvocation.argExprs = args;
        return startTransactionInvocation;
    }

    public BLangInvocation createTransactionalCheckInvocation(Location pos) {
        BInvokableSymbol startTransactionInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.CHECK_IF_TRANSACTIONAL);
        if (!this.transactionInternalModuleIncluded) {
            this.desugar.addTransactionInternalModuleImport();
            this.transactionInternalModuleIncluded = true;
        }
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        BLangInvocation startTransactionInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, startTransactionInvokableSymbol, args, this.symResolver);
        startTransactionInvocation.argExprs = args;
        return startTransactionInvocation;
    }

    private BLangSimpleVariableDef createPrevAttemptInfoVarDef(SymbolEnv env, Location pos) {
        BLangLiteral nilLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE);
        BLangSimpleVariable prevAttemptVariable = this.createPrevAttemptVariable(env, pos);
        prevAttemptVariable.expr = nilLiteral;
        return ASTBuilderUtil.createVariableDef(pos, prevAttemptVariable);
    }

    private BLangSimpleVariable createPrevAttemptVariable(SymbolEnv env, Location pos) {
        BSymbol infoRecordSymbol = this.symResolver.lookupSymbolInMainSpace(this.symTable.pkgEnvMap.get(this.symTable.langTransactionModuleSymbol), Names.TRANSACTION_INFO_RECORD);
        BUnionType infoRecordType = BUnionType.create(null, infoRecordSymbol.type, this.symTable.nilType);
        BVarSymbol prevAttemptVarSymbol = new BVarSymbol(0L, new Name("prevAttempt" + this.uniqueId), env.scope.owner.pkgID, infoRecordType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        prevAttemptVarSymbol.closure = true;
        return ASTBuilderUtil.createVariable(pos, "prevAttempt" + this.uniqueId, infoRecordType, null, prevAttemptVarSymbol);
    }

    private void createRollbackIfFailed(Location pos, BLangBlockStmt transactionBlockStmt, BSymbol trxFuncResultSymbol) {
        BLangIf rollbackCheck = ASTBuilderUtil.createIfStmt(pos, transactionBlockStmt);
        BConstructorSymbol transactionErrorSymbol = (BConstructorSymbol)this.symTable.langTransactionModuleSymbol.scope.lookup((Name)this.names.fromString((String)"TransactionError")).symbol;
        BType errorType = transactionErrorSymbol.type;
        BLangErrorType trxErrorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        trxErrorTypeNode.type = errorType;
        BLangSimpleVarRef result = ASTBuilderUtil.createVariableRef(pos, trxFuncResultSymbol);
        BLangTypeTestExpr testExpr = ASTBuilderUtil.createTypeTestExpr(pos, result, trxErrorTypeNode);
        testExpr.type = this.symTable.booleanType;
        BLangGroupExpr transactionErrorCheckGroupExpr = new BLangGroupExpr();
        transactionErrorCheckGroupExpr.type = this.symTable.booleanType;
        BOperatorSymbol notOperatorSymbol = new BOperatorSymbol(this.names.fromString(OperatorKind.NOT.value()), this.symTable.rootPkgSymbol.pkgID, errorType, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        transactionErrorCheckGroupExpr.expression = ASTBuilderUtil.createUnaryExpr(pos, testExpr, this.symTable.booleanType, OperatorKind.NOT, notOperatorSymbol);
        BLangTypeTestExpr errorCheck = this.desugar.createTypeCheckExpr(pos, result, this.desugar.getErrorTypeNode());
        rollbackCheck.expr = ASTBuilderUtil.createBinaryExpr(pos, errorCheck, transactionErrorCheckGroupExpr, this.symTable.booleanType, OperatorKind.AND, null);
        BLangRollback rollbackStmt = (BLangRollback)TreeBuilder.createRollbackNode();
        rollbackStmt.expr = this.desugar.addConversionExprIfRequired(result, this.symTable.errorOrNilType);
        rollbackCheck.body = ASTBuilderUtil.createBlockStmt(pos);
        rollbackCheck.body.stmts.add(this.desugar.rewrite(rollbackStmt, this.env));
    }

    private BLangInvocation createCleanupTrxStmt(Location pos) {
        BInvokableSymbol cleanupTrxInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.CLEAN_UP_TRANSACTION);
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(this.transactionBlockID);
        BLangInvocation cleanupTrxInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, cleanupTrxInvokableSymbol, args, this.symResolver);
        cleanupTrxInvocation.argExprs = args;
        return cleanupTrxInvocation;
    }

    BLangStatementExpression desugar(BLangRollback rollbackNode) {
        Location pos = rollbackNode.pos;
        BLangBlockStmt rollbackBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        BInvokableSymbol rollbackTransactionInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.ROLLBACK_TRANSACTION);
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(this.transactionBlockID);
        if (rollbackNode.expr != null) {
            args.add(rollbackNode.expr);
        }
        BLangInvocation rollbackTransactionInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, rollbackTransactionInvokableSymbol, args, this.symResolver);
        rollbackTransactionInvocation.argExprs = args;
        BLangExpressionStmt rollbackStmt = ASTBuilderUtil.createExpressionStmt(pos, rollbackBlockStmt);
        rollbackStmt.expr = rollbackTransactionInvocation;
        BLangAssignment shouldCleanUpStmt = ASTBuilderUtil.createAssignmentStmt(pos, this.shouldCleanUpVariableRef, ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true));
        rollbackBlockStmt.addStatement(shouldCleanUpStmt);
        BLangStatementExpression rollbackStmtExpr = ASTBuilderUtil.createStatementExpression(rollbackBlockStmt, ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE));
        rollbackStmtExpr.type = this.symTable.nilType;
        return rollbackStmtExpr;
    }

    BLangStatementExpression desugar(BLangCommitExpr commitExpr, SymbolEnv env) {
        Location pos = commitExpr.pos;
        BLangBlockStmt commitBlockStatement = ASTBuilderUtil.createBlockStmt(pos);
        BLangSimpleVariableDef outputVariableDef = this.createCommitResultVarDef(env, pos);
        BLangSimpleVarRef outputVarRef = ASTBuilderUtil.createVariableRef(pos, outputVariableDef.var.symbol);
        commitBlockStatement.addStatement(outputVariableDef);
        BInvokableSymbol transactionCleanerInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.GET_AND_CLEAR_FAILURE_TRANSACTION);
        BLangInvocation transactionCleanerInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, transactionCleanerInvokableSymbol, new ArrayList<BLangExpression>(), this.symResolver);
        transactionCleanerInvocation.argExprs = new ArrayList<BLangExpression>();
        BVarSymbol isTransactionFailedVarSymbol = new BVarSymbol(0L, new Name("isFailed"), env.scope.owner.pkgID, this.symTable.booleanType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable isTransactionFailedVariable = ASTBuilderUtil.createVariable(pos, "isFailed", this.symTable.booleanType, transactionCleanerInvocation, isTransactionFailedVarSymbol);
        BLangSimpleVariableDef isTransactionFailedVariableDef = ASTBuilderUtil.createVariableDef(pos, isTransactionFailedVariable);
        commitBlockStatement.addStatement(isTransactionFailedVariableDef);
        BLangBlockStmt failureHandlerBlockStatement = ASTBuilderUtil.createBlockStmt(pos);
        BInvokableSymbol commitTransactionInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.END_TRANSACTION);
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(this.transactionID);
        args.add(this.transactionBlockID);
        BLangInvocation commitTransactionInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, commitTransactionInvokableSymbol, args, this.symResolver);
        commitTransactionInvocation.argExprs = args;
        BUnionType commitReturnType = BUnionType.create(null, this.symTable.stringType, this.symTable.errorType);
        BVarSymbol commitTransactionVarSymbol = new BVarSymbol(0L, new Name("commitResult"), env.scope.owner.pkgID, commitReturnType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable commitResultVariable = ASTBuilderUtil.createVariable(pos, "commitResult", commitReturnType, commitTransactionInvocation, commitTransactionVarSymbol);
        BLangSimpleVariableDef commitResultVariableDef = ASTBuilderUtil.createVariableDef(pos, commitResultVariable);
        BLangSimpleVarRef commitResultVarRef = ASTBuilderUtil.createVariableRef(pos, commitResultVariable.symbol);
        failureHandlerBlockStatement.addStatement(commitResultVariableDef);
        BLangIf commitResultValidationIf = ASTBuilderUtil.createIfStmt(pos, failureHandlerBlockStatement);
        BLangGroupExpr commitResultValidationGroupExpr = new BLangGroupExpr();
        commitResultValidationGroupExpr.type = this.symTable.booleanType;
        BLangValueType stringType = (BLangValueType)TreeBuilder.createValueTypeNode();
        stringType.type = this.symTable.stringType;
        stringType.typeKind = TypeKind.STRING;
        commitResultValidationGroupExpr.expression = ASTBuilderUtil.createTypeTestExpr(pos, commitResultVarRef, stringType);
        commitResultValidationIf.expr = commitResultValidationGroupExpr;
        commitResultValidationIf.body = ASTBuilderUtil.createBlockStmt(pos);
        BLangAssignment shouldCleanUpStmt = ASTBuilderUtil.createAssignmentStmt(pos, this.shouldCleanUpVariableRef, ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true));
        commitResultValidationIf.body.addStatement(shouldCleanUpStmt);
        commitResultValidationIf.elseStmt = ASTBuilderUtil.createAssignmentStmt(pos, outputVarRef, commitResultVarRef);
        BLangIf failureValidationIf = ASTBuilderUtil.createIfStmt(pos, commitBlockStatement);
        BLangGroupExpr failureValidationGroupExpr = new BLangGroupExpr();
        failureValidationGroupExpr.type = this.symTable.booleanType;
        BLangSimpleVarRef failureValidationExprVarRef = ASTBuilderUtil.createVariableRef(pos, isTransactionFailedVariable.symbol);
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        paramTypes.add(this.symTable.booleanType);
        BInvokableType type = new BInvokableType(paramTypes, this.symTable.booleanType, null);
        BOperatorSymbol notOperatorSymbol = new BOperatorSymbol(this.names.fromString(OperatorKind.NOT.value()), this.symTable.rootPkgSymbol.pkgID, type, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        failureValidationGroupExpr.expression = ASTBuilderUtil.createUnaryExpr(pos, failureValidationExprVarRef, this.symTable.booleanType, OperatorKind.NOT, notOperatorSymbol);
        failureValidationIf.expr = failureValidationGroupExpr;
        failureValidationIf.body = failureHandlerBlockStatement;
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(commitBlockStatement, outputVarRef);
        stmtExpr.type = this.symTable.errorOrNilType;
        return stmtExpr;
    }

    private BLangSimpleVariableDef createCommitResultVarDef(SymbolEnv env, Location pos) {
        BLangLiteral nilLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE);
        BVarSymbol outputVarSymbol = new BVarSymbol(0L, new Name("$outputVar$"), env.scope.owner.pkgID, this.symTable.errorOrNilType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable outputVariable = ASTBuilderUtil.createVariable(pos, "$outputVar$", this.symTable.errorOrNilType, nilLiteral, outputVarSymbol);
        return ASTBuilderUtil.createVariableDef(pos, outputVariable);
    }

    @Override
    public void visit(BLangRetryTransaction retryTrxBlock) {
        BLangBlockStmt blockStmt = this.desugarTransactionBody(retryTrxBlock.transaction, this.env, true, retryTrxBlock.pos);
        BLangSimpleVarRef resultRef = ASTBuilderUtil.createVariableRef(retryTrxBlock.pos, this.transactionError);
        BLangSimpleVariableDef retryMgrDef = this.desugar.createRetryManagerDef(retryTrxBlock.retrySpec, retryTrxBlock.pos);
        BLangTypeTestExpr isErrorCheck = this.desugar.createTypeCheckExpr(retryTrxBlock.pos, resultRef, this.desugar.getErrorTypeNode());
        BLangIf ifStmt = ASTBuilderUtil.createIfStmt(retryTrxBlock.pos, blockStmt);
        ifStmt.expr = isErrorCheck;
        ifStmt.body = ASTBuilderUtil.createBlockStmt(retryTrxBlock.pos);
        ifStmt.body.stmts.add(retryMgrDef);
        BLangWhile retryWhileLoop = this.desugar.createRetryWhileLoop(retryTrxBlock.pos, retryMgrDef, this.retryStmt, resultRef);
        this.createRollbackIfFailed(retryTrxBlock.pos, retryWhileLoop.body, resultRef.symbol);
        ifStmt.body.stmts.add(retryWhileLoop);
        this.desugar.createErrorReturn(retryTrxBlock.pos, blockStmt, resultRef);
        if (retryTrxBlock.transaction.statementBlockReturns) {
            BLangInvokableNode encInvokable = this.env.enclInvokable;
            this.result = ASTBuilderUtil.createStatementExpression(blockStmt, this.desugar.addConversionExprIfRequired(resultRef, encInvokable.returnTypeNode.type));
        } else {
            this.result = ASTBuilderUtil.createStatementExpression(blockStmt, ASTBuilderUtil.createLiteral(retryTrxBlock.pos, this.symTable.nilType, Names.NIL_VALUE));
        }
    }

    public BSymbol getTransactionLibInvokableSymbol(Name name) {
        return this.symTable.langTransactionModuleSymbol.scope.lookup((Name)name).symbol;
    }

    public BSymbol getInternalTransactionModuleInvokableSymbol(Name name) {
        if (this.symTable.internalTransactionModuleSymbol == null) {
            this.symTable.internalTransactionModuleSymbol = this.packageCache.getSymbol(PackageID.TRANSACTION_INTERNAL);
        }
        return this.symTable.internalTransactionModuleSymbol.scope.lookup((Name)name).symbol;
    }
}

