/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.diagnostic;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;

public class BLangDiagnostic
extends Diagnostic {
    private Location location;
    private String msg;
    private DiagnosticInfo diagnosticInfo;
    private DiagnosticCode diagnosticCode;

    public BLangDiagnostic(Location location, String msg, DiagnosticInfo diagnosticInfo) {
        this.location = location;
        this.msg = msg;
        this.diagnosticInfo = diagnosticInfo;
        this.diagnosticCode = null;
    }

    public BLangDiagnostic(Location location, String msg, DiagnosticInfo diagnosticInfo, DiagnosticCode diagnosticCode) {
        this.location = location;
        this.msg = msg;
        this.diagnosticInfo = diagnosticInfo;
        this.diagnosticCode = diagnosticCode;
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public DiagnosticInfo diagnosticInfo() {
        return this.diagnosticInfo;
    }

    @Override
    public String message() {
        return this.msg;
    }

    public DiagnosticCode getCode() {
        return this.diagnosticCode;
    }

    @Override
    public String toString() {
        return this.diagnosticInfo.severity() + " [" + this.location.lineRange().filePath() + ":" + this.location + "] " + this.msg;
    }
}

