/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.diagnostic;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnostic;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BLangDiagnosticLog
implements DiagnosticLog {
    private static final CompilerContext.Key<BLangDiagnosticLog> DIAGNOSTIC_LOG_KEY = new CompilerContext.Key();
    private static final String ERROR_PREFIX = "error";
    private static final String WARNING_PREFIX = "warning";
    private static final String NOTE_PREFIX = "note";
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("compiler", Locale.getDefault());
    private int errorCount = 0;
    private PackageCache packageCache;
    private PackageID currentPackageId;
    private boolean isMute = false;

    private BLangDiagnosticLog(CompilerContext context) {
        context.put(DIAGNOSTIC_LOG_KEY, this);
        this.packageCache = PackageCache.getInstance(context);
    }

    public static BLangDiagnosticLog getInstance(CompilerContext context) {
        BLangDiagnosticLog dLogger = context.get(DIAGNOSTIC_LOG_KEY);
        if (dLogger == null) {
            dLogger = new BLangDiagnosticLog(context);
        }
        return dLogger;
    }

    public void setCurrentPackageId(PackageID packageID) {
        this.currentPackageId = packageID;
    }

    public void error(Location location, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(ERROR_PREFIX, code, args);
        this.reportDiagnostic(null, code, location, msg, DiagnosticSeverity.ERROR);
    }

    public void warning(Location location, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(WARNING_PREFIX, code, args);
        this.reportDiagnostic(null, code, location, msg, DiagnosticSeverity.WARNING);
    }

    public void note(Location location, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(NOTE_PREFIX, code, args);
        this.reportDiagnostic(null, code, location, msg, DiagnosticSeverity.INFO);
    }

    public int errorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void resetErrorCount() {
        this.errorCount = 0;
    }

    public void mute() {
        this.isMute = true;
    }

    public void unmute() {
        this.isMute = false;
    }

    @Override
    @Deprecated
    public void logDiagnostic(DiagnosticSeverity severity, Location location, CharSequence message) {
        this.reportDiagnostic(null, null, location, message.toString(), severity);
    }

    @Override
    public void logDiagnostic(DiagnosticSeverity severity, PackageID pkgId, Location location, CharSequence message) {
        this.reportDiagnostic(pkgId, null, location, message.toString(), severity);
    }

    public void logDiagnostic(PackageID pkgId, Diagnostic diagnostic) {
        if (diagnostic.diagnosticInfo().severity() == DiagnosticSeverity.ERROR) {
            ++this.errorCount;
        }
        this.storeDiagnosticInModule(pkgId, diagnostic);
    }

    private String formatMessage(String prefix, DiagnosticCode code, Object[] args) {
        String msgKey = MESSAGES.getString(prefix + "." + code.messageKey());
        return MessageFormat.format(msgKey, args);
    }

    private void reportDiagnostic(PackageID packageID, DiagnosticCode diagnosticCode, Location location, String msg, DiagnosticSeverity severity) {
        if (severity == DiagnosticSeverity.ERROR) {
            ++this.errorCount;
        }
        if (this.isMute) {
            return;
        }
        DiagnosticInfo diagInfo = diagnosticCode != null ? new DiagnosticInfo(diagnosticCode.diagnosticId(), diagnosticCode.messageKey(), diagnosticCode.severity()) : new DiagnosticInfo(null, msg, severity);
        BLangDiagnostic diagnostic = new BLangDiagnostic(location, msg, diagInfo, diagnosticCode);
        if (packageID != null) {
            this.storeDiagnosticInModule(packageID, diagnostic);
        } else {
            this.storeDiagnosticInModule(this.currentPackageId, diagnostic);
        }
    }

    private void storeDiagnosticInModule(PackageID pkgId, Diagnostic diagnostic) {
        BLangPackage pkgNode = this.packageCache.get(pkgId);
        pkgNode.addDiagnostic(diagnostic);
    }
}

