/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.converters;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

class FilterSearch
extends SimpleFileVisitor {
    private final List<Path> excludeDir;
    private List<Path> pathList = new ArrayList<Path>();

    FilterSearch(List<Path> exclude) {
        this.excludeDir = exclude;
    }

    @Override
    public FileVisitResult preVisitDirectory(Object dir2, BasicFileAttributes attrs) throws IOException {
        if (!this.isExcluded((Path)dir2)) {
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Object file, BasicFileAttributes attrs) throws IOException {
        if (this.isBal((Path)file, Files.readAttributes((Path)file, BasicFileAttributes.class, new LinkOption[0]))) {
            this.pathList.add((Path)file);
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean isExcluded(Path path) {
        Path name = path.getFileName();
        return name != null && this.excludeDir.contains(name);
    }

    private boolean isBal(Path path, BasicFileAttributes attributes) {
        Path fileName = path.getFileName();
        return attributes.isRegularFile() && fileName != null && fileName.toString().endsWith(".bal");
    }

    public List<Path> getPathList() {
        return this.pathList;
    }
}

