/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class BLangAnonymousModelHelper {
    private Map<PackageID, Integer> anonTypeCount;
    private Map<PackageID, Integer> anonServiceCount;
    private Map<PackageID, Integer> anonFunctionCount;
    private Map<PackageID, Integer> anonForkCount;
    private Map<PackageID, Integer> errorTypeIdCount;
    private Map<PackageID, Integer> rawTemplateTypeCount;
    private static final String ANON_TYPE = "$anonType$";
    public static final String LAMBDA = "$lambda$";
    private static final String SERVICE = "$$service$";
    private static final String ANON_SERVICE = "$anonService$";
    private static final String BUILTIN_ANON_TYPE = "$anonType$builtin$";
    private static final String BUILTIN_LAMBDA = "$lambda$builtin$";
    private static final String FORK = "$fork$";
    private static final String ANON_TYPE_ID = "$anonTypeid$";
    private static final String RAW_TEMPLATE_TYPE = "$rawTemplate$";
    private static final CompilerContext.Key<BLangAnonymousModelHelper> ANONYMOUS_MODEL_HELPER_KEY = new CompilerContext.Key();

    private BLangAnonymousModelHelper(CompilerContext context) {
        context.put(ANONYMOUS_MODEL_HELPER_KEY, this);
        this.anonTypeCount = new HashMap<PackageID, Integer>();
        this.anonServiceCount = new HashMap<PackageID, Integer>();
        this.anonFunctionCount = new HashMap<PackageID, Integer>();
        this.anonForkCount = new HashMap<PackageID, Integer>();
        this.errorTypeIdCount = new HashMap<PackageID, Integer>();
        this.rawTemplateTypeCount = new HashMap<PackageID, Integer>();
    }

    public static BLangAnonymousModelHelper getInstance(CompilerContext context) {
        BLangAnonymousModelHelper helper = context.get(ANONYMOUS_MODEL_HELPER_KEY);
        if (helper == null) {
            helper = new BLangAnonymousModelHelper(context);
        }
        return helper;
    }

    public String getNextAnonymousTypeKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonTypeCount.get(packageID)).orElse(0);
        this.anonTypeCount.put(packageID, nextValue + 1);
        if (PackageID.ANNOTATIONS.equals(packageID)) {
            return "$anonType$builtin$_" + nextValue;
        }
        return "$anonType$_" + nextValue;
    }

    String getNextAnonymousServiceTypeKey(PackageID packageID, String serviceName) {
        Integer nextValue = Optional.ofNullable(this.anonServiceCount.get(packageID)).orElse(0);
        this.anonServiceCount.put(packageID, nextValue + 1);
        return serviceName + "$$service$_" + nextValue;
    }

    String getNextAnonymousServiceVarKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonServiceCount.get(packageID)).orElse(0);
        this.anonServiceCount.put(packageID, nextValue + 1);
        return "$anonService$_" + nextValue;
    }

    public String getNextAnonymousFunctionKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonFunctionCount.get(packageID)).orElse(0);
        this.anonFunctionCount.put(packageID, nextValue + 1);
        return "$lambda$_" + nextValue;
    }

    public String getNextAnonymousForkKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonFunctionCount.get(packageID)).orElse(0);
        this.anonFunctionCount.put(packageID, nextValue + 1);
        return "$fork$_" + nextValue;
    }

    public String getNextDistinctErrorId(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.errorTypeIdCount.get(packageID)).orElse(0);
        this.anonFunctionCount.put(packageID, nextValue + 1);
        return ANON_TYPE_ID + String.valueOf(nextValue);
    }

    public String getNextRawTemplateTypeKey(PackageID packageID, Name rawTemplateTypeName) {
        Integer nextValue = this.rawTemplateTypeCount.getOrDefault(packageID, 0);
        this.rawTemplateTypeCount.put(packageID, nextValue + 1);
        return RAW_TEMPLATE_TYPE + rawTemplateTypeName.value + "$_" + nextValue;
    }

    public boolean isAnonymousType(BSymbol symbol) {
        return symbol.name.value.startsWith(ANON_TYPE);
    }
}

