/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class BLangMissingNodesHelper {
    private Map<PackageID, Integer> missingIdentifierCount;
    private static final String MISSING_NODE_PREFIX = "$missingNode$";
    private static final CompilerContext.Key<BLangMissingNodesHelper> MISSING_NODES_HELPER_KEY = new CompilerContext.Key();

    private BLangMissingNodesHelper(CompilerContext context) {
        context.put(MISSING_NODES_HELPER_KEY, this);
        this.missingIdentifierCount = new HashMap<PackageID, Integer>();
    }

    public static BLangMissingNodesHelper getInstance(CompilerContext context) {
        BLangMissingNodesHelper helper = context.get(MISSING_NODES_HELPER_KEY);
        if (helper == null) {
            helper = new BLangMissingNodesHelper(context);
        }
        return helper;
    }

    public String getNextMissingNodeName(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.missingIdentifierCount.get(packageID)).orElse(0);
        this.missingIdentifierCount.put(packageID, nextValue + 1);
        return "$missingNode$_" + nextValue;
    }

    public boolean isMissingNode(Name nodeName) {
        return this.isMissingNode(nodeName.value);
    }

    public boolean isMissingNode(String nodeName) {
        return nodeName.startsWith(MISSING_NODE_PREFIX);
    }
}

