/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.nio.file.Path;
import java.util.Arrays;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.CompilationUnitNode;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.repository.PackageSource;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.packaging.converters.FileSystemSourceInput;
import org.wso2.ballerinalang.compiler.parser.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.parser.ParserCache;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;

public class Parser {
    private static final CompilerContext.Key<Parser> PARSER_KEY = new CompilerContext.Key();
    private CompilerContext context;
    private PackageCache pkgCache;
    private ParserCache parserCache;
    private NodeCloner nodeCloner;
    private BLangDiagnosticLog dlog;

    public static Parser getInstance(CompilerContext context) {
        Parser parser = context.get(PARSER_KEY);
        if (parser == null) {
            parser = new Parser(context);
        }
        return parser;
    }

    public Parser(CompilerContext context) {
        this.context = context;
        this.context.put(PARSER_KEY, this);
        this.pkgCache = PackageCache.getInstance(context);
        this.parserCache = ParserCache.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
    }

    public BLangPackage parse(PackageSource pkgSource, Path sourceRootPath) {
        PackageID pkgId = pkgSource.getPackageId();
        BLangPackage pkgNode = (BLangPackage)TreeBuilder.createPackageNode();
        this.pkgCache.put(pkgId, pkgNode);
        for (CompilerInput sourceInput : pkgSource.getPackageSourceEntries()) {
            if (ProjectDirs.isTestSource(((FileSystemSourceInput)sourceInput).getPath(), sourceRootPath, pkgId.getName().value)) {
                if (!pkgNode.containsTestablePkg()) {
                    BLangTestablePackage testablePkg = TreeBuilder.createTestablePackageNode();
                    testablePkg.flagSet.add(Flag.TESTABLE);
                    testablePkg.pos = new BLangDiagnosticLocation(pkgSource.getName(), 1, 1, 1, 1);
                    pkgNode.addTestablePkg(testablePkg);
                }
                pkgNode.getTestablePkg().addCompilationUnit(this.generateCompilationUnitNew(sourceInput, pkgId));
                continue;
            }
            pkgNode.addCompilationUnit(this.generateCompilationUnitNew(sourceInput, pkgId));
        }
        pkgNode.pos = new BLangDiagnosticLocation(pkgSource.getName(), 0, 0, 0, 0);
        pkgNode.repos = pkgSource.getRepoHierarchy();
        return pkgNode;
    }

    private CompilationUnitNode generateCompilationUnitNew(CompilerInput sourceEntry, PackageID packageID) {
        String entryName = sourceEntry.getEntryName();
        SyntaxTree tree = sourceEntry.getTree();
        this.reportSyntaxDiagnostics(packageID, tree);
        byte[] code = sourceEntry.getCode();
        int hash = Parser.getHash(code);
        int length = code.length;
        BLangCompilationUnit compilationUnit = this.parserCache.get(packageID, entryName, hash, length);
        if (compilationUnit != null) {
            return compilationUnit;
        }
        BLangNodeTransformer bLangNodeTransformer = new BLangNodeTransformer(this.context, packageID, entryName);
        compilationUnit = (BLangCompilationUnit)bLangNodeTransformer.accept((Node)tree.rootNode()).get(0);
        compilationUnit.setPackageID(packageID);
        this.parserCache.put(packageID, entryName, hash, length, compilationUnit);
        compilationUnit = this.nodeCloner.cloneCUnit(compilationUnit);
        return compilationUnit;
    }

    private static int getHash(byte[] code) {
        return Arrays.hashCode(code);
    }

    private void reportSyntaxDiagnostics(PackageID pkgID, SyntaxTree tree) {
        for (Diagnostic syntaxDiagnostic : tree.diagnostics()) {
            this.dlog.logDiagnostic(pkgID, syntaxDiagnostic);
        }
    }
}

