/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

class ParserCache {
    private static final CompilerContext.Key<ParserCache> PARSER_CACHE_KEY = new CompilerContext.Key();
    private boolean cacheEnabled;
    private NodeCloner nodeCloner;
    private Map<PackageID, Map<String, BLangCompilationUnit>> pkgCache = new HashMap<PackageID, Map<String, BLangCompilationUnit>>();

    private ParserCache(CompilerContext context) {
        context.put(PARSER_CACHE_KEY, this);
        CompilerOptions options = CompilerOptions.getInstance(context);
        CompilerPhase compilerPhase = options.getCompilerPhase();
        this.cacheEnabled = compilerPhase.compareTo(CompilerPhase.DESUGAR) < 0;
        this.nodeCloner = NodeCloner.getInstance(context);
    }

    static ParserCache getInstance(CompilerContext context) {
        ParserCache cache = context.get(PARSER_CACHE_KEY);
        if (cache == null) {
            cache = new ParserCache(context);
        }
        return cache;
    }

    BLangCompilationUnit get(PackageID packageID, String entryName, int hash, int length) {
        if (!this.cacheEnabled) {
            return null;
        }
        Map<String, BLangCompilationUnit> sourceEntryCache = this.pkgCache.get(packageID);
        if (sourceEntryCache == null) {
            return null;
        }
        BLangCompilationUnit compilationUnit = sourceEntryCache.get(entryName);
        if (compilationUnit == null || compilationUnit.hash != hash || compilationUnit.length != length) {
            return null;
        }
        return this.nodeCloner.cloneCUnit(compilationUnit);
    }

    void put(PackageID packageID, String entryName, int hash, int length, BLangCompilationUnit newCompUnit) {
        if (!this.cacheEnabled) {
            return;
        }
        Map<String, BLangCompilationUnit> sourceEntryCache = this.pkgCache.get(packageID);
        if (sourceEntryCache == null || !this.pkgCache.containsKey(packageID)) {
            sourceEntryCache = new HashMap<String, BLangCompilationUnit>();
            this.pkgCache.put(packageID, sourceEntryCache);
        }
        newCompUnit.hash = hash;
        newCompUnit.length = length;
        newCompUnit.setPackageID(packageID);
        sourceEntryCache.put(entryName, newCompUnit);
    }
}

