/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.runtime.internal.util.RuntimeUtils;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.compiler.plugins.CompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class CompilerPluginRunner
extends BLangNodeVisitor {
    private static final CompilerContext.Key<CompilerPluginRunner> COMPILER_PLUGIN_RUNNER_KEY = new CompilerContext.Key();
    private SymbolTable symTable;
    private PackageCache packageCache;
    private SymbolResolver symResolver;
    private Names names;
    private final Types types;
    private BLangDiagnosticLog dlog;
    private Location defaultPos;
    private CompilerContext context;
    private List<CompilerPlugin> pluginList;
    private Map<DefinitionID, Set<CompilerPlugin>> processorMap;
    private Map<CompilerPlugin, List<DefinitionID>> resourceTypeProcessorMap;
    private Map<CompilerPlugin, BType> serviceListenerMap;
    private List<CompilerPlugin> failedPlugins;

    public static CompilerPluginRunner getInstance(CompilerContext context) {
        CompilerPluginRunner annotationProcessor = context.get(COMPILER_PLUGIN_RUNNER_KEY);
        if (annotationProcessor == null) {
            annotationProcessor = new CompilerPluginRunner(context);
        }
        return annotationProcessor;
    }

    private CompilerPluginRunner(CompilerContext context) {
        context.put(COMPILER_PLUGIN_RUNNER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.packageCache = PackageCache.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.context = context;
        this.pluginList = new ArrayList<CompilerPlugin>();
        this.processorMap = new HashMap<DefinitionID, Set<CompilerPlugin>>();
        this.resourceTypeProcessorMap = new HashMap<CompilerPlugin, List<DefinitionID>>();
        this.serviceListenerMap = new HashMap<CompilerPlugin, BType>();
        this.failedPlugins = new ArrayList<CompilerPlugin>();
        ServiceLoader<CompilerPlugin> pluginLoader = ServiceLoader.load(CompilerPlugin.class);
        pluginLoader.forEach(plugin -> this.pluginList.add((CompilerPlugin)plugin));
    }

    public BLangPackage runPlugins(BLangPackage pkgNode) {
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        this.defaultPos = pkgNode.pos;
        this.loadPlugins();
        pkgNode.accept(this);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.COMPILER_PLUGIN)) {
            return;
        }
        for (CompilerPlugin compilerPlugin : this.pluginList) {
            this.executePluginSafely(pkgNode, compilerPlugin, pkgNode.packageID, compilerPlugin::pluginExecutionStarted);
        }
        for (CompilerPlugin compilerPlugin : this.pluginList) {
            this.executePluginSafely(pkgNode, compilerPlugin, pkgNode, compilerPlugin::process);
        }
        for (TopLevelNode topLevelNode : pkgNode.topLevelNodes) {
            ((BLangNode)((Object)topLevelNode)).accept(this);
        }
        pkgNode.getTestablePkgs().forEach(testablePackage -> {
            this.defaultPos = testablePackage.pos;
            this.visit((BLangTestablePackage)testablePackage);
        });
        for (CompilerPlugin plugin : this.pluginList) {
            this.executePluginSafely(pkgNode, plugin, pkgNode.packageID, plugin::pluginExecutionCompleted);
        }
        pkgNode.completedPhases.add(CompilerPhase.COMPILER_PLUGIN);
    }

    private <T> void executePluginSafely(BLangPackage pkgNode, CompilerPlugin plugin, T arg, Consumer<T> consumer) {
        if (this.failedPlugins.contains(plugin)) {
            return;
        }
        try {
            consumer.accept(arg);
        }
        catch (Throwable e) {
            this.dlog.warning(pkgNode.pos, DiagnosticWarningCode.COMPILER_PLUGIN_ERROR, new Object[0]);
            this.printErrorLog(e);
            this.failedPlugins.add(plugin);
        }
    }

    @Override
    public void visit(BLangTestablePackage testablePkgNode) {
        if (testablePkgNode.completedPhases.contains((Object)CompilerPhase.COMPILER_PLUGIN)) {
            return;
        }
        for (CompilerPlugin plugin : this.pluginList) {
            this.executePluginSafely(testablePkgNode, plugin, testablePkgNode, plugin::process);
        }
        for (TopLevelNode topLevelNode : testablePkgNode.topLevelNodes) {
            ((BLangNode)((Object)topLevelNode)).accept(this);
        }
        testablePkgNode.completedPhases.add(CompilerPhase.COMPILER_PLUGIN);
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        List<BLangAnnotationAttachment> attachmentList = annotationNode.getAnnotationAttachments();
        this.notifyProcessors(attachmentList, (processor, list) -> processor.process(annotationNode, (List<AnnotationAttachmentNode>)list));
    }

    @Override
    public void visit(BLangFunction funcNode) {
        List<BLangAnnotationAttachment> attachmentList = funcNode.getAnnotationAttachments();
        this.notifyProcessors(attachmentList, (processor, list) -> processor.process(funcNode, (List<AnnotationAttachmentNode>)list));
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        BPackageSymbol pkgSymbol = importPkgNode.symbol;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgSymbol);
        if (pkgEnv == null) {
            return;
        }
        pkgEnv.node.accept(this);
    }

    @Override
    public void visit(BLangService serviceNode) {
        List<BLangAnnotationAttachment> attachmentList = serviceNode.getAnnotationAttachments();
        this.notifyProcessors(attachmentList, (processor, list) -> processor.process(serviceNode, (List<AnnotationAttachmentNode>)list));
        this.notifyServiceTypeProcessors(serviceNode, attachmentList, (processor, list) -> processor.process(serviceNode, (List<AnnotationAttachmentNode>)list));
    }

    @Override
    public void visit(BLangTypeDefinition typeDefNode) {
        List<BLangAnnotationAttachment> attachmentList = typeDefNode.getAnnotationAttachments();
        this.notifyProcessors(attachmentList, (processor, list) -> processor.process(typeDefNode, (List<AnnotationAttachmentNode>)list));
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        List<BLangAnnotationAttachment> attachmentList = classDefinition.getAnnotationAttachments();
        this.notifyProcessors(attachmentList, (processor, list) -> processor.process(classDefinition, (List<AnnotationAttachmentNode>)list));
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        List<BLangAnnotationAttachment> attachmentList = varNode.getAnnotationAttachments();
        this.notifyProcessors(attachmentList, (processor, list) -> processor.process(varNode, (List<AnnotationAttachmentNode>)list));
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangConstant constant) {
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
    }

    private void loadPlugins() {
        this.pluginList.forEach(this::initPlugin);
    }

    private void initPlugin(CompilerPlugin plugin) {
        this.handleAnnotationProcesses(plugin);
        this.handleServiceTypeProcesses(plugin);
        plugin.setCompilerContext(this.context);
        plugin.init(this.dlog);
    }

    private void handleAnnotationProcesses(CompilerPlugin plugin) {
        SupportedAnnotationPackages supportedAnnotationPackages = plugin.getClass().getAnnotation(SupportedAnnotationPackages.class);
        if (supportedAnnotationPackages == null) {
            return;
        }
        String[] annotationPkgs = supportedAnnotationPackages.value();
        if (annotationPkgs.length == 0) {
            return;
        }
        for (String annPackage : annotationPkgs) {
            List<BAnnotationSymbol> annotationSymbols = this.getAnnotationSymbols(annPackage);
            annotationSymbols.forEach(annSymbol -> {
                DefinitionID definitionID = new DefinitionID(annSymbol.pkgID.name.value, annSymbol.name.value);
                Set processors = this.processorMap.computeIfAbsent(definitionID, k -> new HashSet());
                processors.add(plugin);
            });
        }
    }

    private List<BAnnotationSymbol> getAnnotationSymbols(String annPackage) {
        ArrayList<BAnnotationSymbol> annotationSymbols = new ArrayList<BAnnotationSymbol>();
        BPackageSymbol symbol = this.packageCache.getSymbol(annPackage);
        if (symbol == null) {
            return annotationSymbols;
        }
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(symbol);
        if (pkgEnv != null) {
            symbol.scope.entries.forEach((name, scope) -> {
                if (2 == scope.symbol.tag) {
                    annotationSymbols.add((BAnnotationSymbol)scope.symbol);
                }
            });
        }
        return annotationSymbols;
    }

    private void notifyProcessors(List<BLangAnnotationAttachment> attachments, BiConsumer<CompilerPlugin, List<AnnotationAttachmentNode>> notifier) {
        HashMap<CompilerPlugin, List> attachmentMap = new HashMap<CompilerPlugin, List>();
        for (BLangAnnotationAttachment attachment : attachments) {
            DefinitionID aID = new DefinitionID(attachment.annotationSymbol.pkgID.getName().value, attachment.annotationName.value);
            if (!this.processorMap.containsKey(aID)) continue;
            for (CompilerPlugin proc : this.processorMap.get(aID)) {
                List attachmentNodes = attachmentMap.computeIfAbsent(proc, k -> new ArrayList());
                attachmentNodes.add(attachment);
            }
        }
        for (CompilerPlugin processor : attachmentMap.keySet()) {
            if (this.failedPlugins.contains(processor)) continue;
            List list = (List)attachmentMap.get(processor);
            try {
                notifier.accept(processor, Collections.unmodifiableList(list));
            }
            catch (Throwable e) {
                this.dlog.warning(((AnnotationAttachmentNode)list.get(0)).getPosition(), DiagnosticWarningCode.COMPILER_PLUGIN_ERROR, new Object[0]);
                this.printErrorLog(e);
                this.failedPlugins.add(processor);
            }
        }
    }

    private void printErrorLog(Throwable e) {
        RuntimeUtils.printCrashLog(e);
    }

    private void handleServiceTypeProcesses(CompilerPlugin plugin) {
        SupportedResourceParamTypes resParamTypes = plugin.getClass().getAnnotation(SupportedResourceParamTypes.class);
        if (resParamTypes == null) {
            return;
        }
        SupportedResourceParamTypes.Type[] supportedTypes = resParamTypes.paramTypes();
        if (supportedTypes.length == 0) {
            return;
        }
        BType listenerType = null;
        if (!resParamTypes.expectedListenerType().name().isEmpty() && !resParamTypes.expectedListenerType().packageName().isEmpty()) {
            Name listenerName = this.names.fromString(resParamTypes.expectedListenerType().name());
            String packageQName = resParamTypes.expectedListenerType().orgName() + "/" + resParamTypes.expectedListenerType().packageName();
            BPackageSymbol symbol = this.packageCache.getSymbol(packageQName);
            if (symbol != null) {
                SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(symbol);
                BSymbol listenerSymbol = this.symResolver.lookupSymbolInMainSpace(pkgEnv, listenerName);
                if ((listenerSymbol.tag & 0x3005C) == 196700) {
                    listenerType = listenerSymbol.type;
                }
            }
        }
        List definitions = Arrays.stream(supportedTypes).map(type -> new DefinitionID(type.packageName(), type.name())).collect(Collectors.toList());
        this.resourceTypeProcessorMap.put(plugin, definitions);
        this.serviceListenerMap.put(plugin, listenerType);
    }

    private void notifyServiceTypeProcessors(BLangService serviceNode, List<BLangAnnotationAttachment> attachments, BiConsumer<CompilerPlugin, List<AnnotationAttachmentNode>> notifier) {
        block0: for (CompilerPlugin plugin : this.resourceTypeProcessorMap.keySet()) {
            boolean isCurrentPluginProcessed = false;
            BType listenerType = this.serviceListenerMap.get(plugin);
            if (listenerType != null) {
                for (BLangExpression expr : serviceNode.getAttachedExprs()) {
                    if (!this.types.isSameType(expr.type, listenerType)) continue;
                    isCurrentPluginProcessed = true;
                    this.invokeServiceProcessor(serviceNode, attachments, notifier, plugin);
                    break;
                }
            }
            if (isCurrentPluginProcessed) continue;
            for (DefinitionID definitionID : this.resourceTypeProcessorMap.get(plugin)) {
                for (FunctionNode functionNode : serviceNode.getResources()) {
                    BLangFunction resourceNode = (BLangFunction)functionNode;
                    if (resourceNode.symbol.params.stream().filter(varSym -> varSym.type.tsymbol != null).map(varSym -> varSym.type.tsymbol).noneMatch(tsym -> definitionID.name.equals(tsym.name.value) && definitionID.pkgName.equals(tsym.pkgID.name.value))) continue;
                    isCurrentPluginProcessed = true;
                    this.invokeServiceProcessor(serviceNode, attachments, notifier, plugin);
                    break;
                }
                if (!isCurrentPluginProcessed) continue;
                continue block0;
            }
        }
    }

    private void invokeServiceProcessor(BLangService serviceNode, List<BLangAnnotationAttachment> attachments, BiConsumer<CompilerPlugin, List<AnnotationAttachmentNode>> notifier, CompilerPlugin plugin) {
        notifier.accept(plugin, Collections.unmodifiableList(attachments));
        if (serviceNode.listenerType == null) {
            serviceNode.listenerType = this.serviceListenerMap.get(plugin);
        }
    }

    private static class DefinitionID {
        String pkgName;
        String name;

        DefinitionID(String pkgName, String name) {
            this.pkgName = pkgName;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefinitionID that = (DefinitionID)o;
            return Objects.equals(this.pkgName, that.pkgName) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.pkgName, this.name);
        }
    }
}

