/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.Stack;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class ConstantAnalyzer
extends BLangNodeVisitor {
    private static final CompilerContext.Key<ConstantAnalyzer> CONSTANT_ANALYZER_KEY = new CompilerContext.Key();
    private BLangDiagnosticLog dlog;
    private Stack<BLangExpression> expressions = new Stack();

    private ConstantAnalyzer(CompilerContext context) {
        context.put(CONSTANT_ANALYZER_KEY, this);
        this.dlog = BLangDiagnosticLog.getInstance(context);
    }

    public static ConstantAnalyzer getInstance(CompilerContext context) {
        ConstantAnalyzer constantAnalyzer = context.get(CONSTANT_ANALYZER_KEY);
        if (constantAnalyzer == null) {
            constantAnalyzer = new ConstantAnalyzer(context);
        }
        return constantAnalyzer;
    }

    @Override
    public void visit(BLangConstant constant) {
        this.analyzeExpr(constant.expr);
    }

    @Override
    public void visit(BLangLiteral literal) {
    }

    @Override
    public void visit(BLangNumericLiteral literal) {
    }

    @Override
    public void visit(BLangSimpleVarRef varRef) {
        BSymbol symbol = varRef.symbol;
        if (symbol != null && (symbol.tag & 0x200001C) != 33554460) {
            this.dlog.error(varRef.pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
        }
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                this.analyzeExpr(keyValuePair.key.expr);
                this.analyzeExpr(keyValuePair.valueExpr);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.analyzeExpr((BLangRecordLiteral.BLangRecordVarNameField)field);
                continue;
            }
            this.analyzeExpr(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr);
        }
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        for (int i = this.expressions.size() - 1; i >= 0; --i) {
            NodeKind kind = ((BLangExpression)this.expressions.get(i)).getKind();
            if (kind == NodeKind.GROUP_EXPR || kind == NodeKind.BINARY_EXPR) continue;
            this.dlog.error(binaryExpr.pos, DiagnosticErrorCode.CONSTANT_EXPRESSION_NOT_SUPPORTED, new Object[0]);
        }
        this.analyzeExpr(binaryExpr.lhsExpr);
        this.analyzeExpr(binaryExpr.rhsExpr);
    }

    @Override
    public void visit(BLangGroupExpr expr) {
        this.analyzeExpr(expr.expression);
    }

    void analyzeExpr(BLangExpression expr) {
        switch (expr.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: 
            case RECORD_LITERAL_EXPR: 
            case SIMPLE_VARIABLE_REF: 
            case BINARY_EXPR: 
            case GROUP_EXPR: {
                this.expressions.push(expr);
                expr.accept(this);
                this.expressions.pop();
                return;
            }
        }
        this.dlog.error(expr.pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
    }

    static boolean isValidConstantExpressionNode(BLangExpression expression) {
        switch (expression.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: 
            case RECORD_LITERAL_EXPR: 
            case BINARY_EXPR: 
            case GROUP_EXPR: {
                return true;
            }
        }
        return false;
    }
}

