/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.TaintRecord;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangInputClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableMultiKeyExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTryCatchFinally;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Lists;

public class TaintAnalyzer
extends BLangNodeVisitor {
    private static final CompilerContext.Key<TaintAnalyzer> TAINT_ANALYZER_KEY = new CompilerContext.Key();
    private SymbolEnv env;
    private SymbolEnv currPkgEnv;
    private Names names;
    private SymbolTable symTable;
    private BLangDiagnosticLog dlog;
    private Types types;
    private boolean overridingAnalysis = true;
    private boolean entryPointPreAnalysis;
    private boolean entryPointAnalysis;
    private boolean stopAnalysis;
    private boolean attachedFunctionAnalysis;
    private List<BlockedNode> blockedNodeList;
    private List<BlockedNode> blockedEntryPointNodeList;
    private List<BInvokableSymbol> ignoredInvokableSymbol;
    private Stack<AnalysisState> analysisStateStack;
    private Set<TaintRecord.TaintError> dlogSet;
    private BLangFunction currTopLevelFunction;
    private boolean topLevelFunctionAllParamsUntaintedAnalysis;
    private static final String ANNOTATION_TAINTED = "tainted";
    public static final String ANNOTATION_UNTAINTED = "untainted";
    public static final int ALL_UNTAINTED_TABLE_ENTRY_INDEX = -1;
    private AnalyzerPhase analyzerPhase;

    public static TaintAnalyzer getInstance(CompilerContext context) {
        TaintAnalyzer taintAnalyzer = context.get(TAINT_ANALYZER_KEY);
        if (taintAnalyzer == null) {
            taintAnalyzer = new TaintAnalyzer(context);
        }
        return taintAnalyzer;
    }

    public TaintAnalyzer(CompilerContext context) {
        context.put(TAINT_ANALYZER_KEY, this);
        this.names = Names.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        pkgNode.accept(this);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        this.blockedNodeList = new ArrayList<BlockedNode>();
        this.blockedEntryPointNodeList = new ArrayList<BlockedNode>();
        this.ignoredInvokableSymbol = new ArrayList<BInvokableSymbol>();
        this.analysisStateStack = new Stack();
        this.dlogSet = new LinkedHashSet<TaintRecord.TaintError>();
        this.currTopLevelFunction = null;
        this.topLevelFunctionAllParamsUntaintedAnalysis = false;
        this.analyzerPhase = AnalyzerPhase.INITIAL_ANALYSIS;
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.TAINT_ANALYZE)) {
            return;
        }
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        this.analyze(pkgNode, pkgEnv);
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.visit((BLangPackage)testablePackage));
    }

    private void analyze(BLangPackage pkgNode, SymbolEnv pkgEnv) {
        SymbolEnv prevPkgEnv = this.currPkgEnv;
        this.currPkgEnv = pkgEnv;
        this.env = pkgEnv;
        Map<Boolean, List<TopLevelNode>> topLevelNodeGroups = pkgNode.topLevelNodes.stream().collect(Collectors.partitioningBy(node -> node.getKind() == NodeKind.VARIABLE || node.getKind() == NodeKind.CONSTANT));
        this.analyzeNode(topLevelNodeGroups.get(true));
        this.analyzeNode(topLevelNodeGroups.get(false));
        this.analyzerPhase = AnalyzerPhase.BLOCKED_NODE_ANALYSIS;
        this.resolveBlockedInvokable(this.blockedNodeList);
        this.resolveBlockedInvokable(this.blockedEntryPointNodeList);
        this.analyzeModuleLevelVariableDefinitions(topLevelNodeGroups.get(true));
        if (this.dlogSet.size() > 0) {
            this.dlogSet.forEach(dlogEntry -> this.dlog.error(dlogEntry.pos, dlogEntry.diagnosticCode, dlogEntry.paramName.toArray()));
        }
        this.currPkgEnv = prevPkgEnv;
        pkgNode.completedPhases.add(CompilerPhase.TAINT_ANALYZE);
    }

    private void analyzeModuleLevelVariableDefinitions(List<TopLevelNode> topLevelNodes) {
        topLevelNodes.stream().filter(node -> node.getKind() == NodeKind.VARIABLE || node.getKind() == NodeKind.VARIABLE_DEF).forEach(topLevelNode -> {
            AnalysisState analysisState = new AnalysisState();
            this.analysisStateStack.push(analysisState);
            ((BLangNode)((Object)topLevelNode)).accept(this);
            this.analysisStateStack.pop();
        });
    }

    private void analyzeNode(List<TopLevelNode> topLevelNodes) {
        topLevelNodes.stream().filter(node -> node.getKind() != NodeKind.FUNCTION || !((BLangFunction)node).flagSet.contains((Object)Flag.LAMBDA)).forEach(node -> {
            AnalysisState analysisState = new AnalysisState();
            this.analysisStateStack.push(analysisState);
            ((BLangNode)((Object)node)).accept(this);
            this.analysisStateStack.pop();
        });
    }

    private void restCurrentTaintPropagationSet() {
        for (Map.Entry<BSymbol, Boolean> taintStatus : this.getCurrentAnalysisState().prevSymbolTaintStatus.entrySet()) {
            taintStatus.getKey().tainted = taintStatus.getValue();
        }
    }

    @Override
    public void visit(BLangCompilationUnit compUnit) {
        compUnit.topLevelNodes.forEach(e -> ((BLangNode)((Object)e)).accept(this));
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        if (typeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE || typeDefinition.typeNode.getKind() == NodeKind.RECORD_TYPE) {
            typeDefinition.typeNode.accept(this);
        }
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        BTypeSymbol objectSymbol = classDefinition.symbol;
        SymbolEnv classDefEnv = SymbolEnv.createPkgLevelSymbolEnv(classDefinition, objectSymbol.scope, this.env);
        classDefinition.fields.forEach(field -> this.analyzeNode(field, classDefEnv));
        if (classDefinition.initFunction != null) {
            this.analyzeNode(classDefinition.initFunction, classDefEnv);
        }
        classDefinition.functions.forEach(f -> this.analyzeNode(f, classDefEnv));
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectConstructorExpression) {
        this.visit(objectConstructorExpression.typeInit);
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        BPackageSymbol pkgSymbol = importPkgNode.symbol;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgSymbol);
        if (pkgEnv == null) {
            return;
        }
        this.env = pkgEnv;
        pkgEnv.node.accept(this);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI.accept(this);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        if (funcNode.flagSet.contains((Object)Flag.LAMBDA)) {
            funcNode.symbol.taintTable = null;
        } else {
            this.currTopLevelFunction = funcNode;
        }
        AnalysisState analysisState = new AnalysisState();
        this.analysisStateStack.push(analysisState);
        if (!this.attachedFunctionAnalysis && funcNode.flagSet.contains((Object)Flag.ATTACHED)) {
            this.analysisStateStack.pop();
            this.visitAttachedInvokable(funcNode);
            return;
        }
        analysisState.requiredParams = funcNode.requiredParams;
        analysisState.restParam = funcNode.restParam;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        if (funcNode.flagSet.contains((Object)Flag.RESOURCE) || CompilerUtils.isMainFunction(funcNode)) {
            this.entryPointPreAnalysis = true;
            boolean isBlocked = this.visitInvokable(funcNode, funcEnv);
            this.entryPointPreAnalysis = false;
            if (!isBlocked) {
                this.visitEntryPoint(funcNode, funcEnv);
            }
        } else {
            this.visitInvokable(funcNode, funcEnv);
        }
        this.analysisStateStack.pop();
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        for (BLangStatement stmt : body.stmts) {
            if (this.stopAnalysis) break;
            this.analyzeNode(stmt, bodyEnv);
        }
    }

    @Override
    public void visit(BLangExprFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        this.analyzeNode(body.expr, bodyEnv);
        if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
            this.getCurrentAnalysisState().returnTaintedStatus = TaintRecord.TaintedStatus.TAINTED;
        }
        this.getCurrentAnalysisState().taintedStatus = this.getCurrentAnalysisState().returnTaintedStatus;
        this.updateParameterTaintedStatuses();
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
    }

    @Override
    public void visit(BLangService serviceNode) {
        if (serviceNode.isAnonymousServiceValue) {
            this.setTaintedStatus(serviceNode.symbol, TaintRecord.TaintedStatus.TAINTED);
            this.setTaintedStatus(serviceNode.serviceClass.symbol, TaintRecord.TaintedStatus.TAINTED);
        }
    }

    @Override
    public void visit(BLangResource resourceNode) {
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        for (BLangLetVariable letVarDeclaration : letExpression.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVarDeclaration.definitionNode), letExpression.env);
        }
        this.analyzeNode(letExpression.expr, letExpression.env);
    }

    @Override
    public void visit(BLangObjectTypeNode objectNode) {
        BSymbol objectSymbol = objectNode.symbol;
        SymbolEnv objectEnv = SymbolEnv.createPkgLevelSymbolEnv(objectNode, objectSymbol.scope, this.env);
        objectNode.fields.forEach(field -> this.analyzeNode(field, objectEnv));
        if (objectNode.initFunction != null) {
            this.analyzeNode(objectNode.initFunction, objectEnv);
        }
        objectNode.functions.forEach(f -> this.analyzeNode(f, objectEnv));
    }

    @Override
    public void visit(BLangRecordTypeNode recordNode) {
        BSymbol objectSymbol = recordNode.symbol;
        SymbolEnv objectEnv = SymbolEnv.createPkgLevelSymbolEnv(recordNode, objectSymbol.scope, this.env);
        recordNode.fields.forEach(field -> this.analyzeNode(field, objectEnv));
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        if (bLangTupleVariable.expr != null) {
            SymbolEnv varInitEnv = SymbolEnv.createVarInitEnv(bLangTupleVariable, this.env, bLangTupleVariable.symbol);
            this.analyzeNode(bLangTupleVariable.expr, varInitEnv);
            this.setTaintedStatus(bLangTupleVariable, this.getCurrentAnalysisState().taintedStatus);
        }
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        if (bLangRecordVariable.expr != null) {
            SymbolEnv varInitEnv = SymbolEnv.createVarInitEnv(bLangRecordVariable, this.env, bLangRecordVariable.symbol);
            this.analyzeNode(bLangRecordVariable.expr, varInitEnv);
            this.setTaintedStatus(bLangRecordVariable, this.getCurrentAnalysisState().taintedStatus);
        }
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        if (varNode.expr != null) {
            SymbolEnv varInitEnv = SymbolEnv.createVarInitEnv(varNode, this.env, varNode.symbol);
            this.analyzeNode(varNode.expr, varInitEnv);
            if (varNode.expr.getKind() == NodeKind.LAMBDA) {
                Map<Integer, TaintRecord> taintTable = ((BLangLambdaFunction)varNode.expr).function.symbol.taintTable;
                if (varNode.symbol.kind == SymbolKind.FUNCTION) {
                    ((BInvokableSymbol)varNode.symbol).taintTable = taintTable;
                }
            }
            if (this.stopAnalysis && this.isModuleVariable(varNode.symbol)) {
                this.stopAnalysis = false;
            }
            if (this.isModuleVariable(varNode.symbol) && this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
                this.dlogSet.add(new TaintRecord.TaintError(varNode.pos, varNode.name.value, (DiagnosticCode)DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_GLOBAL_VARIABLE));
            }
            this.setTaintedStatus(varNode, this.getCurrentAnalysisState().taintedStatus);
        }
        if (varNode.flagSet.contains((Object)Flag.LISTENER)) {
            if (this.hasAnnotation(varNode, ANNOTATION_UNTAINTED)) {
                this.setTaintedStatus(varNode, TaintRecord.TaintedStatus.UNTAINTED);
            } else {
                this.setTaintedStatus(varNode, TaintRecord.TaintedStatus.TAINTED);
            }
        }
        if (this.isModuleVariable(varNode.symbol) || varNode.symbol.owner.type != null && varNode.symbol.owner.type.tag == 33) {
            if (this.hasAnnotation(varNode, ANNOTATION_TAINTED)) {
                varNode.symbol.taintabilityAllowance = BVarSymbol.TaintabilityAllowance.TAINTED;
                this.setTaintedStatus(varNode.symbol, TaintRecord.TaintedStatus.TAINTED);
            } else if (this.hasAnnotation(varNode, ANNOTATION_UNTAINTED)) {
                varNode.symbol.taintabilityAllowance = BVarSymbol.TaintabilityAllowance.UNTAINTED;
            }
        }
    }

    private boolean isModuleVariable(BSymbol symbol) {
        return symbol.tag == 52 && symbol.owner.getKind() == SymbolKind.PACKAGE;
    }

    @Override
    public void visit(BLangWorker workerNode) {
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        for (BLangStatement stmt : blockNode.stmts) {
            if (this.stopAnalysis) break;
            this.analyzeNode(stmt, blockEnv);
        }
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        varDefNode.var.accept(this);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        assignNode.expr.accept(this);
        BLangExpression varRefExpr = assignNode.varRef;
        this.visitAssignment(varRefExpr, this.getCurrentAnalysisState().taintedStatus, assignNode.pos);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment) {
        compoundAssignment.varRef.accept(this);
        TaintRecord.TaintedStatus varRefTaintedStatus = this.getCurrentAnalysisState().taintedStatus;
        compoundAssignment.expr.accept(this);
        TaintRecord.TaintedStatus exprTaintedStatus = this.getCurrentAnalysisState().taintedStatus;
        TaintRecord.TaintedStatus combinedTaintedStatus = this.getCombinedTaintedStatus(varRefTaintedStatus, exprTaintedStatus);
        this.visitAssignment(compoundAssignment.varRef, combinedTaintedStatus, compoundAssignment.pos);
    }

    private void visitAssignment(BLangExpression varRefExpr, TaintRecord.TaintedStatus varTaintedStatus, Location location) {
        if (varRefExpr == null) {
            return;
        }
        if (varTaintedStatus != TaintRecord.TaintedStatus.IGNORED) {
            if (varTaintedStatus == TaintRecord.TaintedStatus.TAINTED && varRefExpr instanceof BLangVariableReference) {
                BLangVariableReference varRef = (BLangVariableReference)varRefExpr;
                if (this.isMutableVariable(varRef) && this.isGlobalVarOrServiceVar(varRef) && !this.isMarkedTainted(varRef)) {
                    if (varRef.symbol != null && varRef.symbol.type.tag == 33) {
                        this.addTaintError(location, this.getVariableName(varRef), DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_MODULE_OBJECT);
                    } else {
                        this.addTaintError(location, this.getVariableName(varRef), DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_GLOBAL_VARIABLE);
                    }
                    return;
                }
                if (varRef.symbol != null && varRef.symbol.closure && !varRef.symbol.tainted && this.notInSameScope(varRef, this.env)) {
                    this.addTaintError(location, this.getVariableName(varRef), DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_CLOSURE_VARIABLE);
                    return;
                }
                if (varRef.symbol != null && this.isMarkedUntainted(varRef) && (varRef.symbol.flags & 0x40L) == 64L) {
                    this.addTaintError(location, this.getVariableName(varRef), DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_UNTAINTED_PARAMETER);
                }
            }
            if (varRefExpr.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
                this.overridingAnalysis = false;
                this.updatedVarRefTaintedState(varRefExpr, varTaintedStatus);
                this.overridingAnalysis = true;
            } else if (varRefExpr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
                BLangFieldBasedAccess fieldBasedAccessExpr = (BLangFieldBasedAccess)varRefExpr;
                if (fieldBasedAccessExpr.symbol != null) {
                    this.setTaintedStatus(fieldBasedAccessExpr, varTaintedStatus);
                }
                this.overridingAnalysis = false;
                this.updatedVarRefTaintedState(fieldBasedAccessExpr, varTaintedStatus);
                this.overridingAnalysis = true;
            } else if (varRefExpr.getKind() == NodeKind.GROUP_EXPR) {
                BLangGroupExpr groupExpr = (BLangGroupExpr)varRefExpr;
                this.visitAssignment(groupExpr.expression, varTaintedStatus, groupExpr.pos);
            } else if (varRefExpr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
                BLangListConstructorExpr listConstructorExpr = (BLangListConstructorExpr)varRefExpr;
                listConstructorExpr.exprs.forEach(expr -> this.visitAssignment((BLangExpression)expr, varTaintedStatus, listConstructorExpr.pos));
            } else if (varRefExpr.getKind() == NodeKind.XML_ATTRIBUTE_ACCESS_EXPR) {
                this.overridingAnalysis = false;
                this.updatedVarRefTaintedState(((BLangXMLAttributeAccess)varRefExpr).expr, varTaintedStatus);
                this.overridingAnalysis = true;
            } else if (varRefExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.setTaintedStatus((BLangVariableReference)varRefExpr, varTaintedStatus);
            }
        }
    }

    private String getVariableName(BLangVariableReference varRef) {
        if (this.isStructuredAccessOnVariableReference(varRef)) {
            return this.getVariableName((BLangVariableReference)((BLangAccessExpression)varRef).expr);
        }
        return varRef.symbol.name.value;
    }

    private boolean isMutableVariable(BLangVariableReference varRef) {
        if (this.isStructuredAccessOnVariableReference(varRef)) {
            return this.isMutableVariable((BLangVariableReference)((BLangAccessExpression)varRef).expr);
        }
        return varRef.symbol.getKind() != SymbolKind.CONSTANT && (varRef.symbol.flags & 4L) != 4L;
    }

    private boolean notInSameScope(BLangVariableReference varRefExpr, SymbolEnv env) {
        return !varRefExpr.symbol.owner.equals(env.scope.owner);
    }

    private boolean isMarkedTainted(BLangVariableReference varRef) {
        if (this.isStructuredAccessOnVariableReference(varRef)) {
            return this.isMarkedTainted((BLangVariableReference)((BLangAccessExpression)varRef).expr);
        }
        return ((BVarSymbol)varRef.symbol).taintabilityAllowance == BVarSymbol.TaintabilityAllowance.TAINTED;
    }

    private boolean isStructuredAccessOnVariableReference(BLangVariableReference variableReference) {
        return variableReference.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR || variableReference.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR || variableReference.getKind() == NodeKind.XML_ATTRIBUTE_ACCESS_EXPR;
    }

    private boolean isMarkedUntainted(BLangVariableReference varRef) {
        if (this.isStructuredAccessOnVariableReference(varRef)) {
            return this.isMarkedUntainted((BLangVariableReference)((BLangAccessExpression)varRef).expr);
        }
        return ((BVarSymbol)varRef.symbol).taintabilityAllowance == BVarSymbol.TaintabilityAllowance.UNTAINTED;
    }

    private boolean isGlobalVarOrServiceVar(BLangVariableReference varRef) {
        if (this.isStructuredAccessOnVariableReference(varRef)) {
            return this.isGlobalVarOrServiceVar((BLangVariableReference)((BLangAccessExpression)varRef).expr);
        }
        return varRef.symbol != null && varRef.symbol.owner != null && (this.isModuleVariable(varRef.symbol) || (varRef.symbol.owner.flags & 0x40000L) == 262144L);
    }

    private void updatedVarRefTaintedState(BLangExpression varRef, TaintRecord.TaintedStatus taintedState) {
        if (varRef.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            this.setTaintedStatus((BLangVariableReference)varRef, taintedState);
        } else if (varRef.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR || varRef.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            BLangAccessExpression accessExpr = (BLangAccessExpression)varRef;
            this.updatedVarRefTaintedState(accessExpr.expr, taintedState);
        }
    }

    @Override
    public void visit(BLangRetry retryNode) {
        retryNode.retryBody.accept(this);
        if (retryNode.onFailClause != null) {
            this.analyzeNode(retryNode.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
    }

    @Override
    public void visit(BLangContinue continueNode) {
    }

    @Override
    public void visit(BLangBreak breakNode) {
    }

    @Override
    public void visit(BLangReturn returnNode) {
        returnNode.expr.accept(this);
        if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
            this.getCurrentAnalysisState().returnTaintedStatus = TaintRecord.TaintedStatus.TAINTED;
        }
        this.getCurrentAnalysisState().taintedStatus = this.getCurrentAnalysisState().returnTaintedStatus;
        this.updateParameterTaintedStatuses();
    }

    @Override
    public void visit(BLangPanic throwNode) {
        throwNode.expr.accept(this);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl.accept(this);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        SymbolEnv stmtEnv = new SymbolEnv(exprStmtNode, this.env.scope);
        this.env.copyTo(stmtEnv);
        this.analyzeNode(exprStmtNode.expr, stmtEnv);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.overridingAnalysis = false;
        ifNode.expr.accept(this);
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        ifNode.body.accept(this);
        if (ifNode.elseStmt != null) {
            ifNode.elseStmt.accept(this);
        }
        this.overridingAnalysis = true;
    }

    @Override
    public void visit(BLangMatchStatement matchStatement) {
        matchStatement.expr.accept(this);
        TaintRecord.TaintedStatus observedTaintedStatusOfMatchExpr = this.getCurrentAnalysisState().taintedStatus;
        for (BLangMatchClause matchClause : matchStatement.matchClauses) {
            this.getCurrentAnalysisState().taintedStatus = observedTaintedStatusOfMatchExpr;
            matchClause.accept(this);
        }
        if (matchStatement.onFailClause != null) {
            this.analyzeNode(matchStatement.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangMatchClause matchClause) {
        matchClause.blockStmt.accept(this);
    }

    @Override
    public void visit(BLangMatch matchStmt) {
        matchStmt.expr.accept(this);
        TaintRecord.TaintedStatus observedTaintedStatusOfMatchExpr = this.getCurrentAnalysisState().taintedStatus;
        matchStmt.patternClauses.forEach(clause -> {
            this.getCurrentAnalysisState().taintedStatus = observedTaintedStatusOfMatchExpr;
            clause.accept(this);
        });
        if (matchStmt.onFailClause != null) {
            this.analyzeNode(matchStmt.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause clause) {
        clause.body.accept(this);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause clause) {
        clause.body.accept(this);
    }

    @Override
    public void visit(BLangForeach foreach) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(foreach.body, this.env);
        foreach.collection.accept(this);
        if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
            this.setTaintedStatus((BLangVariable)foreach.variableDefinitionNode.getVariable(), this.getCurrentAnalysisState().taintedStatus);
        }
        this.analyzeNode(foreach.body, blockEnv);
        if (foreach.onFailClause != null) {
            this.analyzeNode(foreach.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(onFailClause.body, this.env);
        this.analyzeNode(onFailClause.body, blockEnv);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
    }

    @Override
    public void visit(BLangWhile whileNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(whileNode.body, this.env);
        this.analyzeNode(whileNode.body, blockEnv);
        if (whileNode.onFailClause != null) {
            this.analyzeNode(whileNode.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangDo doNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(doNode.body, this.env);
        this.analyzeNode(doNode.body, blockEnv);
        if (doNode.onFailClause != null) {
            this.analyzeNode(doNode.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangFail failNode) {
        failNode.expr.accept(this);
        if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
            this.getCurrentAnalysisState().returnTaintedStatus = TaintRecord.TaintedStatus.TAINTED;
        }
    }

    @Override
    public void visit(BLangLock lockNode) {
        lockNode.body.accept(this);
        if (lockNode.onFailClause != null) {
            this.analyzeNode(lockNode.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        transactionNode.transactionBody.accept(this);
        if (transactionNode.onFailClause != null) {
            this.analyzeNode(transactionNode.onFailClause, this.env);
        }
        this.overridingAnalysis = false;
        this.overridingAnalysis = true;
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        if (rollbackNode.expr != null) {
            rollbackNode.expr.accept(this);
        }
    }

    @Override
    public void visit(BLangTryCatchFinally tryNode) {
        tryNode.tryBody.accept(this);
        this.overridingAnalysis = false;
        tryNode.catchBlocks.forEach(c -> c.accept(this));
        if (tryNode.finallyBody != null) {
            tryNode.finallyBody.accept(this);
        }
        this.overridingAnalysis = true;
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        stmt.expr.accept(this);
        for (int varIndex = 0; varIndex < stmt.varRef.expressions.size(); ++varIndex) {
            BLangExpression varRefExpr = stmt.varRef.expressions.get(varIndex);
            this.visitAssignment(varRefExpr, this.getCurrentAnalysisState().taintedStatus, stmt.pos);
        }
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        stmt.expr.accept(this);
        for (int varIndex = 0; varIndex < stmt.varRef.recordRefFields.size(); ++varIndex) {
            BLangRecordVarRef.BLangRecordVarRefKeyValue varRefExpr = stmt.varRef.recordRefFields.get(varIndex);
            this.visitAssignment(varRefExpr.variableReference, this.getCurrentAnalysisState().taintedStatus, stmt.pos);
        }
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
    }

    @Override
    public void visit(BLangCatch catchNode) {
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        workerSendNode.expr.accept(this);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        syncSendExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        workerReceiveNode.sendExpression.accept(this);
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        if (listConstructorExpr.exprs.size() == 0) {
            this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        } else {
            TaintRecord.TaintedStatus isTainted = TaintRecord.TaintedStatus.UNTAINTED;
            for (BLangExpression expression : listConstructorExpr.exprs) {
                expression.accept(this);
                if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
                isTainted = TaintRecord.TaintedStatus.TAINTED;
            }
            this.getCurrentAnalysisState().taintedStatus = isTainted;
        }
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        if (tableConstructorExpr.recordLiteralList.size() == 0) {
            this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        } else {
            TaintRecord.TaintedStatus isTainted = TaintRecord.TaintedStatus.UNTAINTED;
            for (BLangExpression bLangExpression : tableConstructorExpr.recordLiteralList) {
                bLangExpression.accept(this);
                if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
                isTainted = TaintRecord.TaintedStatus.TAINTED;
            }
            this.getCurrentAnalysisState().taintedStatus = isTainted;
        }
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression.accept(this);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        TaintRecord.TaintedStatus isTainted = TaintRecord.TaintedStatus.UNTAINTED;
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                if (keyValuePair.key.computedKey) {
                    keyValuePair.key.expr.accept(this);
                    if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
                        isTainted = TaintRecord.TaintedStatus.TAINTED;
                    }
                }
                keyValuePair.valueExpr.accept(this);
            } else if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                ((BLangRecordLiteral.BLangRecordVarNameField)field).accept(this);
            } else {
                ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr.accept(this);
            }
            if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
            isTainted = TaintRecord.TaintedStatus.TAINTED;
        }
        this.getCurrentAnalysisState().taintedStatus = isTainted;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        if (varRefExpr.symbol == null) {
            Name varName = this.names.fromIdNode(varRefExpr.variableName);
            if (varName != Names.IGNORE && varRefExpr.pkgSymbol.tag == 8193) {
                this.getCurrentAnalysisState().taintedStatus = varRefExpr.pkgSymbol.tainted ? TaintRecord.TaintedStatus.TAINTED : TaintRecord.TaintedStatus.UNTAINTED;
                return;
            }
            this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        } else {
            BSymbol symbol;
            if ((varRefExpr.symbol.tag & 0x34) == 52) {
                BVarSymbol varSymbol = (BVarSymbol)varRefExpr.symbol;
                symbol = varSymbol.originalSymbol == null ? varSymbol : varSymbol.originalSymbol;
            } else {
                symbol = varRefExpr.symbol;
            }
            this.getCurrentAnalysisState().taintedStatus = symbol.tainted ? TaintRecord.TaintedStatus.TAINTED : TaintRecord.TaintedStatus.UNTAINTED;
        }
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        BType varRefType = fieldAccessExpr.expr.type;
        switch (varRefType.tag) {
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 33: {
                fieldAccessExpr.expr.accept(this);
            }
        }
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        indexAccessExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangTableMultiKeyExpr tableMultiKeyExpr) {
        this.analyzeExprList(tableMultiKeyExpr.multiKeyIndexExprs);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        if (this.isErrorConstructorInvocation(invocationExpr) || this.isExternalLangLibFunction(invocationExpr)) {
            ((BInvokableSymbol)invocationExpr.symbol).taintTable = this.createIdentityTaintTable(invocationExpr);
        }
        if (invocationExpr.symbol != null) {
            BInvokableSymbol invokableSymbol = (BInvokableSymbol)invocationExpr.symbol;
            if (invokableSymbol.taintTable == null) {
                boolean blocked = true;
                if (this.ignoredInvokableSymbol.contains(invokableSymbol)) {
                    this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.IGNORED;
                    blocked = false;
                } else if (this.analyzerPhase == AnalyzerPhase.LOOP_ANALYSIS) {
                    this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.IGNORED;
                    this.analyzerPhase = AnalyzerPhase.LOOP_ANALYSIS_COMPLETE;
                    this.ignoredInvokableSymbol.add(invokableSymbol);
                    blocked = false;
                }
                if (blocked) {
                    this.addToBlockedList(invocationExpr);
                }
            } else {
                this.analyzeInvocation(invocationExpr);
            }
        }
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocation) {
        this.visit((BLangInvocation)actionInvocation);
    }

    private boolean isErrorConstructorInvocation(BLangInvocation invocationExpr) {
        return invocationExpr.symbol != null && invocationExpr.symbol.kind == SymbolKind.ERROR_CONSTRUCTOR;
    }

    private void analyzeLangLibFunctionInvocation(BLangInvocation invocationExpr) {
        for (BLangExpression requiredArg : invocationExpr.requiredArgs) {
            requiredArg.accept(this);
            if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
            return;
        }
        for (BLangExpression expression : invocationExpr.restArgs) {
            expression.accept(this);
            if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
            return;
        }
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    private boolean isExternalLangLibFunction(BLangInvocation invocationExpr) {
        return invocationExpr.symbol.pkgID.orgName.value.equals("ballerina") && invocationExpr.symbol.pkgID.name.value.startsWith("lang.") && Symbols.isNative(invocationExpr.symbol);
    }

    private int receiverIfAttachedFunction(BLangInvocation invocationExpr) {
        return this.isTaintAnalyzableAttachedFunction(invocationExpr) ? 1 : 0;
    }

    private Map<Integer, TaintRecord> createIdentityTaintTable(BLangInvocation invocationExpr) {
        HashMap<Integer, TaintRecord> taintTable = new HashMap<Integer, TaintRecord>();
        int requiredParamCount = invocationExpr.requiredArgs.size();
        int restCount = invocationExpr.restArgs == null || invocationExpr.restArgs.isEmpty() ? 0 : 1;
        int totalParamCount = requiredParamCount + restCount + this.receiverIfAttachedFunction(invocationExpr);
        for (int i = -1; i < totalParamCount; ++i) {
            TaintRecord record = new TaintRecord(i == -1 ? TaintRecord.TaintedStatus.IGNORED : TaintRecord.TaintedStatus.TAINTED, new ArrayList<TaintRecord.TaintedStatus>());
            taintTable.put(i, record);
            for (int j = 0; j < totalParamCount; ++j) {
                record.parameterTaintedStatusList.add(TaintRecord.TaintedStatus.IGNORED);
            }
        }
        return taintTable;
    }

    @Override
    public void visit(BLangTypeInit typeInit) {
        TaintRecord.TaintedStatus typeTaintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        for (BLangExpression expr : typeInit.argsExpr) {
            expr.accept(this);
            if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
            typeTaintedStatus = TaintRecord.TaintedStatus.TAINTED;
        }
        if (typeInit.type.tag != 14 && (typeInit.type.tag != 33 || ((BObjectTypeSymbol)typeInit.type.tsymbol).initializerFunc != null)) {
            typeInit.initInvocation.accept(this);
        }
        this.getCurrentAnalysisState().taintedStatus = typeTaintedStatus;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        this.overridingAnalysis = false;
        ternaryExpr.thenExpr.accept(this);
        TaintRecord.TaintedStatus thenTaintedCheckResult = this.getCurrentAnalysisState().taintedStatus;
        ternaryExpr.elseExpr.accept(this);
        this.overridingAnalysis = true;
        TaintRecord.TaintedStatus elseTaintedCheckResult = this.getCurrentAnalysisState().taintedStatus;
        this.getCurrentAnalysisState().taintedStatus = this.getCombinedTaintedStatus(thenTaintedCheckResult, elseTaintedCheckResult);
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        waitExpr.getExpression().accept(this);
    }

    @Override
    public void visit(BLangWaitForAllExpr waitExpr) {
        TaintRecord.TaintedStatus statusForWait = TaintRecord.TaintedStatus.UNTAINTED;
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyValue : waitExpr.keyValuePairs) {
            BLangExpression expr = keyValue.valueExpr != null ? keyValue.valueExpr : keyValue.keyExpr;
            expr.accept(this);
            statusForWait = this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED ? TaintRecord.TaintedStatus.TAINTED : TaintRecord.TaintedStatus.UNTAINTED;
        }
        this.getCurrentAnalysisState().taintedStatus = statusForWait;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        xmlElementAccess.expr.accept(this);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        xmlNavigation.expr.accept(this);
        if (xmlNavigation.childIndex != null) {
            TaintRecord.TaintedStatus exprTaintStatus = this.getCurrentAnalysisState().taintedStatus;
            xmlNavigation.childIndex.accept(this);
            this.getCurrentAnalysisState().taintedStatus = exprTaintStatus;
        }
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        binaryExpr.lhsExpr.accept(this);
        TaintRecord.TaintedStatus lhsTaintedCheckResult = this.getCurrentAnalysisState().taintedStatus;
        binaryExpr.rhsExpr.accept(this);
        TaintRecord.TaintedStatus rhsTaintedCheckResult = this.getCurrentAnalysisState().taintedStatus;
        this.getCurrentAnalysisState().taintedStatus = this.getCombinedTaintedStatus(lhsTaintedCheckResult, rhsTaintedCheckResult);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        elvisExpr.lhsExpr.accept(this);
        TaintRecord.TaintedStatus lhsTaintedCheckResult = this.getCurrentAnalysisState().taintedStatus;
        elvisExpr.rhsExpr.accept(this);
        TaintRecord.TaintedStatus rhsTaintedCheckResult = this.getCurrentAnalysisState().taintedStatus;
        this.getCurrentAnalysisState().taintedStatus = this.getCombinedTaintedStatus(lhsTaintedCheckResult, rhsTaintedCheckResult);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        switch (unaryExpr.operator) {
            case LENGTHOF: {
                this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
                break;
            }
            case UNTAINT: {
                this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
                break;
            }
            default: {
                unaryExpr.expr.accept(this);
            }
        }
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        TaintRecord.TaintedStatus annotStatus;
        conversionExpr.expr.accept(this);
        if (!conversionExpr.annAttachments.isEmpty() && (annotStatus = this.getTaintedStatusBasedOnAnnotations(conversionExpr.annAttachments)) != TaintRecord.TaintedStatus.IGNORED) {
            this.getCurrentAnalysisState().taintedStatus = annotStatus;
        }
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        xmlAttribute.name.accept(this);
        TaintRecord.TaintedStatus attrNameTaintedStatus = this.getCurrentAnalysisState().taintedStatus;
        xmlAttribute.value.accept(this);
        TaintRecord.TaintedStatus attrValueTaintedStatus = this.getCurrentAnalysisState().taintedStatus;
        this.getCurrentAnalysisState().taintedStatus = this.getCombinedTaintedStatus(attrNameTaintedStatus, attrValueTaintedStatus);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        boolean inLineNamespaceTainted = false;
        for (BLangXMLAttribute bLangXMLAttribute : xmlElementLiteral.attributes) {
            if (bLangXMLAttribute.name.getKind() != NodeKind.XML_QNAME || !((BLangXMLQName)bLangXMLAttribute.name).prefix.value.equals("xmlns")) continue;
            bLangXMLAttribute.accept(this);
            if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.IGNORED) {
                return;
            }
            this.setTaintedStatus(bLangXMLAttribute.symbol, this.getCurrentAnalysisState().taintedStatus);
            if (!bLangXMLAttribute.symbol.tainted) continue;
            inLineNamespaceTainted = true;
        }
        boolean attributesTainted = false;
        for (BLangXMLAttribute attribute : xmlElementLiteral.attributes) {
            if (attribute.name.getKind() != NodeKind.XML_QNAME || ((BLangXMLQName)attribute.name).prefix.value.equals("xmlns")) continue;
            attribute.accept(this);
            if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.IGNORED) {
                return;
            }
            this.setTaintedStatus(attribute.symbol, this.getCurrentAnalysisState().taintedStatus);
            if (!attribute.symbol.tainted) continue;
            attributesTainted = true;
        }
        xmlElementLiteral.startTagName.accept(this);
        if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.IGNORED) {
            return;
        }
        TaintRecord.TaintedStatus taintedStatus = this.getCurrentAnalysisState().taintedStatus;
        TaintRecord.TaintedStatus endTagTaintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        if (xmlElementLiteral.endTagName != null) {
            xmlElementLiteral.endTagName.accept(this);
            if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.IGNORED) {
                return;
            }
            endTagTaintedStatus = this.getCurrentAnalysisState().taintedStatus;
        }
        boolean tagNamesTainted = taintedStatus == TaintRecord.TaintedStatus.TAINTED || endTagTaintedStatus == TaintRecord.TaintedStatus.TAINTED;
        boolean childrenTainted = false;
        for (BLangExpression expr : xmlElementLiteral.children) {
            expr.accept(this);
            if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.IGNORED) {
                return;
            }
            if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
            childrenTainted = true;
        }
        this.getCurrentAnalysisState().taintedStatus = inLineNamespaceTainted || attributesTainted || tagNamesTainted || childrenTainted ? TaintRecord.TaintedStatus.TAINTED : TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        this.analyzeExprList(xmlTextLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        this.analyzeExprList(xmlCommentLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.target.accept(this);
        if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.UNTAINTED) {
            this.analyzeExprList(xmlProcInsLiteral.dataFragments);
        }
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        this.analyzeExprList(xmlQuotedString.textFragments);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.analyzeExprList(stringTemplateLiteral.exprs);
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        this.analyzeExprList(rawTemplateLiteral.strings);
        this.analyzeExprList(rawTemplateLiteral.insertions);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        bLangLambdaFunction.function.accept(this);
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        xmlAttributeAccessExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangRestArgsExpression varArgsExpression) {
        varArgsExpression.expr.accept(this);
    }

    @Override
    public void visit(BLangNamedArgsExpression namedArgsExpression) {
        namedArgsExpression.expr.accept(this);
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
        bLangMatchExpression.expr.accept(this);
    }

    @Override
    public void visit(BLangCheckedExpr match) {
        match.expr.accept(this);
        if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
            this.getCurrentAnalysisState().returnTaintedStatus = TaintRecord.TaintedStatus.TAINTED;
        }
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanicExpr) {
        checkPanicExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        boolean anyListenerstainted = false;
        for (BLangExpression expr : serviceConstructorExpr.serviceNode.attachedExprs) {
            if (expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)expr).symbol.tainted) {
                anyListenerstainted = true;
                break;
            }
            if (expr.getKind() != NodeKind.TYPE_INIT_EXPR) continue;
            anyListenerstainted = true;
            break;
        }
        if (anyListenerstainted || serviceConstructorExpr.type.tsymbol.tainted) {
            this.setTaintedStatus(serviceConstructorExpr.type.tsymbol, TaintRecord.TaintedStatus.TAINTED);
        }
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        annotAccessExpr.expr.accept(this);
    }

    @Override
    public void visit(BLangValueType valueType) {
    }

    @Override
    public void visit(BLangArrayType arrayType) {
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef packageVarRef) {
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangTypeLoad typeLoad) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr arrayIndexAccessExpr) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr tableKeyAccessExpr) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlIndexAccessExpr) {
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation bFunctionPointerInvocation) {
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation iExpr) {
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr jsonAccessExpr) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        BLangInputClause inputClause = (BLangInputClause)queryExpr.getQueryClauses().get(0);
        for (BLangNode clause : queryExpr.getQueryClauses()) {
            if (clause.getKind() == NodeKind.FROM || clause.getKind() == NodeKind.JOIN) {
                inputClause = (BLangInputClause)clause;
            }
            ((BLangExpression)inputClause.getCollection()).accept(this);
            if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
            this.setTaintedStatus((BLangVariable)inputClause.variableDefinitionNode.getVariable(), this.getCurrentAnalysisState().taintedStatus);
        }
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
    }

    @Override
    public void visit(BLangConstant constant) {
    }

    private <T extends BLangNode, U extends SymbolEnv> void analyzeNode(T t, U u) {
        SymbolEnv prevEnv = this.env;
        this.env = u;
        t.accept(this);
        this.env = prevEnv;
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.visit(bLangTupleVariableDef.var);
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.visit(bLangRecordVariableDef.var);
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.visit(bLangErrorVariableDef.errorVariable);
    }

    private void analyzeExprList(List<? extends BLangExpression> exprs) {
        for (BLangExpression bLangExpression : exprs) {
            bLangExpression.accept(this);
            if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
            break;
        }
    }

    private boolean hasAnnotation(BLangSimpleVariable variable, String expectedAnnotation) {
        return this.hasAnnotation(variable.annAttachments, expectedAnnotation);
    }

    private boolean hasAnnotation(List<BLangAnnotationAttachment> annotationAttachmentList, String expectedAnnotation) {
        return annotationAttachmentList.stream().anyMatch(annotation -> annotation.annotationName.value.equals(expectedAnnotation));
    }

    private TaintRecord.TaintedStatus getCombinedTaintedStatus(TaintRecord.TaintedStatus ... taintedStatuses) {
        TaintRecord.TaintedStatus combinedTaintedStatus = TaintRecord.TaintedStatus.IGNORED;
        for (TaintRecord.TaintedStatus taintedStatus : taintedStatuses) {
            if (taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
                combinedTaintedStatus = TaintRecord.TaintedStatus.TAINTED;
                continue;
            }
            if (combinedTaintedStatus != TaintRecord.TaintedStatus.IGNORED || taintedStatus != TaintRecord.TaintedStatus.UNTAINTED) continue;
            combinedTaintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        }
        return combinedTaintedStatus;
    }

    private void setTaintedStatus(BLangVariable varNode, TaintRecord.TaintedStatus taintedStatus) {
        if (varNode.getKind() == NodeKind.RECORD_VARIABLE) {
            ((BLangRecordVariable)varNode).variableList.forEach(variable -> this.setTaintedStatus(variable.valueBindingPattern, taintedStatus));
            return;
        }
        if (varNode.getKind() == NodeKind.TUPLE_VARIABLE) {
            for (BLangVariable variable2 : ((BLangTupleVariable)varNode).memberVariables) {
                this.setTaintedStatus(variable2, taintedStatus);
            }
            return;
        }
        if (varNode.getKind() == NodeKind.VARIABLE) {
            boolean isTaintedVar;
            BLangSimpleVariable simpleVarNode = (BLangSimpleVariable)varNode;
            boolean bl = isTaintedVar = simpleVarNode.symbol != null && !simpleVarNode.symbol.tainted;
            if (taintedStatus != TaintRecord.TaintedStatus.IGNORED && (this.overridingAnalysis || isTaintedVar)) {
                this.setTaintedStatus(simpleVarNode.symbol, taintedStatus);
            }
        }
    }

    private void setTaintedStatus(BLangVariableReference varNode, TaintRecord.TaintedStatus taintedStatus) {
        if (taintedStatus != TaintRecord.TaintedStatus.IGNORED && (this.overridingAnalysis || varNode.symbol != null && !varNode.symbol.tainted)) {
            this.setTaintedStatus(varNode.symbol, taintedStatus);
        }
    }

    private void setTaintedStatus(BSymbol symbol, TaintRecord.TaintedStatus taintedStatus) {
        if (taintedStatus != TaintRecord.TaintedStatus.IGNORED && symbol != null) {
            this.getCurrentAnalysisState().prevSymbolTaintStatus.put(symbol, symbol.tainted);
            symbol.tainted = taintedStatus == TaintRecord.TaintedStatus.TAINTED;
        }
    }

    private void visitEntryPoint(BLangInvokableNode invNode, SymbolEnv funcEnv) {
        if (this.analyzerPhase == AnalyzerPhase.LOOP_ANALYSIS) {
            return;
        }
        boolean markParamsTainted = true;
        if (invNode.getKind() == NodeKind.FUNCTION && ((BLangFunction)invNode).receiver != null && ((BLangFunction)invNode).receiver.type.tag == 33 && !((BLangFunction)invNode).receiver.type.tsymbol.tainted) {
            markParamsTainted = false;
        }
        if (this.isEntryPointParamsInvalid(invNode.requiredParams, markParamsTainted)) {
            return;
        }
        if (invNode.restParam != null && this.isEntryPointParamsInvalid(Collections.singletonList(invNode.restParam), markParamsTainted)) {
            return;
        }
        this.entryPointAnalysis = true;
        this.analyzeReturnTaintedStatus(invNode, funcEnv);
        this.entryPointAnalysis = false;
        boolean isBlocked = this.processBlockedNode(invNode);
        if (!isBlocked) {
            for (TaintRecord.TaintError taintError : this.getCurrentAnalysisState().taintErrorSet) {
                if (taintError.diagnosticCode == DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_MODULE_OBJECT) {
                    this.dlogSet.add(new TaintRecord.TaintError(taintError.pos, taintError.paramName, (DiagnosticCode)DiagnosticErrorCode.INVOCATION_TAINT_GLOBAL_OBJECT));
                    continue;
                }
                this.dlogSet.add(taintError);
            }
        }
    }

    private boolean isEntryPointParamsInvalid(List<BLangSimpleVariable> params, boolean markParamsTainted) {
        if (params != null) {
            for (BLangSimpleVariable param : params) {
                if (markParamsTainted) {
                    this.setTaintedStatus(param.symbol, TaintRecord.TaintedStatus.TAINTED);
                } else {
                    this.setTaintedStatus(param.symbol, TaintRecord.TaintedStatus.UNTAINTED);
                }
                if (!this.hasAnnotation(param, ANNOTATION_UNTAINTED)) continue;
                this.dlog.error(param.pos, DiagnosticErrorCode.ENTRY_POINT_PARAMETERS_CANNOT_BE_UNTAINTED, param.name.value);
                return true;
            }
        }
        return false;
    }

    private boolean visitInvokable(BLangInvokableNode invNode, SymbolEnv symbolEnv) {
        if (this.analyzerPhase == AnalyzerPhase.LOOPS_RESOLVED_ANALYSIS || invNode.symbol.taintTable == null) {
            boolean isBlocked;
            if (Symbols.isNative(invNode.symbol) || invNode.getKind() == NodeKind.FUNCTION && ((BLangFunction)invNode).interfaceFunction) {
                this.attachNativeFunctionTaintTable(invNode);
                return false;
            }
            HashMap<Integer, TaintRecord> taintTable = new HashMap<Integer, TaintRecord>();
            this.analyzeAllParamsUntaintedReturnTaintedStatus(taintTable, invNode, symbolEnv);
            if (this.analyzerPhase == AnalyzerPhase.LOOP_ANALYSIS_COMPLETE) {
                this.analyzerPhase = AnalyzerPhase.LOOP_ANALYSIS;
            }
            if (invNode.flagSet.contains((Object)Flag.LAMBDA)) {
                BLangFunction prevTopLevelFunction = this.currTopLevelFunction;
                if (invNode.getKind() == NodeKind.FUNCTION) {
                    this.currTopLevelFunction = (BLangFunction)invNode;
                }
                isBlocked = this.processBlockedNode(this.currTopLevelFunction);
                this.currTopLevelFunction = prevTopLevelFunction;
            } else {
                isBlocked = this.processBlockedNode(invNode);
            }
            if (isBlocked) {
                return true;
            }
            int requiredParamCount = invNode.requiredParams.size();
            int totalParamCount = requiredParamCount + (invNode.restParam == null ? 0 : 1);
            if (this.getCurrentAnalysisState().taintErrorSet.size() > 0) {
                List<TaintRecord.TaintedStatus> paramTaintedStatus = Collections.nCopies(totalParamCount, TaintRecord.TaintedStatus.UNTAINTED);
                taintTable.put(-1, new TaintRecord(TaintRecord.TaintedStatus.UNTAINTED, paramTaintedStatus));
                for (int paramIndex = 0; paramIndex < totalParamCount; ++paramIndex) {
                    taintTable.put(paramIndex, new TaintRecord(TaintRecord.TaintedStatus.UNTAINTED, paramTaintedStatus));
                }
                this.getCurrentAnalysisState().taintErrorSet.clear();
            } else {
                for (int paramIndex = 0; paramIndex < totalParamCount; ++paramIndex) {
                    BLangSimpleVariable param = this.getParam(invNode, paramIndex, requiredParamCount);
                    if (this.hasAnnotation(param, ANNOTATION_UNTAINTED)) continue;
                    this.analyzeReturnTaintedStatus(taintTable, invNode, symbolEnv, paramIndex, requiredParamCount);
                    if (this.analyzerPhase == AnalyzerPhase.LOOP_ANALYSIS_COMPLETE) {
                        this.analyzerPhase = AnalyzerPhase.LOOP_ANALYSIS;
                    }
                    this.getCurrentAnalysisState().taintErrorSet.clear();
                }
            }
            invNode.symbol.taintTable = taintTable;
            this.validateReturnAndParameterTaintedAnnotations(invNode, taintTable);
            this.restCurrentTaintPropagationSet();
        }
        return false;
    }

    private void visitAttachedInvokable(BLangFunction invNode) {
        List prevRequiredParam = invNode.requiredParams;
        if (invNode.symbol.receiverSymbol != null) {
            BLangSimpleVariable self = invNode.receiver;
            List<BLangSimpleVariable> requiredParamsWithSelf = Lists.of(self);
            requiredParamsWithSelf.addAll(prevRequiredParam);
            invNode.requiredParams = requiredParamsWithSelf;
        }
        this.attachedFunctionAnalysis = true;
        this.visit(invNode);
        this.attachedFunctionAnalysis = false;
        invNode.requiredParams = prevRequiredParam;
    }

    private void analyzeAllParamsUntaintedReturnTaintedStatus(Map<Integer, TaintRecord> taintTable, BLangInvokableNode invokableNode, SymbolEnv symbolEnv) {
        if (this.currTopLevelFunction == invokableNode) {
            this.topLevelFunctionAllParamsUntaintedAnalysis = true;
        }
        this.analyzeReturnTaintedStatus(taintTable, invokableNode, symbolEnv, -1, 0);
        if (this.currTopLevelFunction == invokableNode) {
            this.topLevelFunctionAllParamsUntaintedAnalysis = false;
        }
    }

    private void validateReturnAndParameterTaintedAnnotations(BLangInvokableNode invokableNode, Map<Integer, TaintRecord> taintedStatusBasedOnAnnotations) {
        if (this.analyzerPhase == AnalyzerPhase.LOOP_ANALYSIS || this.analyzerPhase == AnalyzerPhase.LOOP_ANALYSIS_COMPLETE) {
            return;
        }
        TaintRecord taintRecord = taintedStatusBasedOnAnnotations.get(-1);
        if (taintRecord.returnTaintedStatus == TaintRecord.TaintedStatus.TAINTED && !this.hasAnnotation(invokableNode.returnTypeAnnAttachments, ANNOTATION_TAINTED) && !invokableNode.flagSet.contains((Object)Flag.LAMBDA)) {
            this.dlog.error(invokableNode.returnTypeNode.pos, DiagnosticErrorCode.TAINTED_RETURN_NOT_ANNOTATED_TAINTED, invokableNode.name.getValue());
            this.stopAnalysis = true;
        }
        int requiredParamCount = invokableNode.requiredParams.size();
        int totalParamCount = requiredParamCount + (invokableNode.restParam == null ? 0 : 1);
        for (int i = 0; i < totalParamCount; ++i) {
            TaintRecord.TaintedStatus taintedStatus = taintRecord.parameterTaintedStatusList.get(i);
            if (taintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
            BLangSimpleVariable param = this.getParam(invokableNode, i, requiredParamCount);
            if (i == 0 && (invokableNode.symbol.flags & 8L) == 8L || this.hasAnnotation(param, ANNOTATION_TAINTED)) continue;
            this.dlog.error(param.pos, DiagnosticErrorCode.TAINTED_PARAM_NOT_ANNOTATED_TAINTED, param.name, invokableNode.name);
            this.stopAnalysis = true;
        }
    }

    private void analyzeReturnTaintedStatus(Map<Integer, TaintRecord> taintTable, BLangInvokableNode invokableNode, SymbolEnv symbolEnv, int paramIndex, int requiredParamCount) {
        this.getCurrentAnalysisState().returnTaintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        this.getCurrentAnalysisState().parameterTaintedStatus = new ArrayList<TaintRecord.TaintedStatus>();
        this.resetTaintedStatusOfVariables(invokableNode.requiredParams);
        if (invokableNode.restParam != null) {
            this.resetTaintedStatusOfVariables(Collections.singletonList(invokableNode.restParam));
        }
        boolean prevParamTaintedState = false;
        if (paramIndex != -1) {
            prevParamTaintedState = this.markNthParamSymbolTainted(invokableNode, paramIndex, requiredParamCount);
        }
        this.analyzeReturnTaintedStatus(invokableNode, symbolEnv);
        if (this.getCurrentAnalysisState().taintErrorSet.size() > 0) {
            boolean isLambdaFunc = invokableNode.flagSet.contains((Object)Flag.LAMBDA);
            if (paramIndex == -1 && (this.topLevelFunctionAllParamsUntaintedAnalysis || this.entryPointAnalysis) && (this.analyzerPhase == AnalyzerPhase.INITIAL_ANALYSIS || this.analyzerPhase == AnalyzerPhase.BLOCKED_NODE_ANALYSIS || this.analyzerPhase == AnalyzerPhase.LOOPS_RESOLVED_ANALYSIS)) {
                this.dlogSet.addAll(this.getCurrentAnalysisState().taintErrorSet);
            } else {
                taintTable.put(paramIndex, new TaintRecord(new ArrayList<TaintRecord.TaintError>(this.getCurrentAnalysisState().taintErrorSet)));
            }
        } else if (this.getCurrentAnalysisState().blockedNode == null) {
            if (invokableNode.returnTypeNode.type != this.symTable.nilType) {
                TaintRecord.TaintedStatus taintedStatusBasedOnAnnotations = this.getTaintedStatusBasedOnAnnotations(invokableNode.returnTypeAnnAttachments);
                if (taintedStatusBasedOnAnnotations != TaintRecord.TaintedStatus.IGNORED) {
                    this.getCurrentAnalysisState().returnTaintedStatus = taintedStatusBasedOnAnnotations;
                }
            } else {
                this.getCurrentAnalysisState().returnTaintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
            }
            this.updateParameterTaintedStatuses();
            taintTable.put(paramIndex, new TaintRecord(this.getCurrentAnalysisState().returnTaintedStatus, this.getCurrentAnalysisState().parameterTaintedStatus));
        }
        if (paramIndex != -1) {
            this.restoreNthParamSymbolTaintedness(invokableNode, paramIndex, requiredParamCount, prevParamTaintedState);
        }
    }

    private boolean markNthParamSymbolTainted(BLangInvokableNode invokableNode, int paramIndex, int requiredParamCount) {
        return this.changeNthParamSymbolTo(invokableNode, paramIndex, requiredParamCount, true);
    }

    private void restoreNthParamSymbolTaintedness(BLangInvokableNode invokableNode, int paramIndex, int requiredParamCount, boolean prevTaintedStatet) {
        this.changeNthParamSymbolTo(invokableNode, paramIndex, requiredParamCount, prevTaintedStatet);
    }

    private boolean changeNthParamSymbolTo(BLangInvokableNode invokableNode, int paramIndex, int requiredParamCount, boolean toTaintedState) {
        if (paramIndex < requiredParamCount) {
            boolean prevState = invokableNode.requiredParams.get((int)paramIndex).symbol.tainted;
            this.setTaintedStatus(invokableNode.requiredParams.get((int)paramIndex).symbol, toTaintedState ? TaintRecord.TaintedStatus.TAINTED : TaintRecord.TaintedStatus.UNTAINTED);
            return prevState;
        }
        if (invokableNode.restParam != null) {
            boolean prevState = invokableNode.restParam.symbol.tainted;
            this.setTaintedStatus(invokableNode.restParam.symbol, toTaintedState ? TaintRecord.TaintedStatus.TAINTED : TaintRecord.TaintedStatus.UNTAINTED);
            return prevState;
        }
        return false;
    }

    private void resetTaintedStatusOfVariables(List<BLangSimpleVariable> params) {
        if (params != null) {
            params.forEach(param -> this.setTaintedStatus(param.symbol, TaintRecord.TaintedStatus.UNTAINTED));
        }
    }

    private void analyzeReturnTaintedStatus(BLangInvokableNode invokableNode, SymbolEnv symbolEnv) {
        this.getCurrentAnalysisState().returnTaintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        this.getCurrentAnalysisState().parameterTaintedStatus = new ArrayList<TaintRecord.TaintedStatus>();
        this.analyzeNode(invokableNode.body, symbolEnv);
        if (this.stopAnalysis) {
            this.stopAnalysis = false;
        }
    }

    private void attachNativeFunctionTaintTable(BLangInvokableNode invokableNode) {
        if (invokableNode.symbol.taintTable == null) {
            boolean hasTaintedAnnotation = this.hasAnnotation(invokableNode.returnTypeAnnAttachments, ANNOTATION_TAINTED);
            TaintRecord.TaintedStatus retParamsTaintedStatus = hasTaintedAnnotation ? TaintRecord.TaintedStatus.TAINTED : TaintRecord.TaintedStatus.UNTAINTED;
            int requiredParamCount = invokableNode.requiredParams.size();
            int totalParamCount = requiredParamCount + (invokableNode.restParam == null ? 0 : 1);
            ArrayList<TaintRecord.TaintedStatus> paramTaintedStatusList = new ArrayList<TaintRecord.TaintedStatus>();
            for (int paramIndex = 0; paramIndex < totalParamCount; ++paramIndex) {
                BLangSimpleVariable param = this.getParam(invokableNode, paramIndex, requiredParamCount);
                TaintRecord.TaintedStatus taintedStateBasedOnAnnotations = this.getTaintedStatusBasedOnAnnotations(param.annAttachments);
                paramTaintedStatusList.add(taintedStateBasedOnAnnotations);
            }
            HashMap<Integer, TaintRecord> taintTable = new HashMap<Integer, TaintRecord>();
            taintTable.put(-1, new TaintRecord(retParamsTaintedStatus, paramTaintedStatusList));
            for (int paramIndex = 0; paramIndex < totalParamCount; ++paramIndex) {
                BLangSimpleVariable param = this.getParam(invokableNode, paramIndex, requiredParamCount);
                if (this.hasAnnotation(param, ANNOTATION_UNTAINTED)) continue;
                taintTable.put(paramIndex, new TaintRecord(retParamsTaintedStatus, paramTaintedStatusList));
            }
            invokableNode.symbol.taintTable = taintTable;
        }
    }

    private TaintRecord.TaintedStatus getTaintedStatusBasedOnAnnotations(List<BLangAnnotationAttachment> annotations) {
        if (this.hasAnnotation(annotations, ANNOTATION_UNTAINTED)) {
            return TaintRecord.TaintedStatus.UNTAINTED;
        }
        if (this.hasAnnotation(annotations, ANNOTATION_TAINTED)) {
            return TaintRecord.TaintedStatus.TAINTED;
        }
        return TaintRecord.TaintedStatus.IGNORED;
    }

    private boolean processBlockedNode(BLangInvokableNode invokableNode) {
        boolean isBlocked = false;
        if (this.getCurrentAnalysisState().blockedNode != null) {
            this.getCurrentAnalysisState().blockedNode.invokableNode = invokableNode;
            if (this.analyzerPhase == AnalyzerPhase.INITIAL_ANALYSIS) {
                if (this.entryPointPreAnalysis || this.entryPointAnalysis) {
                    this.blockedEntryPointNodeList.add(this.getCurrentAnalysisState().blockedNode);
                } else {
                    this.blockedNodeList.add(this.getCurrentAnalysisState().blockedNode);
                }
            }
            this.getCurrentAnalysisState().blockedNode = null;
            this.getCurrentAnalysisState().taintErrorSet.clear();
            isBlocked = true;
        }
        return isBlocked;
    }

    private void analyzeIterableLambdaInvocationArgExpression(BLangExpression argExpr) {
        BLangFunction function = ((BLangLambdaFunction)argExpr).function;
        function.accept(this);
        if (function.symbol.taintTable == null) {
            this.getCurrentAnalysisState().blockedNode = new BlockedNode(this.currPkgEnv, null);
            this.stopAnalysis = true;
            this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        } else if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
            int requiredParamCount = function.requiredParams.size();
            int totalParamCount = requiredParamCount + (function.restParam == null ? 0 : 1);
            Map<Integer, TaintRecord> taintTable = function.symbol.taintTable;
            for (int paramIndex = 0; paramIndex < totalParamCount; ++paramIndex) {
                TaintRecord taintRecord = taintTable.get(paramIndex);
                BLangSimpleVariable param = this.getParam(function, paramIndex, requiredParamCount);
                if (taintRecord == null) {
                    this.addTaintError(argExpr.pos, param.name.value, DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_UNTAINTED_PARAMETER);
                } else if (taintRecord.taintError != null && taintRecord.taintError.size() > 0) {
                    this.addTaintError(taintRecord.taintError);
                }
                if (this.stopAnalysis) break;
            }
        }
    }

    private void addTaintError(Location location, String paramName, DiagnosticCode diagnosticCode) {
        TaintRecord.TaintError taintError = new TaintRecord.TaintError(location, paramName, diagnosticCode);
        this.getCurrentAnalysisState().taintErrorSet.add(taintError);
        if (!this.entryPointAnalysis) {
            this.stopAnalysis = true;
        }
    }

    private void addTaintError(Location diagnosticLocation, String paramName, String paramName2, DiagnosticCode diagnosticCode) {
        TaintRecord.TaintError taintError = new TaintRecord.TaintError(diagnosticLocation, paramName, paramName2, diagnosticCode);
        this.getCurrentAnalysisState().taintErrorSet.add(taintError);
        if (!this.entryPointAnalysis) {
            this.stopAnalysis = true;
        }
    }

    private void addTaintError(List<TaintRecord.TaintError> taintErrors) {
        this.getCurrentAnalysisState().taintErrorSet.addAll(taintErrors);
        if (!this.entryPointAnalysis) {
            this.stopAnalysis = true;
        }
    }

    private void addToBlockedList(BLangInvocation invocationExpr) {
        BlockingNode blockingNode = new BlockingNode(invocationExpr.symbol.pkgID, invocationExpr.symbol.name);
        this.getCurrentAnalysisState().blockedNode = new BlockedNode(this.currPkgEnv, blockingNode);
        this.stopAnalysis = true;
        this.getCurrentAnalysisState().taintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
    }

    private void combinedParameterTaintedStatus(List<TaintRecord.TaintedStatus> combinedArgTaintedStatus, List<TaintRecord.TaintedStatus> argTaintedStatus) {
        if (combinedArgTaintedStatus.isEmpty()) {
            combinedArgTaintedStatus.addAll(argTaintedStatus);
        } else {
            for (int paramIndex = 0; paramIndex < argTaintedStatus.size(); ++paramIndex) {
                if (argTaintedStatus.get(paramIndex) != TaintRecord.TaintedStatus.TAINTED) continue;
                combinedArgTaintedStatus.set(paramIndex, TaintRecord.TaintedStatus.TAINTED);
            }
        }
    }

    private void updateParameterTaintedStatuses() {
        this.updateParameterTaintedStatuses(this.getCurrentAnalysisState().requiredParams, 0);
        if (this.getCurrentAnalysisState().restParam != null) {
            this.updateParameterTaintedStatuses(Collections.singletonList(this.getCurrentAnalysisState().restParam), this.getCurrentAnalysisState().requiredParams.size());
        }
    }

    private void updateParameterTaintedStatuses(List<BLangSimpleVariable> paramList, int startIndex) {
        if (this.getCurrentAnalysisState().parameterTaintedStatus.size() <= startIndex) {
            for (BLangSimpleVariable param : paramList) {
                TaintRecord.TaintedStatus taintedStateBasedOnAnnotations = this.getTaintedStatusBasedOnAnnotations(param.annAttachments);
                if (taintedStateBasedOnAnnotations == TaintRecord.TaintedStatus.IGNORED) {
                    if (this.types.isValueType(param.type)) {
                        this.getCurrentAnalysisState().parameterTaintedStatus.add(TaintRecord.TaintedStatus.UNTAINTED);
                        continue;
                    }
                    this.getCurrentAnalysisState().parameterTaintedStatus.add(param.symbol.tainted ? TaintRecord.TaintedStatus.TAINTED : TaintRecord.TaintedStatus.UNTAINTED);
                    continue;
                }
                this.getCurrentAnalysisState().parameterTaintedStatus.add(taintedStateBasedOnAnnotations);
            }
        } else {
            for (int paramIndex = 0; paramIndex < paramList.size(); ++paramIndex) {
                BLangVariable param = paramList.get(paramIndex);
                TaintRecord.TaintedStatus taintedStateBasedOnAnnotations = this.getTaintedStatusBasedOnAnnotations(param.annAttachments);
                if (taintedStateBasedOnAnnotations != TaintRecord.TaintedStatus.TAINTED && !param.symbol.tainted) continue;
                if (this.types.isValueType(param.type)) {
                    this.getCurrentAnalysisState().parameterTaintedStatus.set(startIndex + paramIndex, TaintRecord.TaintedStatus.UNTAINTED);
                    continue;
                }
                this.getCurrentAnalysisState().parameterTaintedStatus.set(startIndex + paramIndex, TaintRecord.TaintedStatus.TAINTED);
            }
        }
    }

    private void analyzeInvocation(BLangInvocation invocationExpr) {
        TaintRecord.TaintedStatus argumentTaintReturnValue;
        BLangExpression argExpr2;
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)invocationExpr.symbol;
        Map<Integer, TaintRecord> origTaintTable = invokableSymbol.taintTable;
        TaintRecord.TaintedStatus returnTaintedStatus = TaintRecord.TaintedStatus.UNTAINTED;
        ArrayList<TaintRecord.TaintedStatus> argTaintedStatusList = new ArrayList();
        TaintRecord allParamsUntaintedRecord = origTaintTable.get(-1);
        if (allParamsUntaintedRecord != null) {
            if (allParamsUntaintedRecord.taintError != null && allParamsUntaintedRecord.taintError.size() > 0) {
                this.addTaintError(allParamsUntaintedRecord.taintError);
            } else {
                returnTaintedStatus = allParamsUntaintedRecord.returnTaintedStatus;
                if (allParamsUntaintedRecord.parameterTaintedStatusList != null) {
                    argTaintedStatusList = new ArrayList<TaintRecord.TaintedStatus>(allParamsUntaintedRecord.parameterTaintedStatusList);
                }
            }
        }
        int requiredParamCount = invokableSymbol.params.size();
        int namedArgsCount = this.countNamedArgs(invocationExpr);
        int positionalArgsCount = invocationExpr.requiredArgs.size() - namedArgsCount;
        List<BLangExpression> restArgs = invocationExpr.restArgs;
        int restArgsCount = restArgs.size();
        List<Integer> paramPositionsOfProvidedArguments = this.getParamPositionsOfProvidedArguments(invocationExpr.requiredArgs, ((BInvokableSymbol)invocationExpr.symbol).params);
        List<TaintRecord.TaintedStatus> paramsReceiverTainting = null;
        if (this.isTaintAnalyzableAttachedFunction(invocationExpr)) {
            BVarSymbol receiverSymbol = this.getMethodReceiverSymbol(invocationExpr.expr);
            returnTaintedStatus = this.analyzeAllArgsUntaintedReceiverTaintedness(invocationExpr, origTaintTable, returnTaintedStatus, receiverSymbol);
            if (this.stopAnalysis) {
                return;
            }
            paramsReceiverTainting = this.collectSelfTaintednessForEachTaintedParam(origTaintTable, paramPositionsOfProvidedArguments, restArgsCount);
            invokableSymbol.taintTable = this.duplicateTaintTableSkippingReceiverEntry(origTaintTable);
            if (!argTaintedStatusList.isEmpty()) {
                argTaintedStatusList.remove(0);
            }
        }
        for (int reqArgIndex = 0; reqArgIndex < positionalArgsCount; ++reqArgIndex) {
            argExpr2 = invocationExpr.requiredArgs.get(reqArgIndex);
            argumentTaintReturnValue = this.analyzeInvocationArgument(reqArgIndex, invocationExpr, argExpr2, argTaintedStatusList);
            if (this.restoreTableIfIgnored(invokableSymbol, origTaintTable, argumentTaintReturnValue)) {
                return;
            }
            returnTaintedStatus = this.updateAndGetTaintedStatus(invocationExpr, returnTaintedStatus, paramsReceiverTainting, reqArgIndex, argumentTaintReturnValue);
            if (this.stopAnalysis) break;
        }
        for (BLangExpression argExpr2 : invocationExpr.requiredArgs) {
            if (argExpr2.getKind() != NodeKind.NAMED_ARGS_EXPR) continue;
            String currentNamedArgExprName = ((BLangNamedArgsExpression)argExpr2).name.value;
            int paramIndex = this.findDefaultableParamIndex(invokableSymbol, requiredParamCount, currentNamedArgExprName);
            TaintRecord.TaintedStatus argumentTaintReturnValue2 = this.analyzeInvocationArgument(paramIndex, invocationExpr, argExpr2, argTaintedStatusList);
            if (this.restoreTableIfIgnored(invokableSymbol, origTaintTable, argumentTaintReturnValue2)) {
                return;
            }
            returnTaintedStatus = this.updateAndGetTaintedStatus(invocationExpr, returnTaintedStatus, paramsReceiverTainting, paramIndex, argumentTaintReturnValue2);
            if (!this.stopAnalysis) continue;
            break;
        }
        if (restArgsCount == 1 && positionalArgsCount < requiredParamCount && restArgs.get(0).getKind() == NodeKind.REST_ARGS_EXPR) {
            int paramIndex;
            BLangExpression varArg = restArgs.get(0);
            for (paramIndex = positionalArgsCount; paramIndex < requiredParamCount; ++paramIndex) {
                argumentTaintReturnValue = this.analyzeInvocationArgument(paramIndex, invocationExpr, varArg, argTaintedStatusList);
                if (this.restoreTableIfIgnored(invokableSymbol, origTaintTable, argumentTaintReturnValue)) {
                    return;
                }
                returnTaintedStatus = this.updateAndGetTaintedStatus(invocationExpr, returnTaintedStatus, paramsReceiverTainting, paramIndex, argumentTaintReturnValue);
                if (this.stopAnalysis) break;
            }
            if (invokableSymbol.restParam != null) {
                paramIndex = requiredParamCount;
                argumentTaintReturnValue = this.analyzeInvocationArgument(paramIndex, invocationExpr, varArg, argTaintedStatusList);
                if (this.restoreTableIfIgnored(invokableSymbol, origTaintTable, argumentTaintReturnValue)) {
                    return;
                }
                returnTaintedStatus = this.updateAndGetTaintedStatus(invocationExpr, returnTaintedStatus, paramsReceiverTainting, paramIndex, argumentTaintReturnValue);
            }
        } else {
            for (int argIndex = 0; argIndex < restArgsCount; ++argIndex) {
                int paramIndex = requiredParamCount;
                argExpr2 = restArgs.get(argIndex);
                TaintRecord.TaintedStatus argumentTaintReturnValue3 = this.analyzeInvocationArgument(paramIndex, invocationExpr, argExpr2, argTaintedStatusList);
                if (this.restoreTableIfIgnored(invokableSymbol, origTaintTable, argumentTaintReturnValue3)) {
                    return;
                }
                returnTaintedStatus = this.updateAndGetTaintedStatus(invocationExpr, returnTaintedStatus, paramsReceiverTainting, paramIndex, argumentTaintReturnValue3);
                if (this.stopAnalysis) break;
            }
        }
        this.updateArgTaintedStatus(invocationExpr, argTaintedStatusList);
        invokableSymbol.taintTable = origTaintTable;
        if (invocationExpr.expr != null) {
            invocationExpr.expr.accept(this);
            if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.IGNORED) {
                return;
            }
            if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
                returnTaintedStatus = this.getTaintedStatusOfReceiverParam(invokableSymbol);
            }
        }
        this.getCurrentAnalysisState().taintedStatus = returnTaintedStatus;
    }

    private TaintRecord.TaintedStatus getTaintedStatusOfReceiverParam(BInvokableSymbol invokableSymbol) {
        TaintRecord taintRecordOfReceiverParam = invokableSymbol.taintTable.get(0);
        if (taintRecordOfReceiverParam == null) {
            return TaintRecord.TaintedStatus.TAINTED;
        }
        return taintRecordOfReceiverParam.returnTaintedStatus;
    }

    private boolean restoreTableIfIgnored(BInvokableSymbol invokableSymbol, Map<Integer, TaintRecord> origTaintTable, TaintRecord.TaintedStatus argumentTaintReturnValue) {
        if (argumentTaintReturnValue != TaintRecord.TaintedStatus.IGNORED) {
            return false;
        }
        invokableSymbol.taintTable = origTaintTable;
        return true;
    }

    private TaintRecord.TaintedStatus updateAndGetTaintedStatus(BLangInvocation invocationExpr, TaintRecord.TaintedStatus returnTaintedStatus, List<TaintRecord.TaintedStatus> paramsReceiverTainting, int reqArgIndex, TaintRecord.TaintedStatus argumentTaintReturnValue) {
        if (argumentTaintReturnValue == TaintRecord.TaintedStatus.TAINTED) {
            returnTaintedStatus = TaintRecord.TaintedStatus.TAINTED;
        }
        if (this.getCurrentAnalysisState().taintedStatus == TaintRecord.TaintedStatus.TAINTED) {
            this.updateSelfTaintedStatusToTainted(invocationExpr, paramsReceiverTainting, reqArgIndex);
        }
        return returnTaintedStatus;
    }

    private int countNamedArgs(BLangInvocation invocationExpr) {
        int namedArgsCount = 0;
        for (BLangExpression arg : invocationExpr.requiredArgs) {
            if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) continue;
            ++namedArgsCount;
        }
        return namedArgsCount;
    }

    private List<Integer> getParamPositionsOfProvidedArguments(List<BLangExpression> args, List<BVarSymbol> params) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < args.size(); ++i) {
            BLangExpression arg = args.get(i);
            if (arg.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                String paramName = ((BLangNamedArgsExpression)arg).name.value;
                for (int p = 0; p < params.size(); ++p) {
                    BVarSymbol paramSymbol = params.get(p);
                    if (!paramSymbol.name.value.equals(paramName)) continue;
                    positions.add(p);
                }
                continue;
            }
            positions.add(i);
        }
        return positions;
    }

    private int findDefaultableParamIndex(BInvokableSymbol invokableSymbol, int requiredParamCount, String currentNamedArgExprName) {
        int paramIndex = 0;
        for (int defaultableParamIndex = 0; defaultableParamIndex < requiredParamCount; ++defaultableParamIndex) {
            BVarSymbol defaultableParam = invokableSymbol.params.get(defaultableParamIndex);
            if (!defaultableParam.name.value.equals(currentNamedArgExprName)) continue;
            paramIndex = defaultableParamIndex;
            break;
        }
        return paramIndex;
    }

    private TaintRecord.TaintedStatus analyzeAllArgsUntaintedReceiverTaintedness(BLangInvocation invocationExpr, Map<Integer, TaintRecord> taintTable, TaintRecord.TaintedStatus returnTaintedStatus, BVarSymbol receiverSymbol) {
        TaintRecord allUntaintedEntry;
        TaintRecord receiverTaintRecord = taintTable.get(0);
        if (receiverSymbol != null) {
            returnTaintedStatus = this.checkTaintErrorsInObjectMethods(invocationExpr, returnTaintedStatus, receiverSymbol, receiverTaintRecord);
        }
        if ((allUntaintedEntry = taintTable.get(-1)) != null && allUntaintedEntry.parameterTaintedStatusList != null && !allUntaintedEntry.parameterTaintedStatusList.isEmpty() && allUntaintedEntry.parameterTaintedStatusList.get(0) == TaintRecord.TaintedStatus.TAINTED) {
            this.visitAssignment(invocationExpr.expr, TaintRecord.TaintedStatus.TAINTED, invocationExpr.pos);
        }
        if (receiverTaintRecord != null && receiverTaintRecord.parameterTaintedStatusList != null) {
            List<TaintRecord.TaintedStatus> actualArgTaintStatus = receiverTaintRecord.parameterTaintedStatusList.subList(1, receiverTaintRecord.parameterTaintedStatusList.size());
            this.updateArgTaintedStatus(invocationExpr, actualArgTaintStatus);
        }
        return returnTaintedStatus;
    }

    private List<TaintRecord.TaintedStatus> collectSelfTaintednessForEachTaintedParam(Map<Integer, TaintRecord> taintTable, List<Integer> paramPositionsOfProvidedArgs, int restArgsCount) {
        int paramsCount = paramPositionsOfProvidedArgs.size() - restArgsCount;
        int paramSize = taintTable.size() - 1 - (taintTable.containsKey(0) ? -1 : 0);
        ArrayList<TaintRecord.TaintedStatus> selfTaintedStatusList = new ArrayList<TaintRecord.TaintedStatus>(Collections.nCopies(paramSize, TaintRecord.TaintedStatus.IGNORED));
        for (int i = 0; i < paramsCount; ++i) {
            Integer argPos = paramPositionsOfProvidedArgs.get(i);
            TaintRecord taintRecord = taintTable.get(argPos + 1);
            if (taintRecord == null) {
                selfTaintedStatusList.add(TaintRecord.TaintedStatus.UNTAINTED);
                continue;
            }
            if (taintRecord.parameterTaintedStatusList != null) {
                selfTaintedStatusList.add(argPos, taintRecord.parameterTaintedStatusList.get(0));
                continue;
            }
            selfTaintedStatusList.add(argPos, TaintRecord.TaintedStatus.TAINTED);
        }
        return selfTaintedStatusList;
    }

    private TaintRecord.TaintedStatus checkTaintErrorsInObjectMethods(BLangInvocation invocationExpr, TaintRecord.TaintedStatus returnTaintedStatus, BVarSymbol receiverSymbol, TaintRecord receiverTaintRecord) {
        if (receiverSymbol.tainted) {
            if (receiverTaintRecord == null) {
                this.addTaintError(invocationExpr.pos, receiverSymbol.name.value, DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_UNTAINTED_PARAMETER_ORIGINATING_AT);
                return returnTaintedStatus;
            }
            if (receiverTaintRecord.returnTaintedStatus == TaintRecord.TaintedStatus.TAINTED) {
                returnTaintedStatus = TaintRecord.TaintedStatus.TAINTED;
            }
            if (receiverTaintRecord.taintError != null && !receiverTaintRecord.taintError.isEmpty()) {
                for (TaintRecord.TaintError error : receiverTaintRecord.taintError) {
                    if (error.diagnosticCode == DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_GLOBAL_VARIABLE) {
                        this.addTaintError(receiverTaintRecord.taintError);
                        continue;
                    }
                    if (error.diagnosticCode == DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_MODULE_OBJECT) {
                        this.addTaintError(invocationExpr.pos, this.getMethodReceiverSymbol((BLangExpression)invocationExpr).name.value, error.diagnosticCode);
                        continue;
                    }
                    this.addTaintError(invocationExpr.pos, error.paramName.get(0), invocationExpr.name.value, DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_UNTAINTED_PARAMETER_ORIGINATING_AT);
                }
            }
        }
        return returnTaintedStatus;
    }

    private boolean isTaintAnalyzableAttachedFunction(BLangInvocation invocationExpr) {
        boolean isAttachedFunction = (invocationExpr.symbol.flags & 8L) == 8L;
        boolean hasExpr = invocationExpr.expr != null;
        boolean isTypeInit = invocationExpr.parent != null && invocationExpr.parent.getKind() == NodeKind.TYPE_INIT_EXPR;
        return isAttachedFunction && (hasExpr || isTypeInit);
    }

    private void updateSelfTaintedStatusToTainted(BLangInvocation invocationExpr, List<TaintRecord.TaintedStatus> paramVsSelfTaintedStatus, int argIndex) {
        if (paramVsSelfTaintedStatus != null && paramVsSelfTaintedStatus.get(argIndex) == TaintRecord.TaintedStatus.TAINTED) {
            this.visitAssignment(invocationExpr.expr, TaintRecord.TaintedStatus.TAINTED, invocationExpr.pos);
        }
    }

    private BVarSymbol getMethodReceiverSymbol(BLangExpression expr) {
        if (expr == null) {
            return null;
        }
        switch (expr.getKind()) {
            case SIMPLE_VARIABLE_REF: {
                return (BVarSymbol)((BLangSimpleVarRef)expr).symbol;
            }
            case FIELD_BASED_ACCESS_EXPR: {
                return this.getMethodReceiverSymbol(((BLangFieldBasedAccess)expr).expr);
            }
            case INDEX_BASED_ACCESS_EXPR: {
                return this.getMethodReceiverSymbol(((BLangIndexBasedAccess)expr).expr);
            }
            case INVOCATION: {
                return (BVarSymbol)((BLangInvocation)expr).symbol;
            }
        }
        return null;
    }

    private Map<Integer, TaintRecord> duplicateTaintTableSkippingReceiverEntry(Map<Integer, TaintRecord> taintTable) {
        HashMap<Integer, TaintRecord> taintTableWithoutReceiver = new HashMap<Integer, TaintRecord>();
        if (taintTable.containsKey(-1)) {
            taintTableWithoutReceiver.put(-1, this.skipTaintRecSelfParam(taintTable.get(-1)));
        }
        for (Map.Entry<Integer, TaintRecord> entry : taintTable.entrySet()) {
            if (entry.getKey() <= 0) continue;
            taintTableWithoutReceiver.put(entry.getKey() - 1, this.skipTaintRecSelfParam(entry.getValue()));
        }
        return taintTableWithoutReceiver;
    }

    private TaintRecord skipTaintRecSelfParam(TaintRecord taintRecord) {
        if (taintRecord.parameterTaintedStatusList == null || taintRecord.parameterTaintedStatusList.isEmpty()) {
            return taintRecord;
        }
        TaintRecord newRec = new TaintRecord(taintRecord.taintError);
        newRec.returnTaintedStatus = taintRecord.returnTaintedStatus;
        newRec.parameterTaintedStatusList = taintRecord.parameterTaintedStatusList.subList(1, taintRecord.parameterTaintedStatusList.size());
        return newRec;
    }

    private void updateArgTaintedStatus(BLangInvocation invocationExpr, List<TaintRecord.TaintedStatus> argTaintedStatusList) {
        TaintRecord.TaintedStatus argTaintedStatus;
        BLangExpression argExpr;
        int argIndex;
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)invocationExpr.symbol;
        int requiredParamCount = invokableSymbol.params.size();
        List positionalArgs = invocationExpr.requiredArgs.stream().filter(a -> a.getKind() != NodeKind.NAMED_ARGS_EXPR).collect(Collectors.toList());
        List namedArgs = invocationExpr.requiredArgs.stream().filter(a -> a.getKind() == NodeKind.NAMED_ARGS_EXPR).collect(Collectors.toList());
        int namedArgsCount = namedArgs.size();
        int positionalArgsCount = positionalArgs.size();
        List<BLangExpression> restArgs = invocationExpr.restArgs;
        int restArgsCount = restArgs.size();
        for (argIndex = 0; argIndex < positionalArgsCount; ++argIndex) {
            argExpr = (BLangExpression)positionalArgs.get(argIndex);
            argTaintedStatus = TaintRecord.TaintedStatus.IGNORED;
            if (!argTaintedStatusList.isEmpty()) {
                argTaintedStatus = argTaintedStatusList.get(argIndex);
            }
            if (argTaintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
            this.updateArgTaintedStatus(argExpr, argTaintedStatus);
        }
        for (argIndex = 0; argIndex < namedArgsCount; ++argIndex) {
            argExpr = (BLangExpression)namedArgs.get(argIndex);
            String currentNamedArgExprName = ((BLangNamedArgsExpression)argExpr).name.value;
            int paramIndex = this.findDefaultableParamIndex(invokableSymbol, requiredParamCount, currentNamedArgExprName);
            TaintRecord.TaintedStatus argTaintedStatus2 = argTaintedStatusList.get(paramIndex);
            this.updateArgTaintedStatus(argExpr, argTaintedStatus2);
        }
        if (positionalArgsCount < requiredParamCount && restArgsCount == 1 && restArgs.get(0).getKind() == NodeKind.REST_ARGS_EXPR) {
            BLangExpression restArgExpr = restArgs.get(0);
            for (int paramIndex = positionalArgsCount; paramIndex < requiredParamCount; ++paramIndex) {
                argTaintedStatus = argTaintedStatusList.get(paramIndex);
                if (argTaintedStatus != TaintRecord.TaintedStatus.TAINTED) continue;
                this.updateArgTaintedStatus(restArgExpr, argTaintedStatus);
            }
            if (invokableSymbol.restParam != null) {
                TaintRecord.TaintedStatus argTaintedStatus3 = argTaintedStatusList.get(requiredParamCount);
                this.updateArgTaintedStatus(restArgExpr, argTaintedStatus3);
            }
        } else {
            for (argIndex = 0; argIndex < restArgsCount; ++argIndex) {
                argExpr = restArgs.get(argIndex);
                argTaintedStatus = argTaintedStatusList.get(requiredParamCount);
                this.updateArgTaintedStatus(argExpr, argTaintedStatus);
            }
        }
    }

    private void updateArgTaintedStatus(BLangExpression varRefExpr, TaintRecord.TaintedStatus varTaintedStatus) {
        if (varRefExpr.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR || varRefExpr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR || varRefExpr.getKind() == NodeKind.GROUP_EXPR || varRefExpr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR || varRefExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)varRefExpr).pkgSymbol.tag != 8193) {
            this.visitAssignment(varRefExpr, varTaintedStatus, varRefExpr.pos);
        } else if (varRefExpr.getKind() == NodeKind.TYPE_CONVERSION_EXPR) {
            this.visitAssignment(((BLangTypeConversionExpr)varRefExpr).expr, varTaintedStatus, varRefExpr.pos);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private TaintRecord.TaintedStatus analyzeInvocationArgument(int paramIndex, BLangInvocation invocationExpr, BLangExpression argExpr, List<TaintRecord.TaintedStatus> argTaintedStatusList) {
        argExpr.accept(this);
        if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.TAINTED) {
            if (this.getCurrentAnalysisState().taintedStatus != TaintRecord.TaintedStatus.IGNORED) return TaintRecord.TaintedStatus.UNTAINTED;
            return TaintRecord.TaintedStatus.IGNORED;
        }
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)invocationExpr.symbol;
        TaintRecord taintRecord = invokableSymbol.taintTable.get(paramIndex);
        int requiredParamCount = invokableSymbol.params.size();
        BVarSymbol paramSymbol = this.getParamSymbol(invokableSymbol, paramIndex, requiredParamCount);
        if (taintRecord == null) {
            Location argPos = argExpr.pos != null ? argExpr.pos : invocationExpr.pos;
            this.addTaintError(argPos, paramSymbol.name.value, DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_UNTAINTED_PARAMETER);
            this.stopAnalysis = false;
            return TaintRecord.TaintedStatus.UNTAINTED;
        }
        if (taintRecord.taintError != null && taintRecord.taintError.size() > 0) {
            taintRecord.taintError.forEach(error -> {
                if (error.diagnosticCode == DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_GLOBAL_VARIABLE || error.diagnosticCode == DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_MODULE_OBJECT) {
                    this.addTaintError(taintRecord.taintError);
                } else {
                    Location argPos = argExpr.pos != null ? argExpr.pos : invocationExpr.pos;
                    this.addTaintError(argPos, paramSymbol.name.value, DiagnosticErrorCode.TAINTED_VALUE_PASSED_TO_UNTAINTED_PARAMETER);
                }
            });
            return TaintRecord.TaintedStatus.UNTAINTED;
        }
        this.combinedParameterTaintedStatus(argTaintedStatusList, taintRecord.parameterTaintedStatusList);
        return taintRecord.returnTaintedStatus;
    }

    private void resolveBlockedInvokable(List<BlockedNode> blockedNodeList) {
        ArrayList<BlockedNode> remainingBlockedNodeList = new ArrayList<BlockedNode>();
        for (BlockedNode blockedNode : blockedNodeList) {
            this.env = blockedNode.pkgSymbol;
            blockedNode.invokableNode.accept(this);
            if (blockedNode.invokableNode.symbol.taintTable != null) continue;
            remainingBlockedNodeList.add(blockedNode);
        }
        if (remainingBlockedNodeList.size() != 0 && blockedNodeList.size() == remainingBlockedNodeList.size()) {
            for (BlockedNode blockedNode : remainingBlockedNodeList) {
                this.analyzerPhase = AnalyzerPhase.LOOP_ANALYSIS;
                this.env = blockedNode.pkgSymbol;
                blockedNode.invokableNode.accept(this);
            }
            this.analyzerPhase = AnalyzerPhase.LOOPS_RESOLVED_ANALYSIS;
            this.resolveBlockedInvokable(remainingBlockedNodeList);
        } else if (remainingBlockedNodeList.size() > 0) {
            this.resolveBlockedInvokable(remainingBlockedNodeList);
        }
    }

    private BLangSimpleVariable getParam(BLangInvokableNode invNode, int paramIndex, int requiredParamCount) {
        BLangSimpleVariable param = paramIndex < requiredParamCount ? invNode.requiredParams.get(paramIndex) : invNode.restParam;
        return param;
    }

    private BVarSymbol getParamSymbol(BInvokableSymbol invSymbol, int paramIndex, int requiredParamCount) {
        BVarSymbol param = paramIndex < requiredParamCount ? invSymbol.params.get(paramIndex) : invSymbol.restParam;
        return param;
    }

    private AnalysisState getCurrentAnalysisState() {
        return this.analysisStateStack.peek();
    }

    private class AnalysisState {
        private TaintRecord.TaintedStatus taintedStatus;
        private TaintRecord.TaintedStatus returnTaintedStatus;
        private List<BLangSimpleVariable> requiredParams;
        private BLangSimpleVariable restParam;
        private List<TaintRecord.TaintedStatus> parameterTaintedStatus;
        private BlockedNode blockedNode;
        private Set<TaintRecord.TaintError> taintErrorSet = new LinkedHashSet<TaintRecord.TaintError>();
        private Map<BSymbol, Boolean> prevSymbolTaintStatus = new HashMap<BSymbol, Boolean>();

        private AnalysisState() {
        }
    }

    private class BlockedNode {
        SymbolEnv pkgSymbol;
        BLangInvokableNode invokableNode;
        BlockingNode blockingNode;

        BlockedNode(SymbolEnv pkgSymbol, BlockingNode blockingNode) {
            this.pkgSymbol = pkgSymbol;
            this.blockingNode = blockingNode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockedNode that = (BlockedNode)o;
            return this.invokableNode.symbol.pkgID.equals(that.invokableNode.symbol.pkgID) && this.invokableNode.symbol.name.equals(that.invokableNode.symbol.name);
        }

        public int hashCode() {
            int result = this.invokableNode.symbol.pkgID.hashCode();
            result = 31 * result + this.invokableNode.symbol.name.hashCode();
            return result;
        }
    }

    private class BlockingNode {
        PackageID packageID;
        Name name;

        BlockingNode(PackageID packageID, Name name) {
            this.packageID = packageID;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockingNode that = (BlockingNode)o;
            if (!this.packageID.equals(that.packageID)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.packageID.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }

    private static enum AnalyzerPhase {
        INITIAL_ANALYSIS,
        BLOCKED_NODE_ANALYSIS,
        LOOP_ANALYSIS,
        LOOP_ANALYSIS_COMPLETE,
        LOOPS_RESOLVED_ANALYSIS;

    }
}

