/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model;

import io.ballerina.tools.diagnostics.Location;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstructorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BReadonlyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStringSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Lists;

public class SymbolTable {
    private static final CompilerContext.Key<SymbolTable> SYM_TABLE_KEY = new CompilerContext.Key();
    public static final PackageID TRANSACTION = new PackageID(Names.BUILTIN_ORG, Names.TRANSACTION_PACKAGE, Names.EMPTY);
    public static final Integer BBYTE_MIN_VALUE = 0;
    public static final Integer BBYTE_MAX_VALUE = 255;
    public static final Integer SIGNED32_MAX_VALUE = Integer.MAX_VALUE;
    public static final Integer SIGNED32_MIN_VALUE = Integer.MIN_VALUE;
    public static final Integer SIGNED16_MAX_VALUE = Short.MAX_VALUE;
    public static final Integer SIGNED16_MIN_VALUE = Short.MIN_VALUE;
    public static final Integer SIGNED8_MAX_VALUE = 127;
    public static final Integer SIGNED8_MIN_VALUE = -128;
    public static final Long UNSIGNED32_MAX_VALUE = 0xFFFFFFFFL;
    public static final Integer UNSIGNED16_MAX_VALUE = 65535;
    public static final Integer UNSIGNED8_MAX_VALUE = 255;
    public final Location builtinPos;
    public final BLangPackage rootPkgNode;
    public final BPackageSymbol rootPkgSymbol;
    public final BSymbol notFoundSymbol;
    public final Scope rootScope;
    public final BType noType = new BNoType(23);
    public final BType nilType = new BNilType();
    public final BType neverType = new BNeverType();
    public final BType intType = new BType(1, null, 32L);
    public final BType byteType = new BType(2, null, 32L);
    public final BType floatType = new BType(3, null, 32L);
    public final BType decimalType = new BType(4, null, 32L);
    public final BType stringType = new BType(5, null, 32L);
    public final BType booleanType = new BType(6, null, 32L);
    public final BType jsonType = new BJSONType(7, null);
    public final BType anyType = new BAnyType(17, null);
    public final BType anydataType = new BAnydataType(11, null);
    public final BMapType mapType = new BMapType(15, this.anyType, null);
    public final BMapType mapStringType = new BMapType(15, this.stringType, null);
    public final BMapType mapAnydataType = new BMapType(15, this.anydataType, null);
    public final BMapType mapJsonType = new BMapType(15, this.jsonType, null);
    public final BFutureType futureType = new BFutureType(31, this.nilType, null);
    public final BArrayType arrayType = new BArrayType(this.anyType);
    public final BArrayType arrayStringType = new BArrayType(this.stringType);
    public final BArrayType arrayAnydataType = new BArrayType(this.anydataType);
    public final BArrayType arrayJsonType = new BArrayType(this.jsonType);
    public final BType tupleType = new BTupleType(Lists.of(this.noType));
    public final BType recordType = new BRecordType(null);
    public final BType stringArrayType = new BArrayType(this.stringType);
    public final BType jsonArrayType = new BArrayType(this.jsonType);
    public final BType anydataArrayType = new BArrayType(this.anydataType);
    public final BType anyServiceType = new BServiceType(null);
    public final BType handleType = new BHandleType(36, null);
    public final BTypedescType typeDesc = new BTypedescType(this.anyType, null);
    public final BType readonlyType = new BReadonlyType(37, null);
    public final BType anydataOrReadonly = BUnionType.create(null, this.anydataType, this.readonlyType);
    public final BType semanticError = new BType(27, null);
    public final BType nullSet = new BType(50, null);
    public final BUnionType anydataOrReadOnlyType = BUnionType.create(null, this.anydataType, this.readonlyType);
    public BType streamType = new BStreamType(14, this.anydataType, null, null);
    public BType tableType = new BTableType(9, this.anydataType, null);
    public BMapType detailType = new BMapType(15, this.anydataOrReadonly, null);
    public BErrorType errorType = new BErrorType(null, this.detailType);
    public BConstructorSymbol errorConstructor;
    public BUnionType anyOrErrorType;
    public BUnionType pureType;
    public BUnionType errorOrNilType;
    public BFiniteType trueType;
    public BObjectType intRangeType;
    public BMapType mapAllType;
    public BArrayType arrayAllType;
    public BObjectType rawTemplateType;
    public final BIntSubType signed32IntType = new BIntSubType(38, Names.SIGNED32);
    public final BIntSubType signed16IntType = new BIntSubType(39, Names.SIGNED16);
    public final BIntSubType signed8IntType = new BIntSubType(40, Names.SIGNED8);
    public final BIntSubType unsigned32IntType = new BIntSubType(41, Names.UNSIGNED32);
    public final BIntSubType unsigned16IntType = new BIntSubType(42, Names.UNSIGNED16);
    public final BIntSubType unsigned8IntType = new BIntSubType(43, Names.UNSIGNED8);
    public final BStringSubType charStringType = new BStringSubType(44, Names.CHAR);
    public final BXMLSubType xmlElementType = new BXMLSubType(45, Names.XML_ELEMENT);
    public final BXMLSubType xmlPIType = new BXMLSubType(46, Names.XML_PI);
    public final BXMLSubType xmlCommentType = new BXMLSubType(47, Names.XML_COMMENT);
    public final BXMLSubType xmlTextType = new BXMLSubType(48, Names.XML_TEXT, 32L);
    public final BType xmlType = new BXMLType(BUnionType.create(null, this.xmlElementType, this.xmlCommentType, this.xmlPIType, this.xmlTextType), null);
    public BPackageSymbol langInternalModuleSymbol;
    public BPackageSymbol langAnnotationModuleSymbol;
    public BPackageSymbol langJavaModuleSymbol;
    public BPackageSymbol langArrayModuleSymbol;
    public BPackageSymbol langDecimalModuleSymbol;
    public BPackageSymbol langErrorModuleSymbol;
    public BPackageSymbol langFloatModuleSymbol;
    public BPackageSymbol langFutureModuleSymbol;
    public BPackageSymbol langIntModuleSymbol;
    public BPackageSymbol langMapModuleSymbol;
    public BPackageSymbol langObjectModuleSymbol;
    public BPackageSymbol langStreamModuleSymbol;
    public BPackageSymbol langStringModuleSymbol;
    public BPackageSymbol langTableModuleSymbol;
    public BPackageSymbol langTypedescModuleSymbol;
    public BPackageSymbol langValueModuleSymbol;
    public BPackageSymbol langXmlModuleSymbol;
    public BPackageSymbol langBooleanModuleSymbol;
    public BPackageSymbol langQueryModuleSymbol;
    public BPackageSymbol langRuntimeModuleSymbol;
    public BPackageSymbol langTransactionModuleSymbol;
    public BPackageSymbol internalTransactionModuleSymbol;
    private Names names;
    public Map<BPackageSymbol, SymbolEnv> pkgEnvMap = new HashMap<BPackageSymbol, SymbolEnv>();
    public Map<Name, BPackageSymbol> predeclaredModules = new HashMap<Name, BPackageSymbol>();

    public static SymbolTable getInstance(CompilerContext context) {
        SymbolTable symTable = context.get(SYM_TABLE_KEY);
        if (symTable == null) {
            symTable = new SymbolTable(context);
        }
        return symTable;
    }

    private SymbolTable(CompilerContext context) {
        context.put(SYM_TABLE_KEY, this);
        this.names = Names.getInstance(context);
        this.rootPkgNode = (BLangPackage)TreeBuilder.createPackageNode();
        this.rootPkgSymbol = new BPackageSymbol(PackageID.ANNOTATIONS, null, null, SymbolOrigin.BUILTIN);
        this.rootPkgNode.pos = this.builtinPos = new BLangDiagnosticLocation(Names.EMPTY.value, -1, -1, -1, -1);
        this.rootPkgNode.symbol = this.rootPkgSymbol;
        this.rootPkgSymbol.scope = this.rootScope = new Scope(this.rootPkgSymbol);
        this.rootPkgSymbol.pos = this.builtinPos;
        this.notFoundSymbol = new BSymbol(0, 1L, Names.INVALID, this.rootPkgSymbol.pkgID, this.noType, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.VIRTUAL);
        this.initializeType(this.intType, TypeKind.INT.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.byteType, TypeKind.BYTE.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.floatType, TypeKind.FLOAT.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.decimalType, TypeKind.DECIMAL.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.stringType, TypeKind.STRING.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.booleanType, TypeKind.BOOLEAN.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.jsonType, TypeKind.JSON.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.xmlType, TypeKind.XML.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.streamType, TypeKind.STREAM.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.tableType, TypeKind.TABLE.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType((BType)this.mapType, TypeKind.MAP.typeName(), SymbolOrigin.VIRTUAL);
        this.initializeType((BType)this.mapStringType, TypeKind.MAP.typeName(), SymbolOrigin.VIRTUAL);
        this.initializeType((BType)this.mapAnydataType, TypeKind.MAP.typeName(), SymbolOrigin.VIRTUAL);
        this.initializeType((BType)this.futureType, TypeKind.FUTURE.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.anyType, TypeKind.ANY.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.anydataType, TypeKind.ANYDATA.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.nilType, TypeKind.NIL.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.neverType, TypeKind.NEVER.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.anyServiceType, TypeKind.SERVICE.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.handleType, TypeKind.HANDLE.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType((BType)this.typeDesc, TypeKind.TYPEDESC.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.readonlyType, TypeKind.READONLY.typeName(), SymbolOrigin.BUILTIN);
        this.initializeTSymbol(this.signed32IntType, Names.SIGNED32, PackageID.INT);
        this.initializeTSymbol(this.signed16IntType, Names.SIGNED16, PackageID.INT);
        this.initializeTSymbol(this.signed8IntType, Names.SIGNED8, PackageID.INT);
        this.initializeTSymbol(this.unsigned32IntType, Names.UNSIGNED32, PackageID.INT);
        this.initializeTSymbol(this.unsigned16IntType, Names.UNSIGNED16, PackageID.INT);
        this.initializeTSymbol(this.unsigned8IntType, Names.UNSIGNED8, PackageID.INT);
        this.initializeTSymbol(this.charStringType, Names.CHAR, PackageID.STRING);
        this.initializeTSymbol(this.xmlElementType, Names.XML_ELEMENT, PackageID.XML);
        this.initializeTSymbol(this.xmlPIType, Names.XML_PI, PackageID.XML);
        this.initializeTSymbol(this.xmlCommentType, Names.XML_COMMENT, PackageID.XML);
        this.initializeTSymbol(this.xmlTextType, Names.XML_TEXT, PackageID.XML);
        final BLangLiteral trueLiteral = new BLangLiteral();
        trueLiteral.type = this.booleanType;
        trueLiteral.value = Boolean.TRUE;
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(0x10001C, 1L, this.names.fromString("$anonType$TRUE"), this.rootPkgNode.packageID, null, this.rootPkgNode.symbol.owner, this.builtinPos, SymbolOrigin.VIRTUAL);
        this.trueType = new BFiniteType(finiteTypeSymbol, (Set<BLangExpression>)new HashSet<BLangExpression>(){
            {
                this.add(trueLiteral);
            }
        });
    }

    public BType getTypeFromTag(int tag) {
        switch (tag) {
            case 1: {
                return this.intType;
            }
            case 2: {
                return this.byteType;
            }
            case 3: {
                return this.floatType;
            }
            case 4: {
                return this.decimalType;
            }
            case 5: {
                return this.stringType;
            }
            case 6: {
                return this.booleanType;
            }
            case 7: {
                return this.jsonType;
            }
            case 8: {
                return this.xmlType;
            }
            case 47: {
                return this.xmlCommentType;
            }
            case 46: {
                return this.xmlPIType;
            }
            case 45: {
                return this.xmlElementType;
            }
            case 48: {
                return this.xmlTextType;
            }
            case 14: {
                return this.streamType;
            }
            case 9: {
                return this.tableType;
            }
            case 10: {
                return this.nilType;
            }
            case 49: {
                return this.neverType;
            }
            case 28: {
                return this.errorType;
            }
            case 38: {
                return this.signed32IntType;
            }
            case 39: {
                return this.signed16IntType;
            }
            case 40: {
                return this.signed8IntType;
            }
            case 41: {
                return this.unsigned32IntType;
            }
            case 42: {
                return this.unsigned16IntType;
            }
            case 43: {
                return this.unsigned8IntType;
            }
            case 44: {
                return this.charStringType;
            }
        }
        return this.semanticError;
    }

    public BType getLangLibSubType(String name) {
        switch (name) {
            case "Signed32": {
                return this.signed32IntType;
            }
            case "Signed16": {
                return this.signed16IntType;
            }
            case "Signed8": {
                return this.signed8IntType;
            }
            case "Unsigned32": {
                return this.unsigned32IntType;
            }
            case "Unsigned16": {
                return this.unsigned16IntType;
            }
            case "Unsigned8": {
                return this.unsigned8IntType;
            }
            case "Char": {
                return this.charStringType;
            }
            case "Element": {
                return this.xmlElementType;
            }
            case "ProcessingInstruction": {
                return this.xmlPIType;
            }
            case "Comment": {
                return this.xmlCommentType;
            }
            case "Text": {
                return this.xmlTextType;
            }
        }
        throw new IllegalStateException("LangLib Subtype not found: " + name);
    }

    public void loadPredeclaredModules() {
        this.predeclaredModules = Map.ofEntries(Map.entry(Names.BOOLEAN, this.langBooleanModuleSymbol), Map.entry(Names.DECIMAL, this.langDecimalModuleSymbol), Map.entry(Names.ERROR, this.langErrorModuleSymbol), Map.entry(Names.FLOAT, this.langFloatModuleSymbol), Map.entry(Names.FUTURE, this.langFutureModuleSymbol), Map.entry(Names.INT, this.langIntModuleSymbol), Map.entry(Names.MAP, this.langMapModuleSymbol), Map.entry(Names.OBJECT, this.langObjectModuleSymbol), Map.entry(Names.STREAM, this.langStreamModuleSymbol), Map.entry(Names.STRING, this.langStringModuleSymbol), Map.entry(Names.TABLE, this.langTableModuleSymbol), Map.entry(Names.TYPEDESC, this.langTypedescModuleSymbol), Map.entry(Names.XML, this.langXmlModuleSymbol));
    }

    private void initializeType(BType type, String name, SymbolOrigin origin) {
        this.initializeType(type, this.names.fromString(name), origin);
    }

    private void initializeType(BType type, Name name, SymbolOrigin origin) {
        this.defineType(type, new BTypeSymbol(12, 1L, name, this.rootPkgSymbol.pkgID, type, this.rootPkgSymbol, this.builtinPos, origin));
    }

    private void initializeTSymbol(BType type, Name name, PackageID packageID) {
        type.tsymbol = new BTypeSymbol(12, 1L, name, packageID, type, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.BUILTIN);
    }

    private void defineType(BType type, BTypeSymbol tSymbol) {
        type.tsymbol = tSymbol;
        this.rootScope.define(tSymbol.name, tSymbol);
    }

    public void defineOperators() {
        this.defineIntegerArithmeticOperations();
        this.defineXmlStringConcatanationOperations();
        this.defineBinaryOperator(OperatorKind.ADD, this.stringType, this.stringType, this.stringType);
        this.defineBinaryOperator(OperatorKind.ADD, this.stringType, this.charStringType, this.stringType);
        this.defineBinaryOperator(OperatorKind.ADD, this.charStringType, this.stringType, this.stringType);
        this.defineBinaryOperator(OperatorKind.ADD, this.charStringType, this.charStringType, this.stringType);
        this.defineBinaryOperator(OperatorKind.ADD, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.ADD, this.decimalType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.ADD, this.intType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.ADD, this.floatType, this.intType, this.floatType);
        this.defineBinaryOperator(OperatorKind.ADD, this.intType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.ADD, this.decimalType, this.intType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.ADD, this.floatType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.ADD, this.decimalType, this.floatType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.SUB, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.SUB, this.decimalType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.SUB, this.floatType, this.intType, this.floatType);
        this.defineBinaryOperator(OperatorKind.SUB, this.intType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.SUB, this.decimalType, this.intType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.SUB, this.intType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.SUB, this.decimalType, this.floatType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.SUB, this.floatType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.DIV, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.DIV, this.decimalType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.DIV, this.intType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.DIV, this.floatType, this.intType, this.floatType);
        this.defineBinaryOperator(OperatorKind.DIV, this.intType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.DIV, this.decimalType, this.intType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.DIV, this.floatType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.DIV, this.decimalType, this.floatType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MUL, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.MUL, this.decimalType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MUL, this.floatType, this.intType, this.floatType);
        this.defineBinaryOperator(OperatorKind.MUL, this.intType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.MUL, this.decimalType, this.intType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MUL, this.intType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MUL, this.decimalType, this.floatType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MUL, this.floatType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MOD, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.MOD, this.decimalType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MOD, this.floatType, this.intType, this.floatType);
        this.defineBinaryOperator(OperatorKind.MOD, this.intType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.MOD, this.decimalType, this.intType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MOD, this.intType, this.decimalType, this.decimalType);
        this.defineIntegerBitwiseAndOperations();
        this.defineIntegerBitwiseOrOperations(OperatorKind.BITWISE_OR);
        this.defineIntegerBitwiseOrOperations(OperatorKind.BITWISE_XOR);
        this.defineIntegerLeftShiftOperations();
        this.defineIntegerRightShiftOperations(OperatorKind.BITWISE_RIGHT_SHIFT);
        this.defineIntegerRightShiftOperations(OperatorKind.BITWISE_UNSIGNED_RIGHT_SHIFT);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.jsonType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.nilType, this.jsonType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.anyType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.nilType, this.anyType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.anydataType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.nilType, this.anydataType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.jsonType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.nilType, this.jsonType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.anyType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.nilType, this.anyType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.anydataType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.nilType, this.anydataType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.jsonType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.nilType, this.jsonType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.anyType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.nilType, this.anyType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.anydataType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.nilType, this.anydataType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.intType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.floatType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.intType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.decimalType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.floatType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.decimalType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.floatType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.intType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.intType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.decimalType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.floatType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.decimalType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.floatType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.intType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.intType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.decimalType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.floatType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.decimalType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.floatType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.intType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.intType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.decimalType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.floatType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.decimalType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.AND, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.OR, this.booleanType, this.booleanType, this.booleanType);
        this.defineUnaryOperator(OperatorKind.ADD, this.floatType, this.floatType);
        this.defineUnaryOperator(OperatorKind.ADD, this.decimalType, this.decimalType);
        this.defineUnaryOperator(OperatorKind.ADD, this.intType, this.intType);
        this.defineUnaryOperator(OperatorKind.SUB, this.floatType, this.floatType);
        this.defineUnaryOperator(OperatorKind.SUB, this.decimalType, this.decimalType);
        this.defineUnaryOperator(OperatorKind.SUB, this.intType, this.intType);
        this.defineUnaryOperator(OperatorKind.NOT, this.booleanType, this.booleanType);
        this.defineUnaryOperator(OperatorKind.BITWISE_COMPLEMENT, this.byteType, this.byteType);
        this.defineUnaryOperator(OperatorKind.BITWISE_COMPLEMENT, this.intType, this.intType);
    }

    private void defineXmlStringConcatanationOperations() {
        this.defineBinaryOperator(OperatorKind.ADD, this.xmlType, this.stringType, this.xmlType);
        this.defineBinaryOperator(OperatorKind.ADD, this.xmlType, this.charStringType, this.xmlType);
        this.defineBinaryOperator(OperatorKind.ADD, this.stringType, this.xmlType, this.xmlType);
        this.defineBinaryOperator(OperatorKind.ADD, this.charStringType, this.xmlType, this.xmlType);
        this.defineBinaryOperator(OperatorKind.ADD, this.stringType, this.xmlTextType, this.xmlTextType);
        this.defineBinaryOperator(OperatorKind.ADD, this.charStringType, this.xmlTextType, this.xmlTextType);
        this.defineBinaryOperator(OperatorKind.ADD, this.xmlTextType, this.stringType, this.xmlTextType);
        this.defineBinaryOperator(OperatorKind.ADD, this.xmlTextType, this.charStringType, this.xmlTextType);
    }

    private void defineIntegerArithmeticOperations() {
        BType[] intTypes;
        for (BType lhs : intTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType}) {
            for (BType rhs : intTypes) {
                this.defineBinaryOperator(OperatorKind.ADD, lhs, rhs, this.intType);
                this.defineBinaryOperator(OperatorKind.SUB, lhs, rhs, this.intType);
                this.defineBinaryOperator(OperatorKind.DIV, lhs, rhs, this.intType);
                this.defineBinaryOperator(OperatorKind.MUL, lhs, rhs, this.intType);
                this.defineBinaryOperator(OperatorKind.MOD, lhs, rhs, this.intType);
            }
        }
    }

    private void defineIntegerBitwiseAndOperations() {
        BType[] unsignedIntTypes = new BType[]{this.byteType, this.unsigned8IntType, this.unsigned16IntType, this.unsigned32IntType};
        BType[] signedIntTypes = new BType[]{this.intType, this.signed8IntType, this.signed16IntType, this.signed32IntType};
        for (BType unsigned : unsignedIntTypes) {
            for (BType signed : signedIntTypes) {
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsigned, signed, unsigned);
            }
        }
        for (int i = 0; i < unsignedIntTypes.length; ++i) {
            for (int j = 0; j < unsignedIntTypes.length; ++j) {
                BType unsignedIntTypeLhs = unsignedIntTypes[i];
                BType unsignedIntTypeRhs = unsignedIntTypes[j];
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsignedIntTypeLhs, unsignedIntTypeRhs, i <= j ? unsignedIntTypeLhs : unsignedIntTypeRhs);
            }
        }
        for (BType signed : signedIntTypes) {
            for (BType unsigned : unsignedIntTypes) {
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signed, unsigned, unsigned);
            }
        }
        for (BType signedLhs : signedIntTypes) {
            for (BType signedRhs : signedIntTypes) {
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signedLhs, signedRhs, this.intType);
            }
        }
    }

    private void defineIntegerBitwiseOrOperations(OperatorKind orOpKind) {
        BType[] unsignedIntTypes = new BType[]{this.byteType, this.unsigned8IntType, this.unsigned16IntType, this.unsigned32IntType};
        BType[] signedIntTypes = new BType[]{this.intType, this.signed8IntType, this.signed16IntType, this.signed32IntType};
        for (BType unsigned : unsignedIntTypes) {
            for (BType signed : signedIntTypes) {
                this.defineBinaryOperator(orOpKind, unsigned, signed, this.intType);
            }
        }
        for (int i = 0; i < unsignedIntTypes.length; ++i) {
            for (int j = 0; j < unsignedIntTypes.length; ++j) {
                BType unsignedIntTypeLhs = unsignedIntTypes[i];
                BType unsignedIntTypeRhs = unsignedIntTypes[j];
                this.defineBinaryOperator(orOpKind, unsignedIntTypeLhs, unsignedIntTypeRhs, i <= j ? unsignedIntTypeLhs : unsignedIntTypeRhs);
            }
        }
        for (BType signed : signedIntTypes) {
            for (BType unsigned : unsignedIntTypes) {
                this.defineBinaryOperator(orOpKind, signed, unsigned, this.intType);
            }
        }
        for (BType signedLhs : signedIntTypes) {
            for (BType signedRhs : signedIntTypes) {
                this.defineBinaryOperator(orOpKind, signedLhs, signedRhs, this.intType);
            }
        }
    }

    private void defineIntegerLeftShiftOperations() {
        BType[] allIntTypes;
        for (BType lhs : allIntTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType}) {
            for (BType rhs : allIntTypes) {
                this.defineBinaryOperator(OperatorKind.BITWISE_LEFT_SHIFT, lhs, rhs, this.intType);
            }
        }
    }

    private void defineIntegerRightShiftOperations(OperatorKind rightShiftOpKind) {
        BType[] unsignedIntTypes = new BType[]{this.byteType, this.unsigned8IntType, this.unsigned16IntType, this.unsigned32IntType};
        BType[] signedIntTypes = new BType[]{this.intType, this.signed8IntType, this.signed16IntType, this.signed32IntType};
        BType[] allIntTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType};
        for (BType unsignedLhs : unsignedIntTypes) {
            for (BType intRhs : allIntTypes) {
                this.defineBinaryOperator(rightShiftOpKind, unsignedLhs, intRhs, unsignedLhs);
            }
        }
        for (BType signedLhs : signedIntTypes) {
            for (BType intRhs : allIntTypes) {
                this.defineBinaryOperator(rightShiftOpKind, signedLhs, intRhs, this.intType);
            }
        }
    }

    public void defineBinaryOperator(OperatorKind kind, BType lhsType, BType rhsType, BType retType) {
        List<BType> paramTypes = Lists.of(lhsType, rhsType);
        this.defineOperator(this.names.fromString(kind.value()), paramTypes, retType);
    }

    private void defineUnaryOperator(OperatorKind kind, BType type, BType retType) {
        List<BType> paramTypes = Lists.of(type);
        this.defineOperator(this.names.fromString(kind.value()), paramTypes, retType);
    }

    private void defineOperator(Name name, List<BType> paramTypes, BType retType) {
        BInvokableType opType = new BInvokableType(paramTypes, retType, null);
        BOperatorSymbol symbol = new BOperatorSymbol(name, this.rootPkgSymbol.pkgID, opType, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.BUILTIN);
        this.rootScope.define(name, symbol);
    }
}

