/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.symbols;

import io.ballerina.tools.diagnostics.Location;
import java.util.Set;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class Symbols {
    public static BPackageSymbol createPackageSymbol(PackageID packageID, SymbolTable symTable, SymbolOrigin origin) {
        BPackageSymbol pkgSymbol = new BPackageSymbol(packageID, symTable.rootPkgSymbol, symTable.builtinPos, origin);
        return Symbols.createPackageSymbolScope(symTable, pkgSymbol);
    }

    public static BPackageSymbol createPackageSymbol(PackageID packageID, SymbolTable symTable, long flags, SymbolOrigin origin) {
        BPackageSymbol pkgSymbol = new BPackageSymbol(packageID, symTable.rootPkgSymbol, flags, symTable.builtinPos, origin);
        return Symbols.createPackageSymbolScope(symTable, pkgSymbol);
    }

    private static BPackageSymbol createPackageSymbolScope(SymbolTable symTable, BPackageSymbol pkgSymbol) {
        pkgSymbol.scope = pkgSymbol.pkgID.equals(PackageID.ANNOTATIONS) ? symTable.rootScope : new Scope(pkgSymbol);
        return pkgSymbol;
    }

    public static BObjectTypeSymbol createObjectSymbol(long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        BObjectTypeSymbol typeSymbol = new BObjectTypeSymbol(196700, flags, name, pkgID, type, owner, pos, origin);
        typeSymbol.kind = SymbolKind.OBJECT;
        return typeSymbol;
    }

    public static BClassSymbol createClassSymbol(long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        BClassSymbol typeSymbol = new BClassSymbol(196700, flags, name, pkgID, type, owner, pos, origin);
        typeSymbol.kind = SymbolKind.OBJECT;
        return typeSymbol;
    }

    public static BRecordTypeSymbol createRecordSymbol(long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        BRecordTypeSymbol typeSymbol = new BRecordTypeSymbol(327772, flags, name, pkgID, type, owner, pos, origin);
        typeSymbol.kind = SymbolKind.RECORD;
        return typeSymbol;
    }

    public static BErrorTypeSymbol createErrorSymbol(long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        BErrorTypeSymbol typeSymbol = new BErrorTypeSymbol(589852, flags, name, pkgID, type, owner, pos, origin);
        typeSymbol.kind = SymbolKind.ERROR;
        return typeSymbol;
    }

    public static BAnnotationSymbol createAnnotationSymbol(long flags, Set<AttachPoint> points, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        BAnnotationSymbol annotationSymbol = new BAnnotationSymbol(name, flags, points, pkgID, type, owner, pos, origin);
        annotationSymbol.kind = SymbolKind.ANNOTATION;
        return annotationSymbol;
    }

    public static BInvokableSymbol createWorkerSymbol(long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        BInvokableSymbol symbol = Symbols.createInvokableSymbol(1284, flags, name, pkgID, type, owner, pos, origin);
        symbol.kind = SymbolKind.WORKER;
        return symbol;
    }

    public static BServiceSymbol createServiceSymbol(long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        BServiceSymbol serviceSymbol = new BServiceSymbol(flags, name, pkgID, type, owner, pos, origin);
        serviceSymbol.kind = SymbolKind.SERVICE;
        return serviceSymbol;
    }

    public static BInvokableSymbol createFunctionSymbol(long flags, Name name, PackageID pkgID, BType type, BSymbol owner, boolean bodyExist, Location pos, SymbolOrigin origin) {
        BInvokableSymbol symbol = Symbols.createInvokableSymbol(820, flags, name, pkgID, type, owner, pos, origin);
        symbol.bodyExist = bodyExist;
        symbol.kind = SymbolKind.FUNCTION;
        return symbol;
    }

    public static BTypeSymbol createTypeSymbol(int symTag, long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        if (type != null && type.tag == 16) {
            return Symbols.createInvokableTypeSymbol(symTag, flags, pkgID, type, owner, pos, origin);
        }
        return new BTypeSymbol(symTag, flags, name, pkgID, type, owner, pos, origin);
    }

    public static BInvokableTypeSymbol createInvokableTypeSymbol(int symTag, long flags, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        return new BInvokableTypeSymbol(symTag, flags, pkgID, type, owner, pos, origin);
    }

    public static BInvokableSymbol createInvokableSymbol(int kind, long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        return new BInvokableSymbol(kind, flags, name, pkgID, type, owner, pos, origin);
    }

    public static BXMLNSSymbol createXMLNSSymbol(Name name, String nsURI, PackageID pkgID, BSymbol owner, Location pos, SymbolOrigin origin) {
        return new BXMLNSSymbol(name, nsURI, pkgID, owner, pos, origin);
    }

    public static String getAttachedFuncSymbolName(String typeName, String funcName) {
        return typeName + Names.DOT.value + funcName;
    }

    public static boolean isNative(BSymbol sym) {
        return (sym.flags & 2L) == 2L;
    }

    public static boolean isPublic(BSymbol sym) {
        return (sym.flags & 1L) == 1L;
    }

    public static boolean isPrivate(BSymbol sym) {
        return (sym.flags & 0x400L) == 1024L;
    }

    public static boolean isRemote(BSymbol sym) {
        return (sym.flags & 0x8000L) == 32768L;
    }

    public static boolean isFlagOn(long mask, long flag) {
        return (mask & flag) == flag;
    }

    public static boolean isAttachPointPresent(int mask, int attachPoint) {
        return (mask & attachPoint) != 0;
    }

    public static boolean isOptional(BSymbol sym) {
        return (sym.flags & 0x1000L) == 4096L;
    }

    public static boolean isFunctionDeclaration(BSymbol sym) {
        return (sym.flags & 0x80L) == 128L;
    }

    public static boolean isTagOn(BSymbol symbol, int symTag) {
        return (symbol.tag & symTag) == symTag;
    }
}

