/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import org.ballerinalang.model.types.ObjectType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BObjectType
extends BStructureType
implements ObjectType {
    private static final String OBJECT = "object";
    private static final String SPACE = " ";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String LEFT_CURL = "{";
    private static final String RIGHT_CURL = "}";
    private static final String SEMI_COLON = ";";
    private static final String READONLY = "readonly";
    public BIntersectionType immutableType;
    public BObjectType mutableType = null;
    public BTypeIdSet typeIdSet = new BTypeIdSet();

    public BObjectType(BTypeSymbol tSymbol) {
        super(33, tSymbol);
    }

    public BObjectType(BTypeSymbol tSymbol, long flags) {
        super(33, tSymbol, flags);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.OBJECT;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        if (this.shouldPrintShape(this.tsymbol.name)) {
            StringBuilder sb = new StringBuilder();
            long symbolFlags = this.tsymbol.flags;
            if (Symbols.isFlagOn(symbolFlags, 0x20000000L)) {
                sb.append("isolated ");
            }
            sb.append(OBJECT).append(SPACE).append(LEFT_CURL);
            for (BField field : this.fields.values()) {
                long flags = field.symbol.flags;
                if (Symbols.isFlagOn(flags, 1L)) {
                    sb.append(SPACE).append(PUBLIC);
                } else if (Symbols.isFlagOn(flags, 1024L)) {
                    sb.append(SPACE).append(PRIVATE);
                }
                if (Symbols.isFlagOn(flags, 4L)) {
                    sb.append(SPACE).append("final");
                }
                sb.append(SPACE).append(field.type).append(SPACE).append(field.name).append(SEMI_COLON);
            }
            BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)this.tsymbol;
            for (BAttachedFunction fun : objectSymbol.attachedFuncs) {
                if (Symbols.isFlagOn(fun.symbol.flags, 1L)) {
                    sb.append(SPACE).append(PUBLIC);
                } else if (Symbols.isFlagOn(fun.symbol.flags, 1024L)) {
                    sb.append(SPACE).append(PRIVATE);
                }
                sb.append(SPACE).append(fun).append(SEMI_COLON);
            }
            sb.append(SPACE).append(RIGHT_CURL);
            if (Symbols.isFlagOn(symbolFlags, 32L)) {
                sb.append(" & readonly");
            }
            return sb.toString();
        }
        return this.tsymbol.toString();
    }

    @Override
    public BIntersectionType getImmutableType() {
        return this.immutableType;
    }
}

