/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import org.ballerinalang.model.types.TableType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BTableType
extends BType
implements TableType {
    public BType constraint;
    public BType keyTypeConstraint;
    public List<String> fieldNameList;
    public Location keyPos;
    public Location constraintPos;
    public BIntersectionType immutableType;

    public BTableType(int tag, BType constraint, BTypeSymbol tSymbol) {
        super(tag, tSymbol);
        this.constraint = constraint;
    }

    public BTableType(int tag, BType constraint, BTypeSymbol tSymbol, long flags) {
        super(tag, tSymbol, flags);
        this.constraint = constraint;
    }

    public BType getConstraint() {
        return this.constraint;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        Object stringRep;
        boolean readonly = Symbols.isFlagOn(this.flags, 32L);
        if (this.constraint == null) {
            return readonly ? super.toString().concat(" & readonly") : super.toString();
        }
        StringBuilder keyStringBuilder = new StringBuilder();
        if (this.fieldNameList != null) {
            for (String fieldName : this.fieldNameList) {
                if (!keyStringBuilder.toString().equals("")) {
                    keyStringBuilder.append(", ");
                }
                keyStringBuilder.append(fieldName);
            }
            stringRep = super.toString() + "<" + this.constraint + "> key(" + keyStringBuilder.toString() + ")";
        } else {
            stringRep = (super.toString() + "<" + this.constraint + "> " + (String)(this.keyTypeConstraint != null ? "key<" + this.keyTypeConstraint + ">" : "")).trim();
        }
        return readonly ? ((String)stringRep).concat(" & readonly") : stringRep;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.TABLE;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BIntersectionType getImmutableType() {
        return this.immutableType;
    }
}

