/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.types.UnionType;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.util.Names;

public class BUnionType
extends BType
implements UnionType {
    public BIntersectionType immutableType;
    private boolean nullable;
    private LinkedHashSet<BType> memberTypes;
    private Optional<Boolean> isAnyData = Optional.empty();
    private Optional<Boolean> isPureType = Optional.empty();

    protected BUnionType(BTypeSymbol tsymbol, LinkedHashSet<BType> memberTypes, boolean nullable, boolean readonly) {
        super(20, tsymbol);
        if (readonly) {
            this.flags |= 0x20L;
            if (tsymbol != null) {
                this.tsymbol.flags |= 0x20L;
            }
        }
        this.memberTypes = memberTypes;
        this.nullable = nullable;
    }

    public Set<BType> getMemberTypes() {
        return Collections.unmodifiableSet(this.memberTypes);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.UNION;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(this.getKind().typeName());
        for (BType bType : this.memberTypes) {
            if (bType.tag == 10) continue;
            joiner.add(bType.toString());
        }
        long count = 0L;
        for (BType memberType : this.memberTypes) {
            if (memberType.tag == 10) continue;
            ++count;
        }
        Object typeStr = count > 1L ? "(" + joiner.toString() + ")" : joiner.toString();
        boolean hasNilType = false;
        for (BType type : this.memberTypes) {
            if (type.tag != 10) continue;
            hasNilType = true;
            break;
        }
        return this.nullable && hasNilType ? (String)typeStr + Names.QUESTION_MARK.value : typeStr;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public static BUnionType create(BTypeSymbol tsymbol, LinkedHashSet<BType> types) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        boolean isImmutable = true;
        for (BType bType : BUnionType.toFlatTypeSet(types)) {
            if (bType.tag != 49) {
                memberTypes.add(bType);
            }
            if (!isImmutable || Symbols.isFlagOn(bType.flags, 32L)) continue;
            isImmutable = false;
        }
        boolean hasNilableType = false;
        for (BType bType : memberTypes) {
            if (!bType.isNullable() || bType.tag == 10) continue;
            hasNilableType = true;
            break;
        }
        if (hasNilableType) {
            LinkedHashSet<BType> linkedHashSet = new LinkedHashSet<BType>();
            for (BType t : memberTypes) {
                if (t.tag == 10) continue;
                linkedHashSet.add(t);
            }
            memberTypes = linkedHashSet;
        }
        for (BType bType : memberTypes) {
            if (!bType.isNullable()) continue;
            return new BUnionType(tsymbol, memberTypes, true, isImmutable);
        }
        return new BUnionType(tsymbol, memberTypes, false, isImmutable);
    }

    public static BUnionType create(BTypeSymbol tsymbol, BType ... types) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        for (BType type : types) {
            memberTypes.add(type);
        }
        return BUnionType.create(tsymbol, memberTypes);
    }

    public void add(BType type) {
        if (type.tag == 20 && !BUnionType.isTypeParamAvailable(type)) {
            assert (type instanceof BUnionType);
            this.memberTypes.addAll(BUnionType.toFlatTypeSet(((BUnionType)type).memberTypes));
        } else {
            this.memberTypes.add(type);
        }
        if (Symbols.isFlagOn(this.flags, 32L) && !Symbols.isFlagOn(type.flags, 32L)) {
            this.flags ^= 0x20L;
        }
        this.nullable = this.nullable || type.isNullable();
    }

    public void addAll(LinkedHashSet<BType> types) {
        types.forEach(this::add);
    }

    public void remove(BType type) {
        if (type.tag == 20) {
            assert (type instanceof BUnionType);
            this.memberTypes.removeAll(((BUnionType)type).getMemberTypes());
        } else {
            this.memberTypes.remove(type);
        }
        if (type.isNullable()) {
            this.nullable = false;
        }
        if (Symbols.isFlagOn(this.flags, 32L)) {
            return;
        }
        boolean isImmutable = true;
        for (BType memBType : this.memberTypes) {
            if (Symbols.isFlagOn(memBType.flags, 32L)) continue;
            isImmutable = false;
            break;
        }
        if (isImmutable) {
            this.flags |= 0x20L;
        }
    }

    public Iterator<BType> iterator() {
        return this.memberTypes.iterator();
    }

    @Override
    public boolean isAnydata() {
        if (this.isAnyData.isPresent()) {
            return this.isAnyData.get();
        }
        for (BType memberType : this.memberTypes) {
            if (memberType.isAnydata()) continue;
            this.isAnyData = Optional.of(false);
            return false;
        }
        this.isAnyData = Optional.of(true);
        return true;
    }

    @Override
    public boolean isPureType() {
        if (this.isPureType.isPresent()) {
            return this.isPureType.get();
        }
        for (BType memberType : this.memberTypes) {
            if (memberType.isPureType()) continue;
            this.isPureType = Optional.of(false);
            return false;
        }
        this.isPureType = Optional.of(true);
        return true;
    }

    private static LinkedHashSet<BType> toFlatTypeSet(LinkedHashSet<BType> types) {
        return types.stream().flatMap(type -> type.tag == 20 && !BUnionType.isTypeParamAvailable(type) ? ((BUnionType)type).memberTypes.stream() : Stream.of(type)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static boolean isTypeParamAvailable(BType type) {
        return type.tsymbol != null && Symbols.isFlagOn(type.tsymbol.flags, 0x200000L);
    }

    @Override
    public BIntersectionType getImmutableType() {
        return this.immutableType;
    }
}

