/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.QueryExpressionNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class BLangQueryExpr
extends BLangExpression
implements QueryExpressionNode {
    public List<BLangNode> queryClauseList = new ArrayList<BLangNode>();
    public List<IdentifierNode> fieldNameIdentifierList = new ArrayList<IdentifierNode>();
    public boolean isStream = false;
    public boolean isTable = false;

    @Override
    public BLangSelectClause getSelectClause() {
        for (BLangNode clause : this.queryClauseList) {
            if (clause.getKind() != NodeKind.SELECT) continue;
            return (BLangSelectClause)clause;
        }
        return null;
    }

    public List<BLangNode> getQueryClauses() {
        return this.queryClauseList;
    }

    @Override
    public void addQueryClause(BLangNode queryClause) {
        this.queryClauseList.add(queryClause);
    }

    @Override
    public boolean isStream() {
        return this.isStream;
    }

    @Override
    public void setIsStream(boolean isStream) {
        this.isStream = isStream;
    }

    @Override
    public boolean isTable() {
        return this.isTable;
    }

    @Override
    public void setIsTable(boolean isTable) {
        this.isTable = isTable;
    }

    @Override
    public void addFieldNameIdentifier(IdentifierNode fieldNameIdentifier) {
        this.fieldNameIdentifierList.add(fieldNameIdentifier);
    }

    @Override
    public List<IdentifierNode> getFieldNameIdentifierList() {
        return this.fieldNameIdentifierList;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.QUERY_EXPR;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.queryClauseList.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }
}

