/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.statements;

import io.ballerina.tools.diagnostics.Location;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.VariableReferenceNode;
import org.ballerinalang.model.tree.statements.AssignmentNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;

public class BLangAssignment
extends BLangStatement
implements AssignmentNode {
    public BLangExpression varRef;
    public BLangExpression expr;
    public boolean declaredWithVar;
    public boolean safeAssignment;

    public BLangAssignment() {
    }

    public BLangAssignment(Location pos, BLangExpression varRef, BLangExpression expr, boolean declaredWithVar) {
        this.pos = pos;
        this.varRef = varRef;
        this.expr = expr;
        this.declaredWithVar = declaredWithVar;
    }

    @Override
    public ExpressionNode getVariable() {
        return this.varRef;
    }

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    public boolean isDeclaredWithVar() {
        return this.declaredWithVar;
    }

    @Override
    public void setExpression(ExpressionNode expression) {
        this.expr = (BLangExpression)expression;
    }

    @Override
    public void setDeclaredWithVar(boolean isDeclaredWithVar) {
        this.declaredWithVar = isDeclaredWithVar;
    }

    @Override
    public void setVariable(VariableReferenceNode variableReferenceNode) {
        this.varRef = (BLangVariableReference)variableReferenceNode;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ASSIGNMENT;
    }

    public String toString() {
        return (this.declaredWithVar ? "var " : "") + (this.varRef != null ? this.varRef : "") + (String)(this.expr != null ? " = " + this.expr : ";");
    }
}

