/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.util.Flags;

public class ImmutableTypeCloner {
    private static final String AND_READONLY_SUFFIX = " & readonly";

    public static BType getEffectiveImmutableType(Location pos, Types types, SelectivelyImmutableReferenceType type, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        return ImmutableTypeCloner.getImmutableIntersectionType((Location)pos, (Types)types, (SelectivelyImmutableReferenceType)type, (SymbolEnv)env, (PackageID)env.enclPkg.packageID, (BSymbol)env.scope.owner, (SymbolTable)symTable, (BLangAnonymousModelHelper)anonymousModelHelper, (Names)names, new HashSet<Flag>(), new HashSet<BType>()).effectiveType;
    }

    public static BType getEffectiveImmutableType(Location pos, Types types, SelectivelyImmutableReferenceType type, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        return ImmutableTypeCloner.getImmutableIntersectionType((Location)pos, (Types)types, (SelectivelyImmutableReferenceType)type, null, (PackageID)pkgId, (BSymbol)owner, (SymbolTable)symTable, (BLangAnonymousModelHelper)anonymousModelHelper, (Names)names, new HashSet<Flag>(), new HashSet<BType>()).effectiveType;
    }

    public static BIntersectionType getImmutableIntersectionType(Location pos, Types types, SelectivelyImmutableReferenceType type, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<Flag> origObjFlagSet) {
        return ImmutableTypeCloner.getImmutableIntersectionType(pos, types, type, env, env.enclPkg.packageID, env.scope.owner, symTable, anonymousModelHelper, names, origObjFlagSet, new HashSet<BType>());
    }

    public static void markFieldsAsImmutable(BLangClassDefinition classDef, SymbolEnv pkgEnv, BObjectType objectType, Types types, BLangAnonymousModelHelper anonymousModelHelper, SymbolTable symbolTable, Names names, Location pos) {
        SymbolEnv typeDefEnv = SymbolEnv.createClassEnv(classDef, objectType.tsymbol.scope, pkgEnv);
        Iterator objectTypeFieldIterator = objectType.fields.values().iterator();
        Iterator<BLangSimpleVariable> classFieldIterator = classDef.fields.iterator();
        while (objectTypeFieldIterator.hasNext()) {
            BField typeField = (BField)objectTypeFieldIterator.next();
            BLangSimpleVariable classField = classFieldIterator.next();
            BType type = typeField.type;
            if (!types.isInherentlyImmutableType(type)) {
                typeField.symbol.type = ImmutableTypeCloner.getImmutableIntersectionType(pos, types, (SelectivelyImmutableReferenceType)((Object)type), typeDefEnv, symbolTable, anonymousModelHelper, names, classDef.flagSet);
                BIntersectionType immutableFieldType = typeField.symbol.type;
                classField.type = typeField.type = immutableFieldType;
            }
            typeField.symbol.flags |= 4L;
        }
    }

    private static BType getImmutableType(Location pos, Types types, BType type, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<BType> unresolvedTypes) {
        if (types.isInherentlyImmutableType(type)) {
            return type;
        }
        if (!types.isSelectivelyImmutableType(type, unresolvedTypes)) {
            return symTable.semanticError;
        }
        return ImmutableTypeCloner.getImmutableIntersectionType(pos, types, (SelectivelyImmutableReferenceType)((Object)type), env, pkgId, owner, symTable, anonymousModelHelper, names, new HashSet<Flag>(), unresolvedTypes);
    }

    private static BIntersectionType getImmutableIntersectionType(Location pos, Types types, SelectivelyImmutableReferenceType type, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<Flag> origObjFlagSet, Set<BType> unresolvedTypes) {
        BType origBType = (BType)((Object)type);
        if (origBType.tag == 21 && Symbols.isFlagOn(origBType.flags, 32L)) {
            return (BIntersectionType)origBType;
        }
        BIntersectionType immutableType = type.getImmutableType();
        if (immutableType != null) {
            return immutableType;
        }
        return ImmutableTypeCloner.setImmutableType(pos, types, type, env, pkgId, owner, symTable, anonymousModelHelper, names, origObjFlagSet, unresolvedTypes);
    }

    private static BIntersectionType setImmutableType(Location pos, Types types, SelectivelyImmutableReferenceType selectivelyImmutableRefType, SymbolEnv env, PackageID pkgId, BSymbol owner, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Set<Flag> origObjFlagSet, Set<BType> unresolvedTypes) {
        BIntersectionType immutableUnionIntersectionType;
        BType immutableType;
        BType type = (BType)((Object)selectivelyImmutableRefType);
        switch (type.tag) {
            case 45: 
            case 46: 
            case 47: {
                BIntersectionType immutableXmlSubTypeIntersectionType;
                BXMLSubType origXmlSubType = (BXMLSubType)type;
                BXMLSubType immutableXmlSubType = new BXMLSubType(origXmlSubType.tag, names.fromString(origXmlSubType.name.getValue().concat(AND_READONLY_SUFFIX)), origXmlSubType.flags | 0x20L);
                origXmlSubType.immutableType = immutableXmlSubTypeIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, origXmlSubType, immutableXmlSubType, symTable);
                return immutableXmlSubTypeIntersectionType;
            }
            case 8: {
                BIntersectionType immutableXmlIntersectionType;
                BXMLType origXmlType = (BXMLType)type;
                BTypeSymbol immutableXmlTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(names, origXmlType.tsymbol, env, pkgId, owner);
                BXMLType immutableXmlType = new BXMLType(ImmutableTypeCloner.getImmutableType(pos, types, origXmlType.constraint, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes), immutableXmlTSymbol, origXmlType.flags | 0x20L);
                immutableXmlTSymbol.type = immutableXmlType;
                origXmlType.immutableType = immutableXmlIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, origXmlType, immutableXmlType, symTable);
                return immutableXmlIntersectionType;
            }
            case 19: {
                BIntersectionType immutableArrayIntersectionType;
                BArrayType origArrayType = (BArrayType)type;
                BTypeSymbol immutableArrayTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(names, origArrayType.tsymbol, env, pkgId, owner);
                BArrayType immutableArrayType = new BArrayType(ImmutableTypeCloner.getImmutableType(pos, types, origArrayType.getElementType(), env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes), immutableArrayTSymbol, origArrayType.size, origArrayType.state, origArrayType.flags | 0x20L);
                if (immutableArrayTSymbol != null) {
                    immutableArrayTSymbol.type = immutableArrayType;
                }
                origArrayType.immutableType = immutableArrayIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(env, origArrayType, immutableArrayType, symTable);
                return immutableArrayIntersectionType;
            }
            case 30: {
                BIntersectionType immutableTupleIntersectionType;
                BTupleType origTupleType = (BTupleType)type;
                List<BType> origTupleMemTypes = origTupleType.tupleTypes;
                ArrayList<BType> immutableMemTypes = new ArrayList<BType>(origTupleMemTypes.size());
                for (BType origTupleMemType : origTupleMemTypes) {
                    immutableMemTypes.add(ImmutableTypeCloner.getImmutableType(pos, types, origTupleMemType, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes));
                }
                BTypeSymbol immutableTupleTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(names, origTupleType.tsymbol, env, pkgId, owner);
                BType origRestType = origTupleType.restType;
                BType tupleRestType = origRestType == null ? origRestType : ImmutableTypeCloner.getImmutableType(pos, types, origRestType, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes);
                BTupleType immutableTupleType = new BTupleType(immutableTupleTSymbol, immutableMemTypes, tupleRestType, origTupleType.flags | 0x20L);
                if (immutableTupleTSymbol != null) {
                    immutableTupleTSymbol.type = immutableTupleType;
                }
                origTupleType.immutableType = immutableTupleIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(env, origTupleType, immutableTupleType, symTable);
                return immutableTupleIntersectionType;
            }
            case 15: {
                BIntersectionType immutableMapIntersectionType;
                BMapType origMapType = (BMapType)type;
                BTypeSymbol immutableMapTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(names, origMapType.tsymbol, env, pkgId, owner);
                BMapType immutableMapType = new BMapType(origMapType.tag, ImmutableTypeCloner.getImmutableType(pos, types, origMapType.constraint, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes), immutableMapTSymbol, origMapType.flags | 0x20L);
                if (immutableMapTSymbol != null) {
                    immutableMapTSymbol.type = immutableMapType;
                }
                origMapType.immutableType = immutableMapIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(env, origMapType, immutableMapType, symTable);
                return immutableMapIntersectionType;
            }
            case 12: {
                BRecordType origRecordType = (BRecordType)type;
                return ImmutableTypeCloner.defineImmutableRecordType(pos, origRecordType, env, symTable, anonymousModelHelper, names, types, unresolvedTypes);
            }
            case 33: {
                BObjectType origObjectType = (BObjectType)type;
                return ImmutableTypeCloner.defineImmutableObjectType(pos, origObjectType, env, symTable, anonymousModelHelper, names, types, origObjFlagSet, unresolvedTypes);
            }
            case 9: {
                BIntersectionType immutableTableIntersectionType;
                BTableType origTableType = (BTableType)type;
                BTypeSymbol immutableTableTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(names, origTableType.tsymbol, env, pkgId, owner);
                BTableType immutableTableType = new BTableType(origTableType.tag, ImmutableTypeCloner.getImmutableType(pos, types, origTableType.constraint, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes), immutableTableTSymbol, origTableType.flags | 0x20L);
                BType origKeyTypeConstraint = origTableType.keyTypeConstraint;
                if (origKeyTypeConstraint != null) {
                    immutableTableType.keyTypeConstraint = ImmutableTypeCloner.getImmutableType(pos, types, origKeyTypeConstraint, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes);
                }
                immutableTableType.keyPos = origTableType.keyPos;
                immutableTableType.constraintPos = origTableType.constraintPos;
                immutableTableType.fieldNameList = origTableType.fieldNameList;
                if (immutableTableTSymbol != null) {
                    immutableTableTSymbol.type = immutableTableType;
                }
                origTableType.immutableType = immutableTableIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(env, origTableType, immutableTableType, symTable);
                return immutableTableIntersectionType;
            }
            case 17: {
                BIntersectionType immutableAnyIntersectionType;
                BAnyType immutableAnyType;
                BAnyType origAnyType = (BAnyType)type;
                BTypeSymbol immutableAnyTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(names, origAnyType.tsymbol, env, pkgId, owner);
                if (immutableAnyTSymbol != null) {
                    immutableAnyType = new BAnyType(origAnyType.tag, immutableAnyTSymbol, immutableAnyTSymbol.name, origAnyType.flags | 0x20L, origAnyType.isNullable());
                    immutableAnyTSymbol.type = immutableAnyType;
                } else {
                    immutableAnyType = new BAnyType(origAnyType.tag, immutableAnyTSymbol, ImmutableTypeCloner.getImmutableTypeName(names, TypeKind.ANY.typeName()), origAnyType.flags | 0x20L, origAnyType.isNullable());
                }
                origAnyType.immutableType = immutableAnyIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, origAnyType, immutableAnyType, symTable);
                return immutableAnyIntersectionType;
            }
            case 11: {
                BIntersectionType immutableAnydataIntersectionType;
                BAnydataType immutableAnydataType;
                BAnydataType origAnydataType = (BAnydataType)type;
                BTypeSymbol immutableAnydataTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(names, origAnydataType.tsymbol, env, pkgId, owner);
                if (immutableAnydataTSymbol != null) {
                    immutableAnydataType = new BAnydataType(origAnydataType.tag, immutableAnydataTSymbol, immutableAnydataTSymbol.name, origAnydataType.flags | 0x20L, origAnydataType.isNullable());
                    immutableAnydataTSymbol.type = immutableAnydataType;
                } else {
                    immutableAnydataType = new BAnydataType(origAnydataType.tag, immutableAnydataTSymbol, ImmutableTypeCloner.getImmutableTypeName(names, TypeKind.ANYDATA.typeName()), origAnydataType.flags | 0x20L, origAnydataType.isNullable());
                }
                origAnydataType.immutableType = immutableAnydataIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, origAnydataType, immutableAnydataType, symTable);
                return immutableAnydataIntersectionType;
            }
            case 7: {
                BIntersectionType immutableJsonIntersectionType;
                BJSONType origJsonType = (BJSONType)type;
                BTypeSymbol immutableJsonTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(names, origJsonType.tsymbol, env, pkgId, owner);
                BJSONType immutableJsonType = new BJSONType(origJsonType.tag, immutableJsonTSymbol, origJsonType.isNullable(), origJsonType.flags | 0x20L);
                if (immutableJsonTSymbol != null) {
                    immutableJsonTSymbol.type = immutableJsonType;
                }
                origJsonType.immutableType = immutableJsonIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(pkgId, owner, origJsonType, immutableJsonType, symTable);
                return immutableJsonIntersectionType;
            }
            case 21: {
                return (BIntersectionType)type;
            }
        }
        BUnionType origUnionType = (BUnionType)type;
        LinkedHashSet<BType> readOnlyMemTypes = new LinkedHashSet<BType>();
        for (BType memberType : origUnionType.getMemberTypes()) {
            if (types.isInherentlyImmutableType(memberType)) {
                readOnlyMemTypes.add(memberType);
                continue;
            }
            if (!types.isSelectivelyImmutableType(memberType, unresolvedTypes)) continue;
            readOnlyMemTypes.add(ImmutableTypeCloner.getImmutableType(pos, types, memberType, env, pkgId, owner, symTable, anonymousModelHelper, names, unresolvedTypes));
        }
        if (readOnlyMemTypes.size() == 1) {
            immutableType = (BType)readOnlyMemTypes.iterator().next();
        } else if (origUnionType.tsymbol != null) {
            BTypeSymbol immutableUnionTSymbol = ImmutableTypeCloner.getReadonlyTSymbol(names, origUnionType.tsymbol, env, pkgId, owner);
            immutableType = BUnionType.create(immutableUnionTSymbol, readOnlyMemTypes);
            immutableType.flags |= origUnionType.flags | 0x20L;
            if (immutableUnionTSymbol != null) {
                immutableUnionTSymbol.type = immutableType;
            }
        } else {
            immutableType = BUnionType.create(null, readOnlyMemTypes);
            immutableType.flags |= origUnionType.flags | 0x20L;
        }
        origUnionType.immutableType = immutableUnionIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(env, origUnionType, immutableType, symTable);
        return immutableUnionIntersectionType;
    }

    public static void defineUndefinedImmutableFields(BLangTypeDefinition immutableTypeDefinition, Types types, SymbolEnv pkgEnv, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        Location pos = immutableTypeDefinition.pos;
        SymbolEnv env = SymbolEnv.createTypeEnv(immutableTypeDefinition.typeNode, immutableTypeDefinition.symbol.scope, pkgEnv);
        PackageID pkgID = env.enclPkg.symbol.pkgID;
        BType immutableType = immutableTypeDefinition.type;
        if (immutableType.tag == 12) {
            ImmutableTypeCloner.defineUndefinedImmutableRecordFields((BRecordType)immutableType, pos, pkgID, immutableTypeDefinition, types, env, symTable, anonymousModelHelper, names);
            return;
        }
        ImmutableTypeCloner.defineUndefinedImmutableObjectFields((BObjectType)immutableType, pos, pkgID, immutableTypeDefinition, types, env, symTable, anonymousModelHelper, names);
    }

    private static void defineUndefinedImmutableRecordFields(BRecordType immutableRecordType, Location loc, PackageID pkgID, BLangTypeDefinition immutableTypeDefinition, Types types, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        BType currentRestFieldType;
        BRecordType origRecordType = immutableRecordType.mutableType;
        if (origRecordType.fields.size() != immutableRecordType.fields.size()) {
            ImmutableTypeCloner.populateImmutableStructureFields(types, symTable, anonymousModelHelper, names, (BLangRecordTypeNode)immutableTypeDefinition.typeNode, immutableRecordType, origRecordType, loc, env, pkgID, new HashSet<BType>());
        }
        if ((currentRestFieldType = immutableRecordType.restFieldType) != null && currentRestFieldType != symTable.noType) {
            return;
        }
        ImmutableTypeCloner.setRestType(types, symTable, anonymousModelHelper, names, immutableRecordType, origRecordType, loc, env, new HashSet<BType>());
    }

    private static void defineUndefinedImmutableObjectFields(BObjectType immutableObjectType, Location location, PackageID pkgID, BLangTypeDefinition immutableTypeDefinition, Types types, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names) {
        BObjectType origObjectType = immutableObjectType.mutableType;
        if (origObjectType.fields.size() != immutableObjectType.fields.size()) {
            ImmutableTypeCloner.populateImmutableStructureFields(types, symTable, anonymousModelHelper, names, (BLangObjectTypeNode)immutableTypeDefinition.typeNode, immutableObjectType, origObjectType, location, env, pkgID, new HashSet<BType>(), 4L);
        }
    }

    private static void populateImmutableStructureFields(Types types, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, BLangStructureTypeNode immutableStructureTypeNode, BStructureType immutableStructureType, BStructureType origStructureType, Location pos, SymbolEnv env, PackageID pkgID, Set<BType> unresolvedTypes) {
        ImmutableTypeCloner.populateImmutableStructureFields(types, symTable, anonymousModelHelper, names, immutableStructureTypeNode, immutableStructureType, origStructureType, pos, env, pkgID, unresolvedTypes, 32L);
    }

    private static void populateImmutableStructureFields(Types types, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, BLangStructureTypeNode immutableStructureTypeNode, BStructureType immutableStructureType, BStructureType origStructureType, Location pos, SymbolEnv env, PackageID pkgID, Set<BType> unresolvedTypes, long flag) {
        BTypeSymbol immutableStructureSymbol = immutableStructureType.tsymbol;
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        for (BField origField : origStructureType.fields.values()) {
            BType immutableFieldType = ImmutableTypeCloner.getImmutableType(pos, types, origField.type, env, env.enclPkg.packageID, env.scope.owner, symTable, anonymousModelHelper, names, unresolvedTypes);
            Name origFieldName = origField.name;
            BVarSymbol immutableFieldSymbol = new BVarSymbol(origField.symbol.flags | flag, origFieldName, pkgID, immutableFieldType, immutableStructureSymbol, origField.pos, SymbolOrigin.SOURCE);
            if (immutableFieldType.tag == 16 && immutableFieldType.tsymbol != null) {
                BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)immutableFieldType.tsymbol;
                BInvokableSymbol invokableSymbol = (BInvokableSymbol)immutableFieldSymbol;
                invokableSymbol.params = tsymbol.params;
                invokableSymbol.restParam = tsymbol.restParam;
                invokableSymbol.retType = tsymbol.returnType;
                invokableSymbol.flags = tsymbol.flags;
            }
            String nameString = origFieldName.value;
            fields.put(nameString, new BField(origFieldName, null, immutableFieldSymbol));
            immutableStructureSymbol.scope.define(origFieldName, immutableFieldSymbol);
        }
        immutableStructureType.fields = fields;
        BLangUserDefinedType origTypeRef = new BLangUserDefinedType(ASTBuilderUtil.createIdentifier(pos, ImmutableTypeCloner.getPackageAlias(env, pos.lineRange().filePath(), origStructureType.tsymbol.pkgID)), ASTBuilderUtil.createIdentifier(pos, origStructureType.tsymbol.name.value));
        origTypeRef.pos = pos;
        origTypeRef.type = origStructureType;
        immutableStructureTypeNode.typeRefs.add(origTypeRef);
    }

    private static String getPackageAlias(SymbolEnv env, String compUnitName, PackageID typePkgId) {
        for (BLangImportPackage importStmt : env.enclPkg.imports) {
            if (!typePkgId.equals(importStmt.symbol.pkgID) || !importStmt.compUnit.value.equals(compUnitName)) continue;
            return importStmt.alias.value;
        }
        return "";
    }

    private static void setRestType(Types types, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, BRecordType immutableRecordType, BRecordType origRecordType, Location pos, SymbolEnv env, Set<BType> unresolvedTypes) {
        immutableRecordType.sealed = origRecordType.sealed;
        BType origRestFieldType = origRecordType.restFieldType;
        if (origRestFieldType == null || origRestFieldType == symTable.noType) {
            immutableRecordType.restFieldType = origRestFieldType;
            return;
        }
        immutableRecordType.restFieldType = ImmutableTypeCloner.getImmutableType(pos, types, origRestFieldType, env, env.enclPkg.packageID, env.scope.owner, symTable, anonymousModelHelper, names, unresolvedTypes);
    }

    private static BIntersectionType defineImmutableRecordType(Location pos, BRecordType origRecordType, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Types types, Set<BType> unresolvedTypes) {
        BIntersectionType immutableRecordIntersectionType;
        PackageID pkgID = env.enclPkg.symbol.pkgID;
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(origRecordType.tsymbol.flags | 0x20L, ImmutableTypeCloner.getImmutableTypeName(names, origRecordType.tsymbol.toString()), pkgID, null, env.scope.owner, pos, SymbolOrigin.SOURCE);
        BInvokableType bInvokableType = new BInvokableType(new ArrayList<BType>(), symTable.nilType, null);
        BInvokableSymbol initFuncSymbol = Symbols.createFunctionSymbol(1L, Names.EMPTY, env.enclPkg.symbol.pkgID, bInvokableType, env.scope.owner, false, symTable.builtinPos, SymbolOrigin.VIRTUAL);
        initFuncSymbol.retType = symTable.nilType;
        recordSymbol.initializerFunc = new BAttachedFunction(Names.INIT_FUNCTION_SUFFIX, initFuncSymbol, bInvokableType, symTable.builtinPos);
        recordSymbol.scope = new Scope(recordSymbol);
        recordSymbol.scope.define(names.fromString(recordSymbol.name.value + "." + recordSymbol.initializerFunc.funcName.value), recordSymbol.initializerFunc.symbol);
        BRecordType immutableRecordType = new BRecordType(recordSymbol, origRecordType.flags | 0x20L);
        origRecordType.immutableType = immutableRecordIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(env, origRecordType, immutableRecordType, symTable);
        immutableRecordType.mutableType = origRecordType;
        recordSymbol.type = immutableRecordType;
        immutableRecordType.tsymbol = recordSymbol;
        BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(new ArrayList<BLangSimpleVariable>(), immutableRecordType, pos);
        ImmutableTypeCloner.populateImmutableStructureFields(types, symTable, anonymousModelHelper, names, recordTypeNode, immutableRecordType, origRecordType, pos, env, pkgID, unresolvedTypes);
        ImmutableTypeCloner.setRestType(types, symTable, anonymousModelHelper, names, immutableRecordType, origRecordType, pos, env, unresolvedTypes);
        TypeDefBuilderHelper.createInitFunctionForRecordType(recordTypeNode, env, names, symTable);
        BLangTypeDefinition typeDefinition = TypeDefBuilderHelper.addTypeDefinition(immutableRecordType, recordSymbol, recordTypeNode, env);
        typeDefinition.pos = pos;
        return immutableRecordIntersectionType;
    }

    private static BIntersectionType defineImmutableObjectType(Location pos, BObjectType origObjectType, SymbolEnv env, SymbolTable symTable, BLangAnonymousModelHelper anonymousModelHelper, Names names, Types types, Set<Flag> flagSet, Set<BType> unresolvedTypes) {
        BIntersectionType immutableObjectIntersectionType;
        PackageID pkgID = env.enclPkg.symbol.pkgID;
        BObjectTypeSymbol origObjectTSymbol = (BObjectTypeSymbol)origObjectType.tsymbol;
        BObjectTypeSymbol objectSymbol = Symbols.createObjectSymbol(origObjectTSymbol.flags | 0x20L, ImmutableTypeCloner.getImmutableTypeName(names, origObjectTSymbol.toString()), pkgID, null, env.scope.owner, pos, SymbolOrigin.SOURCE);
        objectSymbol.scope = new Scope(objectSymbol);
        ImmutableTypeCloner.defineObjectFunctions(objectSymbol, origObjectTSymbol, names, symTable);
        BObjectType immutableObjectType = new BObjectType(objectSymbol, origObjectType.flags | 0x20L);
        origObjectType.immutableType = immutableObjectIntersectionType = ImmutableTypeCloner.createImmutableIntersectionType(env, origObjectType, immutableObjectType, symTable);
        immutableObjectType.mutableType = origObjectType;
        objectSymbol.type = immutableObjectType;
        immutableObjectType.tsymbol = objectSymbol;
        BLangObjectTypeNode objectTypeNode = TypeDefBuilderHelper.createObjectTypeNode(new ArrayList<BLangSimpleVariable>(), immutableObjectType, pos);
        objectTypeNode.flagSet.addAll(flagSet);
        ImmutableTypeCloner.populateImmutableStructureFields(types, symTable, anonymousModelHelper, names, objectTypeNode, immutableObjectType, origObjectType, pos, env, pkgID, unresolvedTypes, 4L);
        BLangTypeDefinition typeDefinition = TypeDefBuilderHelper.addTypeDefinition(immutableObjectType, objectSymbol, objectTypeNode, env);
        typeDefinition.pos = pos;
        return immutableObjectIntersectionType;
    }

    public static void defineObjectFunctions(BObjectTypeSymbol immutableObjectSymbol, BObjectTypeSymbol originalObjectSymbol, Names names, SymbolTable symTable) {
        List originalObjectAttachedFuncs = originalObjectSymbol.attachedFuncs;
        List immutableObjectAttachedFuncs = immutableObjectSymbol.attachedFuncs;
        if (originalObjectAttachedFuncs.isEmpty() || immutableObjectAttachedFuncs.size() == originalObjectAttachedFuncs.size()) {
            return;
        }
        ArrayList<BAttachedFunction> immutableFuncs = new ArrayList<BAttachedFunction>();
        for (BAttachedFunction origFunc : originalObjectAttachedFuncs) {
            Name funcName = names.fromString(Symbols.getAttachedFuncSymbolName(immutableObjectSymbol.name.value, origFunc.funcName.value));
            BInvokableSymbol immutableFuncSymbol = ASTBuilderUtil.duplicateFunctionDeclarationSymbol(origFunc.symbol, immutableObjectSymbol, funcName, immutableObjectSymbol.pkgID, symTable.builtinPos, SymbolOrigin.VIRTUAL);
            immutableFuncs.add(new BAttachedFunction(origFunc.funcName, immutableFuncSymbol, (BInvokableType)immutableFuncSymbol.type, symTable.builtinPos));
            immutableObjectSymbol.scope.define(funcName, immutableFuncSymbol);
        }
        immutableObjectSymbol.attachedFuncs = immutableFuncs;
    }

    private static BTypeSymbol getReadonlyTSymbol(Names names, BTypeSymbol originalTSymbol, SymbolEnv env, PackageID pkgId, BSymbol owner) {
        if (originalTSymbol == null) {
            return null;
        }
        if (env == null) {
            return Symbols.createTypeSymbol(originalTSymbol.tag, originalTSymbol.flags | 0x20L, ImmutableTypeCloner.getImmutableTypeName(names, originalTSymbol), pkgId, null, owner, originalTSymbol.pos, SymbolOrigin.SOURCE);
        }
        return Symbols.createTypeSymbol(originalTSymbol.tag, originalTSymbol.flags | 0x20L, ImmutableTypeCloner.getImmutableTypeName(names, originalTSymbol), env.enclPkg.symbol.pkgID, null, env.scope.owner, originalTSymbol.pos, SymbolOrigin.SOURCE);
    }

    private static Name getImmutableTypeName(Names names, BTypeSymbol originalTSymbol) {
        return ImmutableTypeCloner.getImmutableTypeName(names, originalTSymbol.name.getValue());
    }

    private static Name getImmutableTypeName(Names names, String origName) {
        return names.fromString("(".concat(origName).concat(AND_READONLY_SUFFIX).concat(")"));
    }

    private static BIntersectionType createImmutableIntersectionType(SymbolEnv env, BType nonReadOnlyType, BType effectiveType, SymbolTable symTable) {
        return ImmutableTypeCloner.createImmutableIntersectionType(env.enclPkg.symbol.pkgID, env.scope.owner, nonReadOnlyType, effectiveType, symTable);
    }

    private static BIntersectionType createImmutableIntersectionType(PackageID pkgId, BSymbol owner, final BType nonReadOnlyType, BType effectiveType, final SymbolTable symTable) {
        BTypeSymbol intersectionTypeSymbol = Symbols.createTypeSymbol(4194332, Flags.asMask(EnumSet.of(Flag.PUBLIC, Flag.READONLY)), Names.EMPTY, pkgId, null, owner, symTable.builtinPos, SymbolOrigin.VIRTUAL);
        LinkedHashSet<BType> constituentTypes = new LinkedHashSet<BType>(){
            {
                this.add(nonReadOnlyType);
                this.add(symTable.readonlyType);
            }
        };
        BIntersectionType intersectionType = new BIntersectionType(intersectionTypeSymbol, constituentTypes, effectiveType, 32L);
        intersectionTypeSymbol.type = intersectionType;
        return intersectionType;
    }
}

