/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.TaintRecord;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Flags;

public class TypeDefBuilderHelper {
    public static BLangRecordTypeNode createRecordTypeNode(BRecordType recordType, PackageID packageID, SymbolTable symTable, Location pos) {
        ArrayList<BLangSimpleVariable> fieldList = new ArrayList<BLangSimpleVariable>();
        for (BField field : recordType.fields.values()) {
            BVarSymbol symbol = field.symbol;
            if (symbol == null) {
                symbol = new BVarSymbol(1L, field.name, packageID, symTable.pureType, null, field.pos, SymbolOrigin.VIRTUAL);
            }
            BLangSimpleVariable fieldVar = ASTBuilderUtil.createVariable(field.pos, symbol.name.value, field.type, null, symbol);
            fieldList.add(fieldVar);
        }
        return TypeDefBuilderHelper.createRecordTypeNode(fieldList, recordType, pos);
    }

    public static BLangObjectTypeNode createObjectTypeNode(BObjectType objectType, Location pos) {
        ArrayList<BLangSimpleVariable> fieldList = new ArrayList<BLangSimpleVariable>();
        for (BField field : objectType.fields.values()) {
            BVarSymbol symbol = field.symbol;
            BLangSimpleVariable fieldVar = ASTBuilderUtil.createVariable(field.pos, symbol.name.value, field.type, null, symbol);
            fieldList.add(fieldVar);
        }
        return TypeDefBuilderHelper.createObjectTypeNode(fieldList, objectType, pos);
    }

    public static BLangRecordTypeNode createRecordTypeNode(List<BLangSimpleVariable> typeDefFields, BRecordType recordType, Location pos) {
        BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)TreeBuilder.createRecordTypeNode();
        recordTypeNode.type = recordType;
        recordTypeNode.fields = typeDefFields;
        recordTypeNode.symbol = recordType.tsymbol;
        recordTypeNode.pos = pos;
        return recordTypeNode;
    }

    public static BLangObjectTypeNode createObjectTypeNode(List<BLangSimpleVariable> typeDefFields, BObjectType objectType, Location pos) {
        BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)TreeBuilder.createObjectTypeNode();
        objectTypeNode.type = objectType;
        objectTypeNode.fields = typeDefFields;
        objectTypeNode.symbol = objectType.tsymbol;
        objectTypeNode.pos = pos;
        return objectTypeNode;
    }

    public static BLangFunction createInitFunctionForRecordType(BLangRecordTypeNode recordTypeNode, SymbolEnv env, Names names, SymbolTable symTable) {
        BLangFunction initFunction = TypeDefBuilderHelper.createInitFunctionForStructureType(recordTypeNode.pos, recordTypeNode.symbol, env, names, Names.INIT_FUNCTION_SUFFIX, symTable, recordTypeNode.type);
        BStructureTypeSymbol structureSymbol = (BStructureTypeSymbol)recordTypeNode.type.tsymbol;
        structureSymbol.initializerFunc = new BAttachedFunction(initFunction.symbol.name, initFunction.symbol, (BInvokableType)initFunction.type, initFunction.pos);
        recordTypeNode.initFunction = initFunction;
        structureSymbol.scope.define(structureSymbol.initializerFunc.symbol.name, structureSymbol.initializerFunc.symbol);
        return initFunction;
    }

    public static BLangFunction createInitFunctionForStructureType(Location location, BSymbol symbol, SymbolEnv env, Names names, Name suffix, SymbolTable symTable, BType type) {
        BVarSymbol receiverSymbol;
        String structTypeName = type.tsymbol.name.value;
        BLangFunction initFunction = ASTBuilderUtil.createInitFunctionWithNilReturn(location, structTypeName, suffix);
        initFunction.receiver = ASTBuilderUtil.createReceiver(location, type);
        initFunction.receiver.symbol = receiverSymbol = new BVarSymbol(Flags.asMask(EnumSet.noneOf(Flag.class)), names.fromIdNode(initFunction.receiver.name), env.enclPkg.symbol.pkgID, type, null, location, SymbolOrigin.VIRTUAL);
        initFunction.attachedFunction = true;
        initFunction.flagSet.add(Flag.ATTACHED);
        initFunction.type = new BInvokableType(new ArrayList<BType>(), symTable.nilType, null);
        Name funcSymbolName = names.fromString(Symbols.getAttachedFuncSymbolName(structTypeName, suffix.value));
        initFunction.symbol = Symbols.createFunctionSymbol(Flags.asMask(initFunction.flagSet), funcSymbolName, env.enclPkg.symbol.pkgID, initFunction.type, symbol, initFunction.body != null, initFunction.pos, SymbolOrigin.VIRTUAL);
        initFunction.symbol.scope = new Scope(initFunction.symbol);
        initFunction.symbol.scope.define(receiverSymbol.name, receiverSymbol);
        initFunction.symbol.receiverSymbol = receiverSymbol;
        initFunction.name = ASTBuilderUtil.createIdentifier(location, funcSymbolName.value);
        BInvokableTypeSymbol tsymbol = Symbols.createInvokableTypeSymbol(67108892, initFunction.symbol.flags, env.enclPkg.packageID, initFunction.type, initFunction.symbol, initFunction.pos, SymbolOrigin.VIRTUAL);
        tsymbol.params = initFunction.symbol.params;
        tsymbol.restParam = initFunction.symbol.restParam;
        tsymbol.returnType = initFunction.symbol.retType;
        initFunction.type.tsymbol = tsymbol;
        receiverSymbol.owner = initFunction.symbol;
        initFunction.symbol.retType = symTable.nilType;
        initFunction.symbol.taintTable = new HashMap<Integer, TaintRecord>();
        TaintRecord taintRecord = new TaintRecord(TaintRecord.TaintedStatus.UNTAINTED, new ArrayList<TaintRecord.TaintedStatus>());
        initFunction.symbol.taintTable.put(-1, taintRecord);
        return initFunction;
    }

    public static BLangTypeDefinition addTypeDefinition(BType type, BTypeSymbol symbol, BLangType typeNode, SymbolEnv env) {
        BLangTypeDefinition typeDefinition = (BLangTypeDefinition)TreeBuilder.createTypeDefinition();
        env.enclPkg.addTypeDefinition(typeDefinition);
        typeDefinition.typeNode = typeNode;
        typeDefinition.type = type;
        typeDefinition.symbol = symbol;
        return typeDefinition;
    }

    public static BLangClassDefinition createClassDef(Location pos, BObjectTypeSymbol classTSymbol, SymbolEnv env) {
        BObjectType objType = (BObjectType)classTSymbol.type;
        ArrayList<BLangSimpleVariable> fieldList = new ArrayList<BLangSimpleVariable>();
        for (BField field : objType.fields.values()) {
            BVarSymbol symbol = field.symbol;
            BLangSimpleVariable fieldVar = ASTBuilderUtil.createVariable(field.pos, symbol.name.value, field.type, null, symbol);
            fieldList.add(fieldVar);
        }
        BLangClassDefinition classDefNode = (BLangClassDefinition)TreeBuilder.createClassDefNode();
        classDefNode.type = objType;
        classDefNode.fields = fieldList;
        classDefNode.symbol = classTSymbol;
        classDefNode.pos = pos;
        env.enclPkg.addClassDefinition(classDefNode);
        return classDefNode;
    }
}

