/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.openapi.validator.ResourceParameter;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

class ResourceSummary {
    private Diagnostic.DiagnosticPosition resourcePosition = null;
    private String path = null;
    private String body;
    private Diagnostic.DiagnosticPosition pathPosition = null;
    private List<String> methods = new ArrayList<String>();
    private Diagnostic.DiagnosticPosition methodsPosition = null;
    private Map<String, BLangSimpleVariable> parameters = new HashMap<String, BLangSimpleVariable>();

    ResourceSummary() {
    }

    void setResourcePosition(Diagnostic.DiagnosticPosition position) {
        this.resourcePosition = position;
    }

    String getPath() {
        return this.path;
    }

    void setPath(String path) {
        this.path = path;
    }

    List<String> getMethods() {
        return this.methods;
    }

    void addMethod(String method) {
        this.methods.add(method);
    }

    boolean isMethodAvailable(String method) {
        boolean isAvailable = false;
        for (String m : this.methods) {
            if (!m.equals(method)) continue;
            isAvailable = true;
            break;
        }
        return isAvailable;
    }

    Diagnostic.DiagnosticPosition getPathPosition() {
        return this.pathPosition;
    }

    void setPathPosition(Diagnostic.DiagnosticPosition pathPosition) {
        this.pathPosition = pathPosition;
    }

    Diagnostic.DiagnosticPosition getMethodsPosition() {
        return this.methodsPosition;
    }

    void setMethodsPosition(Diagnostic.DiagnosticPosition methodsPosition) {
        this.methodsPosition = methodsPosition;
    }

    public void setParameters(List<? extends SimpleVariableNode> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            BLangSimpleVariable variable;
            SimpleVariableNode simpleVariableNode;
            if (i <= 1 || !((simpleVariableNode = parameters.get(i)) instanceof BLangSimpleVariable) || (variable = (BLangSimpleVariable)simpleVariableNode).getName().getValue().equals(this.getBody())) continue;
            this.parameters.put(variable.getName().getValue(), variable);
        }
    }

    public List<ResourceParameter> getParamNames() {
        ArrayList<ResourceParameter> paramNames = new ArrayList<ResourceParameter>();
        for (Map.Entry<String, BLangSimpleVariable> entry : this.parameters.entrySet()) {
            ResourceParameter resourceParameter = new ResourceParameter();
            resourceParameter.setName(entry.getKey());
            if (entry.getValue().type != null && entry.getValue().type.tsymbol != null) {
                resourceParameter.setType(entry.getValue().type.tsymbol.name.getValue());
            }
            resourceParameter.setParameter(entry.getValue());
            paramNames.add(resourceParameter);
        }
        return paramNames;
    }

    public String getBody() {
        return this.body;
    }

    public Diagnostic.DiagnosticPosition getResourcePosition() {
        return this.resourcePosition;
    }

    public void setBody(String body) {
        this.body = body;
    }
}

