/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.string;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.string", functionName="equalsIgnoreCaseAscii", args={@Argument(name="str1", type=TypeKind.STRING), @Argument(name="str2", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.BOOLEAN)}, isPublic=true)
public class EqualsIgnoreCaseAscii {
    private static CharsetDecoder decoder = Charset.forName("US-ASCII").newDecoder();

    public static boolean equalsIgnoreCaseAscii(Strand strand, String str1, String str2) {
        if (str1.length() != str2.length()) {
            return false;
        }
        for (int i = 0; i < str1.length(); ++i) {
            String charFromOne = Character.toString(str1.charAt(i));
            String charFromTwo = Character.toString(str2.charAt(i));
            if (!(EqualsIgnoreCaseAscii.isPureAscii(charFromOne) && EqualsIgnoreCaseAscii.isPureAscii(charFromTwo) ? !charFromOne.equalsIgnoreCase(charFromTwo) : !charFromOne.equals(charFromTwo))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPureAscii(String str) {
        byte[] byteArray = str.getBytes();
        try {
            decoder.decode(ByteBuffer.wrap(byteArray)).toString();
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }
}

