/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.string;

import java.text.StringCharacterIterator;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.string", functionName="next", receiver=@Receiver(type=TypeKind.OBJECT, structType="StringIterator", structPackage="ballerina/lang.string"), returnType={@ReturnType(type=TypeKind.RECORD)}, isPublic=true)
public class Next {
    public static final String IS_STRING_VALUE_PROP = "ballerina.bstring";
    public static final boolean USE_BSTRING = System.getProperty("ballerina.bstring") != null;

    public static Object next(Strand strand, ObjectValue m) {
        StringCharacterIterator stringCharacterIterator = (StringCharacterIterator)m.getNativeData("&iterator&");
        if (stringCharacterIterator == null) {
            String s = USE_BSTRING ? ((BString)m.get(StringUtils.fromString((String)"m"))).getValue() : m.getStringValue("m");
            stringCharacterIterator = new StringCharacterIterator(s);
            m.addNativeData("&iterator&", (Object)stringCharacterIterator);
        }
        if (stringCharacterIterator.current() != '\uffff') {
            char character = stringCharacterIterator.current();
            stringCharacterIterator.next();
            String charAsStr = USE_BSTRING ? StringUtils.fromString((String)String.valueOf(character)) : String.valueOf(character);
            return BallerinaValues.createRecord((MapValue)new MapValueImpl((BType)BTypes.stringItrNextReturnType), (Object[])new Object[]{charAsStr});
        }
        return null;
    }
}

