/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel.ql;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.ql.StateComparator;
import org.apache.ode.ql.Compiler;
import org.apache.ode.ql.eval.skel.AbstractConjunction;
import org.apache.ode.ql.eval.skel.AbstractDisjunction;
import org.apache.ode.ql.eval.skel.AbstractEqualityEvaluator;
import org.apache.ode.ql.eval.skel.CommandEvaluator;
import org.apache.ode.ql.eval.skel.ConjunctionEvaluator;
import org.apache.ode.ql.eval.skel.DisjunctionEvaluator;
import org.apache.ode.ql.eval.skel.EqualityEvaluator;
import org.apache.ode.ql.eval.skel.GEEvaluator;
import org.apache.ode.ql.eval.skel.GreaterEvaluator;
import org.apache.ode.ql.eval.skel.INEvaluator;
import org.apache.ode.ql.eval.skel.LEEvaluator;
import org.apache.ode.ql.eval.skel.LessEvaluator;
import org.apache.ode.ql.eval.skel.LikeEvaluator;
import org.apache.ode.ql.eval.skel.OrderByEvaluator;
import org.apache.ode.ql.tree.Builder;
import org.apache.ode.ql.tree.BuilderFactory;
import org.apache.ode.ql.tree.nodes.Conjunction;
import org.apache.ode.ql.tree.nodes.Disjunction;
import org.apache.ode.ql.tree.nodes.Equality;
import org.apache.ode.ql.tree.nodes.Field;
import org.apache.ode.ql.tree.nodes.GE;
import org.apache.ode.ql.tree.nodes.Greater;
import org.apache.ode.ql.tree.nodes.Identifier;
import org.apache.ode.ql.tree.nodes.IdentifierToValueCMP;
import org.apache.ode.ql.tree.nodes.In;
import org.apache.ode.ql.tree.nodes.LE;
import org.apache.ode.ql.tree.nodes.Less;
import org.apache.ode.ql.tree.nodes.Like;
import org.apache.ode.ql.tree.nodes.Limit;
import org.apache.ode.ql.tree.nodes.LogicExprNode;
import org.apache.ode.ql.tree.nodes.LogicNode;
import org.apache.ode.ql.tree.nodes.Node;
import org.apache.ode.ql.tree.nodes.OrderBy;
import org.apache.ode.ql.tree.nodes.OrderByElement;
import org.apache.ode.ql.tree.nodes.OrderByType;
import org.apache.ode.ql.tree.nodes.Property;
import org.apache.ode.ql.tree.nodes.Query;
import org.apache.ode.ql.tree.nodes.Value;
import org.apache.ode.ql.tree.nodes.ValuesHelper;
import org.apache.ode.utils.ISO8601DateParser;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class HibernateInstancesQueryCompiler
extends Compiler<List, Session> {
    private static final String INSTANCE_ID_FIELD = "iid";
    private static final String PROCESS_ID_FIELD = "pid";
    private static final String PROCESS_NAME_FIELD = "name";
    private static final String PROCESS_NAMESPACE_FIELD = "namespace";
    private static final String INSTANCE_STATUS_FIELD = "status";
    private static final String INSTANCE_STARTED_FIELD = "started";
    private static final String INSTANCE_LAST_ACTIVE_FIELD = "last-active";
    private static final String INSTANCE_ID_DB_FIELD = "id";
    private static final String PROCESS_ID_DB_FIELD = "process.processId";
    private static final String PROCESS_NAME_DB_FIELD = "process.typeName";
    private static final String PROCESS_NAMESPACE_DB_FIELD = "process.typeNamespace";
    private static final String INSTANCE_STATUS_DB_FIELD = "state";
    private static final String PROPERTY_NS_DB_FIELD = "process.typeNamespace";
    private static final String PROPERTY_NAME_DB_FIELD = "property.name";
    private static final String PROPERTY_VALUE_DB_FIELD = "property.value";
    private static final String INSTANCE_STARTED_DB_FIELD = "created";
    private static final String INSTANCE_LAST_ACTIVE_DB_FIELD = "lastActiveTime";
    private static final String STATUS_ACTIVE = "active";
    private static final String STATUS_SUSPENDED = "suspended";
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_COMPLETED = "completed";
    private static final String STATUS_TERMINATED = "terminated";
    private static final String STATUS_FAULTED = "failed";
    private static final Map<String, String> nodeIdentifierToDBField = new HashMap<String, String>(20);
    private boolean propertyInQuery;
    private boolean orderByStatus;
    private boolean orderByStatusDesc;

    private static String getDBField(String name) {
        String dbField = nodeIdentifierToDBField.get(name);
        if (dbField == null) {
            throw new IllegalArgumentException("Unsupported field " + name);
        }
        return dbField;
    }

    private void init() {
        this.propertyInQuery = false;
        this.orderByStatus = false;
        this.orderByStatusDesc = false;
    }

    public CommandEvaluator<List, Session> compile(Query node) {
        this.init();
        final OrderByEvaluator<Collection<Order>, Object> orderEvaluator = node.getOrder() != null ? this.compileOrderBy(node.getOrder()) : null;
        final CommandEvaluator selectionEvaluator = node.getChilds().size() == 0 ? null : this.compileEvaluator(node.getChilds().iterator().next());
        final boolean joinCorrelationSet = this.propertyInQuery;
        final boolean sortByStatus = this.orderByStatus;
        final boolean sortByStatusDesc = this.orderByStatusDesc;
        final Limit limit = node.getLimit();
        return new CommandEvaluator<List, Session>(){

            public List evaluate(Session session) {
                Criteria criteria = session.createCriteria(HProcessInstance.class).createAlias("process", "process");
                if (joinCorrelationSet) {
                    criteria = criteria.createAlias("correlationSets", "property");
                }
                if (selectionEvaluator != null) {
                    criteria.add((Criterion)selectionEvaluator.evaluate(null));
                }
                if (orderEvaluator != null) {
                    Collection orders = (Collection)orderEvaluator.evaluate(null);
                    for (Order order : orders) {
                        criteria.addOrder(order);
                    }
                }
                if (limit != null) {
                    criteria.setMaxResults(limit.getNumber());
                }
                List result = criteria.list();
                if (sortByStatus) {
                    Collections.sort(result, sortByStatusDesc ? StateComparator.DESC : StateComparator.ASC);
                }
                return result;
            }
        };
    }

    protected ConjunctionEvaluator<Criterion, Object> compileConjunction(Collection<CommandEvaluator> childs) {
        return new AbstractConjunction<Criterion, Object>(childs){

            public Criterion evaluate(Object arg) {
                org.hibernate.criterion.Conjunction conj = Restrictions.conjunction();
                for (CommandEvaluator eval : this.childs) {
                    conj.add((Criterion)eval.evaluate(null));
                }
                return conj;
            }
        };
    }

    protected DisjunctionEvaluator<Criterion, Object> compileDisjunction(Collection<CommandEvaluator> childs) {
        return new AbstractDisjunction<Criterion, Object>(childs){

            public Criterion evaluate(Object arg) {
                org.hibernate.criterion.Disjunction conj = Restrictions.disjunction();
                for (CommandEvaluator eval : this.childs) {
                    conj.add((Criterion)eval.evaluate(null));
                }
                return conj;
            }
        };
    }

    protected EqualityEvaluator<String, Criterion, Object> compileEqual(final Equality eq) {
        if (eq.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)eq.getIdentifier();
            return new EqualityEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object paramValue) {
                    org.hibernate.criterion.Conjunction conj = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conj.add((Criterion)Restrictions.eq((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conj.add((Criterion)Restrictions.eq((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conj.add((Criterion)Restrictions.eq((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)eq.getValue().getValue()));
                    return conj;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        String fieldName = eq.getIdentifier().getName();
        final Object value = eq.getValue().getValue();
        final String dbField = HibernateInstancesQueryCompiler.getDBField(fieldName);
        if (INSTANCE_STATUS_FIELD.equals(fieldName)) {
            return new FieldValueEquality(INSTANCE_STATUS_FIELD){

                public Criterion evaluate(Object paramValue) {
                    short noState = 200;
                    org.hibernate.criterion.Disjunction disj = Restrictions.disjunction();
                    if (HibernateInstancesQueryCompiler.STATUS_ACTIVE.equals(paramValue)) {
                        disj.add((Criterion)Restrictions.eq((String)dbField, (Object)0));
                        disj.add((Criterion)Restrictions.eq((String)dbField, (Object)20));
                        disj.add((Criterion)Restrictions.eq((String)dbField, (Object)10));
                    } else if (HibernateInstancesQueryCompiler.STATUS_SUSPENDED.equals(paramValue)) {
                        disj.add((Criterion)Restrictions.eq((String)dbField, (Object)50));
                    } else if (HibernateInstancesQueryCompiler.STATUS_ERROR.equals(value)) {
                        disj.add((Criterion)Restrictions.eq((String)dbField, (Object)noState));
                    } else if (HibernateInstancesQueryCompiler.STATUS_COMPLETED.equals(paramValue)) {
                        disj.add((Criterion)Restrictions.eq((String)dbField, (Object)30));
                    } else if (HibernateInstancesQueryCompiler.STATUS_TERMINATED.equals(paramValue)) {
                        disj.add((Criterion)Restrictions.eq((String)dbField, (Object)60));
                    } else if (HibernateInstancesQueryCompiler.STATUS_FAULTED.equals(paramValue)) {
                        disj.add((Criterion)Restrictions.eq((String)dbField, (Object)40));
                    } else {
                        disj.add((Criterion)Restrictions.eq((String)dbField, (Object)noState));
                    }
                    return disj;
                }
            };
        }
        return new DBFieldValueEq(dbField, value);
    }

    public CommandEvaluator compileEvaluator(Object node) {
        if (node instanceof In) {
            return this.compileIn((In)node);
        }
        if (node instanceof Conjunction) {
            return this.compileConjunction(this.evaluate((LogicExprNode)node));
        }
        if (node instanceof Disjunction) {
            return this.compileDisjunction(this.evaluate((LogicExprNode)node));
        }
        if (node instanceof IdentifierToValueCMP) {
            return this.compileIdentifierToValueCMP((IdentifierToValueCMP)node);
        }
        throw new IllegalArgumentException("Unsupported node " + node.getClass());
    }

    protected CommandEvaluator<Criterion, Object> compileIdentifierToValueCMP(IdentifierToValueCMP node) {
        Identifier id = node.getIdentifier();
        if (id instanceof Field) {
            String name = id.getName();
            Value value = node.getValue();
            if (INSTANCE_ID_FIELD.equals(name)) {
                value.setValue((Object)Long.valueOf((String)value.getValue()));
            } else if (INSTANCE_STARTED_FIELD.equals(name) || INSTANCE_LAST_ACTIVE_FIELD.equals(name)) {
                try {
                    value.setValue((Object)ISO8601DateParser.parse((String)((String)value.getValue())));
                }
                catch (ParseException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (node instanceof Equality) {
            return this.compileEqual((Equality)node);
        }
        if (node instanceof Less) {
            return this.compileLess((Less)node);
        }
        if (node instanceof Greater) {
            return this.compileGreater((Greater)node);
        }
        if (node instanceof GE) {
            return this.compileGE((GE)node);
        }
        if (node instanceof LE) {
            return this.compileLE((LE)node);
        }
        if (node instanceof Like) {
            return this.compileLike((Like)node);
        }
        throw new IllegalArgumentException("Unsupported node " + node.getClass());
    }

    protected GEEvaluator<String, Criterion, Object> compileGE(final GE ge) {
        if (ge.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)ge.getIdentifier();
            return new GEEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object paramValue) {
                    org.hibernate.criterion.Conjunction conj = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conj.add((Criterion)Restrictions.ge((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conj.add((Criterion)Restrictions.ge((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conj.add((Criterion)Restrictions.ge((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)ge.getValue().getValue()));
                    return conj;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        final String fieldName = ge.getIdentifier().getName();
        final Object objValue = ge.getValue().getValue();
        if (INSTANCE_STATUS_FIELD.equals(fieldName)) {
            throw new IllegalArgumentException("Field status is not supported.");
        }
        final String dbField = HibernateInstancesQueryCompiler.getDBField(fieldName);
        return new GEEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object paramValue) {
                return Restrictions.ge((String)dbField, (Object)objValue);
            }

            public String getIdentifier() {
                return fieldName;
            }
        };
    }

    protected GreaterEvaluator<String, Criterion, Object> compileGreater(final Greater gt) {
        if (gt.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)gt.getIdentifier();
            return new GreaterEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object paramValue) {
                    org.hibernate.criterion.Conjunction conj = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conj.add((Criterion)Restrictions.gt((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conj.add((Criterion)Restrictions.gt((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conj.add((Criterion)Restrictions.gt((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)gt.getValue().getValue()));
                    return conj;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        final String fieldName = gt.getIdentifier().getName();
        final Object value = gt.getValue().getValue();
        if (INSTANCE_STATUS_FIELD.equals(fieldName)) {
            throw new IllegalArgumentException("Field status is not supported.");
        }
        final String dbField = HibernateInstancesQueryCompiler.getDBField(fieldName);
        return new GreaterEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object paramValue) {
                return Restrictions.gt((String)dbField, (Object)value);
            }

            public String getIdentifier() {
                return fieldName;
            }
        };
    }

    protected INEvaluator<String, Criterion, Object> compileIn(final In in) {
        Collection<Date> objValues;
        if (in.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)in.getIdentifier();
            return new INEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object paramValue) {
                    org.hibernate.criterion.Disjunction disj = Restrictions.disjunction();
                    String propertyNS = property.getNamespace();
                    String propertyName = property.getName();
                    for (Value value : in.getValues()) {
                        org.hibernate.criterion.Conjunction conj = Restrictions.conjunction();
                        if (!StringUtils.isEmpty((String)property.getNamespace())) {
                            conj.add((Criterion)Restrictions.gt((String)"process.typeNamespace", (Object)propertyNS));
                        }
                        conj.add((Criterion)Restrictions.gt((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)propertyName));
                        conj.add((Criterion)Restrictions.gt((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)value.getValue()));
                        disj.add((Criterion)conj);
                    }
                    return disj;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        String fieldName = in.getIdentifier().getName();
        if (INSTANCE_STATUS_FIELD.equals(fieldName)) {
            short noState = 200;
            final org.hibernate.criterion.Disjunction disj = Restrictions.disjunction();
            Collection values = ValuesHelper.extract((Collection)in.getValues());
            if (values.contains(STATUS_ACTIVE)) {
                disj.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)0));
                disj.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)20));
                disj.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)10));
            }
            if (values.contains(STATUS_SUSPENDED)) {
                disj.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)50));
            }
            if (values.contains(STATUS_ERROR)) {
                disj.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)noState));
            }
            if (values.contains(STATUS_COMPLETED)) {
                disj.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)30));
            }
            if (values.contains(STATUS_TERMINATED)) {
                disj.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)60));
            }
            if (values.contains(STATUS_FAULTED)) {
                disj.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)40));
            }
            return new INEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object paramValue) {
                    return disj;
                }

                public String getIdentifier() {
                    return HibernateInstancesQueryCompiler.INSTANCE_STATUS_DB_FIELD;
                }
            };
        }
        Collection values = in.getValues();
        if (INSTANCE_ID_FIELD.equals(fieldName)) {
            objValues = new ArrayList(values.size());
            for (Value value : values) {
                objValues.add((Date)((Object)Long.valueOf((String)value.getValue())));
            }
        } else if (INSTANCE_STARTED_FIELD.equals(fieldName) || INSTANCE_LAST_ACTIVE_FIELD.equals(fieldName)) {
            objValues = new ArrayList(values.size());
            try {
                for (Value value : values) {
                    objValues.add(ISO8601DateParser.parse((String)((String)value.getValue())));
                }
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            objValues = ValuesHelper.extract((Collection)values);
        }
        final String dbField = HibernateInstancesQueryCompiler.getDBField(fieldName);
        return new INEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object paramValue) {
                return Restrictions.in((String)dbField, (Collection)objValues);
            }

            public String getIdentifier() {
                return dbField;
            }
        };
    }

    protected LEEvaluator<String, Criterion, Object> compileLE(final LE le) {
        if (le.getIdentifier() instanceof Property) {
            final Property property = (Property)le.getIdentifier();
            return new LEEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object paramValue) {
                    org.hibernate.criterion.Conjunction conj = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conj.add((Criterion)Restrictions.le((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conj.add((Criterion)Restrictions.le((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conj.add((Criterion)Restrictions.le((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)le.getValue().getValue()));
                    return conj;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        final String fieldName = le.getIdentifier().getName();
        final Object value = le.getValue().getValue();
        if (INSTANCE_STATUS_FIELD.equals(fieldName)) {
            throw new IllegalArgumentException("Field status is not supported.");
        }
        final String dbField = HibernateInstancesQueryCompiler.getDBField(fieldName);
        return new LEEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object paramValue) {
                return Restrictions.le((String)dbField, (Object)value);
            }

            public String getIdentifier() {
                return fieldName;
            }
        };
    }

    protected LessEvaluator<String, Criterion, Object> compileLess(final Less less) {
        if (less.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)less.getIdentifier();
            return new LessEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object paramValue) {
                    org.hibernate.criterion.Conjunction conj = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conj.add((Criterion)Restrictions.lt((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conj.add((Criterion)Restrictions.lt((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conj.add((Criterion)Restrictions.lt((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)less.getValue().getValue()));
                    return conj;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        final String fieldName = less.getIdentifier().getName();
        final Object value = less.getValue().getValue();
        if (INSTANCE_STATUS_FIELD.equals(fieldName)) {
            throw new IllegalArgumentException("Field status is not supported.");
        }
        final String dbField = HibernateInstancesQueryCompiler.getDBField(fieldName);
        return new LessEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object paramValue) {
                return Restrictions.lt((String)dbField, (Object)value);
            }

            public String getIdentifier() {
                return fieldName;
            }
        };
    }

    protected LikeEvaluator<String, Criterion, Object> compileLike(final Like like) {
        if (like.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)like.getIdentifier();
            return new LikeEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object paramValue) {
                    org.hibernate.criterion.Conjunction conj = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conj.add((Criterion)Restrictions.like((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conj.add((Criterion)Restrictions.like((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conj.add((Criterion)Restrictions.like((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)like.getValue().getValue()));
                    return conj;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        String fieldName = like.getIdentifier().getName();
        if (INSTANCE_STATUS_FIELD.equals(fieldName)) {
            throw new IllegalArgumentException("Field status is not supported by like operation.");
        }
        if (INSTANCE_ID_FIELD.equals(fieldName)) {
            throw new IllegalArgumentException("Field iid is not supported by like operation.");
        }
        final Object value = like.getValue().getValue();
        final String dbField = HibernateInstancesQueryCompiler.getDBField(fieldName);
        return new LikeEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object paramValue) {
                return Restrictions.like((String)dbField, (Object)value);
            }

            public String getIdentifier() {
                return dbField;
            }
        };
    }

    protected OrderByEvaluator<Collection<Order>, Object> compileOrderBy(OrderBy orderBy) {
        final LinkedHashMap<String, Boolean> orders = new LinkedHashMap<String, Boolean>();
        for (OrderByElement idOrder : orderBy.getOrders()) {
            if (!(idOrder.getIdentifier() instanceof Field)) {
                throw new IllegalArgumentException("Only field identifier supported by order by operator.");
            }
            String idName = idOrder.getIdentifier().getName();
            if (INSTANCE_STATUS_FIELD.equals(idName)) {
                if (orderBy.getOrders().size() > 1) {
                    throw new RuntimeException("Status field should be used alone in <order by> construction.");
                }
                this.orderByStatus = true;
                this.orderByStatusDesc = idOrder.getType() == OrderByType.DESC;
                return null;
            }
            String dbField = HibernateInstancesQueryCompiler.getDBField(idName);
            orders.put(dbField, idOrder.getType() == null || idOrder.getType() == OrderByType.ASC);
        }
        return new OrderByEvaluator<Collection<Order>, Object>(){

            public Collection<Order> evaluate(Object paramValue) {
                ArrayList<Order> hibernateOrders = new ArrayList<Order>(orders.size());
                for (Map.Entry order : orders.entrySet()) {
                    hibernateOrders.add((Boolean)order.getValue() != false ? Order.asc((String)((String)order.getKey())) : Order.desc((String)((String)order.getKey())));
                }
                return hibernateOrders;
            }
        };
    }

    protected List<CommandEvaluator> evaluate(LogicExprNode exprNode) {
        ArrayList<CommandEvaluator> commandsEv = new ArrayList<CommandEvaluator>(exprNode.getChilds().size());
        for (LogicNode node : exprNode.getChilds()) {
            commandsEv.add(this.compileEvaluator(node));
        }
        return commandsEv;
    }

    public static void main(String[] args) {
        String queryString = "order by last-active desc limit 1000";
        Builder builder = BuilderFactory.getInstance().createBuilder();
        Node queryNode = builder.build((Object)queryString);
        HibernateInstancesQueryCompiler compiler = new HibernateInstancesQueryCompiler();
        compiler.compile((Query)queryNode);
    }

    static {
        nodeIdentifierToDBField.put(INSTANCE_ID_FIELD, INSTANCE_ID_DB_FIELD);
        nodeIdentifierToDBField.put(INSTANCE_ID_FIELD, INSTANCE_ID_DB_FIELD);
        nodeIdentifierToDBField.put(PROCESS_ID_FIELD, PROCESS_ID_DB_FIELD);
        nodeIdentifierToDBField.put(PROCESS_NAME_FIELD, PROCESS_NAME_DB_FIELD);
        nodeIdentifierToDBField.put(PROCESS_NAMESPACE_FIELD, "process.typeNamespace");
        nodeIdentifierToDBField.put(INSTANCE_STARTED_FIELD, INSTANCE_STARTED_DB_FIELD);
        nodeIdentifierToDBField.put(INSTANCE_LAST_ACTIVE_FIELD, INSTANCE_LAST_ACTIVE_DB_FIELD);
        nodeIdentifierToDBField.put(INSTANCE_STATUS_FIELD, INSTANCE_STATUS_DB_FIELD);
    }

    private static abstract class FieldValueEquality
    extends AbstractEqualityEvaluator<String, Criterion, Object> {
        public FieldValueEquality(String identifier) {
            super((Object)identifier);
        }
    }

    private static class DBFieldValueEq
    extends FieldValueEquality {
        protected final Object fieldValue;

        public DBFieldValueEq(String identifier, Object fieldValue) {
            super(identifier);
            this.fieldValue = fieldValue;
        }

        public Criterion evaluate(Object paramValue) {
            return Restrictions.eq((String)((String)this.identifier), (Object)this.fieldValue);
        }
    }
}

