/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.hibernate.Query;

class MessageRouteDaoImpl
extends HibernateDao
implements MessageRouteDAO {
    private static final String LOCK_INSTANCE = "update " + HProcessInstance.class.getName() + " set lock=lock+1 where id=?";
    private HCorrelatorSelector _selector;
    private boolean _locked = false;

    public MessageRouteDaoImpl(SessionManager sm, HCorrelatorSelector hobj) {
        super(sm, hobj);
        this.entering("MessageRouteDaoImpl.MessageRouteDaoImpl");
        this._selector = hobj;
    }

    public ProcessInstanceDAO getTargetInstance() {
        this.entering("MessageRouteDaoImpl.getTargetInstance");
        if (!this._locked) {
            Query q = this.getSession().createQuery(LOCK_INSTANCE);
            q.setLong(0, this._selector.getInstance().getId().longValue());
            q.executeUpdate();
            this._locked = true;
        }
        return new ProcessInstanceDaoImpl(this._sm, this._selector.getInstance());
    }

    public String getGroupId() {
        this.entering("MessageRouteDaoImpl.getGroupId");
        return this._selector.getGroupId();
    }

    public int getIndex() {
        this.entering("MessageRouteDaoImpl.getIndex");
        return this._selector.getIndex();
    }

    public String getRoute() {
        return this._selector.getRoute();
    }

    public CorrelationKeySet getCorrelationKeySet() {
        return new CorrelationKeySet(this._selector.getCorrelationKey());
    }

    public void setCorrelationKeySet(CorrelationKeySet keySet) {
        this._selector.setCorrelationKey(keySet.toCanonicalString());
    }

    public void setCorrelationKey(CorrelationKey key) {
        this._selector.setCorrelationKey(key.toCanonicalString());
    }

    public CorrelationKey getCorrelationKey() {
        return new CorrelationKey(this._selector.getCorrelationKey());
    }
}

