/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.RelativeDateParser;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

class CriteriaBuilder {
    static final Log __log = LogFactory.getLog(CriteriaBuilder.class);

    CriteriaBuilder() {
    }

    Query buildHQLQuery(Session session, InstanceFilter filter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuffer query = new StringBuffer();
        query.append("select pi from HProcessInstance as pi left join fetch pi.fault ");
        if (filter != null) {
            int m;
            Object filters;
            ArrayList<String> clauses = new ArrayList<String>();
            if (filter.getIidFilter() != null) {
                filters = new StringBuffer();
                List iids = filter.getIidFilter();
                for (m = 0; m < iids.size(); ++m) {
                    ((StringBuffer)filters).append(" pi.id = :iid").append(m);
                    parameters.put("iid" + m, Long.parseLong((String)iids.get(m)));
                    if (m >= iids.size() - 1) continue;
                    ((StringBuffer)filters).append(" or");
                }
                clauses.add(" (" + filters + ")");
            }
            if (filter.getPidFilter() != null) {
                filters = new StringBuffer();
                List pids = filter.getPidFilter();
                String cmp = filter.arePidsNegative() ? " != " : " = ";
                for (int m2 = 0; m2 < pids.size(); ++m2) {
                    ((StringBuffer)filters).append(" pi.process.processId ").append(cmp).append(" :pid").append(m2);
                    parameters.put("pid" + m2, pids.get(m2));
                    if (m2 >= pids.size() - 1) continue;
                    ((StringBuffer)filters).append(" or");
                }
                clauses.add(" (" + filters + ")");
            }
            if (filter.getNameFilter() != null) {
                clauses.add(" pi.process.typeName like :pname");
                parameters.put("pname", filter.getNameFilter().replaceAll("\\*", "%"));
            }
            if (filter.getNamespaceFilter() != null) {
                clauses.add(" pi.process.typeNamespace like :pnamespace");
                parameters.put("pnamespace", filter.getNamespaceFilter().replaceAll("\\*", "%"));
            }
            if (filter.getStartedDateFilter() != null) {
                for (String ds : filter.getStartedDateFilter()) {
                    clauses.add(" pi.created " + CriteriaBuilder.dateFilter(ds));
                }
            }
            if (filter.getLastActiveDateFilter() != null) {
                for (String ds : filter.getLastActiveDateFilter()) {
                    clauses.add(" pi.lastActiveTime " + CriteriaBuilder.dateFilter(ds));
                }
            }
            if (filter.getStatusFilter() != null) {
                filters = new StringBuffer();
                List states = filter.convertFilterState();
                for (m = 0; m < states.size(); ++m) {
                    ((StringBuffer)filters).append(" pi.state = :pstate").append(m);
                    parameters.put("pstate" + m, states.get(m));
                    if (m >= states.size() - 1) continue;
                    ((StringBuffer)filters).append(" or");
                }
                clauses.add(" (" + ((StringBuffer)filters).toString() + ")");
            }
            if (filter.getPropertyValuesFilter() != null) {
                Map props = filter.getPropertyValuesFilter();
                query.append(" inner join pi.correlationSets as cs");
                int i = 0;
                for (String propKey : props.keySet()) {
                    query.append(" inner join cs.properties as csp" + ++i);
                    String value = ((String)props.get(propKey)).replaceAll("&#32;", " ");
                    if (propKey.startsWith("{")) {
                        String namespace = propKey.substring(1, propKey.lastIndexOf("}"));
                        clauses.add(" csp" + i + ".name = :cspname" + i + " and csp" + i + ".namespace = :cspnamespace" + i + " and csp" + i + ".value = :cspvalue" + i);
                        parameters.put("cspname" + i, propKey.substring(propKey.lastIndexOf("}") + 1, propKey.length()));
                        parameters.put("cspnamespace" + i, namespace);
                        parameters.put("cspvalue" + i, value);
                        continue;
                    }
                    clauses.add(" csp" + i + ".name = :cspname" + i + " and csp" + i + ".value = :cspvalue" + i);
                    parameters.put("cspname" + i, propKey);
                    parameters.put("cspvalue" + i, value);
                }
            }
            StringBuffer orderby = new StringBuffer("");
            if (filter.getOrders() != null) {
                orderby.append(" order by");
                List orders = filter.getOrders();
                for (int m3 = 0; m3 < orders.size(); ++m3) {
                    String field = (String)orders.get(m3);
                    String ord = " asc";
                    if (field.startsWith("-")) {
                        ord = " desc";
                    }
                    String fieldName = " pi.id";
                    if (field.endsWith("name")) {
                        fieldName = " pi.process.typeName";
                    }
                    if (field.endsWith("namespace")) {
                        fieldName = " pi.process.typeNamespace";
                    }
                    if (field.endsWith("version")) {
                        fieldName = " pi.process.version";
                    }
                    if (field.endsWith("status")) {
                        fieldName = " pi.state";
                    }
                    if (field.endsWith("started")) {
                        fieldName = " pi.created";
                    }
                    if (field.endsWith("last-active")) {
                        fieldName = " pi.lastActiveTime";
                    }
                    orderby.append(fieldName + ord);
                    if (m3 >= orders.size() - 1) continue;
                    orderby.append(", ");
                }
            }
            if (clauses.size() > 0) {
                query.append(" where");
                for (int m4 = 0; m4 < clauses.size(); ++m4) {
                    query.append((String)clauses.get(m4));
                    if (m4 >= clauses.size() - 1) continue;
                    query.append(" and");
                }
            }
            query.append(orderby);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)query.toString());
        }
        Query q = session.createQuery(query.toString());
        for (String p : parameters.keySet()) {
            q.setParameter(p, parameters.get(p));
        }
        if (filter.getLimit() != 0) {
            q.setMaxResults(filter.getLimit());
        }
        return q;
    }

    private static String dateFilter(String filter) {
        String date = Filter.getDateWithoutOp((String)filter);
        String op = filter.substring(0, filter.indexOf(date));
        Date dt = null;
        try {
            dt = ISO8601DateParser.parse((String)date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Timestamp ts = new Timestamp(dt.getTime());
        return op + " '" + ts.toString() + "'";
    }

    void buildCriteria(Criteria crit, InstanceFilter filter) {
        List iids;
        Criteria processCrit = crit.createCriteria("process");
        List pids = filter.getPidFilter();
        if (pids != null && pids.size() > 0) {
            Disjunction disj = Restrictions.disjunction();
            for (Object pid : pids) {
                if (!filter.arePidsNegative()) {
                    disj.add((Criterion)Restrictions.eq((String)"processId", (Object)pid));
                    continue;
                }
                disj.add((Criterion)Restrictions.ne((String)"processId", (Object)pid));
            }
            processCrit.add((Criterion)disj);
        }
        if ((iids = filter.getIidFilter()) != null && iids.size() > 0) {
            Disjunction disj = Restrictions.disjunction();
            for (String string : iids) {
                disj.add((Criterion)Restrictions.eq((String)"id", (Object)new Long(string)));
            }
            crit.add((Criterion)disj);
        }
        if (filter.getNameFilter() != null) {
            processCrit.add((Criterion)Restrictions.like((String)"typeName", (Object)filter.getNameFilter().replaceAll("\\*", "%")));
        }
        if (filter.getNamespaceFilter() != null) {
            processCrit.add((Criterion)Restrictions.like((String)"typeNamespace", (Object)filter.getNamespaceFilter().replaceAll("\\*", "%")));
        }
        if (filter.getStatusFilter() != null) {
            Iterator statuses = filter.convertFilterState();
            Disjunction disj = Restrictions.disjunction();
            Iterator iterator = statuses.iterator();
            while (iterator.hasNext()) {
                short status = (Short)iterator.next();
                disj.add((Criterion)Restrictions.eq((String)"state", (Object)status));
            }
            crit.add((Criterion)disj);
        }
        if (filter.getStartedDateFilter() != null) {
            for (String sdf : filter.getStartedDateFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(crit, sdf, "created");
            }
        }
        if (filter.getLastActiveDateFilter() != null) {
            for (Object ladf : filter.getLastActiveDateFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(crit, (String)ladf, "lastActiveTime");
            }
        }
        if (filter.getPropertyValuesFilter() != null) {
            Criteria propCrit = crit.createCriteria("correlationSets").createCriteria("properties");
            for (Map.Entry entry : filter.getPropertyValuesFilter().entrySet()) {
                String propName = (String)entry.getKey();
                if (propName.startsWith("{")) {
                    String namespace = propName.substring(1, propName.lastIndexOf("}"));
                    propName = propName.substring(propName.lastIndexOf("}") + 1, propName.length());
                    propCrit.add((Criterion)Restrictions.eq((String)"name", (Object)propName)).add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace)).add((Criterion)Restrictions.eq((String)"value", entry.getValue()));
                    continue;
                }
                propCrit.add((Criterion)Restrictions.eq((String)"name", entry.getKey())).add((Criterion)Restrictions.eq((String)"value", entry.getValue()));
            }
        }
        if (filter.orders != null) {
            for (String key : filter.orders) {
                boolean bl;
                boolean bl2 = true;
                String orderKey = key;
                if (key.startsWith("+") || key.startsWith("-")) {
                    orderKey = key.substring(1, key.length());
                    if (key.startsWith("-")) {
                        bl = false;
                    }
                }
                if ("name".equals(orderKey)) {
                    if (bl) {
                        processCrit.addOrder(Property.forName((String)"typeName").asc());
                        continue;
                    }
                    processCrit.addOrder(Property.forName((String)"typeName").desc());
                    continue;
                }
                if ("namespace".equals(orderKey)) {
                    if (bl) {
                        processCrit.addOrder(Property.forName((String)"typeNamespace").asc());
                        continue;
                    }
                    processCrit.addOrder(Property.forName((String)"typeNamespace").desc());
                    continue;
                }
                if ("pid".equals(orderKey)) {
                    if (bl) {
                        processCrit.addOrder(Property.forName((String)"processId").asc());
                        continue;
                    }
                    processCrit.addOrder(Property.forName((String)"processId").desc());
                    continue;
                }
                if ("version".equals(orderKey)) {
                    if (bl) {
                        processCrit.addOrder(Property.forName((String)"version").asc());
                        continue;
                    }
                    processCrit.addOrder(Property.forName((String)"version").desc());
                    continue;
                }
                if ("status".equals(orderKey)) {
                    if (bl) {
                        crit.addOrder(Property.forName((String)"state").asc());
                        continue;
                    }
                    crit.addOrder(Property.forName((String)"state").desc());
                    continue;
                }
                if ("started".equals(orderKey)) {
                    if (bl) {
                        crit.addOrder(Property.forName((String)"created").asc());
                        continue;
                    }
                    crit.addOrder(Property.forName((String)"created").desc());
                    continue;
                }
                if (!"last-active".equals(orderKey)) continue;
                if (bl) {
                    crit.addOrder(Property.forName((String)"lastActiveTime").asc());
                    continue;
                }
                crit.addOrder(Property.forName((String)"lastActiveTime").desc());
            }
        }
        if (filter.getLimit() > 0) {
            crit.setMaxResults(filter.getLimit());
        }
    }

    void buildCriteria(Criteria crit, BpelEventFilter efilter) {
        if (efilter.getTypeFilter() != null) {
            crit.add((Criterion)Restrictions.like((String)"type", (Object)efilter.getTypeFilter().replace('*', '%')));
        }
        if (efilter.getTimestampFilter() != null) {
            for (Filter.Restriction sdf : efilter.getTimestampFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(crit, sdf.op, (Date)sdf.value, "tstamp");
            }
        }
        if (efilter.limit > 0) {
            crit.setMaxResults(efilter.limit);
        }
    }

    void addScopeFilter(Criteria crit, String scopeId) {
        crit.add((Criterion)Restrictions.eq((String)"", (Object)scopeId));
    }

    static void addFilterOnPrefixedDate(Criteria crit, String prefixedDate, String dateAttribute) {
        Date realDate = null;
        try {
            realDate = CriteriaBuilder.parseDateExpression(CriteriaBuilder.getDateWithoutOp(prefixedDate));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        CriteriaBuilder.addFilterOnPrefixedDate(crit, prefixedDate, realDate, dateAttribute);
    }

    private static Date parseDateExpression(String date) throws ParseException {
        if (date.toLowerCase().startsWith("-") && date.length() > 1) {
            return RelativeDateParser.parseRelativeDate((String)date.substring(1));
        }
        return ISO8601DateParser.parse((String)date);
    }

    static void addFilterOnPrefixedDate(Criteria crit, String op, Date date, String dateAttribute) {
        if (op.startsWith("=")) {
            crit.add((Criterion)Restrictions.eq((String)dateAttribute, (Object)date));
        } else if (op.startsWith("<=")) {
            crit.add((Criterion)Restrictions.le((String)dateAttribute, (Object)date));
        } else if (op.startsWith(">=")) {
            crit.add((Criterion)Restrictions.ge((String)dateAttribute, (Object)date));
        } else if (op.startsWith("<")) {
            crit.add((Criterion)Restrictions.lt((String)dateAttribute, (Object)date));
        } else if (op.startsWith(">")) {
            crit.add((Criterion)Restrictions.gt((String)dateAttribute, (Object)date));
        }
    }

    private static String getDateWithoutOp(String ddf) {
        return Filter.getDateWithoutOp((String)ddf);
    }
}

