/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.BLangProgramArchiveBuilder;
import org.ballerinalang.BLangProgramLoader;
import org.ballerinalang.model.BLangProgram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateArchives {
    public static final String MAIN_TYPE = "main";
    public static final String SERVICE_TYPE = "service";
    private static final Logger log = LoggerFactory.getLogger(GenerateArchives.class);

    public static void main(String[] args) {
        String type = args[0];
        String srcDir = args[1];
        String packagePath = args[2];
        String targetName = args[3];
        new GenerateArchives().execute(type, srcDir, packagePath, targetName);
    }

    public void execute(String type, String srcDir, String packagePath, String targetName) {
        Path sourcePath = Paths.get(packagePath, new String[0]);
        try {
            Path realPath = Paths.get(srcDir + File.separator + packagePath, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS);
            if (!Files.isDirectory(realPath, LinkOption.NOFOLLOW_LINKS) && !realPath.toString().endsWith(".bal")) {
                log.error("invalid file or package '" + sourcePath + "'");
                throw new IllegalArgumentException("invalid file or package '" + sourcePath + "'");
            }
        }
        catch (IOException e) {
            log.error("error reading from file: " + sourcePath + " reason: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("error reading from file: " + sourcePath + " reason: " + e.getMessage(), e);
        }
        Path programDirPath = Paths.get(srcDir, new String[0]);
        BLangProgram bLangProgram = null;
        if (MAIN_TYPE.equals(type)) {
            bLangProgram = new BLangProgramLoader().loadMain(programDirPath, sourcePath);
        } else if (SERVICE_TYPE.equals(type)) {
            bLangProgram = new BLangProgramLoader().loadService(programDirPath, sourcePath);
        } else {
            log.error("source type '" + type + "' not supported");
            throw new RuntimeException("source type '" + type + "' not supported");
        }
        new BLangProgramArchiveBuilder().build(bLangProgram, targetName.trim());
    }
}

