/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.sample.osgi.internal;

import java.util.Optional;
import javax.naming.Context;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jndi.JNDIContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public void start(BundleContext bundleContext) throws Exception {
        ServiceReference contextManagerSRef = bundleContext.getServiceReference(JNDIContextManager.class);
        JNDIContextManager jndiContextManager = Optional.ofNullable(contextManagerSRef).map(arg_0 -> ((BundleContext)bundleContext).getService(arg_0)).orElseThrow(() -> new RuntimeException("JNDIContextManager service is not available."));
        Context initialContext = jndiContextManager.newInitialContext();
        Context envContext = initialContext.createSubcontext("java:comp/env");
        envContext.bind("company", (Object)"wso2");
        String value = (String)initialContext.lookup("java:comp/env/company");
        logger.info("JNDI Lookup(java:comp/env/company) value: {}", (Object)value);
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

