/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.websocket;

import java.io.IOException;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class WebSocketServer {
    private static Session session;
    private static Logger log;
    private Server server = null;

    public void start(int port) {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        try {
            ServerContainer wscontainer = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)context);
            wscontainer.addEndpoint(EventSocket.class);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebSocketServer.this.server.start();
                        WebSocketServer.this.server.join();
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }).start();
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            this.server = null;
        }
    }

    public void send(String message, int retryCount) {
        for (int count = 0; session == null && count < retryCount; ++count) {
            try {
                log.info((Object)"Waiting for the client to connect");
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (session != null) {
            try {
                session.getBasicRemote().sendText(message);
            }
            catch (IOException e) {
                log.error((Object)"Error server sending message", (Throwable)e);
            }
        } else {
            log.error((Object)"Session not available to send message");
        }
    }

    static {
        log = Logger.getLogger(WebSocketServer.class);
    }

    @ServerEndpoint(value="/events/")
    public static class EventSocket {
        @OnOpen
        public void onWebSocketConnect(Session sess) {
            log.info((Object)("Server Socket Connected: " + sess));
            session = sess;
        }

        @OnMessage
        public void onWebSocketText(String message) {
            log.info((Object)("Server Received TEXT message: " + message));
        }

        @OnClose
        public void onWebSocketClose(CloseReason reason) {
            log.info((Object)("Server Socket Closed: " + reason));
            session = null;
        }

        @OnError
        public void onWebSocketError(Throwable cause) {
            log.error((Object)"Server Socket Error", cause);
            session = null;
        }
    }
}

