/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.websocket;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.carbon.sample.websocket.Util;
import org.wso2.carbon.sample.websocket.WebSocketClient;
import org.wso2.carbon.sample.websocket.WebSocketServer;

public class Websocket {
    private static Logger log = Logger.getLogger(Websocket.class);
    private static List<String> messagesList = new ArrayList<String>();
    private static BufferedReader bufferedReader = null;
    private static StringBuffer message = new StringBuffer("");
    private static final String asterixLine = "*****";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String port = args[0];
        String url = args[1];
        String filePath = args[2];
        String sampleNumber = args[3];
        if (url.isEmpty()) {
            System.out.println("Starting Websocket publisher on Server Mode");
            WebSocketServer webSocketServer = new WebSocketServer();
            try {
                filePath = Util.getMessageFilePath(sampleNumber, filePath, url);
                webSocketServer.start(Integer.parseInt(port));
                Websocket.readMsg(filePath);
                for (String message : messagesList) {
                    System.out.println("Sending message:");
                    System.out.println(message);
                    System.out.println();
                    webSocketServer.send(message, 50);
                }
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                log.error((Object)"Error when sending the messages", t);
            }
            finally {
                webSocketServer.stop();
            }
        } else {
            System.out.println("Starting Websocket publisher on Client Mode");
            WebSocketClient webSocketClient = new WebSocketClient();
            try {
                webSocketClient.connect(url);
                filePath = Util.getMessageFilePath(sampleNumber, filePath, url);
                Websocket.readMsg(filePath);
                for (String message : messagesList) {
                    System.out.println("Sending message:");
                    System.out.println(message);
                    System.out.println();
                    webSocketClient.send(message);
                }
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                log.error((Object)"Error when sending the messages", t);
            }
            finally {
                webSocketClient.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMsg(String filePath) {
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(filePath));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.equals(asterixLine.trim()) && !"".equals(message.toString().trim())) {
                    messagesList.add(message.toString());
                    message = new StringBuffer("");
                    continue;
                }
                message = message.append(String.format("\n%s", line));
            }
            if (!"".equals(message.toString().trim())) {
                messagesList.add(message.toString());
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when closing the file : " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

